/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.vapi.bindings.client.RetryPolicy;
import com.vmware.vapi.client.exception.TransportProtocolException;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.std.errors.Unauthenticated;
import com.vmware.vise.vim.vapi.VapiConnectionControl;
import com.vmware.vise.vim.vapi.VapiConnectionManagerRegistry;
import com.vmware.vsphere.client.cm.NodeInaccessibleHaltException;
import com.vmware.vsphere.client.cm.util.PropertyCache;
import java.net.SocketTimeoutException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ConnectTimeoutException;

public class CmVapiConnectionControlFactory
implements VapiConnectionManagerRegistry.ControlFactory<String> {
    private static final Log _logger = LogFactory.getLog(CmVapiConnectionControlFactory.class);
    private final PropertyCache<String> _unreachableServersCache;
    private final ConcurrentMap<String, AtomicInteger> _requestsPerNode;
    private final int _maxRequestsPerNode;
    private final Object _sentinelValue = new Object();

    public CmVapiConnectionControlFactory(PropertyCache<String> unreachableServersCache, int maxRequestPerNode) {
        Validate.notNull(unreachableServersCache);
        Validate.isTrue((maxRequestPerNode > 0 ? 1 : 0) != 0, (String)"Max requests per node should be positive");
        this._unreachableServersCache = unreachableServersCache;
        this._requestsPerNode = new ConcurrentHashMap<String, AtomicInteger>();
        this._maxRequestsPerNode = maxRequestPerNode;
    }

    public VapiConnectionControl getControlForEndpoint(String hostname) {
        return new SingleNodeThrottlingConnectionControl(hostname);
    }

    private AtomicInteger getRequestCountForNode(String hostname) {
        if (!this._requestsPerNode.containsKey(hostname)) {
            this._requestsPerNode.putIfAbsent(hostname, new AtomicInteger(0));
        }
        return (AtomicInteger)this._requestsPerNode.get(hostname);
    }

    private class RequestCountingAsyncHandle
    extends AsyncHandle<MethodResult> {
        private final AsyncHandle<MethodResult> _originalHandle;
        private final String _serverName;

        private RequestCountingAsyncHandle(AsyncHandle<MethodResult> originalHandle, String serverName) {
            this._originalHandle = originalHandle;
            this._serverName = serverName;
        }

        public void updateProgress(DataValue dataValue) {
            this._originalHandle.updateProgress(dataValue);
        }

        public void setResult(MethodResult result) {
            int requestCount = CmVapiConnectionControlFactory.this.getRequestCountForNode(this._serverName).decrementAndGet();
            this._originalHandle.setResult((Object)result);
        }

        public void setError(RuntimeException e) {
            int requestCount = CmVapiConnectionControlFactory.this.getRequestCountForNode(this._serverName).decrementAndGet();
            this._originalHandle.setError(e);
        }
    }

    private class ThrottlingApiProvider
    implements ApiProvider {
        private final ApiProvider _nestedProvider;
        private final String _serverName;

        private ThrottlingApiProvider(ApiProvider nestedProvider, String serverName) {
            this._nestedProvider = nestedProvider;
            this._serverName = serverName;
        }

        public void invoke(String serviceId, String operationId, DataValue input, ExecutionContext ctx, AsyncHandle<MethodResult> asyncHandle) {
            int requestCount;
            if (CmVapiConnectionControlFactory.this._unreachableServersCache.getProperty(this._serverName, "__singleton") != null) {
                asyncHandle.setError((RuntimeException)new NodeInaccessibleHaltException(this._serverName));
            }
            if ((requestCount = CmVapiConnectionControlFactory.this.getRequestCountForNode(this._serverName).incrementAndGet()) <= CmVapiConnectionControlFactory.this._maxRequestsPerNode) {
                this._nestedProvider.invoke(serviceId, operationId, input, ctx, (AsyncHandle)new RequestCountingAsyncHandle(asyncHandle, this._serverName));
            } else {
                requestCount = CmVapiConnectionControlFactory.this.getRequestCountForNode(this._serverName).decrementAndGet();
                asyncHandle.setError(new RuntimeException("Too many requests for node."));
            }
        }
    }

    private class SingleNodeThrottlingConnectionControl
    implements VapiConnectionControl {
        private static final int MAX_REAUTHENTICATION_ATTEMPTS = 1;
        private final String _serverName;

        private SingleNodeThrottlingConnectionControl(String serverName) {
            this._serverName = serverName;
        }

        public boolean retryOnError(RuntimeException ex, RetryPolicy.RetryContext ctx, int invocationAttempt) {
            Throwable exceptionCause;
            if (ex instanceof Unauthenticated) {
                return invocationAttempt < 1;
            }
            if (ex instanceof TransportProtocolException && ((exceptionCause = ex.getCause()) instanceof SocketTimeoutException || exceptionCause instanceof ConnectTimeoutException) && CmVapiConnectionControlFactory.this._unreachableServersCache.getProperty(this._serverName, "__singleton") == null) {
                _logger.warn((Object)"Received timeout exception, will throttle subsequent calls", exceptionCause);
                CmVapiConnectionControlFactory.this._unreachableServersCache.setProperty(this._serverName, "__singleton", CmVapiConnectionControlFactory.this._sentinelValue);
            }
            return false;
        }

        public ApiProvider getApiProvider(ApiProvider originalProvider) {
            return new ThrottlingApiProvider(originalProvider, this._serverName);
        }
    }
}

