/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.vim.vmomi.client.exception.ClientHaltException;
import com.vmware.vim.vmomi.client.ext.InvocationContext;
import com.vmware.vim.vmomi.client.ext.InvocationInterceptor;
import com.vmware.vim.vmomi.client.http.impl.HttpProtocolBindingBase;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.cloudvm.CloudVmServiceException;
import com.vmware.vise.vim.sca.ScaService;
import com.vmware.vise.vim.sca.ScaServiceManager;
import com.vmware.vise.vim.sca.ScaServiceProvider;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.PropertyCache;
import java.net.URI;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CmScaServiceProviderImpl
implements ScaServiceProvider {
    private static final Log _logger = LogFactory.getLog(CmScaServiceProviderImpl.class);
    private final Object weakHashSetSentinel = new Object();
    private final WeakHashMap<ScaService, Object> _scasWithInterceptor = new WeakHashMap();
    private final ScaConnectionInterceptor _unreachableServerInterceptor;
    ScaServiceManager _manager = null;

    public CmScaServiceProviderImpl(ScaServiceManager manager, PropertyCache<String> unreachableServerCache) {
        _logger.info((Object)"instantiated");
        this._manager = manager;
        this._unreachableServerInterceptor = new ScaConnectionInterceptor(unreachableServerCache);
    }

    @type(value="cm:Server,cm:Service")
    public ScaService getService(URI server) throws CloudVmServiceException {
        String hostname = this.getHostname(server);
        ScaService result = this._manager.getService((Object)hostname);
        this.addInterceptorToService(result);
        return result;
    }

    @type(value="cm:Server,cm:Service")
    public ScaService getSolutionService(URI server) throws CloudVmServiceException {
        String hostname = this.getHostname(server);
        return this._manager.getSolutionService((Object)hostname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInterceptorToService(ScaService service) {
        if (this._scasWithInterceptor.containsKey(service)) {
            return;
        }
        CmScaServiceProviderImpl cmScaServiceProviderImpl = this;
        synchronized (cmScaServiceProviderImpl) {
            if (this._scasWithInterceptor.containsKey(service)) {
                return;
            }
            HttpProtocolBindingBase b = (HttpProtocolBindingBase)service.getVmomiClient().getBinding();
            b.setInvocationInterceptor((InvocationInterceptor)this._unreachableServerInterceptor);
            this._scasWithInterceptor.put(service, this.weakHashSetSentinel);
        }
    }

    private String getHostname(URI object) throws CloudVmServiceException {
        String hostname = CmReferenceUtil.getServerId(object);
        return hostname;
    }

    private static class ScaConnectionInterceptor
    implements InvocationInterceptor {
        private final Object _sentinelValue = new Object();
        private final PropertyCache<String> _cache;

        ScaConnectionInterceptor(PropertyCache<String> cache) {
            this._cache = cache;
        }

        public void beginInvocation(InvocationContext context) {
            String serverName = ScaConnectionInterceptor.getServerName(context);
            if (this._cache.getProperty(serverName, "__singleton") != null) {
                throw new ClientHaltException();
            }
        }

        public void completeInvocation(InvocationContext context, boolean executionSuccessful) {
            String serverName;
            if (!executionSuccessful && this._cache.getProperty(serverName = ScaConnectionInterceptor.getServerName(context), "__singleton") == null) {
                this._cache.setProperty(serverName, "__singleton", this._sentinelValue);
            }
        }

        private static String getServerName(InvocationContext c) {
            return c.getBinding().getEndpointUri().getHost();
        }
    }
}

