/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.applmgmt;

import com.vmware.appliance.Monitoring;
import com.vmware.appliance.MonitoringTypes;
import com.vmware.appliance.Shutdown;
import com.vmware.appliance.access.Consolecli;
import com.vmware.appliance.access.Dcui;
import com.vmware.appliance.access.Shell;
import com.vmware.appliance.access.Ssh;
import com.vmware.appliance.health.Load;
import com.vmware.appliance.health.Mem;
import com.vmware.appliance.health.Storage;
import com.vmware.appliance.health.Swap;
import com.vmware.appliance.health.System;
import com.vmware.appliance.networking.Interfaces;
import com.vmware.appliance.networking.dns.Domains;
import com.vmware.appliance.networking.dns.Hostname;
import com.vmware.appliance.networking.dns.Servers;
import com.vmware.appliance.system.Uptime;
import com.vmware.appliance.system.Version;
import com.vmware.appliance.techpreview.networking.Ipv4;
import com.vmware.appliance.techpreview.networking.Ipv6;
import com.vmware.appliance.techpreview.networking.Routes;
import com.vmware.appliance.techpreview.networking.firewall.addr.Inbound;
import com.vmware.vapi.bindings.Service;
import com.vmware.vise.vim.cloudvm.CloudVmService;
import com.vmware.vise.vim.cloudvm.CloudVmServiceException;
import com.vmware.vise.vim.cloudvm.CpuStats;
import com.vmware.vise.vim.cloudvm.DnsServerConfig;
import com.vmware.vise.vim.cloudvm.FirewallAddressRule;
import com.vmware.vise.vim.cloudvm.IPv4Config;
import com.vmware.vise.vim.cloudvm.IPv6Config;
import com.vmware.vise.vim.cloudvm.MemStats;
import com.vmware.vise.vim.cloudvm.NetStats;
import com.vmware.vise.vim.cloudvm.NetworkInterfaceInfo;
import com.vmware.vise.vim.cloudvm.NetworkRoute;
import com.vmware.vise.vim.cloudvm.PowerOperationConfig;
import com.vmware.vise.vim.cloudvm.ShellConfig;
import com.vmware.vise.vim.cloudvm.StorageStats;
import com.vmware.vise.vim.cloudvm.SystemStats;
import com.vmware.vise.vim.vapi.VapiConnectionManager;
import com.vmware.vsphere.client.cm.applmgmt.VapiToXmlRpcConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VapiBackedCloudVmService
extends CloudVmService {
    private static final Log _logger = LogFactory.getLog(VapiBackedCloudVmService.class);
    private final VapiConnectionManager _applmgmtConnectionManager;

    public VapiBackedCloudVmService(VapiConnectionManager applmgmtManager) {
        super(null);
        this._applmgmtConnectionManager = applmgmtManager;
    }

    public boolean isConsoleCliEnabled() throws CloudVmServiceException {
        return this.getService(Consolecli.class).get();
    }

    public void setConsoleCliEnabled(boolean enabled) throws CloudVmServiceException {
        this.getService(Consolecli.class).set(enabled);
    }

    public boolean isDcuiEnabled() throws CloudVmServiceException {
        return this.getService(Dcui.class).get();
    }

    public void setDcuiEnabled(boolean enabled) throws CloudVmServiceException {
        this.getService(Dcui.class).set(enabled);
    }

    public ShellConfig getShellConfig() throws CloudVmServiceException {
        return VapiToXmlRpcConverter.fromVapiStruct(this.getService(Shell.class).get());
    }

    public void setShellConfig(ShellConfig config) throws CloudVmServiceException {
        this.getService(Shell.class).set(VapiToXmlRpcConverter.toVapiStruct(config));
    }

    public boolean isSshEnabled() throws CloudVmServiceException {
        return this.getService(Ssh.class).get();
    }

    public void setSshEnabled(boolean enabled) throws CloudVmServiceException {
        this.getService(Ssh.class).set(enabled);
    }

    public String[] listDnsDomains() throws CloudVmServiceException {
        return VapiToXmlRpcConverter.toStringArray(this.getService(Domains.class).list());
    }

    public void setDnsDomains(String[] domains) throws CloudVmServiceException {
        this.getService(Domains.class).set(Arrays.asList(domains));
    }

    public void addDnsDomains(String domain) throws CloudVmServiceException {
        this.getService(Domains.class).add(domain);
    }

    public String getHostname() throws CloudVmServiceException {
        return this.getService(Hostname.class).get();
    }

    public void setHostname(String hostname) throws CloudVmServiceException {
        this.getService(Hostname.class).set(hostname);
    }

    public DnsServerConfig getDnsServersConfig() throws CloudVmServiceException {
        return VapiToXmlRpcConverter.fromVapiStruct(this.getService(Servers.class).get());
    }

    public void setDnsServersConfig(DnsServerConfig servers) throws CloudVmServiceException {
        this.getService(Servers.class).set(VapiToXmlRpcConverter.toVapiStruct(servers));
    }

    public void addDnsServersConfig(String server) throws CloudVmServiceException {
        this.getService(Servers.class).add(server);
    }

    public NetworkInterfaceInfo getNic(String name) throws CloudVmServiceException {
        return VapiToXmlRpcConverter.fromVapiStruct(this.getService(Interfaces.class).get(name));
    }

    public NetworkInterfaceInfo[] listNics() throws CloudVmServiceException {
        return VapiToXmlRpcConverter.fromVapiList(this.getService(Interfaces.class).list());
    }

    public IPv4Config[] getIPv4Config(String[] names) throws CloudVmServiceException {
        return VapiToXmlRpcConverter.fromVapiIpv4List(this.getService(Ipv4.class).get(VapiToXmlRpcConverter.toVapiList(names)));
    }

    public IPv4Config[] listIPv4Config() throws CloudVmServiceException {
        return VapiToXmlRpcConverter.fromVapiIpv4List(this.getService(Ipv4.class).list());
    }

    public void setIPv4Config(IPv4Config[] configs) throws CloudVmServiceException {
        this.getService(Ipv4.class).set(VapiToXmlRpcConverter.toVapiIpv4List(configs));
    }

    public void renewIPv4Config(String[] names) throws CloudVmServiceException {
        this.getService(Ipv4.class).renew(VapiToXmlRpcConverter.toVapiList(names));
    }

    public IPv6Config[] getIPv6Config(String[] names) throws CloudVmServiceException {
        return VapiToXmlRpcConverter.fromVapiIpv6ConfigList(this.getService(Ipv6.class).get(VapiToXmlRpcConverter.toVapiList(names)));
    }

    public void setIPv6Config(IPv6Config[] configs) throws CloudVmServiceException {
        this.getService(Ipv6.class).set(VapiToXmlRpcConverter.toVapiIpv6List(configs));
    }

    public IPv6Config[] listIPv6Config() throws CloudVmServiceException {
        return VapiToXmlRpcConverter.fromVapiIpv6ConfigList(this.getService(Ipv6.class).list());
    }

    public FirewallAddressRule[] listFirewallRules() throws CloudVmServiceException {
        return VapiToXmlRpcConverter.fromVapiFirewallRuleList(this.getService(Inbound.class).list());
    }

    public void setFirewallRules(FirewallAddressRule[] rules) throws CloudVmServiceException {
        this.getService(Inbound.class).set(VapiToXmlRpcConverter.toVapiFirewallRuleList(rules));
    }

    public void addFirewallRule(int position, FirewallAddressRule rule) throws CloudVmServiceException {
        this.getService(Inbound.class).add((long)position, VapiToXmlRpcConverter.toVapiStruct(rule));
    }

    public NetworkRoute[] listRoutes() throws CloudVmServiceException {
        return VapiToXmlRpcConverter.fromVapiRouteList(this.getService(Routes.class).list());
    }

    public void setRoutes(NetworkRoute[] routes) throws CloudVmServiceException {
        this.getService(Routes.class).set(VapiToXmlRpcConverter.toVapiRouteList(routes));
    }

    public String getSystemHealth() throws CloudVmServiceException {
        return this.getService(System.class).get().name();
    }

    public String getStorageHealth() throws CloudVmServiceException {
        return this.getService(Storage.class).get().name();
    }

    public String getMemHealth() throws CloudVmServiceException {
        return this.getService(Mem.class).get().name();
    }

    public String getLoadHealth() throws CloudVmServiceException {
        return this.getService(Load.class).get().name();
    }

    public String getSwapHealth() throws CloudVmServiceException {
        return this.getService(Swap.class).get().name();
    }

    public SystemStats getSystemStats() throws CloudVmServiceException {
        SystemStats result = new SystemStats();
        Uptime uptime = this.getService(Uptime.class);
        result.uptime = uptime.get();
        return result;
    }

    public CpuStats getCpuStats() throws CloudVmServiceException {
        Monitoring monSvc = this.getService(Monitoring.class);
        MonitoringTypes.MonitoredItemDataRequest cpuDataRequest = new MonitoringTypes.MonitoredItemDataRequest();
        cpuDataRequest.setNames(Arrays.asList("cpu.util", "cpu.totalfrequency"));
        cpuDataRequest.setFunction(MonitoringTypes.FunctionType.AVG);
        cpuDataRequest.setInterval(MonitoringTypes.IntervalType.MINUTES5);
        this.setRequestIntervalLastNMinutes(cpuDataRequest, 5);
        List results = monSvc.query(cpuDataRequest);
        CpuStats result = new CpuStats();
        result.timeIntervalMins = 5;
        for (MonitoringTypes.MonitoredItemData data2 : results) {
            if ("cpu.util".equals(data2.getName())) {
                result.used = Double.parseDouble((String)data2.getData().get(0));
                continue;
            }
            if (!"cpu.totalfrequency".equals(data2.getName())) continue;
            result.total = Double.parseDouble((String)data2.getData().get(0));
        }
        return result;
    }

    public MemStats getMemStats() throws CloudVmServiceException {
        Monitoring monSvc = this.getService(Monitoring.class);
        MonitoringTypes.MonitoredItemDataRequest memDataRequest = new MonitoringTypes.MonitoredItemDataRequest();
        memDataRequest.setNames(Arrays.asList("mem.util", "mem.total"));
        memDataRequest.setFunction(MonitoringTypes.FunctionType.AVG);
        memDataRequest.setInterval(MonitoringTypes.IntervalType.MINUTES5);
        this.setRequestIntervalLastNMinutes(memDataRequest, 5);
        List results = monSvc.query(memDataRequest);
        MemStats result = new MemStats();
        long memUtil = 0L;
        for (MonitoringTypes.MonitoredItemData data2 : results) {
            if ("mem.util".equals(data2.getName())) {
                memUtil = (long)Double.parseDouble((String)data2.getData().get(0));
                continue;
            }
            if (!"mem.total".equals(data2.getName())) continue;
            result.total = (long)Double.parseDouble((String)data2.getData().get(0));
        }
        result.free = result.total - memUtil;
        return result;
    }

    public NetStats getNetStats(String nic) throws CloudVmServiceException {
        throw new NotImplementedException();
    }

    public NetStats[] listNetStats() throws CloudVmServiceException {
        Monitoring monSvc = this.getService(Monitoring.class);
        List allMonitoredItems = monSvc.list();
        HashMap<String, MonitoringTypes.MonitoredItem> statsToGet = new HashMap<String, MonitoringTypes.MonitoredItem>();
        HashMap<String, NetStats> statsByNic = new HashMap<String, NetStats>();
        for (MonitoringTypes.MonitoredItem i : allMonitoredItems) {
            if (!i.getCategory().equals("com.vmware.applmgmt.mon.cat.network") || !i.getId().startsWith("net.rx.activity") && !i.getId().startsWith("net.tx.activity") && !i.getId().startsWith("net.rx.packetRate") && !i.getId().startsWith("net.tx.packetRate")) continue;
            statsToGet.put(i.getId(), i);
        }
        MonitoringTypes.MonitoredItemDataRequest request = new MonitoringTypes.MonitoredItemDataRequest();
        request.setNames(new ArrayList(statsToGet.keySet()));
        request.setInterval(MonitoringTypes.IntervalType.MINUTES5);
        request.setFunction(MonitoringTypes.FunctionType.AVG);
        this.setRequestIntervalLastNMinutes(request, 5);
        List results = monSvc.query(request);
        for (MonitoringTypes.MonitoredItemData resultData : results) {
            NetStats statsForNic;
            String itemId = resultData.getName();
            MonitoringTypes.MonitoredItem requestData = (MonitoringTypes.MonitoredItem)statsToGet.get(itemId);
            if (requestData == null) {
                _logger.warn((Object)("Received data that wasn't requested: " + itemId));
                continue;
            }
            String nicName = requestData.getInstance();
            if (!statsByNic.containsKey(nicName)) {
                statsForNic = new NetStats();
                statsForNic.nic = nicName;
                statsForNic.rxBytes = -1L;
                statsForNic.rxPackets = -1L;
                statsForNic.txBytes = -1L;
                statsForNic.txPackets = -1L;
                statsByNic.put(nicName, statsForNic);
            } else {
                statsForNic = (NetStats)statsByNic.get(nicName);
            }
            if (requestData.getId().startsWith("net.rx.activity")) {
                statsForNic.rxBytes = (long)(Double.parseDouble((String)resultData.getData().get(0)) * 5.0 * 60.0 * 1024.0 * 1024.0);
                continue;
            }
            if (requestData.getId().startsWith("net.tx.activity")) {
                statsForNic.txBytes = (long)(Double.parseDouble((String)resultData.getData().get(0)) * 5.0 * 60.0 * 1024.0 * 1024.0);
                continue;
            }
            if (requestData.getId().startsWith("net.rx.packetRate")) {
                statsForNic.rxPackets = (long)(Double.parseDouble((String)resultData.getData().get(0)) * 60.0 * 5.0 * 1000000.0);
                continue;
            }
            if (!requestData.getId().startsWith("net.tx.packetRate")) continue;
            statsForNic.txPackets = (long)(Double.parseDouble((String)resultData.getData().get(0)) * 60.0 * 5.0 * 1000000.0);
        }
        return statsByNic.values().toArray(new NetStats[0]);
    }

    public StorageStats[] listStorageStats() throws CloudVmServiceException {
        Monitoring monSvc = this.getService(Monitoring.class);
        List allMonitoredItems = monSvc.list();
        HashMap<String, MonitoringTypes.MonitoredItem> statsToGet = new HashMap<String, MonitoringTypes.MonitoredItem>();
        HashMap<String, StorageStats> statsByPartition = new HashMap<String, StorageStats>();
        for (MonitoringTypes.MonitoredItem i : allMonitoredItems) {
            if (!i.getCategory().equals("com.vmware.applmgmt.mon.cat.storage") || !i.getId().startsWith("storage.totalsize") && !i.getId().startsWith("storage.used")) continue;
            statsToGet.put(i.getId(), i);
        }
        MonitoringTypes.MonitoredItemDataRequest request = new MonitoringTypes.MonitoredItemDataRequest();
        request.setNames(new ArrayList(statsToGet.keySet()));
        request.setInterval(MonitoringTypes.IntervalType.MINUTES30);
        request.setFunction(MonitoringTypes.FunctionType.MAX);
        this.setRequestIntervalLastNMinutes(request, 30);
        List results = monSvc.query(request);
        for (MonitoringTypes.MonitoredItemData resultData : results) {
            StorageStats statsForPartition;
            String itemId = resultData.getName();
            MonitoringTypes.MonitoredItem requestData = (MonitoringTypes.MonitoredItem)statsToGet.get(itemId);
            if (requestData == null) {
                _logger.warn((Object)("Received data that wasn't requested: " + itemId));
                continue;
            }
            String partitionName = requestData.getInstance();
            if (!statsByPartition.containsKey(partitionName)) {
                statsForPartition = new StorageStats();
                statsForPartition.name = partitionName;
                statsForPartition.totalKBytes = -1L;
                statsForPartition.usedKBytes = -1L;
                statsByPartition.put(partitionName, statsForPartition);
            } else {
                statsForPartition = (StorageStats)statsByPartition.get(partitionName);
            }
            if (requestData.getId().startsWith("storage.totalsize")) {
                statsForPartition.totalKBytes = (long)Double.parseDouble((String)resultData.getData().get(0));
                continue;
            }
            if (!requestData.getId().startsWith("storage.used")) continue;
            statsForPartition.usedKBytes = (long)Double.parseDouble((String)resultData.getData().get(0));
        }
        ArrayList<StorageStats> statsToDisplay = new ArrayList<StorageStats>();
        for (StorageStats ss : statsByPartition.values()) {
            if (ss.usedKBytes == -1L || ss.totalKBytes == -1L) continue;
            statsToDisplay.add(ss);
        }
        return statsToDisplay.toArray(new StorageStats[0]);
    }

    private void setRequestIntervalLastNMinutes(MonitoringTypes.MonitoredItemDataRequest request, int minutes) {
        long now = java.lang.System.currentTimeMillis();
        Calendar start = Calendar.getInstance();
        start.setTimeInMillis(now - (long)(minutes * 60 * 1000));
        Calendar end = Calendar.getInstance();
        end.setTimeInMillis(now);
        request.setStartTime(start);
        request.setEndTime(end);
    }

    public String control(String command, String[] arguments, int timeout) throws CloudVmServiceException {
        throw new NotImplementedException();
    }

    public void restart(PowerOperationConfig config) throws CloudVmServiceException {
        this.getService(Shutdown.class).reboot(Long.valueOf(config.delay).longValue(), config.reason);
    }

    public void shutdown(PowerOperationConfig config) throws CloudVmServiceException {
        this.getService(Shutdown.class).poweroff(Long.valueOf(config.delay).longValue(), config.reason);
    }

    public String getVersion() throws CloudVmServiceException {
        Version versioninfo = this.getService(Version.class);
        return versioninfo.get().getVersion();
    }

    private <C extends Service> C getService(Class<C> type) {
        return (C)this._applmgmtConnectionManager.createServiceStub(type);
    }
}

