/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.vm.migrate;

import com.vmware.vim.binding.vim.OpaqueNetwork;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.PortConnection;
import com.vmware.vim.binding.vim.vm.ConfigSpec;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualDeviceSpec;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.common.compositecommand.api.spec.BaseCommandSpec;
import com.vmware.vsphere.client.common.compositecommand.api.spec.DummyCommandSpec;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.vm.migrate.model.MigrateVmData;
import com.vmware.vsphere.client.h5.network.vm.migrate.model.MigrateVmNetworkData;
import com.vmware.vsphere.client.h5.network.vm.migrate.model.MigrateVmNetworkingProperties;
import com.vmware.vsphere.client.h5.network.vm.migrate.model.VmNetworkProperties;
import com.vmware.vsphere.client.h5.network.vm.migrate.specs.MigrateVmNetworkingSpec;
import com.vmware.vsphere.client.h5.network.vm.migrate.specs.MigrateVmVnicsSpec;
import com.vmware.vsphere.client.network.vm.api.spec.VmReconfigureCommandSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MigrateVmNetworkingParser {
    public static List<MigrateVmNetworkingProperties.VmListItem> createVmListItems(MigrateVmData vmDataModel, ManagedObjectReference sourceNetworkRef, VmNetworkProperties sourceNetworkData, Set<String> hostUids) {
        ArrayList<MigrateVmNetworkingProperties.VmListItem> vmListItems = new ArrayList<MigrateVmNetworkingProperties.VmListItem>();
        if (!ArrayUtil.isNullOrEmpty((Object[])vmDataModel.virtualDevices)) {
            for (VirtualDevice device : vmDataModel.virtualDevices) {
                if (!(device instanceof VirtualEthernetCard)) continue;
                VirtualEthernetCard virtualEthernetCard = (VirtualEthernetCard)device;
                if (sourceNetworkRef != null && !MigrateVmNetworkingParser.isAdapterBackedBySourceNetwork(sourceNetworkRef, sourceNetworkData.networkKey, sourceNetworkData.opaqueNetworkId, sourceNetworkData.opaqueNetworkType, virtualEthernetCard)) continue;
                MigrateVmNetworkingProperties.VmListItem vmItem = MigrateVmNetworkingParser.createListItem(vmDataModel, virtualEthernetCard, hostUids);
                vmListItems.add(vmItem);
            }
        }
        return vmListItems;
    }

    public static DummyCommandSpec createMigrateVmNetworkingCommandSpec(ManagedObjectReference dcRef, MigrateVmNetworkingSpec migrateVmSpec) {
        DummyCommandSpec commandSpec = new DummyCommandSpec();
        commandSpec.mor = dcRef;
        ArrayList<VmReconfigureCommandSpec> vmReconfigureCommandSpecs = new ArrayList<VmReconfigureCommandSpec>();
        for (MigrateVmVnicsSpec vmVnicSpec : migrateVmSpec.vmVnicsSpecs) {
            if (ArrayUtil.isNullOrEmpty((Object[])vmVnicSpec.vnics)) continue;
            VmReconfigureCommandSpec vmReconfigureCommandSpec = new VmReconfigureCommandSpec();
            vmReconfigureCommandSpec.mor = vmVnicSpec.vmRef;
            ConfigSpec vmConfigSpec = new ConfigSpec();
            vmConfigSpec.changeVersion = vmVnicSpec.vmChangeVersion;
            ArrayList<VirtualDeviceSpec> virtualDeviceSpecs = new ArrayList<VirtualDeviceSpec>();
            for (VirtualEthernetCard vnic : vmVnicSpec.vnics) {
                VirtualEthernetCard.DistributedVirtualPortBackingInfo backingInfo;
                VirtualDeviceSpec virtualDeviceSpec = new VirtualDeviceSpec();
                virtualDeviceSpec.operation = VirtualDeviceSpec.Operation.edit;
                virtualDeviceSpec.device = vnic;
                if (DistributedVirtualPortgroup.class.getSimpleName().equals(migrateVmSpec.destinationNetwork.networkType)) {
                    backingInfo = new VirtualEthernetCard.DistributedVirtualPortBackingInfo();
                    backingInfo.port = new PortConnection();
                    backingInfo.port.portgroupKey = migrateVmSpec.destinationNetwork.networkKey;
                    backingInfo.port.switchUuid = migrateVmSpec.destinationNetwork.dvsUuid;
                    virtualDeviceSpec.device.backing = backingInfo;
                } else if (OpaqueNetwork.class.getSimpleName().equals(migrateVmSpec.destinationNetwork.networkType) && !StringUtil.isNullOrEmpty((String)migrateVmSpec.destinationNetwork.opaqueNetworkId) && !StringUtil.isNullOrEmpty((String)migrateVmSpec.destinationNetwork.opaqueNetworkType)) {
                    backingInfo = new VirtualEthernetCard.OpaqueNetworkBackingInfo();
                    backingInfo.opaqueNetworkId = migrateVmSpec.destinationNetwork.opaqueNetworkId;
                    backingInfo.opaqueNetworkType = migrateVmSpec.destinationNetwork.opaqueNetworkType;
                    virtualDeviceSpec.device.backing = backingInfo;
                } else if (!StringUtil.isNullOrEmpty((String)migrateVmSpec.destinationNetwork.networkName)) {
                    backingInfo = new VirtualEthernetCard.NetworkBackingInfo();
                    backingInfo.deviceName = migrateVmSpec.destinationNetwork.networkName;
                    virtualDeviceSpec.device.backing = backingInfo;
                }
                virtualDeviceSpecs.add(virtualDeviceSpec);
            }
            vmConfigSpec.deviceChange = virtualDeviceSpecs.toArray(new VirtualDeviceSpec[virtualDeviceSpecs.size()]);
            vmReconfigureCommandSpec.configSpec = vmConfigSpec;
            vmReconfigureCommandSpecs.add(vmReconfigureCommandSpec);
        }
        commandSpec.dependentSpecs = (BaseCommandSpec[])vmReconfigureCommandSpecs.toArray(new VmReconfigureCommandSpec[vmReconfigureCommandSpecs.size()]);
        return commandSpec;
    }

    public static VmNetworkProperties createVmNetworkData(MigrateVmNetworkData model) {
        ManagedObjectReference networkRef = (ManagedObjectReference)model.provider;
        VmNetworkProperties vmNetwork = new VmNetworkProperties();
        vmNetwork.networkName = model.networkName;
        vmNetwork.networkKey = model.networkKey;
        vmNetwork.networkType = networkRef.getType();
        vmNetwork.dvsUuid = model.dvsUuid;
        vmNetwork.opaqueNetworkId = model.opaqueNetworkId;
        vmNetwork.opaqueNetworkType = model.opaqueNetworkType;
        return vmNetwork;
    }

    public static MigrateVmVnicsSpec[] createMigrateVmVnicsSpecs(MigrateVmData[] vmDataModels, MigrateVmNetworkData sourceNetworkData, Set<String> hostUids) {
        ArrayList<MigrateVmVnicsSpec> specs = new ArrayList<MigrateVmVnicsSpec>();
        for (MigrateVmData data2 : vmDataModels) {
            VirtualEthernetCard[] vnics;
            if (!hostUids.contains(ManagedObjectUtil.morefToString((ManagedObjectReference)data2.host)) || (vnics = MigrateVmNetworkingParser.getNicsBackedByNetwork(data2, sourceNetworkData)).length <= 0) continue;
            MigrateVmVnicsSpec spec = new MigrateVmVnicsSpec();
            spec.vmChangeVersion = data2.changeVersion;
            spec.vmRef = (ManagedObjectReference)data2.provider;
            spec.vnics = vnics;
            specs.add(spec);
        }
        return specs.toArray(new MigrateVmVnicsSpec[specs.size()]);
    }

    private static VirtualEthernetCard[] getNicsBackedByNetwork(MigrateVmData vmDataModel, MigrateVmNetworkData sourceNetworkData) {
        ArrayList<VirtualEthernetCard> nics = new ArrayList<VirtualEthernetCard>();
        for (VirtualDevice device : vmDataModel.virtualDevices) {
            if (!(device instanceof VirtualEthernetCard) || !MigrateVmNetworkingParser.isAdapterBackedBySourceNetwork((ManagedObjectReference)sourceNetworkData.provider, sourceNetworkData.networkKey, sourceNetworkData.opaqueNetworkId, sourceNetworkData.opaqueNetworkType, (VirtualEthernetCard)device)) continue;
            nics.add((VirtualEthernetCard)device);
        }
        return nics.toArray(new VirtualEthernetCard[nics.size()]);
    }

    private static boolean isAdapterBackedBySourceNetwork(ManagedObjectReference sourceNetworkRef, String sourceNetworkKey, String opaqueNetworkId, String opaqueNetworkType, VirtualEthernetCard virtualEthernetCard) {
        if (sourceNetworkRef == null || virtualEthernetCard == null) {
            return false;
        }
        if (virtualEthernetCard.backing instanceof VirtualEthernetCard.NetworkBackingInfo) {
            VirtualEthernetCard.NetworkBackingInfo backingInfo = (VirtualEthernetCard.NetworkBackingInfo)virtualEthernetCard.backing;
            if (backingInfo.network.equals((Object)sourceNetworkRef)) {
                return true;
            }
        } else if (virtualEthernetCard.backing instanceof VirtualEthernetCard.DistributedVirtualPortBackingInfo) {
            VirtualEthernetCard.DistributedVirtualPortBackingInfo portBackingInfo = (VirtualEthernetCard.DistributedVirtualPortBackingInfo)virtualEthernetCard.backing;
            if (ManagedObjectUtil.isOfType((ManagedObjectReference)sourceNetworkRef, DistributedVirtualPortgroup.class) && portBackingInfo.port != null && portBackingInfo.port.portgroupKey.equals(sourceNetworkKey)) {
                return true;
            }
        } else {
            if (virtualEthernetCard.backing instanceof VirtualEthernetCard.OpaqueNetworkBackingInfo) {
                VirtualEthernetCard.OpaqueNetworkBackingInfo opaqueBackingInfo = (VirtualEthernetCard.OpaqueNetworkBackingInfo)virtualEthernetCard.backing;
                return opaqueBackingInfo.opaqueNetworkId.equals(opaqueNetworkId) && opaqueBackingInfo.opaqueNetworkType.equals(opaqueNetworkType);
            }
            if (virtualEthernetCard.backing instanceof VirtualEthernetCard.LegacyNetworkBackingInfo) {
                return true;
            }
        }
        return false;
    }

    private static MigrateVmNetworkingProperties.VmListItem createListItem(MigrateVmData vmDataModel, VirtualEthernetCard adapter, Set<String> hostUids) {
        MigrateVmNetworkingProperties.VmListItem vmItem = new MigrateVmNetworkingProperties.VmListItem();
        ManagedObjectReference vmRef = (ManagedObjectReference)vmDataModel.provider;
        vmItem.name = MixedUtil.escapeVimEntityNameSpecialChars((String)vmDataModel.vmName);
        vmItem.iconId = vmDataModel.vmIconId;
        vmItem.vmId = ManagedObjectUtil.morefToString((ManagedObjectReference)vmRef);
        vmItem.isChecked = false;
        if (adapter.deviceInfo != null) {
            vmItem.adapter = adapter.deviceInfo.label;
        }
        vmItem.virtualEthernetCard = adapter;
        vmItem.isAccessible = vmDataModel.host == null || hostUids == null || hostUids.contains(ManagedObjectUtil.morefToString((ManagedObjectReference)vmDataModel.host));
        vmItem.itemTooltip = vmItem.isAccessible != false ? null : NetworkStringUtil.getString("migrateVmNetworking.inaccessibleNetwork");
        vmItem.hostName = vmDataModel.hostName;
        vmItem.changeVersion = vmDataModel.changeVersion;
        return vmItem;
    }
}

