/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.switchdiagram;

import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.dvs.PortConnectee;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vim.vm.device.VirtualSriovEthernetCard;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortGroupModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortStatus;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.SriovAdapterModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.SriovPortModel;
import com.vmware.vsphere.client.h5.network.switchdiagram.util.SwitchDiagramUtil;
import com.vmware.vsphere.client.network.switchdiagram.api.VssDiagramPortgroupVmsBuilder;
import com.vmware.vsphere.client.network.switchdiagram.api.spec.SwitchDiagramExternalPnicSpec;
import com.vmware.vsphere.client.network.switchdiagram.api.spec.SwitchDiagramVmSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VssDiagramPortgroupVmsBuilderImpl
implements VssDiagramPortgroupVmsBuilder {
    private static final String EXTERNAL_SRIOV_ADAPTER_ID_FORMAT = "externalSriovPnic_%s";
    private SwitchDiagramVmSpec[] vmSpecs;
    private Map<String, PortGroupModel> portgroupsByNetworkName = new HashMap<String, PortGroupModel>();
    private Set<ManagedObjectReference> networkRefsSet = new HashSet<ManagedObjectReference>();

    public VssDiagramPortgroupVmsBuilderImpl(SwitchDiagramVmSpec[] vmSpecs, ManagedObjectReference[] networkRefs) {
        if (vmSpecs == null) {
            throw new IllegalArgumentException("vmSpecs cannot be null");
        }
        if (networkRefs == null) {
            throw new IllegalArgumentException("networkRefs cannot be null");
        }
        this.vmSpecs = vmSpecs;
        this.networkRefsSet.addAll(Arrays.asList(networkRefs));
    }

    public List<PortGroupModel> buildPortgroupVmsModels() {
        for (SwitchDiagramVmSpec vmSpec : this.vmSpecs) {
            if (ArrayUtil.isNullOrEmpty((Object[])vmSpec.devices)) continue;
            Map<ManagedObjectReference, List<VirtualDevice>> devicesPerNetwork = this.getDevicesPerNetwork(vmSpec.devices);
            for (ManagedObjectReference networkRef : this.networkRefsSet) {
                List<VirtualDevice> devices = devicesPerNetwork.get(networkRef);
                if (devices == null) continue;
                boolean includeMac = devices.size() > 1;
                for (VirtualDevice device : devices) {
                    PortGroupModel portGroup = this.getPortgroupByName(((VirtualEthernetCard.NetworkBackingInfo)device.backing).deviceName);
                    PortModel portModel = this.buildPortModel(device, vmSpec, includeMac);
                    portGroup.vmVnics.add(portModel);
                }
            }
        }
        Collection<PortGroupModel> portgroupModels = this.portgroupsByNetworkName.values();
        for (PortGroupModel portGroupModel : portgroupModels) {
            this.sortVms(portGroupModel.vmVnics);
        }
        return new ArrayList<PortGroupModel>(portgroupModels);
    }

    public List<SriovAdapterModel> buildExternalSriovPnicModels(SwitchDiagramExternalPnicSpec externalPnicSpec) {
        HashMap<String, SriovAdapterModel> modelsByPfId = new HashMap<String, SriovAdapterModel>();
        if (externalPnicSpec != null) {
            for (SwitchDiagramVmSpec vmSpec : this.vmSpecs) {
                if (vmSpec == null || ArrayUtil.isNullOrEmpty((Object[])vmSpec.devices)) continue;
                block1: for (PhysicalNic pnic : externalPnicSpec.physicalNics) {
                    if (pnic == null) continue;
                    for (VirtualDevice device : vmSpec.devices) {
                        VirtualSriovEthernetCard.SriovBackingInfo sriovBackingInfo;
                        if (!(device instanceof VirtualSriovEthernetCard) || (sriovBackingInfo = ((VirtualSriovEthernetCard)device).sriovBacking) == null || sriovBackingInfo.physicalFunctionBacking == null || StringUtil.isNullOrEmpty((String)sriovBackingInfo.physicalFunctionBacking.id) || !sriovBackingInfo.physicalFunctionBacking.id.equals(pnic.pci) || modelsByPfId.containsKey(pnic.pci)) continue;
                        SriovAdapterModel adapterModel = new SriovAdapterModel();
                        adapterModel.hostName = externalPnicSpec.hostName;
                        adapterModel.hostValue = externalPnicSpec.hostRef.getValue();
                        adapterModel.title = pnic.device;
                        adapterModel.labelOne = pnic.device;
                        adapterModel.labelTwo = externalPnicSpec.hostName;
                        adapterModel.portStatus = PortStatus.NA;
                        adapterModel.pNicLinkUp = false;
                        adapterModel.physicalFunctionId = pnic.pci;
                        adapterModel.id = String.format(EXTERNAL_SRIOV_ADAPTER_ID_FORMAT, pnic.pci);
                        if (pnic.linkSpeed != null) {
                            adapterModel.pNicLinkUp = true;
                            adapterModel.linkSpeed = Integer.toString(pnic.linkSpeed.speedMb);
                            adapterModel.duplex = SwitchDiagramUtil.getDuplexString(pnic.linkSpeed.duplex);
                            adapterModel.portStatus = PortStatus.CONNECTED;
                        }
                        modelsByPfId.put(pnic.pci, adapterModel);
                        continue block1;
                    }
                }
            }
        }
        ArrayList<SriovAdapterModel> result = new ArrayList<SriovAdapterModel>(modelsByPfId.values());
        this.sortExternalAdapters(result);
        return result;
    }

    private PortModel buildPortModel(VirtualDevice networkAdapter, SwitchDiagramVmSpec vmSpec, boolean includeMac) {
        SriovPortModel portModel;
        if (networkAdapter instanceof VirtualSriovEthernetCard) {
            portModel = new SriovPortModel();
            if (((VirtualSriovEthernetCard)networkAdapter).sriovBacking != null && ((VirtualSriovEthernetCard)networkAdapter).sriovBacking.physicalFunctionBacking != null) {
                portModel.physicalFunctionId = ((VirtualSriovEthernetCard)networkAdapter).sriovBacking.physicalFunctionBacking.id;
            }
        } else {
            portModel = new PortModel();
        }
        portModel.portConnecteeType = PortConnectee.ConnecteeType.vmVnic;
        portModel.id = vmSpec.provider.getValue() + Integer.toString(networkAdapter.key);
        portModel.virtualDeviceKey = networkAdapter.key;
        portModel.vmName = vmSpec.name;
        portModel.title = vmSpec.name;
        portModel.powerState = vmSpec.powerState;
        portModel.portStatus = VirtualMachine.PowerState.poweredOn.equals((Object)vmSpec.powerState) ? PortStatus.CONNECTED : PortStatus.DISCONNECTED;
        portModel.isOrphanedVm = VirtualMachine.ConnectionState.orphaned.equals((Object)vmSpec.connectionState);
        portModel.vmValue = vmSpec.provider.getValue();
        if (includeMac) {
            portModel.macAddress = ((VirtualEthernetCard)networkAdapter).macAddress;
        }
        return portModel;
    }

    private Map<ManagedObjectReference, List<VirtualDevice>> getDevicesPerNetwork(VirtualDevice[] devices) {
        HashMap<ManagedObjectReference, List<VirtualDevice>> result = new HashMap<ManagedObjectReference, List<VirtualDevice>>();
        for (VirtualDevice device : devices) {
            if (device == null || !(device.backing instanceof VirtualEthernetCard.NetworkBackingInfo)) continue;
            VirtualEthernetCard.NetworkBackingInfo backing = (VirtualEthernetCard.NetworkBackingInfo)device.backing;
            if (backing.network == null || !this.networkRefsSet.contains(backing.network)) continue;
            ArrayList<VirtualDevice> devicesOnNetwork = (ArrayList<VirtualDevice>)result.get(backing.network);
            if (devicesOnNetwork == null) {
                devicesOnNetwork = new ArrayList<VirtualDevice>();
                result.put(backing.network, devicesOnNetwork);
            }
            devicesOnNetwork.add(device);
        }
        return result;
    }

    private PortGroupModel getPortgroupByName(String name) {
        PortGroupModel portGroup = this.portgroupsByNetworkName.get(name);
        if (portGroup == null) {
            portGroup = new PortGroupModel();
            portGroup.id = name;
            this.portgroupsByNetworkName.put(name, portGroup);
        }
        return portGroup;
    }

    private void sortVms(List<PortModel> vmVnics) {
        Collections.sort(vmVnics, new Comparator<PortModel>(){

            @Override
            public int compare(PortModel vm1, PortModel vm2) {
                return vm1.vmName.compareToIgnoreCase(vm2.vmName);
            }
        });
    }

    private void sortExternalAdapters(List<SriovAdapterModel> adapters) {
        Collections.sort(adapters, new Comparator<SriovAdapterModel>(){

            @Override
            public int compare(SriovAdapterModel a1, SriovAdapterModel a2) {
                return a1.labelOne.compareToIgnoreCase(a2.labelOne);
            }
        });
    }
}

