/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.switchdiagram;

import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.PortConnectee;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vim.vm.device.VirtualSriovEthernetCard;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.dvs.api.switchdiagram.SwitchDiagramPortgroupVmsBuilder;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortGroupModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.PortStatus;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.SriovAdapterModel;
import com.vmware.vsphere.client.dvs.api.switchdiagram.model.SriovPortModel;
import com.vmware.vsphere.client.h5.network.dvs.addhost.DvsAddHostWizardUtil;
import com.vmware.vsphere.client.h5.network.switchdiagram.SwitchDiagramBuilderBase;
import com.vmware.vsphere.client.h5.network.switchdiagram.util.SwitchDiagramUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.network.switchdiagram.api.spec.SwitchDiagramExternalPnicSpec;
import com.vmware.vsphere.client.network.switchdiagram.api.spec.SwitchDiagramSpec;
import com.vmware.vsphere.client.network.switchdiagram.api.spec.SwitchDiagramVmSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SwitchDiagramPortgroupVmsBuilderImpl
extends SwitchDiagramBuilderBase
implements SwitchDiagramPortgroupVmsBuilder {
    private static final String UNBOUND_VM_KEY_PREFIX = "UNB_";
    private static final String EXTERNAL_SRIOV_ADAPTER_ID_FORMAT = "externalSriovPnic_%s_%s";
    private boolean initialized;
    private SwitchDiagramSpec _switchDiagramSpec;
    private String _dvsUuid;
    private Set<String> _portgroupKeys;
    private Set<SwitchDiagramVmSpec> _vmSpecs = new HashSet<SwitchDiagramVmSpec>();
    private Map<String, SwitchDiagramExternalPnicSpec> _externalPnicSpecsMap = new HashMap<String, SwitchDiagramExternalPnicSpec>();
    private SwitchDiagramExternalPnicSpec[] _externalPnicCandidates = null;
    private Map<String, DistributedVirtualPort> _portsMap = new HashMap<String, DistributedVirtualPort>();

    public SwitchDiagramPortgroupVmsBuilderImpl(SwitchDiagramSpec switchDiagramSpec, String dvsUuid, String[] portgroupKeys) {
        if (switchDiagramSpec == null) {
            throw new IllegalArgumentException("switchDiagramSpec cannot be null");
        }
        if (switchDiagramSpec.dvsSpec == null) {
            throw new IllegalArgumentException("dvsSpec cannot be null");
        }
        if (StringUtil.isNullOrEmpty((String)dvsUuid)) {
            throw new IllegalArgumentException("dvsUuid cannot be null or empty");
        }
        this._switchDiagramSpec = switchDiagramSpec;
        this._dvsUuid = dvsUuid;
        this._portgroupKeys = new HashSet<String>(Arrays.asList(portgroupKeys));
    }

    public SwitchDiagramPortgroupVmsBuilderImpl(SwitchDiagramSpec switchDiagramSpec, String dvsUuid, String[] portgroupKeys, SwitchDiagramExternalPnicSpec[] externalPnicCandidates) {
        this(switchDiagramSpec, dvsUuid, portgroupKeys);
        this._externalPnicCandidates = externalPnicCandidates;
    }

    public List<PortGroupModel> buildPortgroupVmsModels() {
        ArrayList<PortGroupModel> portGroupModels = new ArrayList<PortGroupModel>();
        this.initialize();
        for (String portgroupKey : this._portgroupKeys) {
            PortGroupModel portGroupModel = new PortGroupModel();
            portGroupModel.portgroupKey = portgroupKey;
            this.addVirtualMachines(portGroupModel, portgroupKey);
            this.sortVms(portGroupModel.vmVnics);
            portGroupModels.add(portGroupModel);
        }
        return portGroupModels;
    }

    public List<SriovAdapterModel> buildExternalSriovPnicModels() {
        ArrayList<SriovAdapterModel> externalSriovAdapterModels = new ArrayList<SriovAdapterModel>();
        this.initialize();
        for (SwitchDiagramVmSpec vmSpec : this._vmSpecs) {
            SwitchDiagramExternalPnicSpec externalPnicSpec;
            if (vmSpec == null || vmSpec.host == null || (externalPnicSpec = this._externalPnicSpecsMap.get(vmSpec.host.toString())) == null || ArrayUtil.isNullOrEmpty((Object[])vmSpec.devices)) continue;
            block1: for (PhysicalNic pnic : externalPnicSpec.physicalNics) {
                if (pnic == null) continue;
                for (VirtualDevice device : vmSpec.devices) {
                    VirtualSriovEthernetCard.SriovBackingInfo sriovBackingInfo;
                    if (!(device instanceof VirtualSriovEthernetCard) || (sriovBackingInfo = ((VirtualSriovEthernetCard)device).sriovBacking) == null || sriovBackingInfo.physicalFunctionBacking == null || StringUtil.isNullOrEmpty((String)sriovBackingInfo.physicalFunctionBacking.id) || !sriovBackingInfo.physicalFunctionBacking.id.equals(pnic.pci)) continue;
                    SriovAdapterModel adapterModel = new SriovAdapterModel();
                    adapterModel.hostName = externalPnicSpec.hostName;
                    adapterModel.hostValue = externalPnicSpec.hostRef.getValue();
                    adapterModel.title = pnic.device;
                    adapterModel.labelOne = pnic.device;
                    adapterModel.labelTwo = externalPnicSpec.hostName;
                    adapterModel.portStatus = PortStatus.NA;
                    adapterModel.physicalFunctionId = pnic.pci;
                    adapterModel.id = String.format(EXTERNAL_SRIOV_ADAPTER_ID_FORMAT, vmSpec.host.getValue(), pnic.pci);
                    if (pnic.linkSpeed != null) {
                        adapterModel.pNicLinkUp = true;
                        adapterModel.linkSpeed = Integer.toString(pnic.linkSpeed.speedMb);
                        adapterModel.duplex = SwitchDiagramUtil.getDuplexString(pnic.linkSpeed.duplex);
                        adapterModel.portStatus = PortStatus.CONNECTED;
                    }
                    externalSriovAdapterModels.add(adapterModel);
                    continue block1;
                }
            }
        }
        return externalSriovAdapterModels;
    }

    private void initialize() {
        if (!this.initialized) {
            this.initializeVmSpecsSet();
            this.initializePortsMap();
            this.initializePnicSpecsMap();
            this.initialized = true;
        }
    }

    private void sortVms(List<PortModel> vmVnics) {
        Collections.sort(vmVnics, new Comparator<PortModel>(){

            @Override
            public int compare(PortModel vm1, PortModel vm2) {
                return vm1.title.compareToIgnoreCase(vm2.title);
            }
        });
    }

    private void initializeVmSpecsSet() {
        if (!ArrayUtil.isNullOrEmpty((Object[])this._switchDiagramSpec.dvsSpec.vms)) {
            for (SwitchDiagramVmSpec vmSpec : this._switchDiagramSpec.dvsSpec.vms) {
                if (StringUtil.isNullOrEmpty((String)vmSpec.name)) continue;
                this._vmSpecs.add(vmSpec);
            }
        }
    }

    private void initializePortsMap() {
        if (!ArrayUtil.isNullOrEmpty((Object[])this._switchDiagramSpec.nonUplinkPorts)) {
            for (DistributedVirtualPort distributedVirtualPort : this._switchDiagramSpec.nonUplinkPorts) {
                if (distributedVirtualPort == null || StringUtil.isNullOrEmpty((String)distributedVirtualPort.key)) continue;
                this._portsMap.put(distributedVirtualPort.key, distributedVirtualPort);
            }
        }
    }

    private void initializePnicSpecsMap() {
        if (!ArrayUtil.isNullOrEmpty((Object[])this._externalPnicCandidates)) {
            for (SwitchDiagramExternalPnicSpec spec : this._externalPnicCandidates) {
                if (spec == null) continue;
                this._externalPnicSpecsMap.put(spec.hostRef.toString(), spec);
            }
        }
    }

    private void addVirtualMachines(PortGroupModel portGroupModel, String portgroupKey) {
        HashMap<ManagedObjectReference, List<PortModel>> vmToPortModelMap = new HashMap<ManagedObjectReference, List<PortModel>>();
        for (SwitchDiagramVmSpec vmSpec : this._vmSpecs) {
            boolean isSecondaryVm = vmSpec.ftInfo != null && DvsAddHostWizardUtil.isSecondaryVm(vmSpec.ftInfo.role);
            if (isSecondaryVm || ArrayUtil.isNullOrEmpty((Object[])vmSpec.devices)) continue;
            ArrayList<VirtualDevice> portBackingDevicesForPortgroup = new ArrayList<VirtualDevice>();
            for (VirtualDevice device : vmSpec.devices) {
                if (!(device.backing instanceof VirtualEthernetCard.DistributedVirtualPortBackingInfo) || ((VirtualEthernetCard.DistributedVirtualPortBackingInfo)device.backing).port == null || !this._dvsUuid.equals(((VirtualEthernetCard.DistributedVirtualPortBackingInfo)device.backing).port.switchUuid) || !Objects.equals(portgroupKey, ((VirtualEthernetCard.DistributedVirtualPortBackingInfo)device.backing).port.portgroupKey)) continue;
                portBackingDevicesForPortgroup.add(device);
            }
            boolean includeMac = portBackingDevicesForPortgroup.size() > 1;
            for (VirtualDevice device : portBackingDevicesForPortgroup) {
                VirtualEthernetCard.DistributedVirtualPortBackingInfo deviceBacking = (VirtualEthernetCard.DistributedVirtualPortBackingInfo)device.backing;
                DistributedVirtualPort port = this._portsMap.get(deviceBacking.port.portKey);
                PortModel portModel = this.createPortModel(vmSpec, device, port, includeMac);
                portGroupModel.vmVnics.add(portModel);
                this.mapVmToPortView(vmSpec.provider, portModel, vmToPortModelMap);
            }
        }
        this.processPortViewsMacAddress(vmToPortModelMap);
    }

    private PortModel createPortModel(SwitchDiagramVmSpec vmSpec, VirtualDevice device, DistributedVirtualPort port, boolean includeMac) {
        SriovPortModel portModel = device instanceof VirtualSriovEthernetCard ? new SriovPortModel() : new PortModel();
        portModel.portConnecteeType = PortConnectee.ConnecteeType.vmVnic;
        portModel.title = this.getVmTitle(vmSpec);
        if (vmSpec.provider != null) {
            portModel.vmValue = vmSpec.provider.getValue();
            portModel.id = UNBOUND_VM_KEY_PREFIX + vmSpec.provider.getValue() + device.key;
        }
        portModel.portStatus = PortStatus.NA;
        if (port != null) {
            if (port.key != null) {
                portModel.id = port.key;
            }
            portModel.portStatus = this.getPortConnectionStatus(port);
        }
        if (vmSpec.connectionState == VirtualMachine.ConnectionState.orphaned) {
            portModel.isOrphanedVm = true;
        }
        portModel.vmName = MixedUtil.unescapeVimEntityNameSpecialChars((String)vmSpec.name);
        portModel.powerState = vmSpec.powerState;
        portModel.virtualDeviceKey = device.key;
        if (vmSpec.host != null) {
            portModel.hostValue = vmSpec.host.getValue();
        }
        if (includeMac) {
            portModel.macAddress = SwitchDiagramUtil.getMacAddress(port, device);
        }
        if (device instanceof VirtualSriovEthernetCard && ((VirtualSriovEthernetCard)device).sriovBacking != null && ((VirtualSriovEthernetCard)device).sriovBacking.physicalFunctionBacking != null) {
            portModel.physicalFunctionId = ((VirtualSriovEthernetCard)device).sriovBacking.physicalFunctionBacking.id;
        }
        portModel.activeUplinkPorts = this.getActiveUplinkPorts((VirtualEthernetCard.DistributedVirtualPortBackingInfo)device.backing);
        return portModel;
    }

    private String getVmTitle(SwitchDiagramVmSpec vmSpec) {
        String vmName = null;
        if (vmSpec != null) {
            boolean showSecondaryText = vmSpec.ftInfo != null && DvsAddHostWizardUtil.isSecondaryVm(vmSpec.ftInfo.role);
            vmName = MixedUtil.unescapeVimEntityNameSpecialChars((String)vmSpec.name);
            if (showSecondaryText && vmName != null) {
                vmName = vmName + NetworkStringUtil.getString("SwitchDiagram.secondaryText");
            }
        }
        return vmName;
    }

    private void mapVmToPortView(ManagedObjectReference vm, PortModel portModel, Map<ManagedObjectReference, List<PortModel>> vmToPortView) {
        List<PortModel> vmPortModels = vmToPortView.get(vm);
        if (vmPortModels == null) {
            vmPortModels = new ArrayList<PortModel>();
            vmToPortView.put(vm, vmPortModels);
        }
        vmPortModels.add(portModel);
    }

    private String[] getActiveUplinkPorts(VirtualEthernetCard.DistributedVirtualPortBackingInfo portBackingInfo) {
        DistributedVirtualPort dvPort;
        String[] result = null;
        if (portBackingInfo != null && portBackingInfo.port != null && !StringUtil.isNullOrEmpty((String)portBackingInfo.port.portKey) && (dvPort = this._portsMap.get(portBackingInfo.port.portKey)) != null && dvPort.config != null && dvPort.config.setting instanceof VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy) {
            VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy policy = (VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy)dvPort.config.setting;
            if (policy.uplinkTeamingPolicy != null && policy.uplinkTeamingPolicy.uplinkPortOrder != null) {
                result = policy.uplinkTeamingPolicy.uplinkPortOrder.activeUplinkPort;
            }
        }
        if (result == null) {
            result = new String[]{};
        }
        return result;
    }

    private void processPortViewsMacAddress(Map<ManagedObjectReference, List<PortModel>> vmToPortModelMap) {
        for (Map.Entry<ManagedObjectReference, List<PortModel>> entry : vmToPortModelMap.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            for (PortModel portModel : entry.getValue()) {
                if (portModel.macAddress != null || portModel.virtualDevice == null) continue;
                portModel.macAddress = SwitchDiagramUtil.getMacAddress(null, portModel.virtualDevice);
            }
        }
    }
}

