/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.vnic.model;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.cis.data.model.NestedQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.host.NetStackInstance;
import com.vmware.vim.binding.vim.host.RuntimeInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.h5.network.host.vnic.model.HostVnicFeatures;

@QueryBinding(value="HostSystem")
public class HostVnicServicesData
extends IdentifiableQueryBinding {
    @Property(value="HostSystem/runtime/networkRuntimeInfo/netStackInstanceRuntimeInfo")
    public transient RuntimeInfo.NetStackInstanceRuntimeInfo[] netStackInstanceRuntimeInfos;
    @NestedQueryBinding
    public HostVnicFeatures hostVnicFeatures;

    public boolean getIsProvisioningTrafficEnabledForDefaultStack() {
        return this.isTrafficEnabled(NetStackInstance.SystemStackKey.vSphereProvisioning);
    }

    public boolean getIsVmotionTrafficEnabledForDefaultStack() {
        return this.isTrafficEnabled(NetStackInstance.SystemStackKey.vmotion);
    }

    private boolean isTrafficEnabled(NetStackInstance.SystemStackKey systemStackKey) {
        if (this.hostVnicFeatures.isTcpIpStackSupported && !ArrayUtil.isNullOrEmpty((Object[])this.netStackInstanceRuntimeInfos)) {
            for (RuntimeInfo.NetStackInstanceRuntimeInfo netStackInstanceRuntimeInfo : this.netStackInstanceRuntimeInfos) {
                if (netStackInstanceRuntimeInfo == null || netStackInstanceRuntimeInfo.getNetStackInstanceKey() == null || !netStackInstanceRuntimeInfo.getNetStackInstanceKey().equals(systemStackKey.name())) continue;
                return ArrayUtil.isNullOrEmpty((Object[])netStackInstanceRuntimeInfo.vmknicKeys);
            }
        }
        return true;
    }
}

