/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.vnic;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.vim.binding.vim.host.NetStackInstance;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.host.VirtualNicManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vsphere.client.dvpg.api.HostNetworkDetailsData;
import com.vmware.vsphere.client.h5.network.host.vnic.VnicParser;
import com.vmware.vsphere.client.h5.network.host.vnic.VnicUtils;
import com.vmware.vsphere.client.h5.network.host.vnic.model.HostNetworkData;
import com.vmware.vsphere.client.h5.network.host.vnic.model.HostVnicFeatures;
import com.vmware.vsphere.client.h5.network.host.vnic.model.HostVnicItem;
import com.vmware.vsphere.client.h5.network.host.vnic.model.HostVnicNetStackData;
import com.vmware.vsphere.client.h5.network.host.vnic.model.HostVnicsResult;
import java.util.List;

public class HostVnicsPropertyProvider
implements PropertyProviderBean {
    private final QueryBindingService _queryBindingService;

    public HostVnicsPropertyProvider(QueryBindingServiceFactory queryBindingServiceFactory) {
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="vnic", property="virtualAdaptersData")
    public HostVnicsResult getVirtualAdaptersData(ManagedObjectReference hostRef) {
        HostVnicsResult vnicsResult = new HostVnicsResult();
        HostNetworkData hostNetworkData = this.fetchHostNetworkInfo(hostRef);
        if (hostNetworkData != null) {
            List<HostVnicItem> vnics = VnicParser.parse(hostNetworkData);
            vnicsResult.items = vnics.toArray(new HostVnicItem[vnics.size()]);
            vnicsResult.hostFeatures = hostNetworkData.hostVnicSupportedFeatures;
            vnicsResult.isVsanWitnessTrafficSupported = VnicParser.isVsanWitnessTrafficSupported(hostNetworkData.vnicManagerInfo);
        } else {
            vnicsResult.items = new HostVnicItem[0];
            vnicsResult.hostFeatures = new HostVnicFeatures();
            vnicsResult.isVsanWitnessTrafficSupported = false;
        }
        return vnicsResult;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="vnic", property="virtualAdapterDetailsData")
    public HostNetworkDetailsData getVirtualAdapterDetailsData(ManagedObjectReference hostRef, String device) {
        HostNetworkData hostNetworkData = this.fetchHostNetworkInfo(hostRef);
        if (hostNetworkData == null || hostNetworkData.networkInfo == null) {
            return null;
        }
        VirtualNic virtualNic = VnicUtils.getVnicByDevice(hostNetworkData.networkInfo.vnic, device);
        return VnicParser.parseVnicDetails(hostNetworkData, virtualNic);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="vnic", property="isSystemTrafficEnabled")
    public boolean getIsSystemTrafficEnabled(ManagedObjectReference hostRef, String systemTrafficName) {
        VirtualNicManager.NicType nicType;
        HostVnicNetStackData hostVnicNetStackData = (HostVnicNetStackData)((Object)this._queryBindingService.prepare(HostVnicNetStackData.class).fetch((Object)hostRef));
        if (hostVnicNetStackData == null || hostVnicNetStackData.vnics == null || hostVnicNetStackData.vnicManagerInfo == null) {
            return false;
        }
        if (systemTrafficName.equals(NetStackInstance.SystemStackKey.vmotion.name())) {
            nicType = VirtualNicManager.NicType.vmotion;
        } else if (systemTrafficName.equals(NetStackInstance.SystemStackKey.vSphereProvisioning.name())) {
            nicType = VirtualNicManager.NicType.vSphereProvisioning;
        } else {
            throw new IllegalArgumentException(String.format("The provided system traffic '%s' is neither 'vmotion' nor 'vSphereProvisioning'.", systemTrafficName));
        }
        for (VirtualNic vnic : hostVnicNetStackData.vnics) {
            if (!VnicUtils.isDefaultNetStackInstance(vnic.spec.netStackInstanceKey) || !VnicUtils.isTrafficEnabled(vnic.key, nicType, hostVnicNetStackData.vnicManagerInfo.netConfig)) continue;
            return true;
        }
        return false;
    }

    private HostNetworkData fetchHostNetworkInfo(ManagedObjectReference hostRef) {
        return (HostNetworkData)((Object)this._queryBindingService.prepare(HostNetworkData.class).fetch((Object)hostRef));
    }
}

