/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.pnic;

import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vim.host.NetworkInfo;
import com.vmware.vim.binding.vim.host.NetworkPolicy;
import com.vmware.vim.binding.vim.host.OpaqueSwitch;
import com.vmware.vim.binding.vim.host.PciDevice;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vim.host.SriovInfo;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.h5.network.host.pnic.model.EditHostPnicModel;
import com.vmware.vsphere.client.h5.network.host.pnic.model.HostPnicDetailsData;
import com.vmware.vsphere.client.h5.network.host.pnic.model.HostPnicItem;
import com.vmware.vsphere.client.h5.network.host.pnic.model.HostPnicSwitchData;
import com.vmware.vsphere.client.h5.network.host.pnic.model.HostPnicsWithDetailsModel;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import com.vmware.vsphere.client.network.host.api.CdpInfoItem;
import com.vmware.vsphere.client.network.host.api.DeviceCapabilitiesItem;
import com.vmware.vsphere.client.network.host.api.HostPnicDetailsItem;
import com.vmware.vsphere.client.network.host.api.LldpInfoItem;
import com.vmware.vsphere.client.network.host.api.SriovInfoItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PnicParser {
    private static final Log _logger = LogFactory.getLog(PnicParser.class);
    public static final int AUTO_LINK_SPEED_SPEED = 0;
    public static final boolean AUTO_LINK_SPEED_DUPLEX = false;
    public static final int VLAN_NUM_NONE = 0;
    public static final int VLAN_NUM_ALL = 4095;
    public static final String PNIC_DEVICE_PREFIX = "vmnic";

    public static HostPnicDetailsItem createHostPnicDetailsItem(PhysicalNic pnic, HostPnicDetailsData pnicDetailsData) {
        PciDevice pciDevice;
        if (pnic == null || pnicDetailsData == null) {
            return null;
        }
        HostPnicDetailsItem pnicDetailsItem = new HostPnicDetailsItem();
        pnicDetailsItem.location = NetworkStringUtil.getString("pnicDetails.pci", pnic.getPci());
        pnicDetailsItem.deviceName = pnic.getDevice();
        pnicDetailsItem.driverName = pnic.getDriver();
        boolean bl = pnicDetailsItem.isConnected = pnic.getLinkSpeed() != null;
        if (pnicDetailsItem.isConnected) {
            pnicDetailsItem.actualSpeed = pnic.getLinkSpeed().getSpeedMb();
            pnicDetailsItem.isActualSpeedFullDuplex = pnic.getLinkSpeed().isDuplex();
            if (pnic.getSpec() != null && pnic.getSpec().getLinkSpeed() != null) {
                pnicDetailsItem.configuredSpeed = pnic.getSpec().getLinkSpeed().getSpeedMb();
                pnicDetailsItem.isConfiguredSpeedFullDuplex = pnic.getSpec().getLinkSpeed().isDuplex();
            }
        }
        if ((pciDevice = PnicParser.getPciDevice(pnic, pnicDetailsData.pciDevices)) != null) {
            pnicDetailsItem.adapterName = String.format("%s %s", pciDevice.getVendorName(), pciDevice.getDeviceName());
        }
        pnicDetailsItem.networkHints = PnicParser.getNetworkHints(pnic.getDevice(), pnicDetailsData.ipV6Enabled, pnicDetailsData.networkHints);
        if (pnic.resourcePoolSchedulerAllowed != null && !NetworkUtil.isPnicAttachedToVss(pnic, pnicDetailsData.vSwitches)) {
            pnicDetailsItem.resourcePoolSchedulerAllowed = pnic.resourcePoolSchedulerAllowed;
            pnicDetailsItem.resourcePoolSchedulerDisallowedReasons = PnicParser.getResourcePoolSchedulerDisallowedReasons(pnic);
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])pnicDetailsData.networkHints)) {
            pnicDetailsItem.areNetworkHintsRetrieved = true;
            PhysicalNic.NetworkHint networkHint = PnicParser.getNetworkHint(pnic.device, pnicDetailsData.networkHints);
            pnicDetailsItem.cdpInfo = PnicParser.getCdpInfoItem(networkHint);
            pnicDetailsItem.lldpInfo = PnicParser.getLldpInfoItem(networkHint);
        }
        SriovInfo pnicSriovInfo = NetworkUtil.getSriovByPnic(pnic.pci, pnicDetailsData.sriovInfo);
        pnicDetailsItem.sriovInfo = PnicParser.assignSriovInfoItem(pnicSriovInfo, false);
        return pnicDetailsItem;
    }

    public static HostPnicsWithDetailsModel getUnclaimedPhysicalAdaptersWithDetails(HostPnicSwitchData pnicSwitchData) {
        HostPnicsWithDetailsModel hostPnicsWithDetailsModel = new HostPnicsWithDetailsModel();
        if (pnicSwitchData == null || ArrayUtil.isNullOrEmpty((Object[])pnicSwitchData.pnics)) {
            return hostPnicsWithDetailsModel;
        }
        hostPnicsWithDetailsModel.unclaimed = new ArrayList<String>();
        hostPnicsWithDetailsModel.pnicDetails = new HashMap<String, HostPnicDetailsItem>();
        for (PhysicalNic pnic : pnicSwitchData.pnics) {
            if (PnicParser.getVirtualSwitch(pnic, pnicSwitchData.vSwitches, pnicSwitchData.proxySwitches, pnicSwitchData.opaqueSwitches) != null) continue;
            hostPnicsWithDetailsModel.unclaimed.add(pnic.device);
            hostPnicsWithDetailsModel.pnicDetails.put(pnic.device, PnicParser.createHostPnicDetailsItem(pnic, pnicSwitchData));
        }
        return hostPnicsWithDetailsModel;
    }

    public static HostPnicsWithDetailsModel getPnicWithDetails(HostPnicDetailsData pnicDetailsData, NetworkPolicy.NicOrderPolicy nicOrder, VirtualSwitch vSwitch) {
        PhysicalNic pnic;
        List<String> active = null;
        List<String> standby = null;
        List<String> unused = null;
        if (pnicDetailsData != null && ArrayUtils.isNotEmpty((Object[])pnicDetailsData.pnics)) {
            active = NetworkUtil.getActiveNics(nicOrder);
            standby = NetworkUtil.getStandbyNics(nicOrder);
            unused = NetworkUtil.getUnusedNics(nicOrder, vSwitch, pnicDetailsData.pnics);
        }
        if (CollectionUtils.isEmpty(active) && CollectionUtils.isEmpty(standby) && CollectionUtils.isEmpty(unused)) {
            return null;
        }
        HostPnicsWithDetailsModel pnicsWithDetailsModel = new HostPnicsWithDetailsModel();
        pnicsWithDetailsModel.active = new ArrayList<String>();
        pnicsWithDetailsModel.standby = new ArrayList<String>();
        pnicsWithDetailsModel.unused = new ArrayList<String>();
        pnicsWithDetailsModel.pnicDetails = new HashMap<String, HostPnicDetailsItem>();
        if (CollectionUtils.isNotEmpty(active)) {
            for (String pnicName : active) {
                pnic = NetworkUtil.getPnicByName(pnicName, pnicDetailsData.pnics);
                if (pnic == null) continue;
                pnicsWithDetailsModel.active.add(pnic.device);
                pnicsWithDetailsModel.pnicDetails.put(pnic.device, PnicParser.createHostPnicDetailsItem(pnic, pnicDetailsData));
            }
        }
        if (CollectionUtils.isNotEmpty(standby)) {
            for (String pnicName : standby) {
                pnic = NetworkUtil.getPnicByName(pnicName, pnicDetailsData.pnics);
                if (pnic == null) continue;
                pnicsWithDetailsModel.standby.add(pnic.device);
                pnicsWithDetailsModel.pnicDetails.put(pnic.device, PnicParser.createHostPnicDetailsItem(pnic, pnicDetailsData));
            }
        }
        if (CollectionUtils.isNotEmpty(unused)) {
            for (String pnicName : unused) {
                pnic = NetworkUtil.getPnicByName(pnicName, pnicDetailsData.pnics);
                if (pnic == null) continue;
                pnicsWithDetailsModel.unused.add(pnic.device);
                pnicsWithDetailsModel.pnicDetails.put(pnic.device, PnicParser.createHostPnicDetailsItem(pnic, pnicDetailsData));
            }
        }
        return pnicsWithDetailsModel;
    }

    public static HostPnicsWithDetailsModel getFailOverPnicsWithDetails(HostPnicSwitchData pnicSwitchData, NetworkPolicy.NicOrderPolicy nicOrder, VirtualSwitch vSwitch) {
        HostPnicsWithDetailsModel hostPnicsWithDetailsModel = PnicParser.getPnicWithDetails(pnicSwitchData, nicOrder, vSwitch);
        if (hostPnicsWithDetailsModel == null) {
            hostPnicsWithDetailsModel = new HostPnicsWithDetailsModel();
            hostPnicsWithDetailsModel.pnicDetails = new HashMap<String, HostPnicDetailsItem>();
        }
        hostPnicsWithDetailsModel.unclaimed = new ArrayList<String>();
        List<PhysicalNic> unclaimedPhysicalNics = PnicParser.getUnclaimedPhysicalAdaptersWithDetails(pnicSwitchData.pnics, pnicSwitchData.vSwitches, pnicSwitchData.proxySwitches, pnicSwitchData.opaqueSwitches);
        for (PhysicalNic pnic : unclaimedPhysicalNics) {
            hostPnicsWithDetailsModel.unclaimed.add(pnic.device);
            hostPnicsWithDetailsModel.pnicDetails.put(pnic.device, PnicParser.createHostPnicDetailsItem(pnic, pnicSwitchData));
        }
        return hostPnicsWithDetailsModel;
    }

    public static String getNetworkHint(String pnicDevice, Boolean ipV6Enabled, PhysicalNic.NetworkHint[] networkHints) {
        String networkHint = NetworkStringUtil.getString("pnicData.noNetworks");
        if (pnicDevice != null && networkHints != null) {
            List<String> allNetworkHints = PnicParser.getIpNetworkHints(ipV6Enabled, networkHints, pnicDevice);
            allNetworkHints.addAll(PnicParser.getNamedNetworkHints(networkHints, pnicDevice));
            String hintText = StringUtils.join((Object[])allNetworkHints.toArray(new String[allNetworkHints.size()]), (String)",\n");
            if (!StringUtil.isNullOrEmpty((String)hintText)) {
                networkHint = hintText;
            }
        }
        return networkHint;
    }

    public static HostPnicItem.VirtualSwitch getVirtualSwitch(PhysicalNic pnic, NetworkInfo networkInfo) {
        if (pnic == null || networkInfo == null) {
            return null;
        }
        return PnicParser.getVirtualSwitch(pnic, networkInfo.vswitch, networkInfo.proxySwitch, networkInfo.opaqueSwitch);
    }

    public static List<HostPnicItem> sortPnicsByDeviceNumerically(List<HostPnicItem> pnicItems) {
        if (pnicItems == null) {
            return null;
        }
        Collections.sort(pnicItems, new Comparator<HostPnicItem>(){

            @Override
            public int compare(HostPnicItem item1, HostPnicItem item2) {
                if (item1 == null) {
                    return -1;
                }
                if (item2 == null) {
                    return 1;
                }
                return NetworkUtil.compareNicDevices(item1.device, item2.device, PnicParser.PNIC_DEVICE_PREFIX);
            }
        });
        return pnicItems;
    }

    public static EditHostPnicModel createEditPnicModel(PhysicalNic pnic, SriovInfo sriovInfo) {
        if (pnic == null) {
            return null;
        }
        EditHostPnicModel editHostPnicModel = new EditHostPnicModel();
        editHostPnicModel.pci = pnic.pci;
        editHostPnicModel.name = pnic.device;
        editHostPnicModel.linkSpecification = new ArrayList<PhysicalNic.LinkSpeedDuplex>();
        if (pnic.validLinkSpecification != null) {
            editHostPnicModel.linkSpecification.addAll(Arrays.asList(pnic.validLinkSpecification));
        }
        if (Boolean.TRUE.equals(pnic.autoNegotiateSupported)) {
            editHostPnicModel.linkSpecification.add(new PhysicalNic.LinkSpeedDuplex(0, false));
            if (pnic.spec.linkSpeed == null) {
                editHostPnicModel.linkSpeed = editHostPnicModel.linkSpecification.get(editHostPnicModel.linkSpecification.size() - 1);
            }
        }
        if (pnic.spec.linkSpeed != null) {
            editHostPnicModel.linkSpeed = pnic.spec.linkSpeed;
        }
        editHostPnicModel.sriovInfoItem = PnicParser.assignSriovInfoItem(sriovInfo, true);
        return editHostPnicModel;
    }

    public static SriovInfoItem assignSriovInfoItem(SriovInfo pnicSriovInfo, boolean isEditPnicModel) {
        if (pnicSriovInfo == null) {
            return null;
        }
        SriovInfoItem sriovInfo = new SriovInfoItem();
        sriovInfo.sriovCapable = pnicSriovInfo.sriovCapable;
        sriovInfo.sriovEnabled = pnicSriovInfo.sriovEnabled;
        sriovInfo.numVirtualFunction = pnicSriovInfo.numVirtualFunction;
        sriovInfo.numVirtualFunctionsRequested = pnicSriovInfo.numVirtualFunctionRequested;
        if (isEditPnicModel) {
            sriovInfo.sriovActive = pnicSriovInfo.sriovActive;
            sriovInfo.maxVirtualFunctionSupported = pnicSriovInfo.maxVirtualFunctionSupported;
        }
        return sriovInfo;
    }

    private static List<PhysicalNic> getUnclaimedPhysicalAdaptersWithDetails(PhysicalNic[] hostPnics, VirtualSwitch[] standardSwitches, HostProxySwitch[] hostProxySwitches, OpaqueSwitch[] opaqueSwitches) {
        ArrayList<PhysicalNic> unclaimedPhysicalNics = new ArrayList<PhysicalNic>();
        for (PhysicalNic pnic : hostPnics) {
            if (PnicParser.getVirtualSwitch(pnic, standardSwitches, hostProxySwitches, opaqueSwitches) != null) continue;
            unclaimedPhysicalNics.add(pnic);
        }
        return unclaimedPhysicalNics;
    }

    private static String[] getNetworkHints(String pnicDevice, Boolean ipV6Enabled, PhysicalNic.NetworkHint[] networkHints) {
        if (pnicDevice != null && networkHints != null) {
            List<String> allNetworkHints = PnicParser.getIpNetworkHints(ipV6Enabled, networkHints, pnicDevice);
            allNetworkHints.addAll(PnicParser.getNamedNetworkHints(networkHints, pnicDevice));
            return allNetworkHints.toArray(new String[allNetworkHints.size()]);
        }
        return new String[0];
    }

    private static PciDevice getPciDevice(PhysicalNic pnic, PciDevice[] pciDevices) {
        PciDevice pciDevice = null;
        if (pciDevices != null) {
            for (PciDevice pci : pciDevices) {
                if (!pnic.getPci().equals(pci.getId())) continue;
                pciDevice = pci;
            }
        }
        return pciDevice;
    }

    private static String[] getResourcePoolSchedulerDisallowedReasons(PhysicalNic pnic) {
        if (pnic.resourcePoolSchedulerDisallowedReason == null) {
            return new String[0];
        }
        ArrayList<String> localizedReasons = new ArrayList<String>();
        for (String reason : pnic.resourcePoolSchedulerDisallowedReason) {
            if (PhysicalNic.ResourcePoolSchedulerDisallowedReason.hardwareUnsupported.name().equals(reason)) {
                localizedReasons.add(NetworkStringUtil.getString("PnicView.resAllocDisallowReason.hardwareUnsupported"));
                continue;
            }
            if (PhysicalNic.ResourcePoolSchedulerDisallowedReason.userOptOut.name().equals(reason)) {
                localizedReasons.add(NetworkStringUtil.getString("PnicView.resAllocDisallowReason.usrOptOut"));
                continue;
            }
            _logger.warn((Object)("Unknown resource pool scheduler disallowed reason: " + reason));
        }
        return localizedReasons.toArray(new String[localizedReasons.size()]);
    }

    private static CdpInfoItem getCdpInfoItem(PhysicalNic.NetworkHint networkHint) {
        if (networkHint == null || networkHint.connectedSwitchPort == null) {
            return null;
        }
        PhysicalNic.CdpInfo cdpInfo = networkHint.connectedSwitchPort;
        CdpInfoItem cdpInfoItem = new CdpInfoItem();
        cdpInfoItem.version = PnicParser.formatValue(cdpInfo.cdpVersion);
        cdpInfoItem.timeout = PnicParser.formatValue(cdpInfo.timeout);
        cdpInfoItem.ttl = PnicParser.formatValue(cdpInfo.ttl);
        cdpInfoItem.samples = PnicParser.formatValue(cdpInfo.samples);
        cdpInfoItem.devId = PnicParser.formatValue(cdpInfo.devId);
        cdpInfoItem.address = PnicParser.formatValue(cdpInfo.address);
        cdpInfoItem.portId = PnicParser.formatValue(cdpInfo.portId);
        cdpInfoItem.softwareVersion = PnicParser.formatValue(cdpInfo.softwareVersion);
        cdpInfoItem.hardwarePlatform = PnicParser.formatValue(cdpInfo.hardwarePlatform);
        cdpInfoItem.ipPrefix = PnicParser.formatValue(cdpInfo.ipPrefix);
        cdpInfoItem.ipPrefixLen = PnicParser.formatValue(cdpInfo.ipPrefixLen);
        cdpInfoItem.vlan = PnicParser.formatValue(cdpInfo.vlan);
        cdpInfoItem.fullDuplex = PnicParser.formatValue(cdpInfo.fullDuplex);
        cdpInfoItem.mtu = PnicParser.formatValue(cdpInfo.mtu);
        cdpInfoItem.systemName = PnicParser.formatValue(cdpInfo.systemName);
        cdpInfoItem.systemOID = PnicParser.formatValue(cdpInfo.systemOID);
        cdpInfoItem.mgmtAddr = PnicParser.formatValue(cdpInfo.mgmtAddr);
        cdpInfoItem.location = PnicParser.formatValue(cdpInfo.location);
        cdpInfoItem.deviceCapabilities = PnicParser.getDeviceCapability(cdpInfo.deviceCapability);
        return cdpInfoItem;
    }

    private static LldpInfoItem getLldpInfoItem(PhysicalNic.NetworkHint networkHint) {
        if (networkHint == null || networkHint.lldpInfo == null) {
            return null;
        }
        PhysicalNic.LldpInfo lldpInfo = networkHint.lldpInfo;
        LldpInfoItem lldpInfoItem = new LldpInfoItem();
        lldpInfoItem.chassisId = PnicParser.formatValue(lldpInfo.chassisId);
        lldpInfoItem.portId = PnicParser.formatValue(lldpInfo.portId);
        lldpInfoItem.ttl = PnicParser.formatValue(lldpInfo.timeToLive);
        if (!ArrayUtil.isNullOrEmpty((Object[])lldpInfo.parameter)) {
            lldpInfoItem.parameter = new ArrayList();
            for (KeyAnyValue param : lldpInfo.parameter) {
                if (param == null || param.getValue() instanceof PhysicalNic.CdpDeviceCapability) continue;
                lldpInfoItem.parameter.add(param);
            }
        }
        PhysicalNic.CdpDeviceCapability deviceCapability = PnicParser.getCdpDeviceCapability(lldpInfo.parameter);
        lldpInfoItem.deviceCapabilities = PnicParser.getDeviceCapability(deviceCapability);
        return lldpInfoItem;
    }

    private static DeviceCapabilitiesItem getDeviceCapability(PhysicalNic.CdpDeviceCapability deviceCapability) {
        DeviceCapabilitiesItem deviceCapabilitiesItem = new DeviceCapabilitiesItem();
        if (deviceCapability != null) {
            deviceCapabilitiesItem.router = PnicParser.formatValue(deviceCapability.router);
            deviceCapabilitiesItem.transparentBridge = PnicParser.formatValue(deviceCapability.transparentBridge);
            deviceCapabilitiesItem.sourceRouteBridge = PnicParser.formatValue(deviceCapability.sourceRouteBridge);
            deviceCapabilitiesItem.networkSwitch = PnicParser.formatValue(deviceCapability.networkSwitch);
            deviceCapabilitiesItem.host = PnicParser.formatValue(deviceCapability.host);
            deviceCapabilitiesItem.igmpEnabled = PnicParser.formatValue(deviceCapability.igmpEnabled);
            deviceCapabilitiesItem.repeater = PnicParser.formatValue(deviceCapability.repeater);
        }
        return deviceCapabilitiesItem;
    }

    private static PhysicalNic.CdpDeviceCapability getCdpDeviceCapability(KeyAnyValue[] keyAnyValues) {
        if (ArrayUtil.isNullOrEmpty((Object[])keyAnyValues)) {
            return null;
        }
        for (KeyAnyValue param : keyAnyValues) {
            if (param == null || param.getValue() == null || !(param.getValue() instanceof PhysicalNic.CdpDeviceCapability)) continue;
            return (PhysicalNic.CdpDeviceCapability)param.getValue();
        }
        return null;
    }

    private static PhysicalNic.NetworkHint getNetworkHint(String pnicDevice, PhysicalNic.NetworkHint[] networkHints) {
        if (!ArrayUtil.isNullOrEmpty((Object[])networkHints) && pnicDevice != null) {
            for (PhysicalNic.NetworkHint hint : networkHints) {
                if (!pnicDevice.equals(hint.device)) continue;
                return hint;
            }
        }
        return null;
    }

    private static List<String> getNamedNetworkHints(PhysicalNic.NetworkHint[] networkHints, String pnicDevice) {
        ArrayList<String> namedHints = new ArrayList<String>();
        if (networkHints != null && pnicDevice != null) {
            for (PhysicalNic.NetworkHint nHint : networkHints) {
                if (!StringUtils.equals((String)pnicDevice, (String)nHint.device) || ArrayUtil.isNullOrEmpty((Object[])nHint.network)) continue;
                for (PhysicalNic.NetworkHint.NamedNetwork nNetwork : nHint.network) {
                    namedHints.add(nNetwork.network);
                }
            }
        }
        return namedHints;
    }

    private static List<String> getIpNetworkHints(Boolean isIpv6Enabled, PhysicalNic.NetworkHint[] networkHints, String pnicDevice) {
        ArrayList<String> ipHints = new ArrayList<String>();
        ArrayList<String> ipv6Hints = new ArrayList<String>();
        if (networkHints != null && !StringUtil.isNullOrEmpty((String)pnicDevice)) {
            for (PhysicalNic.NetworkHint nHint : networkHints) {
                if (StringUtils.equals((String)pnicDevice, (String)nHint.device) && !ArrayUtil.isNullOrEmpty((Object[])nHint.subnet)) {
                    for (PhysicalNic.NetworkHint.IpNetwork ipNetwork : nHint.subnet) {
                        if (ipNetwork.ipSubnet == null) continue;
                        String ipNetworkHint = ipNetwork.vlanId != 0 && ipNetwork.vlanId != 4095 ? NetworkStringUtil.getString("pnicData.vlan", ipNetwork.ipSubnet, ipNetwork.vlanId.toString()) : ipNetwork.ipSubnet;
                        if (ipNetwork.ipSubnet.contains(".")) {
                            ipHints.add(ipNetworkHint);
                            continue;
                        }
                        if (isIpv6Enabled == null || !isIpv6Enabled.booleanValue() || !ipNetwork.ipSubnet.contains(":")) continue;
                        ipv6Hints.add(ipNetworkHint);
                    }
                }
                ipHints.addAll(ipv6Hints);
            }
        }
        return ipHints;
    }

    private static HostPnicItem.VirtualSwitch getVirtualSwitch(PhysicalNic pnic, VirtualSwitch[] vSwitches, HostProxySwitch[] proxySwitches, OpaqueSwitch[] opaqueSwitches) {
        HostPnicItem.VirtualSwitch virtualSwitch = new HostPnicItem.VirtualSwitch();
        if (vSwitches != null) {
            for (VirtualSwitch virtualSwitch2 : vSwitches) {
                if (virtualSwitch2.pnic == null) continue;
                for (String pnicKey : virtualSwitch2.pnic) {
                    if (!StringUtils.equals((String)pnicKey, (String)pnic.key)) continue;
                    virtualSwitch.switchName = MixedUtil.unescapeVimEntityNameSpecialChars((String)virtualSwitch2.name);
                    virtualSwitch.iconId = "network-lib-ui-icon-vswitch";
                    return virtualSwitch;
                }
            }
        }
        if (proxySwitches != null) {
            for (VirtualSwitch virtualSwitch3 : proxySwitches) {
                if (virtualSwitch3.pnic == null) continue;
                for (String pnicKey : virtualSwitch3.pnic) {
                    if (!StringUtils.equals((String)pnicKey, (String)pnic.key)) continue;
                    virtualSwitch.switchName = MixedUtil.unescapeVimEntityNameSpecialChars((String)virtualSwitch3.dvsName);
                    virtualSwitch.iconId = "vsphere-icon-dv-switch";
                    return virtualSwitch;
                }
            }
        }
        if (opaqueSwitches != null) {
            for (VirtualSwitch virtualSwitch4 : opaqueSwitches) {
                if (virtualSwitch4.pnic == null) continue;
                for (String pnicKey : virtualSwitch4.pnic) {
                    if (!StringUtils.equals((String)pnicKey, (String)pnic.key)) continue;
                    if (!StringUtil.isNullOrEmpty((String)virtualSwitch4.name)) {
                        virtualSwitch.switchName = MixedUtil.unescapeVimEntityNameSpecialChars((String)virtualSwitch4.name);
                        virtualSwitch.iconId = "network-lib-ui-icon-opaqueSwitch";
                        return virtualSwitch;
                    }
                    if (virtualSwitch4.key == null) continue;
                    String opaqueSwitchKey = virtualSwitch4.key.replace("key-vim.host.OpaqueSwitch-", "");
                    virtualSwitch.switchName = MixedUtil.unescapeVimEntityNameSpecialChars((String)opaqueSwitchKey);
                    virtualSwitch.iconId = "network-lib-ui-icon-opaqueSwitch";
                    return virtualSwitch;
                }
            }
        }
        return null;
    }

    private static <T> String formatValue(T value) {
        if (value instanceof Boolean) {
            return PnicParser.formatBooleanValue((Boolean)value);
        }
        return value == null ? "" : value.toString();
    }

    private static String formatBooleanValue(Boolean value) {
        if (value == null) {
            return "";
        }
        if (value.booleanValue()) {
            return NetworkStringUtil.getString("enabled");
        }
        return NetworkStringUtil.getString("disabled");
    }
}

