/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.netstack;

import com.vmware.vim.binding.vim.host.DnsConfig;
import com.vmware.vim.binding.vim.host.NetStackInstance;
import com.vmware.vsphere.client.h5.network.host.netstack.NetStackUtil;
import com.vmware.vsphere.client.h5.network.host.netstack.model.NetStackReconfigureSpec;

public class HostNetStackParser {
    private HostNetStackParser() {
    }

    public static NetStackInstance buildReconfiguredNetStack(NetStackInstance initialNetStack, NetStackReconfigureSpec reconfigureSpec) {
        NetStackInstance mutatedNetStack = new NetStackInstance();
        mutatedNetStack.key = initialNetStack.key;
        mutatedNetStack.name = reconfigureSpec.name;
        mutatedNetStack.dnsConfig = HostNetStackParser.buildUpdatedDnsConfig(initialNetStack.dnsConfig, reconfigureSpec.dnsConfig);
        mutatedNetStack.ipRouteConfig = reconfigureSpec.ipRouteConfig;
        mutatedNetStack.congestionControlAlgorithm = reconfigureSpec.congestionControlAlgorithm;
        mutatedNetStack.requestedMaxNumberOfConnections = reconfigureSpec.requestedMaxNumberOfConnections;
        return mutatedNetStack;
    }

    public static DnsConfig buildUpdatedDnsConfig(DnsConfig dnsConfigInitial, NetStackReconfigureSpec.DnsReconfigureSpec reconfigureSpec) {
        if (reconfigureSpec == null) {
            return null;
        }
        DnsConfig dnsConfigUpdated = new DnsConfig();
        dnsConfigUpdated.dhcp = dnsConfigInitial.dhcp;
        dnsConfigUpdated.virtualNicDevice = dnsConfigInitial.virtualNicDevice;
        dnsConfigUpdated.hostName = dnsConfigInitial.hostName;
        dnsConfigUpdated.domainName = dnsConfigInitial.domainName;
        dnsConfigUpdated.address = dnsConfigInitial.address;
        dnsConfigUpdated.searchDomain = dnsConfigInitial.searchDomain;
        if (reconfigureSpec.isDhcpEnabled != null) {
            dnsConfigUpdated.dhcp = reconfigureSpec.isDhcpEnabled;
        }
        if (dnsConfigUpdated.dhcp) {
            if (reconfigureSpec.selectedVnic != null) {
                dnsConfigUpdated.virtualNicDevice = reconfigureSpec.selectedVnic;
            }
        } else {
            if (reconfigureSpec.hostName != null) {
                dnsConfigUpdated.hostName = reconfigureSpec.hostName;
            }
            if (reconfigureSpec.domainName != null) {
                dnsConfigUpdated.domainName = reconfigureSpec.domainName;
            }
            if (reconfigureSpec.preferredDns != null || reconfigureSpec.alternateDns != null) {
                dnsConfigUpdated.address = NetStackUtil.createDnsAddresses(reconfigureSpec.preferredDns, reconfigureSpec.alternateDns, dnsConfigUpdated.address);
            }
            if (reconfigureSpec.searchDomains != null) {
                dnsConfigUpdated.searchDomain = NetStackUtil.buildSearchDomains(reconfigureSpec.searchDomains);
            }
        }
        return dnsConfigUpdated;
    }
}

