/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.imports;

import com.vmware.vim.binding.vim.BoolPolicy;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.InheritablePolicy;
import com.vmware.vim.binding.vim.StringPolicy;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.dvs.api.spec.DvpgRestoreSectionRepresentationSpec;
import com.vmware.vsphere.client.dvs.api.spec.DvpgRestoreSettingRepresentationSpec;
import com.vmware.vsphere.client.h5.network.dvs.imports.DvpgRestoreFailoverPolicyModel;
import com.vmware.vsphere.client.h5.network.dvs.imports.DvpgRestoreVlanPolicyModel;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DvpgRestoreParser {
    public static final String GENERIC_TRAFFIC_FILTER_RULESET_AGENT = "dvfilter-generic-vmware";

    public static DvpgRestoreSectionRepresentationSpec getBaseLabels(DistributedVirtualPortgroup.ConfigSpec spec, DistributedVirtualPortgroup.ConfigInfo info, VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy dvsConfig) {
        String resourcePoolValue;
        String pgType;
        DvpgRestoreSectionRepresentationSpec result = new DvpgRestoreSectionRepresentationSpec();
        result.sectionTitle = NetworkStringUtil.getString("dvpg.restore.summary.settings");
        result.sectionSettings = new ArrayList();
        if (spec.name == null) {
            result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.name"), info.name));
        } else {
            result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.name"), spec.name));
        }
        if (spec.description != null) {
            result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.desc"), spec.description));
        }
        if (spec.numPorts != null) {
            pgType = spec.type != null ? spec.type : info.type;
            if (!DistributedVirtualPortgroup.PortgroupType.ephemeral.name().equals(pgType)) {
                result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.portsCount"), Integer.toString(spec.numPorts)));
            }
        }
        if (spec.type != null) {
            String key = NetworkStringUtil.getString("dvpg.restore.summary.portBinding");
            String value = null;
            if (DistributedVirtualPortgroup.PortgroupType.earlyBinding.name().equals(spec.type)) {
                value = NetworkStringUtil.getString("dvpg.restore.summary.portBinding.early");
            }
            if (DistributedVirtualPortgroup.PortgroupType.ephemeral.name().equals(spec.type)) {
                value = NetworkStringUtil.getString("dvpg.restore.summary.portBinding.eph");
            }
            if (DistributedVirtualPortgroup.PortgroupType.lateBinding.name().equals(spec.type)) {
                value = NetworkStringUtil.getString("dvpg.restore.summary.portBinding.late");
            }
            result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(key, value));
        }
        if (spec.autoExpand != null) {
            pgType = spec.type != null ? spec.type : info.type;
            if (DistributedVirtualPortgroup.PortgroupType.earlyBinding.name().equals(pgType)) {
                String allocKey = NetworkStringUtil.getString("dvpg.restore.summary.portAllocationc");
                String allocValue = spec.autoExpand != false ? NetworkStringUtil.getString("dvpg.pgAlloc.autoExpand.true") : NetworkStringUtil.getString("dvpg.pgAlloc.autoExpand.false");
                result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(allocKey, allocValue));
            }
        }
        if (spec.policy != null) {
            result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.policy.reset"), DvpgRestoreParser.getState(spec.policy.portConfigResetAtDisconnect)));
        }
        if (spec.defaultPortConfig != null && spec.defaultPortConfig.networkResourcePoolKey != null && (resourcePoolValue = DvpgRestoreParser.formatNrpPolicy(spec.defaultPortConfig.networkResourcePoolKey, dvsConfig)) != null) {
            result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.port.nrp.value"), DvpgRestoreParser.formatNrpPolicy(spec.defaultPortConfig.networkResourcePoolKey, dvsConfig)));
        }
        return result;
    }

    public static DvpgRestoreSectionRepresentationSpec getSecurityPolicyLabels(VmwareDistributedVirtualSwitch.SecurityPolicy policy, VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy dvsConfig) {
        DvpgRestoreSectionRepresentationSpec result = new DvpgRestoreSectionRepresentationSpec();
        result.sectionTitle = NetworkStringUtil.getString("dvpg.restore.summary.port.security");
        result.sectionSettings = new ArrayList();
        boolean isInherited = DvpgRestoreParser.isPolicyInherited((InheritablePolicy)policy);
        if (isInherited && dvsConfig != null && dvsConfig.securityPolicy != null) {
            VmwareDistributedVirtualSwitch.SecurityPolicy dvsPolicy = dvsConfig.securityPolicy;
            result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.policy.security.promiscuousMode"), DvpgRestoreParser.securityPolicyText(dvsPolicy.allowPromiscuous.value)));
            result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.policy.security.macAddressChanges"), DvpgRestoreParser.securityPolicyText(dvsPolicy.macChanges.value)));
            result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.policy.security.forgedTransmits"), DvpgRestoreParser.securityPolicyText(dvsPolicy.forgedTransmits.value)));
        } else {
            if (policy.allowPromiscuous != null && policy.allowPromiscuous.value != null) {
                result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.policy.security.promiscuousMode"), DvpgRestoreParser.securityPolicyText(policy.allowPromiscuous.value)));
            }
            if (policy.macChanges != null && policy.macChanges.value != null) {
                result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.policy.security.macAddressChanges"), DvpgRestoreParser.securityPolicyText(policy.macChanges.value)));
            }
            if (policy.forgedTransmits != null && policy.forgedTransmits.value != null) {
                result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.policy.security.forgedTransmits"), DvpgRestoreParser.securityPolicyText(policy.forgedTransmits.value)));
            }
        }
        return result;
    }

    public static DvpgRestoreSectionRepresentationSpec displayShapingPolicy(boolean ingress, DistributedVirtualPort.TrafficShapingPolicy policy, VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy dvsConfig) {
        DvpgRestoreSectionRepresentationSpec result = new DvpgRestoreSectionRepresentationSpec();
        result.sectionTitle = ingress ? NetworkStringUtil.getString("dvpg.restore.summary.port.shaping.in") : NetworkStringUtil.getString("dvpg.restore.summary.port.shaping.out");
        result.sectionSettings = new ArrayList();
        boolean isInherited = DvpgRestoreParser.isPolicyInherited((InheritablePolicy)policy);
        if (isInherited && dvsConfig != null) {
            DistributedVirtualPort.TrafficShapingPolicy dvsPolicy;
            DistributedVirtualPort.TrafficShapingPolicy trafficShapingPolicy = dvsPolicy = ingress ? dvsConfig.inShapingPolicy : dvsConfig.outShapingPolicy;
            if (dvsPolicy != null) {
                if (dvsPolicy.enabled != null && dvsPolicy.enabled.value != null && dvsPolicy.enabled.value.booleanValue()) {
                    result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.port.shaping.average"), DvpgRestoreParser.getFormattedShapingBandwidth(dvsPolicy.averageBandwidth.value)));
                    result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.port.shaping.peak"), DvpgRestoreParser.getFormattedShapingBandwidth(dvsPolicy.peakBandwidth.value)));
                    result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.port.shaping.burst"), DvpgRestoreParser.getFormattedBurstSize(dvsPolicy.burstSize.value)));
                } else {
                    result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.port.status"), NetworkStringUtil.getString("dvpg.restore.summary.port.shaping.disabled")));
                }
            }
        } else if (policy.enabled != null && policy.enabled.value != null && policy.enabled.value.booleanValue()) {
            if (policy.averageBandwidth != null && policy.averageBandwidth.value != null) {
                result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.port.shaping.average"), DvpgRestoreParser.getFormattedShapingBandwidth(policy.averageBandwidth.value)));
            }
            if (policy.peakBandwidth != null && policy.peakBandwidth.value != null) {
                result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.port.shaping.peak"), DvpgRestoreParser.getFormattedShapingBandwidth(policy.peakBandwidth.value)));
            }
            if (policy.burstSize != null && policy.burstSize.value != null) {
                result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.port.shaping.burst"), DvpgRestoreParser.getFormattedBurstSize(policy.burstSize.value)));
            }
        } else {
            result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.port.status"), NetworkStringUtil.getString("dvpg.restore.summary.port.shaping.disabled")));
        }
        return result;
    }

    public static DvpgRestoreSectionRepresentationSpec displayVlanPolicy(VmwareDistributedVirtualSwitch.VlanSpec policy, VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy dvsConfig, VmwareDistributedVirtualSwitch.PvlanMapEntry[] pvlanMapEntries) {
        DvpgRestoreSectionRepresentationSpec result = new DvpgRestoreSectionRepresentationSpec();
        result.sectionTitle = NetworkStringUtil.getString("dvpg.restore.summary.port.vlan");
        result.sectionSettings = new ArrayList();
        DvpgRestoreVlanPolicyModel vlanData = new DvpgRestoreVlanPolicyModel();
        boolean isInherited = DvpgRestoreParser.isPolicyInherited((InheritablePolicy)policy);
        if (isInherited) {
            vlanData.setPolicy(dvsConfig != null ? dvsConfig.vlan : null, pvlanMapEntries);
        } else {
            vlanData.setPolicy(policy, pvlanMapEntries);
        }
        if (policy instanceof VmwareDistributedVirtualSwitch.PvlanSpec) {
            VmwareDistributedVirtualSwitch.PvlanMapEntry pvlanMapEntry = vlanData.getPrivateVlanEntry();
            if (pvlanMapEntry != null) {
                result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.port.vlan.private"), DvpgRestoreParser.privateVlanText(pvlanMapEntry)));
            } else {
                result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.port.vlan.private"), NetworkStringUtil.getString("dvpg.restore.summary.port.vlan.private.none")));
            }
        }
        if (policy instanceof VmwareDistributedVirtualSwitch.TrunkVlanSpec) {
            result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.port.vlan.trunk"), vlanData.getVlanIdRanges()));
        }
        if (policy instanceof VmwareDistributedVirtualSwitch.VlanIdSpec) {
            result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.port.vlan.vlanid"), vlanData.getVlanId()));
        }
        return result;
    }

    public static String privateVlanTypeText(String type) {
        try {
            VmwareDistributedVirtualSwitch.PvlanPortType vlanType = VmwareDistributedVirtualSwitch.PvlanPortType.valueOf((String)type);
            switch (vlanType) {
                case promiscuous: {
                    return NetworkStringUtil.getString("dvpg.policy.vlan.private.type.promiscuous");
                }
                case isolated: {
                    return NetworkStringUtil.getString("dvpg.policy.vlan.private.type.isolated");
                }
                case community: {
                    return NetworkStringUtil.getString("dvpg.policy.vlan.private.type.community");
                }
            }
            return "";
        }
        catch (IllegalArgumentException e) {
            return "";
        }
    }

    public static DvpgRestoreSectionRepresentationSpec displayUplinkTeamingPolicy(VmwareDistributedVirtualSwitch.UplinkPortTeamingPolicy policy, VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy dvsConfig, List<String> dvsUplinks, List<String> dvsLags) {
        DvpgRestoreSectionRepresentationSpec result = new DvpgRestoreSectionRepresentationSpec();
        result.sectionTitle = NetworkStringUtil.getString("dvpg.restore.summary.port.uplink");
        result.sectionSettings = new ArrayList();
        DvpgRestoreFailoverPolicyModel uplinkData = new DvpgRestoreFailoverPolicyModel();
        boolean isInherited = DvpgRestoreParser.isPolicyInherited((InheritablePolicy)policy);
        if (isInherited) {
            uplinkData.setPolicy(dvsConfig != null ? dvsConfig.uplinkTeamingPolicy : null, dvsUplinks, dvsLags);
        } else {
            uplinkData.setPolicy(policy, dvsUplinks, dvsLags);
        }
        result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.policy.failover.lb.label"), DvpgRestoreParser.loadBalancingText(uplinkData.getLoadBalancing())));
        result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.policy.failover.detection.label"), DvpgRestoreParser.failureDetectionText(uplinkData.getBeaconProbing())));
        result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.policy.failover.notify.label"), DvpgRestoreParser.notifySwitchesText(uplinkData.getNotifySwitches())));
        result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.policy.failover.failback.label"), DvpgRestoreParser.failbackText(uplinkData.getFailback())));
        if (uplinkData.getActiveUplinksSequence() != null) {
            result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.policy.failover.order.active.label"), uplinkData.getActiveUplinksSequence()));
        }
        if (uplinkData.getStandbyUplinksSequence() != null) {
            result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.policy.failover.order.standby.label"), uplinkData.getStandbyUplinksSequence()));
        }
        if (uplinkData.getUnusedUplinksSequence() != null) {
            result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.policy.failover.order.unused.label"), uplinkData.getUnusedUplinksSequence()));
        }
        return result;
    }

    public static DvpgRestoreSectionRepresentationSpec displayIpfixPolicy(BoolPolicy policy, VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy dvsConfig) {
        DvpgRestoreSectionRepresentationSpec result = new DvpgRestoreSectionRepresentationSpec();
        result.sectionTitle = NetworkStringUtil.getString("dvpg.restore.summary.port.ipfixEnabled");
        result.sectionSettings = new ArrayList();
        BoolPolicy ipFixPolicy = DvpgRestoreParser.isPolicyInherited((InheritablePolicy)policy) ? (dvsConfig != null ? dvsConfig.ipfixEnabled : null) : policy;
        if (ipFixPolicy != null && ipFixPolicy.value != null) {
            String ipFixPolicyValue = ipFixPolicy.value != false ? NetworkStringUtil.getString("dvpg.restore.summary.port.ipfixEnabled.true") : NetworkStringUtil.getString("dvpg.restore.summary.port.ipfixEnabled.false");
            result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.port.status"), ipFixPolicyValue));
        }
        return result;
    }

    public static DvpgRestoreSectionRepresentationSpec displayFilterPolicy(DistributedVirtualPort.FilterPolicy policy, VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy dvsConfig) {
        DvpgRestoreSectionRepresentationSpec result = new DvpgRestoreSectionRepresentationSpec();
        result.sectionTitle = NetworkStringUtil.getString("dvpg.restore.summary.port.filter");
        result.sectionSettings = new ArrayList();
        DistributedVirtualPort.FilterPolicy filterPolicy = DvpgRestoreParser.isPolicyInherited((InheritablePolicy)policy) ? (dvsConfig != null ? dvsConfig.filterPolicy : null) : policy;
        if (filterPolicy != null) {
            int numFilters = ArrayUtil.isNullOrEmpty((Object[])filterPolicy.filterConfig) ? 0 : filterPolicy.filterConfig.length;
            result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.port.numberOfFilters"), Integer.toString(numFilters)));
            ArrayList<String> agentNames = new ArrayList<String>();
            if (filterPolicy.filterConfig != null) {
                for (DistributedVirtualPort.FilterConfig filterConfig : filterPolicy.filterConfig) {
                    if (filterConfig == null || filterConfig.agentName == null || filterConfig.agentName.length() == 0) continue;
                    agentNames.add(filterConfig.agentName);
                }
            }
            if (!agentNames.isEmpty()) {
                result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.port.filterAgents"), DvpgRestoreParser.convertArrayToString((String[])Arrays.copyOf(agentNames.toArray(), agentNames.size(), String[].class), ", ")));
            }
        }
        return result;
    }

    public static DvpgRestoreSectionRepresentationSpec displayTrafficFilterPolicy(DistributedVirtualPort.FilterPolicy policy, VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy dvsConfig) {
        DvpgRestoreSectionRepresentationSpec result = new DvpgRestoreSectionRepresentationSpec();
        result.sectionTitle = NetworkStringUtil.getString("dvpg.restore.summary.port.trafficFiltering");
        result.sectionSettings = new ArrayList();
        DistributedVirtualPort.FilterPolicy filterPolicy = DvpgRestoreParser.isPolicyInherited((InheritablePolicy)policy) ? (dvsConfig != null ? dvsConfig.filterPolicy : null) : policy;
        if (filterPolicy != null) {
            DistributedVirtualPort.TrafficFilterConfig trafficFilterConfig = DvpgRestoreParser.findGenericRuleset(filterPolicy.filterConfig);
            boolean status = false;
            int numRules = 0;
            if (trafficFilterConfig != null && trafficFilterConfig.trafficRuleset != null) {
                status = trafficFilterConfig.trafficRuleset.enabled;
                numRules = ArrayUtil.isNullOrEmpty((Object[])trafficFilterConfig.trafficRuleset.rules) ? 0 : trafficFilterConfig.trafficRuleset.rules.length;
            }
            result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.port.trafficfiltering.status"), DvpgRestoreParser.trafficFilterStatusText(status)));
            result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.port.trafficfiltering.numRules"), Integer.toString(numRules)));
        }
        return result;
    }

    public static DvpgRestoreSectionRepresentationSpec displayPortBlockingPolicy(BoolPolicy policy, VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy dvsConfig) {
        DvpgRestoreSectionRepresentationSpec result = new DvpgRestoreSectionRepresentationSpec();
        result.sectionTitle = NetworkStringUtil.getString("dvpg.restore.summary.port.misc");
        result.sectionSettings = new ArrayList();
        BoolPolicy blockPolicy = DvpgRestoreParser.isPolicyInherited((InheritablePolicy)policy) ? (dvsConfig != null ? dvsConfig.blocked : null) : policy;
        String blockPolicyValue = blockPolicy != null && blockPolicy.value != null && blockPolicy.value != false ? NetworkStringUtil.getString("dvpg.policy.misc.block.on") : NetworkStringUtil.getString("dvpg.policy.misc.block.off");
        result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.port.block"), blockPolicyValue));
        return result;
    }

    public static DvpgRestoreSectionRepresentationSpec displayTxUplinkPolicy() {
        DvpgRestoreSectionRepresentationSpec result = new DvpgRestoreSectionRepresentationSpec();
        result.sectionTitle = NetworkStringUtil.getString("dvpg.restore.summary.port.txUplink");
        result.sectionSettings = new ArrayList();
        result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.port.value"), NetworkStringUtil.getString("dvpg.restore.summary.port.txUplink.changed")));
        return result;
    }

    public static VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy mergePolicies(VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy spec, VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy info) {
        VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy result = new VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy();
        if (spec != null) {
            result = spec;
        }
        if (spec != null && info != null) {
            result.securityPolicy = DvpgRestoreParser.mergeSecurityPolicy(spec, info);
            result.inShapingPolicy = DvpgRestoreParser.mergeShapingPolicy(spec.inShapingPolicy, info.inShapingPolicy);
            result.outShapingPolicy = DvpgRestoreParser.mergeShapingPolicy(spec.outShapingPolicy, info.outShapingPolicy);
            result.uplinkTeamingPolicy = DvpgRestoreParser.mergeUplinkTeamingPolicy(spec, info);
            result.lacpPolicy = new VmwareDistributedVirtualSwitch.UplinkLacpPolicy();
            if (spec.lacpPolicy == null || info.lacpPolicy == null) {
                result.lacpPolicy = spec.lacpPolicy;
            } else {
                result.lacpPolicy.inherited = spec.lacpPolicy.inherited;
                result.lacpPolicy.enable = spec.lacpPolicy.enable == null ? info.lacpPolicy.enable : spec.lacpPolicy.enable;
                StringPolicy stringPolicy = result.lacpPolicy.mode = spec.lacpPolicy.mode == null ? info.lacpPolicy.mode : spec.lacpPolicy.mode;
            }
        }
        if (spec != null) {
            result.vlan = spec.vlan;
            result.ipfixEnabled = spec.ipfixEnabled;
            result.blocked = spec.blocked;
            result.networkResourcePoolKey = spec.networkResourcePoolKey;
        }
        return result;
    }

    public static DvpgRestoreSectionRepresentationSpec getDisplayPolicyMap(DistributedVirtualPortgroup.PortgroupPolicy policy, DistributedVirtualPortgroup.PortgroupPolicy comparedPolicy) {
        DvpgRestoreSectionRepresentationSpec result = new DvpgRestoreSectionRepresentationSpec();
        result.sectionTitle = NetworkStringUtil.getString("dvpg.restore.summary.policy");
        result.sectionSettings = new ArrayList();
        VmwareDistributedVirtualSwitch.VMwarePortgroupPolicy vmwarePolicy = null;
        VmwareDistributedVirtualSwitch.VMwarePortgroupPolicy vmwareComparedPolicy = null;
        if (policy != null && comparedPolicy != null) {
            boolean isTrafficFilterOverrideAllowedChanged;
            boolean isNetworkResourcePoolOverrideAllowedChanged;
            if (policy.blockOverrideAllowed != comparedPolicy.blockOverrideAllowed) {
                result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.policy.block"), DvpgRestoreParser.getState(policy.blockOverrideAllowed)));
            }
            if (policy.shapingOverrideAllowed != comparedPolicy.shapingOverrideAllowed) {
                result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.policy.shaping"), DvpgRestoreParser.getState(policy.shapingOverrideAllowed)));
            }
            if (policy.vendorConfigOverrideAllowed != comparedPolicy.vendorConfigOverrideAllowed) {
                result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.policy.vendor"), DvpgRestoreParser.getState(policy.vendorConfigOverrideAllowed)));
            }
            if (policy instanceof VmwareDistributedVirtualSwitch.VMwarePortgroupPolicy && comparedPolicy instanceof VmwareDistributedVirtualSwitch.VMwarePortgroupPolicy) {
                vmwarePolicy = (VmwareDistributedVirtualSwitch.VMwarePortgroupPolicy)policy;
                vmwareComparedPolicy = (VmwareDistributedVirtualSwitch.VMwarePortgroupPolicy)comparedPolicy;
                if (vmwarePolicy.vlanOverrideAllowed != vmwareComparedPolicy.vlanOverrideAllowed) {
                    result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.policy.vlan"), DvpgRestoreParser.getState(vmwarePolicy.vlanOverrideAllowed)));
                }
                if (vmwarePolicy.uplinkTeamingOverrideAllowed != vmwareComparedPolicy.uplinkTeamingOverrideAllowed) {
                    result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.policy.uplink"), DvpgRestoreParser.getState(vmwarePolicy.uplinkTeamingOverrideAllowed)));
                }
            }
            boolean bl = isNetworkResourcePoolOverrideAllowedChanged = policy.networkResourcePoolOverrideAllowed != null && comparedPolicy.networkResourcePoolOverrideAllowed != null && policy.networkResourcePoolOverrideAllowed.booleanValue() != comparedPolicy.networkResourcePoolOverrideAllowed.booleanValue();
            if (isNetworkResourcePoolOverrideAllowedChanged) {
                result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.policy.net"), DvpgRestoreParser.getState(policy.networkResourcePoolOverrideAllowed)));
            }
            if (vmwarePolicy != null && vmwareComparedPolicy != null) {
                boolean isIpfixOverrideAllowedChanged;
                if (vmwarePolicy.securityPolicyOverrideAllowed != vmwareComparedPolicy.securityPolicyOverrideAllowed) {
                    result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.policy.security"), DvpgRestoreParser.getState(vmwarePolicy.securityPolicyOverrideAllowed)));
                }
                boolean bl2 = isIpfixOverrideAllowedChanged = vmwarePolicy.ipfixOverrideAllowed != null && vmwareComparedPolicy.ipfixOverrideAllowed != null && vmwarePolicy.ipfixOverrideAllowed.booleanValue() != vmwareComparedPolicy.ipfixOverrideAllowed.booleanValue();
                if (isIpfixOverrideAllowedChanged) {
                    result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.policy.ipfix"), DvpgRestoreParser.getState(vmwarePolicy.ipfixOverrideAllowed)));
                }
            }
            if (policy.livePortMovingAllowed != comparedPolicy.livePortMovingAllowed) {
                result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.policy.live"), DvpgRestoreParser.getState(policy.livePortMovingAllowed)));
            }
            boolean bl3 = isTrafficFilterOverrideAllowedChanged = policy.trafficFilterOverrideAllowed != null && comparedPolicy.trafficFilterOverrideAllowed != null && policy.trafficFilterOverrideAllowed.booleanValue() != comparedPolicy.trafficFilterOverrideAllowed.booleanValue();
            if (isTrafficFilterOverrideAllowedChanged) {
                result.sectionSettings.add(new DvpgRestoreSettingRepresentationSpec(NetworkStringUtil.getString("dvpg.restore.summary.policy.trafficfiltering"), DvpgRestoreParser.getState(policy.trafficFilterOverrideAllowed)));
            }
        }
        return result;
    }

    private static VmwareDistributedVirtualSwitch.SecurityPolicy mergeSecurityPolicy(VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy spec, VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy info) {
        VmwareDistributedVirtualSwitch.SecurityPolicy securityPolicy = new VmwareDistributedVirtualSwitch.SecurityPolicy();
        if (spec.securityPolicy == null || info.securityPolicy == null) {
            securityPolicy = spec.securityPolicy;
        } else {
            securityPolicy.inherited = spec.securityPolicy.inherited;
            securityPolicy.allowPromiscuous = spec.securityPolicy.allowPromiscuous == null ? info.securityPolicy.allowPromiscuous : spec.securityPolicy.allowPromiscuous;
            securityPolicy.forgedTransmits = spec.securityPolicy.forgedTransmits == null ? info.securityPolicy.forgedTransmits : spec.securityPolicy.forgedTransmits;
            securityPolicy.macChanges = spec.securityPolicy.macChanges == null ? info.securityPolicy.macChanges : spec.securityPolicy.macChanges;
        }
        return securityPolicy;
    }

    private static DistributedVirtualPort.TrafficShapingPolicy mergeShapingPolicy(DistributedVirtualPort.TrafficShapingPolicy specPolicy, DistributedVirtualPort.TrafficShapingPolicy infoPolicy) {
        DistributedVirtualPort.TrafficShapingPolicy outShapingPolicy = new DistributedVirtualPort.TrafficShapingPolicy();
        if (specPolicy == null || infoPolicy == null) {
            outShapingPolicy = specPolicy;
        } else {
            outShapingPolicy.inherited = specPolicy.inherited;
            outShapingPolicy.enabled = specPolicy.enabled == null ? infoPolicy.enabled : specPolicy.enabled;
            outShapingPolicy.averageBandwidth = specPolicy.averageBandwidth == null ? infoPolicy.averageBandwidth : specPolicy.averageBandwidth;
            outShapingPolicy.peakBandwidth = specPolicy.peakBandwidth == null ? infoPolicy.peakBandwidth : specPolicy.peakBandwidth;
            outShapingPolicy.burstSize = specPolicy.burstSize == null ? infoPolicy.burstSize : specPolicy.burstSize;
        }
        return outShapingPolicy;
    }

    private static VmwareDistributedVirtualSwitch.UplinkPortTeamingPolicy mergeUplinkTeamingPolicy(VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy spec, VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy info) {
        VmwareDistributedVirtualSwitch.UplinkPortTeamingPolicy uplinkTeamingPolicy = new VmwareDistributedVirtualSwitch.UplinkPortTeamingPolicy();
        if (spec.uplinkTeamingPolicy == null || info.uplinkTeamingPolicy == null) {
            uplinkTeamingPolicy = spec.uplinkTeamingPolicy;
        } else {
            uplinkTeamingPolicy.inherited = spec.uplinkTeamingPolicy.inherited;
            uplinkTeamingPolicy.policy = spec.uplinkTeamingPolicy.policy == null ? info.uplinkTeamingPolicy.policy : spec.uplinkTeamingPolicy.policy;
            uplinkTeamingPolicy.reversePolicy = spec.uplinkTeamingPolicy.reversePolicy == null ? info.uplinkTeamingPolicy.reversePolicy : spec.uplinkTeamingPolicy.reversePolicy;
            uplinkTeamingPolicy.notifySwitches = spec.uplinkTeamingPolicy.notifySwitches == null ? info.uplinkTeamingPolicy.notifySwitches : spec.uplinkTeamingPolicy.notifySwitches;
            uplinkTeamingPolicy.rollingOrder = spec.uplinkTeamingPolicy.rollingOrder == null ? info.uplinkTeamingPolicy.rollingOrder : spec.uplinkTeamingPolicy.rollingOrder;
            uplinkTeamingPolicy.failureCriteria = new VmwareDistributedVirtualSwitch.FailureCriteria();
            if (spec.uplinkTeamingPolicy.failureCriteria == null || info.uplinkTeamingPolicy.failureCriteria == null) {
                uplinkTeamingPolicy.failureCriteria = spec.uplinkTeamingPolicy.failureCriteria;
            } else {
                uplinkTeamingPolicy.failureCriteria.checkSpeed = spec.uplinkTeamingPolicy.failureCriteria.checkSpeed == null ? info.uplinkTeamingPolicy.failureCriteria.checkSpeed : spec.uplinkTeamingPolicy.failureCriteria.checkSpeed;
                uplinkTeamingPolicy.failureCriteria.speed = spec.uplinkTeamingPolicy.failureCriteria.speed == null ? info.uplinkTeamingPolicy.failureCriteria.speed : spec.uplinkTeamingPolicy.failureCriteria.speed;
                uplinkTeamingPolicy.failureCriteria.checkDuplex = spec.uplinkTeamingPolicy.failureCriteria.checkDuplex == null ? info.uplinkTeamingPolicy.failureCriteria.checkDuplex : spec.uplinkTeamingPolicy.failureCriteria.checkDuplex;
                uplinkTeamingPolicy.failureCriteria.fullDuplex = spec.uplinkTeamingPolicy.failureCriteria.fullDuplex == null ? info.uplinkTeamingPolicy.failureCriteria.fullDuplex : spec.uplinkTeamingPolicy.failureCriteria.fullDuplex;
                uplinkTeamingPolicy.failureCriteria.checkErrorPercent = spec.uplinkTeamingPolicy.failureCriteria.checkErrorPercent == null ? info.uplinkTeamingPolicy.failureCriteria.checkErrorPercent : spec.uplinkTeamingPolicy.failureCriteria.checkErrorPercent;
                uplinkTeamingPolicy.failureCriteria.percentage = spec.uplinkTeamingPolicy.failureCriteria.percentage == null ? info.uplinkTeamingPolicy.failureCriteria.percentage : spec.uplinkTeamingPolicy.failureCriteria.percentage;
                uplinkTeamingPolicy.failureCriteria.checkBeacon = spec.uplinkTeamingPolicy.failureCriteria.checkBeacon == null ? info.uplinkTeamingPolicy.failureCriteria.checkBeacon : spec.uplinkTeamingPolicy.failureCriteria.checkBeacon;
            }
            uplinkTeamingPolicy.uplinkPortOrder = new VmwareDistributedVirtualSwitch.UplinkPortOrderPolicy();
            if (spec.uplinkTeamingPolicy.uplinkPortOrder == null || info.uplinkTeamingPolicy.uplinkPortOrder == null) {
                uplinkTeamingPolicy.uplinkPortOrder = spec.uplinkTeamingPolicy.uplinkPortOrder;
            } else {
                uplinkTeamingPolicy.uplinkPortOrder.activeUplinkPort = spec.uplinkTeamingPolicy.uplinkPortOrder.activeUplinkPort == null ? info.uplinkTeamingPolicy.uplinkPortOrder.activeUplinkPort : spec.uplinkTeamingPolicy.uplinkPortOrder.activeUplinkPort;
                uplinkTeamingPolicy.uplinkPortOrder.standbyUplinkPort = spec.uplinkTeamingPolicy.uplinkPortOrder.standbyUplinkPort == null ? info.uplinkTeamingPolicy.uplinkPortOrder.standbyUplinkPort : spec.uplinkTeamingPolicy.uplinkPortOrder.standbyUplinkPort;
            }
        }
        return uplinkTeamingPolicy;
    }

    private static String getState(boolean value) {
        return value ? NetworkStringUtil.getString("dvpg.restore.summary.policy.true") : NetworkStringUtil.getString("dvpg.restore.summary.policy.false");
    }

    private static String formatNrpPolicy(StringPolicy policy, VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy dvsConfig) {
        StringPolicy nrpPolicy = DvpgRestoreParser.isPolicyInherited((InheritablePolicy)policy) ? (dvsConfig != null ? dvsConfig.networkResourcePoolKey : null) : policy;
        String value = null;
        if (nrpPolicy != null && nrpPolicy.value != null) {
            value = nrpPolicy.value.equals("-1") ? NetworkStringUtil.getString("dvpg.restore.summary.port.nrp.none") : nrpPolicy.value;
        }
        return value;
    }

    private static String securityPolicyText(boolean value) {
        return value ? NetworkStringUtil.getString("dvpg.policy.security.accept") : NetworkStringUtil.getString("dvpg.policy.security.reject");
    }

    private static String privateVlanText(VmwareDistributedVirtualSwitch.PvlanMapEntry entry) {
        return NetworkStringUtil.getString("dvpg.policy.vlan.displayFormat", DvpgRestoreParser.privateVlanTypeText(entry.pvlanType), Integer.toString(entry.primaryVlanId), Integer.toString(entry.secondaryVlanId));
    }

    private static String loadBalancingText(String value) {
        if (DistributedVirtualSwitch.NicTeamingPolicyMode.failover_explicit.name().equals(value)) {
            return NetworkStringUtil.getString("dvpg.policy.failover.lb.failover_explicit");
        }
        if (DistributedVirtualSwitch.NicTeamingPolicyMode.loadbalance_ip.name().equals(value)) {
            return NetworkStringUtil.getString("dvpg.policy.failover.lb.loadbalance_ip");
        }
        if (DistributedVirtualSwitch.NicTeamingPolicyMode.loadbalance_loadbased.name().equals(value)) {
            return NetworkStringUtil.getString("dvpg.policy.failover.lb.loadbalance_loadbased");
        }
        if (DistributedVirtualSwitch.NicTeamingPolicyMode.loadbalance_srcid.name().equals(value)) {
            return NetworkStringUtil.getString("dvpg.policy.failover.lb.loadbalance_srcid");
        }
        if (DistributedVirtualSwitch.NicTeamingPolicyMode.loadbalance_srcmac.name().equals(value)) {
            return NetworkStringUtil.getString("dvpg.policy.failover.lb.loadbalance_srcmac");
        }
        return null;
    }

    private static String failureDetectionText(boolean value) {
        return value ? NetworkStringUtil.getString("dvpg.policy.failover.detection.beaconProbing") : NetworkStringUtil.getString("dvpg.policy.failover.detection.linkStatus");
    }

    private static String failbackText(boolean value) {
        return value ? NetworkStringUtil.getString("dvpg.policy.failover.failback.on") : NetworkStringUtil.getString("dvpg.policy.failover.failback.off");
    }

    private static String notifySwitchesText(boolean value) {
        return value ? NetworkStringUtil.getString("dvpg.policy.failover.notify.on") : NetworkStringUtil.getString("dvpg.policy.failover.notify.off");
    }

    private static boolean isPolicyInherited(InheritablePolicy policy) {
        return policy != null && policy.inherited;
    }

    private static String getFormattedShapingBandwidth(Long value) {
        return FormatUtil.getBitRateFormatted((Number)value, (int)0, (long)FormatUtil.BPS, (long)FormatUtil.KBPS, (boolean)true);
    }

    private static String getFormattedBurstSize(Long value) {
        return FormatUtil.getDataSizeFormatted((Number)value, (int)0, (long)1L, (long)1024L, (boolean)true);
    }

    private static DistributedVirtualPort.TrafficFilterConfig findGenericRuleset(DistributedVirtualPort.FilterConfig[] trafficFilterConfigArray) {
        if (trafficFilterConfigArray != null) {
            for (DistributedVirtualPort.FilterConfig config : trafficFilterConfigArray) {
                if (config == null || config.agentName == null || !config.agentName.equals(GENERIC_TRAFFIC_FILTER_RULESET_AGENT) || !(config instanceof DistributedVirtualPort.TrafficFilterConfig)) continue;
                return (DistributedVirtualPort.TrafficFilterConfig)config;
            }
        }
        return null;
    }

    private static String trafficFilterStatusText(Boolean value) {
        return value != false ? NetworkStringUtil.getString("dvpg.policy.trafficfiltering.status.enabled") : NetworkStringUtil.getString("dvpg.policy.trafficfiltering.status.disabled");
    }

    private static String convertArrayToString(String[] arr, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length - 1; ++i) {
            sb.append(arr[i]);
            sb.append(delimiter);
        }
        sb.append(arr[arr.length - 1]);
        return sb.toString();
    }
}

