/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.imports;

import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DvpgRestoreFailoverPolicyModel {
    private static final String UPLINKS_SEQUENCE_DELIMITER = ", ";
    private VmwareDistributedVirtualSwitch.UplinkPortTeamingPolicy policy;
    private List<String> activeUplinks = null;
    private List<String> standbyUplinks = null;
    private List<String> unusedUplinks = null;

    public void setPolicy(VmwareDistributedVirtualSwitch.UplinkPortTeamingPolicy value, List<String> dvsUplinks, List<String> dvsLags) {
        if (value != this.policy) {
            this.policy = value;
            if (this.policy != null) {
                this.resetFailoverOrder(this.policy.uplinkPortOrder, dvsUplinks, dvsLags);
            }
        }
    }

    private void resetFailoverOrder(VmwareDistributedVirtualSwitch.UplinkPortOrderPolicy newOrder, List<String> dvsUplinks, List<String> dvsLags) {
        this.policy.uplinkPortOrder = newOrder;
        if (newOrder == null) {
            this.activeUplinks = null;
            this.standbyUplinks = null;
            this.unusedUplinks = null;
        } else {
            if (newOrder.activeUplinkPort == null) {
                newOrder.activeUplinkPort = new String[0];
            }
            if (newOrder.standbyUplinkPort == null) {
                newOrder.standbyUplinkPort = new String[0];
            }
            this.activeUplinks = Arrays.asList(newOrder.activeUplinkPort);
            this.standbyUplinks = Arrays.asList(newOrder.standbyUplinkPort);
            this.unusedUplinks = new ArrayList<String>();
            if (dvsUplinks != null) {
                for (String uplinkName : dvsUplinks) {
                    if (this.activeUplinks.contains(uplinkName) || this.standbyUplinks.contains(uplinkName)) continue;
                    this.unusedUplinks.add(uplinkName);
                }
            }
            if (dvsLags != null) {
                for (String lagName : dvsLags) {
                    if (this.activeUplinks.contains(lagName) || this.standbyUplinks.contains(lagName)) continue;
                    this.unusedUplinks.add(lagName);
                }
            }
        }
    }

    public String getLoadBalancing() {
        if (this.policy != null && this.policy.policy != null && this.policy.policy.value != null) {
            return this.policy.policy.value;
        }
        return null;
    }

    public boolean getBeaconProbing() {
        if (this.policy != null && this.policy.failureCriteria != null && this.policy.failureCriteria.checkBeacon != null && this.policy.failureCriteria.checkBeacon.value != null) {
            return this.policy.failureCriteria.checkBeacon.value;
        }
        return false;
    }

    public boolean getNotifySwitches() {
        if (this.policy != null && this.policy.notifySwitches != null && this.policy.notifySwitches.value != null) {
            return this.policy.notifySwitches.value;
        }
        return false;
    }

    public boolean getFailback() {
        if (this.policy != null && this.policy.rollingOrder != null && this.policy.rollingOrder.value != null) {
            return this.policy.rollingOrder.value == false;
        }
        return false;
    }

    public String getActiveUplinksSequence() {
        if (this.activeUplinks == null) {
            return null;
        }
        return StringUtils.join(this.activeUplinks, (String)UPLINKS_SEQUENCE_DELIMITER);
    }

    public String getStandbyUplinksSequence() {
        if (this.standbyUplinks == null) {
            return null;
        }
        return StringUtils.join(this.standbyUplinks, (String)UPLINKS_SEQUENCE_DELIMITER);
    }

    public String getUnusedUplinksSequence() {
        if (this.unusedUplinks == null) {
            return null;
        }
        return StringUtils.join(this.unusedUplinks, (String)UPLINKS_SEQUENCE_DELIMITER);
    }

    public VmwareDistributedVirtualSwitch.UplinkPortTeamingPolicy getPolicy() {
        return this.policy;
    }
}

