/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvportgroup.manage.filter;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.vise.common.api.filters.QueryFilterBuilder;
import com.vmware.vise.common.api.filters.annotations.QueryFilter;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvpgFilterBuilder
implements QueryFilterBuilder {
    static final String PROPERTY_DVS = "config.distributedVirtualSwitch";
    static final String PROPERTY_IS_UPLINK = "isUplinkPortgroup";
    private static final Log _logger = LogFactory.getLog(DvpgFilterBuilder.class);
    private final ObjectReferenceService _objectReferenceService;

    public DvpgFilterBuilder(ObjectReferenceService objectReferenceService) {
        this._objectReferenceService = objectReferenceService;
    }

    @QueryFilter(value="dvpgObjectsFilter")
    public Filter dvpgObjectsFilter(String objectId) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{objectId});
        Object dvsRef = this.getRef(objectId);
        if (dvsRef == null) {
            return null;
        }
        PropertyPredicate portgroupAttachedToDvsPredicate = new PropertyPredicate(PROPERTY_DVS, PropertyPredicate.ComparisonOperator.EQUAL, dvsRef);
        PropertyPredicate notUplinkPortgroupPredicate = new PropertyPredicate(PROPERTY_IS_UPLINK, PropertyPredicate.ComparisonOperator.NOT_EQUAL, (Object)Boolean.TRUE);
        List<PropertyPredicate> predicateList = Arrays.asList(portgroupAttachedToDvsPredicate, notUplinkPortgroupPredicate);
        return new Filter(predicateList);
    }

    @QueryFilter(value="dvpgExcludedObjectsFilter")
    public Filter dvpgExcludedObjectsFilter(String dvsId, String[] dvpgIds) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{dvsId});
        ValidationUtil.stringsNotNullOrEmpty((String[])dvpgIds);
        Object dvsRef = this._objectReferenceService.getReference(dvsId, true);
        if (dvsRef == null) {
            return null;
        }
        PropertyPredicate portgroupAttachedToDvsPredicate = new PropertyPredicate(PROPERTY_DVS, PropertyPredicate.ComparisonOperator.EQUAL, dvsRef);
        PropertyPredicate notUplinkPortgroupPredicate = new PropertyPredicate(PROPERTY_IS_UPLINK, PropertyPredicate.ComparisonOperator.NOT_EQUAL, (Object)Boolean.TRUE);
        ArrayList<Object> objects = new ArrayList<Object>(dvpgIds.length);
        for (String objectId : dvpgIds) {
            objects.add(this._objectReferenceService.getReference(objectId, true));
        }
        PropertyPredicate excludedPortgroupPredicate = new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.NOT_IN, objects);
        List<PropertyPredicate> predicateList = Arrays.asList(portgroupAttachedToDvsPredicate, notUplinkPortgroupPredicate, excludedPortgroupPredicate);
        return new Filter(predicateList);
    }

    private Object getRef(String objectId) {
        Object objectRef = this._objectReferenceService.getReference(objectId, true);
        if (objectRef == null) {
            _logger.warn((Object)"No valid object ref found for filter");
            return null;
        }
        return objectRef;
    }
}

