/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvportgroup.common;

import com.vmware.vim.binding.vim.BoolPolicy;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.LongPolicy;
import com.vmware.vim.binding.vim.NumericRange;
import com.vmware.vim.binding.vim.StringPolicy;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.NetworkResourcePool;
import com.vmware.vim.binding.vim.dvs.VmVnicNetworkResourcePool;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.dvpg.api.DvPortgroupPortProperties;
import com.vmware.vsphere.client.h5.network.dvportgroup.common.model.DvpgFailoverPolicyModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.common.model.DvpgMiscPolicyModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.common.model.DvpgMonitoringPolicyModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.common.model.DvpgResourceAllocationPolicyModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.common.model.DvpgSecurityPolicyModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.common.model.DvpgTrafficShapingPolicyModel;
import com.vmware.vsphere.client.h5.network.dvportgroup.common.model.DvpgVlanPolicyModel;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import com.vmware.vsphere.client.h5.network.util.NumericRangeUtil;
import com.vmware.vsphere.client.h5.network.util.VlanUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

public class DvPortgroupPolicyParser {
    public static DvpgVlanPolicyModel getVlanPolicyModel(VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy defaultPortConfig, VmwareDistributedVirtualSwitch.PvlanMapEntry[] pvlanConfig) {
        if (defaultPortConfig == null) {
            return null;
        }
        DvpgVlanPolicyModel vlanPolicyModel = new DvpgVlanPolicyModel();
        VmwareDistributedVirtualSwitch.VlanSpec vlanSpec = defaultPortConfig.vlan;
        vlanPolicyModel.vlanType = VlanUtil.getVlanType(vlanSpec);
        if (vlanSpec instanceof VmwareDistributedVirtualSwitch.VlanIdSpec) {
            vlanPolicyModel.vlanId = ((VmwareDistributedVirtualSwitch.VlanIdSpec)vlanSpec).vlanId;
        } else if (vlanSpec instanceof VmwareDistributedVirtualSwitch.TrunkVlanSpec) {
            NumericRange[] trunkRanges = ((VmwareDistributedVirtualSwitch.TrunkVlanSpec)vlanSpec).vlanId;
            vlanPolicyModel.vlanTrunkRanges = NumericRangeUtil.asString(trunkRanges);
            vlanPolicyModel.vlanTrunkNumericRanges = trunkRanges;
        } else if (vlanSpec instanceof VmwareDistributedVirtualSwitch.PvlanSpec) {
            vlanPolicyModel.pvlanId = ((VmwareDistributedVirtualSwitch.PvlanSpec)vlanSpec).pvlanId;
        }
        vlanPolicyModel.pvlanConfig = pvlanConfig;
        return vlanPolicyModel;
    }

    public static DvpgSecurityPolicyModel getSecurityPolicyModel(VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy defaultPortConfig) {
        if (defaultPortConfig == null) {
            return null;
        }
        DvpgSecurityPolicyModel securityPolicyModel = new DvpgSecurityPolicyModel();
        if (defaultPortConfig.securityPolicy != null) {
            VmwareDistributedVirtualSwitch.SecurityPolicy securityPolicy = defaultPortConfig.securityPolicy;
            securityPolicyModel.allowPromiscuous = DvPortgroupPolicyParser.getBooleanPolicyValue(securityPolicy.allowPromiscuous);
            securityPolicyModel.forgedTransmits = DvPortgroupPolicyParser.getBooleanPolicyValue(securityPolicy.forgedTransmits);
            securityPolicyModel.macChanges = DvPortgroupPolicyParser.getBooleanPolicyValue(securityPolicy.macChanges);
        }
        return securityPolicyModel;
    }

    public static DvpgFailoverPolicyModel getTeamingAndFailoverPolicy(VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy defaultPortConfig, String[] uplinkPortNames, VmwareDistributedVirtualSwitch.LacpGroupConfig[] lacpGroupConfigs, String[] loadBalancingModes) {
        if (defaultPortConfig == null) {
            return null;
        }
        DvpgFailoverPolicyModel failoverPolicyModel = new DvpgFailoverPolicyModel();
        if (defaultPortConfig.uplinkTeamingPolicy != null) {
            StringPolicy loadBalancing = defaultPortConfig.uplinkTeamingPolicy.getPolicy();
            if (loadBalancing != null) {
                failoverPolicyModel.loadBalancing = loadBalancing.getValue();
            }
            if (defaultPortConfig.uplinkTeamingPolicy.failureCriteria != null) {
                VmwareDistributedVirtualSwitch.FailureCriteria criteria = defaultPortConfig.uplinkTeamingPolicy.failureCriteria;
                failoverPolicyModel.beaconProbing = DvPortgroupPolicyParser.getBooleanPolicyValue(criteria.checkBeacon);
            }
            failoverPolicyModel.notifySwitches = DvPortgroupPolicyParser.getBooleanPolicyValue(defaultPortConfig.uplinkTeamingPolicy.notifySwitches);
            failoverPolicyModel.rollingOrder = DvPortgroupPolicyParser.getBooleanPolicyValue(defaultPortConfig.uplinkTeamingPolicy.rollingOrder);
        }
        failoverPolicyModel.failoverOrder = DvPortgroupPolicyParser.getFailoverOrderPolicy(defaultPortConfig.uplinkTeamingPolicy, uplinkPortNames, lacpGroupConfigs);
        if (StringUtil.isNullOrEmpty((String)failoverPolicyModel.loadBalancing)) {
            failoverPolicyModel.loadBalancing = DistributedVirtualSwitch.NicTeamingPolicyMode.loadbalance_srcid.toString();
        }
        failoverPolicyModel.loadBalancingModes = loadBalancingModes;
        return failoverPolicyModel;
    }

    public static DvpgFailoverPolicyModel.FailoverOrder getFailoverOrderPolicy(VmwareDistributedVirtualSwitch.UplinkPortTeamingPolicy uplinkTeamingPolicy, String[] uplinkPortNames, VmwareDistributedVirtualSwitch.LacpGroupConfig[] lacpGroupConfigs) {
        DvpgFailoverPolicyModel.FailoverOrder failoverOrder = new DvpgFailoverPolicyModel.FailoverOrder();
        failoverOrder.activeUplinkPortNames = new ArrayList<String>();
        failoverOrder.standbyUplinkPortNames = new ArrayList<String>();
        failoverOrder.unusedUplinkPortNames = new ArrayList<String>();
        if (uplinkTeamingPolicy != null && uplinkTeamingPolicy.uplinkPortOrder != null) {
            if (!ArrayUtil.isNullOrEmpty((Object[])uplinkTeamingPolicy.uplinkPortOrder.activeUplinkPort)) {
                failoverOrder.activeUplinkPortNames = Arrays.asList(uplinkTeamingPolicy.uplinkPortOrder.activeUplinkPort);
            }
            if (!ArrayUtil.isNullOrEmpty((Object[])uplinkTeamingPolicy.uplinkPortOrder.standbyUplinkPort)) {
                failoverOrder.standbyUplinkPortNames = Arrays.asList(uplinkTeamingPolicy.uplinkPortOrder.standbyUplinkPort);
            }
            for (String string : uplinkPortNames) {
                if (failoverOrder.activeUplinkPortNames.contains(string) || failoverOrder.standbyUplinkPortNames.contains(string)) continue;
                failoverOrder.unusedUplinkPortNames.add(string);
            }
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])lacpGroupConfigs)) {
            failoverOrder.lagNames = new ArrayList<String>();
            for (VmwareDistributedVirtualSwitch.LacpGroupConfig lacpGroupConfig : lacpGroupConfigs) {
                if (lacpGroupConfig.name == null) continue;
                failoverOrder.lagNames.add(lacpGroupConfig.name);
                if (failoverOrder.activeUplinkPortNames.contains(lacpGroupConfig.name) || failoverOrder.standbyUplinkPortNames.contains(lacpGroupConfig.name)) continue;
                failoverOrder.unusedUplinkPortNames.add(lacpGroupConfig.name);
            }
        }
        return failoverOrder;
    }

    public static DvpgTrafficShapingPolicyModel getTrafficShapingPolicies(VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy defaultPortConfig) {
        if (defaultPortConfig == null) {
            return null;
        }
        DvpgTrafficShapingPolicyModel trafficShapingModel = new DvpgTrafficShapingPolicyModel();
        trafficShapingModel.inShapingPolicy = DvPortgroupPolicyParser.getTrafficShapingPolicy(defaultPortConfig.inShapingPolicy);
        trafficShapingModel.outShapingPolicy = DvPortgroupPolicyParser.getTrafficShapingPolicy(defaultPortConfig.outShapingPolicy);
        return trafficShapingModel;
    }

    public static DvpgMonitoringPolicyModel getIpfixPolicy(VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy defaultPortConfig, VmwareDistributedVirtualSwitch.IpfixFeatureCapability ipfixCapability) {
        if (defaultPortConfig == null) {
            return null;
        }
        DvpgMonitoringPolicyModel monitoringPolicyData = new DvpgMonitoringPolicyModel();
        if (ipfixCapability != null && ipfixCapability.ipfixSupported != null) {
            monitoringPolicyData.ipfixSupported = ipfixCapability.ipfixSupported;
        }
        if (monitoringPolicyData.ipfixSupported) {
            monitoringPolicyData.ipfixEnabled = DvPortgroupPolicyParser.getBooleanPolicyValue(defaultPortConfig.ipfixEnabled);
        }
        return monitoringPolicyData;
    }

    public static DvpgResourceAllocationPolicyModel getResourceAllocationModel(DistributedVirtualPort.Setting defaultPortConfig, boolean isUplink, Integer niocVersion, String vmVnicNetworkResourcePoolKey, VmVnicNetworkResourcePool[] vmVnicNetworkResourcePools, NetworkResourcePool[] networkResourcePools) {
        DvpgResourceAllocationPolicyModel resAllocModel = new DvpgResourceAllocationPolicyModel();
        if (isUplink || niocVersion == null || niocVersion != 2 && niocVersion != 3) {
            resAllocModel.isNetworkResourcePoolSupported = false;
            return resAllocModel;
        }
        resAllocModel.isNetworkResourcePoolSupported = true;
        resAllocModel.isVmVnicResourcePoolSupported = niocVersion == 3;
        ArrayList<DvpgResourceAllocationPolicyModel.NetworkResourcePool> resourcePools = new ArrayList<DvpgResourceAllocationPolicyModel.NetworkResourcePool>();
        if (niocVersion == 3) {
            String string = resAllocModel.networkResourcePoolKey = vmVnicNetworkResourcePoolKey != null ? vmVnicNetworkResourcePoolKey : "-1";
            if (!ArrayUtil.isNullOrEmpty((Object[])vmVnicNetworkResourcePools)) {
                for (VmVnicNetworkResourcePool vmVnicNetworkResourcePool : vmVnicNetworkResourcePools) {
                    resourcePools.add(DvPortgroupPolicyParser.createResourcePool(vmVnicNetworkResourcePool.key, vmVnicNetworkResourcePool.name));
                }
            }
        } else if (niocVersion == 2) {
            resAllocModel.networkResourcePoolKey = defaultPortConfig != null ? DvPortgroupPolicyParser.getStringPolicyValue(defaultPortConfig.networkResourcePoolKey, "-1") : "-1";
            if (!ArrayUtil.isNullOrEmpty((Object[])networkResourcePools)) {
                for (VmVnicNetworkResourcePool vmVnicNetworkResourcePool : networkResourcePools) {
                    if (NetworkUtil.isSystemNetworkResourcePool(vmVnicNetworkResourcePool.key)) continue;
                    resourcePools.add(DvPortgroupPolicyParser.createResourcePool(vmVnicNetworkResourcePool.key, vmVnicNetworkResourcePool.name));
                }
            }
        }
        if (resourcePools.size() > 1) {
            Collections.sort(resourcePools, new Comparator<DvpgResourceAllocationPolicyModel.NetworkResourcePool>(){

                @Override
                public int compare(DvpgResourceAllocationPolicyModel.NetworkResourcePool nrp1, DvpgResourceAllocationPolicyModel.NetworkResourcePool nrp2) {
                    return nrp1.name.compareToIgnoreCase(nrp2.name);
                }
            });
        }
        DvpgResourceAllocationPolicyModel.NetworkResourcePool defaultResourcePool = new DvpgResourceAllocationPolicyModel.NetworkResourcePool();
        defaultResourcePool.key = "-1";
        defaultResourcePool.name = NetworkStringUtil.getString("dvpg.policy.iorm.pool.none");
        resourcePools.add(0, defaultResourcePool);
        resAllocModel.networkResourcePools = resourcePools;
        return resAllocModel;
    }

    public static DvpgMiscPolicyModel getPortBlockedPolicyModel(VmwareDistributedVirtualSwitch.VmwarePortConfigPolicy defaultPortConfig) {
        if (defaultPortConfig == null) {
            return null;
        }
        DvpgMiscPolicyModel miscPolicyModel = new DvpgMiscPolicyModel();
        miscPolicyModel.arePortsBlocked = DvPortgroupPolicyParser.getBooleanPolicyValue(defaultPortConfig.blocked);
        return miscPolicyModel;
    }

    public static void setAdvancedPortPolicies(DistributedVirtualPortgroup.PortgroupPolicy policy, boolean isUplink, DistributedVirtualSwitch.Capability dvsCapability, Integer niocVersion, DvPortgroupPortProperties dvPortgroupPortProperties) {
        boolean isTrafficFilteringAvailable;
        if (policy == null) {
            return;
        }
        dvPortgroupPortProperties.portConfigResetAtDisconnect = policy.portConfigResetAtDisconnect;
        dvPortgroupPortProperties.blockOverrideAllowed = policy.blockOverrideAllowed;
        if (!isUplink) {
            dvPortgroupPortProperties.shapingOverrideAllowed = policy.shapingOverrideAllowed;
        }
        dvPortgroupPortProperties.vendorConfigOverrideAllowed = policy.vendorConfigOverrideAllowed;
        boolean bl = isTrafficFilteringAvailable = dvsCapability != null && dvsCapability.featuresSupported != null && dvsCapability.featuresSupported.networkFilterSupported != null && dvsCapability.featuresSupported.networkFilterSupported != false;
        if (isTrafficFilteringAvailable) {
            dvPortgroupPortProperties.trafficFilterOverrideAllowed = policy.trafficFilterOverrideAllowed;
        }
        if (policy instanceof VmwareDistributedVirtualSwitch.VMwarePortgroupPolicy) {
            boolean isVmwareImplementation;
            VmwareDistributedVirtualSwitch.VMwarePortgroupPolicy vmwarePolicy = (VmwareDistributedVirtualSwitch.VMwarePortgroupPolicy)policy;
            boolean bl2 = isVmwareImplementation = dvsCapability != null && dvsCapability.featuresSupported instanceof VmwareDistributedVirtualSwitch.FeatureCapability;
            if (isVmwareImplementation) {
                dvPortgroupPortProperties.vlanOverrideAllowed = vmwarePolicy.vlanOverrideAllowed;
                if (!isUplink) {
                    dvPortgroupPortProperties.uplinkTeamingOverrideAllowed = vmwarePolicy.uplinkTeamingOverrideAllowed;
                    dvPortgroupPortProperties.securityPolicyOverrideAllowed = vmwarePolicy.securityPolicyOverrideAllowed;
                }
                VmwareDistributedVirtualSwitch.FeatureCapability supportedFeatures = (VmwareDistributedVirtualSwitch.FeatureCapability)dvsCapability.featuresSupported;
                if (supportedFeatures.ipfixSupported != null && supportedFeatures.ipfixSupported.booleanValue()) {
                    dvPortgroupPortProperties.ipfixOverrideAllowed = vmwarePolicy.ipfixOverrideAllowed;
                }
            }
            if (!isUplink && niocVersion != null && niocVersion == 2) {
                dvPortgroupPortProperties.networkResourcePoolOverrideAllowed = policy.networkResourcePoolOverrideAllowed;
            }
        }
    }

    public static DvpgTrafficShapingPolicyModel.TrafficShapingPolicy getTrafficShapingPolicy(DistributedVirtualPort.TrafficShapingPolicy policy) {
        DvpgTrafficShapingPolicyModel.TrafficShapingPolicy trafficShapingPolicy = new DvpgTrafficShapingPolicyModel.TrafficShapingPolicy();
        if (policy == null) {
            trafficShapingPolicy.averageBandwidth = 100000L;
            trafficShapingPolicy.peakBandwidth = 100000L;
            trafficShapingPolicy.burstSize = 102400L;
            trafficShapingPolicy.enabled = false;
            return trafficShapingPolicy;
        }
        trafficShapingPolicy.averageBandwidth = DvPortgroupPolicyParser.getLongPolicyValue(policy.averageBandwidth, 100000L) / FormatUtil.KBPS;
        trafficShapingPolicy.peakBandwidth = DvPortgroupPolicyParser.getLongPolicyValue(policy.peakBandwidth, 100000L) / FormatUtil.KBPS;
        trafficShapingPolicy.burstSize = DvPortgroupPolicyParser.getLongPolicyValue(policy.burstSize, 102400L) / 1024L;
        trafficShapingPolicy.enabled = DvPortgroupPolicyParser.getBooleanPolicyValue(policy.enabled);
        return trafficShapingPolicy;
    }

    private static DvpgResourceAllocationPolicyModel.NetworkResourcePool createResourcePool(String key, String name) {
        DvpgResourceAllocationPolicyModel.NetworkResourcePool resourcePool = new DvpgResourceAllocationPolicyModel.NetworkResourcePool();
        resourcePool.key = key;
        resourcePool.name = name;
        return resourcePool;
    }

    private static boolean getBooleanPolicyValue(BoolPolicy boolPolicy) {
        return boolPolicy != null && boolPolicy.value != null && boolPolicy.value != false;
    }

    private static long getLongPolicyValue(LongPolicy valuePolicy, long defaultValue) {
        return valuePolicy == null || valuePolicy.value == null ? defaultValue : valuePolicy.value;
    }

    private static String getStringPolicyValue(StringPolicy valuePolicy, String defaultValue) {
        return valuePolicy == null || valuePolicy.value == null ? defaultValue : valuePolicy.value;
    }
}

