/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder.impl;

import com.vmware.vim.binding.vim.encryption.CryptoManagerKmip;
import com.vmware.vim.binding.vim.encryption.KmipServerSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.folder.FolderUtils;
import com.vmware.vsphere.client.folder.keyServers.KmipCertificateType;
import com.vmware.vsphere.client.folder.keyServers.KmipEditServerInfoSpec;
import com.vmware.vsphere.client.folder.keyServers.KmipServerInfoSpec;
import com.vmware.vsphere.client.folder.keyServers.KmipServerRemovalSpec;
import com.vmware.vsphere.client.folder.keyServers.KmipSetDefaultClusterInfoSpec;
import com.vmware.vsphere.client.folder.keyServers.KmipUpdateCertificatePrivateKeySpec;
import com.vmware.vsphere.client.folder.keyServers.KmipUpdateClientCertificateSpec;
import com.vmware.vsphere.client.folder.keyServers.KmipUpdateServerCertificateSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VCenterKmipMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(VCenterKmipMutationProvider.class);

    public OperationResult apply(ManagedObjectReference vcRef, KmipSetDefaultClusterInfoSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vcRef;
        if (spec == null) {
            _logger.error((Object)"KmipSetDefaultClusterInfoSpec is null");
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        try {
            CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
            if (cryptoManagerKmip != null) {
                cryptoManagerKmip.markDefault(FolderUtils.getKmipProviderIdByName(spec.clusterName));
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"KmipServerMutationProvider: Error during setting a default KMIP cluster.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vcRef, KmipEditServerInfoSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vcRef;
        if (spec == null) {
            _logger.error((Object)"KmipEditServerInfoSpec is null");
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        try {
            CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
            if (cryptoManagerKmip != null) {
                KmipServerSpec newSpec = FolderUtils.getKmipServerSpec((KmipServerInfoSpec)spec);
                cryptoManagerKmip.updateKmipServer(newSpec);
                if (spec.trustedCert != null) {
                    cryptoManagerKmip.uploadKmipServerCert(FolderUtils.getKmipProviderIdByName(spec.clusterName), spec.trustedCert);
                }
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"KmipServerMutationProvider: Error during performin operation on the KMIP server.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vcRef, KmipUpdateClientCertificateSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vcRef;
        if (spec == null) {
            _logger.error((Object)"KmipUpdateClientCertificateSpec is null");
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        try {
            CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
            if (cryptoManagerKmip != null) {
                if (spec.type == KmipCertificateType.ROOT_CA || spec.type == KmipCertificateType.SELF_SIGNED) {
                    cryptoManagerKmip.updateSelfSignedClientCert(FolderUtils.getKmipProviderIdByName(spec.clusterName), spec.certificate);
                } else if (spec.type == KmipCertificateType.SIGNED_CSR) {
                    cryptoManagerKmip.updateKmsSignedCsrClientCert(FolderUtils.getKmipProviderIdByName(spec.clusterName), spec.certificate);
                }
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"KmipServerMutationProvider: Error during updating the KMIP cluster certificate.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vcRef, KmipUpdateCertificatePrivateKeySpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vcRef;
        if (spec == null) {
            _logger.error((Object)"KmipUpdateCertificatePrivateKeySpec is null");
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        try {
            CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
            if (cryptoManagerKmip != null) {
                cryptoManagerKmip.uploadClientCert(FolderUtils.getKmipProviderIdByName(spec.clusterName), spec.certificate, spec.privateKey);
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"KmipServerMutationProvider: Error during updating client certificate and its private key.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vcRef, KmipUpdateServerCertificateSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vcRef;
        if (spec == null) {
            _logger.error((Object)"KmipUpdateServerCertificateSpec is null");
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        try {
            CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
            if (cryptoManagerKmip != null) {
                cryptoManagerKmip.uploadKmipServerCert(FolderUtils.getKmipProviderIdByName(spec.clusterName), spec.certificate);
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"KmipServerMutationProvider: Error during updating the KMIP server certificate.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult add(KmipServerInfoSpec spec) {
        OperationResult result = new OperationResult();
        if (spec == null) {
            _logger.error((Object)"KmipServerInfoSpec is null");
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        try {
            result.entity = spec.vcReference;
            CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(spec.vcReference);
            if (cryptoManagerKmip != null) {
                KmipServerSpec newSpec = FolderUtils.getKmipServerSpec(spec);
                cryptoManagerKmip.registerKmipServer(newSpec);
                if (spec.trustedCert != null) {
                    cryptoManagerKmip.uploadKmipServerCert(FolderUtils.getKmipProviderIdByName(spec.clusterName), spec.trustedCert);
                }
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"KmipServerMutationProvider: Error during registring a new kmip server.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult remove(ManagedObjectReference vcRef, KmipServerRemovalSpec spec) {
        OperationResult result = new OperationResult();
        try {
            if (spec == null) {
                _logger.error((Object)"KmipServerRemovalSpec is null");
                result.error = MixedUtil.getInvalidEntityFault();
                return result;
            }
            result.entity = null;
            CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
            if (cryptoManagerKmip != null) {
                cryptoManagerKmip.removeKmipServer(FolderUtils.getKmipProviderIdByName(spec.clusterName), spec.serverName);
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"KmipServerMutationProvider: Error during removing KMIP server.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }
}

