/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.ceip.authentication;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vise.vim.commons.ServiceEndpointType;
import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class ServiceEndpointInfo {
    private final SsoDomain _ssoDomain;
    private final ServiceEndpointType _endpointType;
    private final String _serviceGuid;
    private final URI _serviceUrl;
    private final String _certificate;
    private final String _instanceName;

    public ServiceEndpointInfo(SsoDomain ssoDomain, ServiceEndpointType endpointType, String serviceGuid, String instanceName, URI serviceUrl, String certificate) {
        Validate.notNull((Object)ssoDomain, (String)"ssoDomain shouldn't be null");
        Validate.notNull((Object)endpointType, (String)"The endpointType shouldn't be null");
        Validate.notEmpty((String)StringUtils.strip((String)serviceGuid), (String)"The serviceGuid shouldn't be null or whitespace");
        Validate.notNull((Object)serviceUrl, (String)"The serviceUrl shouldn't be null");
        this._ssoDomain = ssoDomain;
        this._endpointType = endpointType;
        this._serviceGuid = serviceGuid;
        this._instanceName = instanceName;
        this._serviceUrl = serviceUrl;
        this._certificate = certificate;
    }

    public SsoDomain getSsoDomain() {
        return this._ssoDomain;
    }

    public ServiceEndpointType getServiceEndpointType() {
        return this._endpointType;
    }

    public String getServiceGuid() {
        return this._serviceGuid;
    }

    public URI getServiceUrl() {
        return this._serviceUrl;
    }

    public String getCertificate() {
        return this._certificate;
    }

    public String getInstanceName() {
        return this._instanceName;
    }

    public String toString() {
        return "(ssoDomain=" + this._ssoDomain + ", endpointType=" + this._endpointType + ", serviceGuid=" + this._serviceGuid + ", serviceUrl=" + this._serviceUrl + ", instanceName=" + this._instanceName + ")";
    }
}

