/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.fop.apps.CommandLineOptions;
import org.apache.fop.apps.CommandLineStarter;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Version;
import org.apache.fop.layout.Page;
import org.apache.fop.render.awt.AWTRenderer;
import org.xml.sax.XMLReader;

public class PrintStarter
extends CommandLineStarter {
    public PrintStarter(CommandLineOptions options) throws FOPException {
        super(options);
    }

    int getIntProperty(String name, int def) {
        String propValue = System.getProperty(name);
        if (propValue != null) {
            try {
                return Integer.parseInt(propValue);
            }
            catch (Exception exception) {
                return def;
            }
        }
        return def;
    }

    public void run() throws FOPException {
        Driver driver = new Driver();
        if (this.errorDump) {
            driver.setErrorDump(true);
        }
        driver.setLogger(new ConsoleLogger(1));
        this.log.info(Version.getVersion());
        XMLReader parser = this.inputHandler.getParser();
        PrinterJob pj = PrinterJob.getPrinterJob();
        if (System.getProperty("dialog") != null && !pj.printDialog()) {
            throw new FOPException("Printing cancelled by operator");
        }
        PrintRenderer renderer = new PrintRenderer(pj);
        int copies = this.getIntProperty("copies", 1);
        pj.setCopies(copies);
        try {
            driver.setRenderer(renderer);
            driver.render(parser, this.inputHandler.getInputSource());
        }
        catch (Exception e) {
            if (e instanceof FOPException) {
                throw (FOPException)e;
            }
            throw new FOPException(e);
        }
        System.exit(0);
    }

    class PrintRenderer
    extends AWTRenderer {
        private static final int EVEN_AND_ALL = 0;
        private static final int EVEN = 1;
        private static final int ODD = 2;
        private int startNumber;
        private int endNumber;
        private int mode;
        private int copies;
        private PrinterJob printerJob;

        PrintRenderer(PrinterJob printerJob) {
            block2: {
                super(null);
                this.mode = 0;
                this.copies = 1;
                this.printerJob = printerJob;
                this.startNumber = PrintStarter.this.getIntProperty("start", 1) - 1;
                this.endNumber = PrintStarter.this.getIntProperty("end", -1);
                printerJob.setPageable(this);
                this.mode = 0;
                String str = System.getProperty("even");
                if (str == null) break block2;
                try {
                    this.mode = Boolean.valueOf(str) != false ? 1 : 2;
                }
                catch (Exception exception) {}
            }
        }

        private ArrayList getInvalidPageNumbers() {
            ArrayList<String> vec = new ArrayList<String>();
            int max = this.getPageCount();
            int i = 0;
            while (i < max) {
                boolean isValid = true;
                if (i < this.startNumber || i > this.endNumber) {
                    isValid = false;
                } else if (this.mode != 0) {
                    if (this.mode == 1 && (i + 1) % 2 != 0) {
                        isValid = false;
                    } else if (this.mode == 2 && (i + 1) % 2 != 1) {
                        isValid = false;
                    }
                }
                if (!isValid) {
                    vec.add(String.valueOf(i));
                }
                ++i;
            }
            return vec;
        }

        public void renderPage(Page page) {
            this.pageWidth = (int)((float)page.getWidth() / 1000.0f);
            this.pageHeight = (int)((float)page.getHeight() / 1000.0f);
            super.renderPage(page);
        }

        public void stopRenderer(OutputStream outputStream) throws IOException {
            super.stopRenderer(outputStream);
            if (this.endNumber == -1) {
                this.endNumber = this.getPageCount();
            }
            ArrayList numbers = this.getInvalidPageNumbers();
            int i = numbers.size() - 1;
            while (i > -1) {
                this.removePage(Integer.parseInt((String)numbers.get(i)));
                --i;
            }
            try {
                this.printerJob.print();
            }
            catch (PrinterException e) {
                e.printStackTrace();
                throw new IOException("Unable to print: " + e.getClass().getName() + ": " + e.getMessage());
            }
        }
    }
}

