/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.metadata.impl.jaxb;

import com.vmware.vise.metadata.impl.jaxb.JaxbTag;
import com.vmware.vise.metadata.impl.jaxb.JaxbTags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class JaxbTagsMapAdapter
extends XmlAdapter<JaxbTags, Map<String, String>> {
    public Map<String, String> unmarshal(JaxbTags jaxbTagMap) throws Exception {
        if (jaxbTagMap == null) {
            return Collections.emptyMap();
        }
        List<JaxbTag> jaxbTags = jaxbTagMap.getTags();
        if (jaxbTags == null || jaxbTags.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>(jaxbTags.size());
        for (JaxbTag tag : jaxbTags) {
            String name = tag.getName();
            String value = tag.getValue();
            map.put(name, value);
        }
        return map;
    }

    public JaxbTags marshal(Map<String, String> map) throws Exception {
        if (map == null || map.isEmpty()) {
            return null;
        }
        ArrayList<JaxbTag> jaxbTags = new ArrayList<JaxbTag>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            JaxbTag jaxbTag = new JaxbTag(name, value);
            jaxbTags.add(jaxbTag);
        }
        JaxbTags jaxbTagMap = new JaxbTags(jaxbTags);
        return jaxbTagMap;
    }
}

