/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.metadata.impl;

import com.vmware.vise.metadata.TypeDescriptor;
import com.vmware.vise.metadata.impl.TypeOwnership;

public class TypeDescriptorEx {
    private final TypeDescriptor _typeDescriptor;
    private final TypeOwnership _ownership;

    public TypeDescriptorEx(TypeDescriptor typeDescriptor) {
        this(typeDescriptor, null);
    }

    public TypeDescriptorEx(TypeDescriptor typeDescriptor, TypeOwnership ownership) {
        if (typeDescriptor == null) {
            throw new IllegalArgumentException("The typeDescriptor shouldn't be null");
        }
        this._typeDescriptor = typeDescriptor;
        this._ownership = ownership != null ? ownership : TypeOwnership.COMMON;
    }

    public TypeDescriptor getTypeDescriptor() {
        return this._typeDescriptor;
    }

    public TypeOwnership getOwnership() {
        return this._ownership;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("typeDescriptor: [").append(this._typeDescriptor.toString()).append("], ownership: ").append((Object)this._ownership);
        return sb.toString();
    }

    public static TypeDescriptor[] toTypeDescriptors(TypeDescriptorEx[] tdxs) {
        if (tdxs == null) {
            return null;
        }
        int total = tdxs.length;
        TypeDescriptor[] tds = new TypeDescriptor[total];
        for (int i = 0; i < total; ++i) {
            TypeDescriptorEx tdx = tdxs[i];
            tds[i] = tdx != null ? tdx.getTypeDescriptor() : null;
        }
        return tds;
    }
}

