/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.metadata.impl;

import com.vmware.vise.metadata.Descriptor;
import com.vmware.vise.metadata.MetadataServiceI18nException;
import com.vmware.vise.metadata.PropertyDescriptor;
import com.vmware.vise.metadata.RelationshipDescriptor;
import com.vmware.vise.metadata.TypeDescriptor;
import com.vmware.vise.metadata.impl.BundleMetadataDeserializer;
import com.vmware.vise.metadata.impl.BundleMetadataRegistrar;
import com.vmware.vise.metadata.impl.MetadataServiceRegistryInternal;
import com.vmware.vise.metadata.impl.TypeDescriptorEx;
import com.vmware.vise.metadata.impl.TypeOwnership;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.MessageLocalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MetadataServiceRegistryImpl
implements MetadataServiceRegistryInternal {
    private static final Log _logger = LogFactory.getLog(BundleMetadataDeserializer.class);
    private final ConcurrentMap<String, DescriptorData<TypeDescriptor, TypeOwnership>> _typeDescriptorRegister = new ConcurrentHashMap<String, DescriptorData<TypeDescriptor, TypeOwnership>>();
    private final Map<String, DescriptorData<RelationshipDescriptor, Object>> _relationshipsRegister = new HashMap<String, DescriptorData<RelationshipDescriptor, Object>>();
    private final Map<String, Map<String, DescriptorData<RelationshipDescriptor, Object>>> _relationshipsBySource = new HashMap<String, Map<String, DescriptorData<RelationshipDescriptor, Object>>>();
    private final Map<String, Map<String, DescriptorData<RelationshipDescriptor, Object>>> _relationshipsByTarget = new HashMap<String, Map<String, DescriptorData<RelationshipDescriptor, Object>>>();
    private final ConcurrentMap<String, Map<String, DescriptorData<PropertyDescriptor, Object>>> _propertyDescriptorRegister = new ConcurrentHashMap<String, Map<String, DescriptorData<PropertyDescriptor, Object>>>();
    private final ReentrantReadWriteLock _propertyDescriptorLock = new ReentrantReadWriteLock();
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final TypeDescriptor[] EMPTY_TYPE_DESCRIPTORS = new TypeDescriptor[0];
    private static final RelationshipDescriptor[] EMPTY_RELATIONSHIP_DESCRIPTORS = new RelationshipDescriptor[0];
    private static final PropertyDescriptor[] EMPTY_PROPERTY_DESCRIPTORS = new PropertyDescriptor[0];

    public void init() {
        BundleMetadataRegistrar.metadataRegistry = this;
    }

    @Override
    public void registerTypeMetadata(TypeDescriptor[] descriptors, MessageLocalizer msgLoc) {
        for (TypeDescriptor typeDescriptor : descriptors) {
            if (typeDescriptor == null) continue;
            if (typeDescriptor.name == null) {
                throw new IllegalArgumentException("The array contains a " + TypeDescriptor.class.getSimpleName() + " without a name.");
            }
            this.registerTypeDescriptor(typeDescriptor, TypeOwnership.COMMON, msgLoc);
        }
    }

    @Override
    public void registerTypeMetadata(TypeDescriptorEx[] descriptors, MessageLocalizer msgLoc) {
        for (TypeDescriptorEx typeDescriptorEx : descriptors) {
            if (typeDescriptorEx == null) continue;
            TypeDescriptor typeDescriptor = typeDescriptorEx.getTypeDescriptor();
            if (typeDescriptor.name == null) {
                throw new IllegalArgumentException("The array contains a " + TypeDescriptor.class.getSimpleName() + " without a name.");
            }
            TypeOwnership ownership = typeDescriptorEx.getOwnership();
            this.registerTypeDescriptor(typeDescriptor, ownership, msgLoc);
        }
    }

    private void registerTypeDescriptor(TypeDescriptor typeDesc, TypeOwnership ownership, MessageLocalizer msgLoc) {
        String descriptorName = typeDesc.name;
        DescriptorData<TypeDescriptor, TypeOwnership> value = new DescriptorData<TypeDescriptor, TypeOwnership>(typeDesc, ownership, msgLoc);
        DescriptorData<TypeDescriptor, TypeOwnership> previousValue = this._typeDescriptorRegister.putIfAbsent(descriptorName, value);
        if (previousValue != null) {
            _logger.warn((Object)("Did not register type descriptor with name='" + descriptorName + "' because another type descriptor by that name is already registered"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerRelationshipMetadata(RelationshipDescriptor[] descriptors, MessageLocalizer msgLoc) {
        for (RelationshipDescriptor relationshipDescriptor : descriptors) {
            String key = relationshipDescriptor.name;
            Map<String, DescriptorData<RelationshipDescriptor, Object>> map = this._relationshipsRegister;
            synchronized (map) {
                if (!this._relationshipsRegister.containsKey(key)) {
                    DescriptorData relDescData = new DescriptorData(relationshipDescriptor, msgLoc);
                    this._relationshipsRegister.put(key, relDescData);
                    Map<String, DescriptorData<RelationshipDescriptor, Object>> sourceRelationships = this._relationshipsBySource.get(relationshipDescriptor.sourceType);
                    if (sourceRelationships == null) {
                        sourceRelationships = new HashMap<String, DescriptorData<RelationshipDescriptor, Object>>();
                        this._relationshipsBySource.put(relationshipDescriptor.sourceType, sourceRelationships);
                    }
                    sourceRelationships.put(relationshipDescriptor.name, relDescData);
                    Map<String, DescriptorData<RelationshipDescriptor, Object>> targetRelationships = this._relationshipsByTarget.get(relationshipDescriptor.targetType);
                    if (targetRelationships == null) {
                        targetRelationships = new HashMap<String, DescriptorData<RelationshipDescriptor, Object>>();
                        this._relationshipsByTarget.put(relationshipDescriptor.targetType, targetRelationships);
                    }
                    targetRelationships.put(relationshipDescriptor.name, relDescData);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerPropertyMetadata(PropertyDescriptor[] descriptors, MessageLocalizer msgLoc) {
        for (PropertyDescriptor propertyDescriptor : descriptors) {
            Map previousValue;
            String key = propertyDescriptor.providerName;
            Map propertyMap = (LinkedHashMap)this._propertyDescriptorRegister.get(key);
            if (propertyMap == null && (previousValue = (Map)this._propertyDescriptorRegister.putIfAbsent(key, propertyMap = new LinkedHashMap())) != null) {
                propertyMap = previousValue;
            }
            DescriptorData descData = new DescriptorData(propertyDescriptor, msgLoc);
            this._propertyDescriptorLock.readLock().lock();
            if (!propertyMap.containsKey(propertyDescriptor.name)) {
                this._propertyDescriptorLock.readLock().unlock();
                this._propertyDescriptorLock.writeLock().lock();
                try {
                    if (propertyMap.containsKey(propertyDescriptor.name)) continue;
                    propertyMap.put(propertyDescriptor.name, descData);
                    continue;
                }
                finally {
                    this._propertyDescriptorLock.writeLock().unlock();
                }
            }
            this._propertyDescriptorLock.readLock().unlock();
        }
    }

    @Override
    public TypeDescriptor[] lookUpTypeDescriptors(String typeUid) {
        if (typeUid == null || typeUid.isEmpty()) {
            List<TypeDescriptor> types;
            try {
                types = this.getAllValuesWithI18N(this._typeDescriptorRegister);
            }
            catch (MetadataServiceI18nException e) {
                TypeDescriptor td = (TypeDescriptor)e.getDescriptor();
                throw new MetadataServiceI18nException("Failed to localize " + TypeDescriptor.class.getSimpleName() + " for type " + typeUid + ": " + e.getMessage(), td);
            }
            int numTypes = types.size();
            if (numTypes == 0) {
                return EMPTY_TYPE_DESCRIPTORS;
            }
            return types.toArray(new TypeDescriptor[numTypes]);
        }
        DescriptorData descData = (DescriptorData)this._typeDescriptorRegister.get(typeUid);
        if (descData != null) {
            TypeDescriptor rawDesc = (TypeDescriptor)descData.getDescriptor();
            MessageLocalizer msgLoc = descData.getMessageLocalizer();
            TypeDescriptor localized = (TypeDescriptor)rawDesc.buildLocalizedCopy(msgLoc);
            return new TypeDescriptor[]{localized};
        }
        return EMPTY_TYPE_DESCRIPTORS;
    }

    @Override
    public boolean isTypeExplicit(String typeUid) {
        DescriptorData descData = (DescriptorData)this._typeDescriptorRegister.get(typeUid);
        if (descData == null) {
            return false;
        }
        TypeOwnership ownership = (TypeOwnership)((Object)descData.getAdditionalData());
        boolean isExplicit = ownership == TypeOwnership.EXPLICIT;
        return isExplicit;
    }

    @Override
    public String[] getSupertypes(String typeUid) {
        DescriptorData descData;
        if (StringUtil.isNullOrEmpty((String)typeUid) || "Object".equals(typeUid)) {
            return EMPTY_STRINGS;
        }
        LinkedList<String> supertypes = new LinkedList<String>();
        String currentTypeId = typeUid;
        while (!StringUtil.isNullOrEmpty((String)currentTypeId) && !"Object".equals(currentTypeId) && (descData = (DescriptorData)this._typeDescriptorRegister.get(currentTypeId)) != null) {
            TypeDescriptor typeDescriptor = (TypeDescriptor)descData.getDescriptor();
            String supertype = typeDescriptor.supertype;
            if (supertypes.contains(supertype) || typeUid.equals(supertype)) {
                throw new IllegalStateException("There is a cycle in the type hierarchy of type: " + typeUid);
            }
            if (!StringUtil.isNullOrEmpty((String)supertype)) {
                supertypes.add(supertype);
            }
            currentTypeId = supertype;
        }
        supertypes.add("Object");
        String[] result = supertypes.toArray(EMPTY_STRINGS);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RelationshipDescriptor[] lookUpRelationshipDescriptors(String sourceType, String targetType) {
        List<DescriptorData<RelationshipDescriptor, Object>> relationships;
        if (StringUtil.isNullOrEmpty((String)sourceType) && StringUtil.isNullOrEmpty((String)targetType)) {
            ArrayList<DescriptorData<RelationshipDescriptor, Object>> relDescs;
            Map<String, DescriptorData<RelationshipDescriptor, Object>> map = this._relationshipsRegister;
            synchronized (map) {
                relDescs = new ArrayList<DescriptorData<RelationshipDescriptor, Object>>(this._relationshipsRegister.values());
            }
            return this.localizeRelationshipDescriptors(relDescs);
        }
        boolean sourceTypeSpecified = !StringUtil.isNullOrEmpty((String)sourceType);
        boolean targetTypeSpecified = !StringUtil.isNullOrEmpty((String)targetType);
        List<DescriptorData<RelationshipDescriptor, Object>> relationshipsWithSource = Collections.emptyList();
        List relationshipsWithTarget = Collections.emptyList();
        Map<String, DescriptorData<RelationshipDescriptor, Object>> map = this._relationshipsRegister;
        synchronized (map) {
            Map<String, DescriptorData<RelationshipDescriptor, Object>> relationshipsByTarget;
            Map<String, DescriptorData<RelationshipDescriptor, Object>> relationshipsBySource;
            if (sourceTypeSpecified && (relationshipsBySource = this._relationshipsBySource.get(sourceType)) != null) {
                relationshipsWithSource = new ArrayList<DescriptorData<RelationshipDescriptor, Object>>(relationshipsBySource.values());
            }
            if (targetTypeSpecified && (relationshipsByTarget = this._relationshipsByTarget.get(targetType)) != null) {
                relationshipsWithTarget = new ArrayList<DescriptorData<RelationshipDescriptor, Object>>(relationshipsByTarget.values());
            }
        }
        if (!targetTypeSpecified) {
            relationships = relationshipsWithSource;
        } else if (!sourceTypeSpecified) {
            relationships = relationshipsWithTarget;
        } else {
            relationshipsWithSource.retainAll(relationshipsWithTarget);
            relationships = relationshipsWithSource;
        }
        RelationshipDescriptor[] localizedDescs = this.localizeRelationshipDescriptors(relationships);
        return localizedDescs;
    }

    private RelationshipDescriptor[] localizeRelationshipDescriptors(Collection<DescriptorData<RelationshipDescriptor, Object>> relDescs) {
        if (relDescs == null || relDescs.isEmpty()) {
            return EMPTY_RELATIONSHIP_DESCRIPTORS;
        }
        LinkedList<RelationshipDescriptor> localizedDescs = new LinkedList<RelationshipDescriptor>();
        for (DescriptorData<RelationshipDescriptor, Object> rd : relDescs) {
            RelationshipDescriptor relDesc = rd.getDescriptor();
            MessageLocalizer msgLoc = rd.getMessageLocalizer();
            RelationshipDescriptor localized = (RelationshipDescriptor)relDesc.buildLocalizedCopy(msgLoc);
            localizedDescs.add(localized);
        }
        return localizedDescs.toArray(new RelationshipDescriptor[localizedDescs.size()]);
    }

    @Override
    public PropertyDescriptor[] lookUpPropertyDescriptors(String providerType) {
        List<PropertyDescriptor> properties;
        if (StringUtil.isNullOrEmpty((String)providerType)) {
            properties = this.getAllValuesWithI18NFromAllNestedRegisters(this._propertyDescriptorRegister);
        } else {
            Map mapByPropName = (Map)this._propertyDescriptorRegister.get(providerType);
            if (mapByPropName != null) {
                try {
                    properties = this.getAllValuesWithI18N(mapByPropName);
                }
                catch (MetadataServiceI18nException e) {
                    PropertyDescriptor pd = (PropertyDescriptor)e.getDescriptor();
                    throw new MetadataServiceI18nException("Failed to localize " + PropertyDescriptor.class.getSimpleName() + " for type " + providerType + " and property name '" + pd.name + "': " + e.getMessage(), pd);
                }
            } else {
                return EMPTY_PROPERTY_DESCRIPTORS;
            }
        }
        int numProperties = properties.size();
        if (numProperties == 0) {
            return EMPTY_PROPERTY_DESCRIPTORS;
        }
        return properties.toArray(new PropertyDescriptor[numProperties]);
    }

    @Override
    public PropertyDescriptor lookUpPropertyDescriptor(String providerType, String propertyName) {
        if (providerType == null || propertyName == null) {
            return null;
        }
        Map descriptorByProperty = (Map)this._propertyDescriptorRegister.get(providerType);
        if (descriptorByProperty == null || descriptorByProperty.isEmpty()) {
            return null;
        }
        try {
            return (PropertyDescriptor)this.getValueWithI18N(descriptorByProperty, propertyName);
        }
        catch (MetadataServiceI18nException e) {
            PropertyDescriptor pd = (PropertyDescriptor)e.getDescriptor();
            throw new MetadataServiceI18nException("Failed to localize " + PropertyDescriptor.class.getSimpleName() + " for type " + providerType + " and property name '" + pd.name + "': " + e.getMessage(), pd);
        }
    }

    private <T extends Descriptor, S> List<T> getAllValuesWithI18NFromAllNestedRegisters(Map<String, ? extends Map<String, DescriptorData<T, S>>> register) {
        if (register == null || register.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList(register.size());
        for (Map<String, DescriptorData<T, S>> nestedRegister : register.values()) {
            this.getAllValuesWithI18N(nestedRegister, result);
        }
        return result;
    }

    private <T extends Descriptor, S> List<T> getAllValuesWithI18N(Map<String, DescriptorData<T, S>> register) {
        if (register == null || register.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList(register.size());
        this.getAllValuesWithI18N(register, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Descriptor, S> void getAllValuesWithI18N(Map<String, DescriptorData<T, S>> register, List<T> result) {
        this._propertyDescriptorLock.readLock().lock();
        try {
            for (DescriptorData<T, S> descData : register.values()) {
                T rawDesc = descData.getDescriptor();
                MessageLocalizer msgLoc = descData.getMessageLocalizer();
                Descriptor localizedDescriptor = ((Descriptor)rawDesc).buildLocalizedCopy(msgLoc);
                result.add(localizedDescriptor);
            }
        }
        finally {
            this._propertyDescriptorLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Descriptor, S> T getValueWithI18N(Map<String, DescriptorData<T, S>> descriptorByProperty, String propertyName) {
        assert (descriptorByProperty != null);
        assert (propertyName != null);
        this._propertyDescriptorLock.readLock().lock();
        try {
            Descriptor localizedDescriptor;
            DescriptorData<T, S> descriptorData = descriptorByProperty.get(propertyName);
            if (descriptorData == null) {
                T t = null;
                return t;
            }
            T rawDescriptor = descriptorData.getDescriptor();
            MessageLocalizer messageLocalizer = descriptorData.getMessageLocalizer();
            Descriptor descriptor = localizedDescriptor = ((Descriptor)rawDescriptor).buildLocalizedCopy(messageLocalizer);
            return (T)descriptor;
        }
        finally {
            this._propertyDescriptorLock.readLock().unlock();
        }
    }

    private static class DescriptorData<T extends Descriptor, A> {
        private final T _desc;
        private final A _additionalData;
        private final MessageLocalizer _msgLoc;
        private volatile int _cachedHashCode;

        DescriptorData(T desc, MessageLocalizer msgLoc) {
            this(desc, null, msgLoc);
        }

        DescriptorData(T desc, A additionalData, MessageLocalizer msgLoc) {
            if (desc == null) {
                throw new IllegalArgumentException("The descriptor shouldn't be null");
            }
            this._desc = desc;
            this._additionalData = additionalData;
            this._msgLoc = msgLoc;
        }

        T getDescriptor() {
            return this._desc;
        }

        A getAdditionalData() {
            return this._additionalData;
        }

        MessageLocalizer getMessageLocalizer() {
            return this._msgLoc;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof DescriptorData) {
                DescriptorData dd = (DescriptorData)obj;
                return this._desc.equals(dd._desc) && (this._msgLoc == null ? dd._msgLoc == null : this._msgLoc.equals(dd._msgLoc));
            }
            return false;
        }

        public int hashCode() {
            int code = this._cachedHashCode;
            if (code == 0) {
                code = 17;
                code = 31 * code + this._desc.hashCode();
                this._cachedHashCode = code = 31 * code + (this._msgLoc != null ? this._msgLoc.hashCode() : 0);
            }
            return code;
        }
    }
}

