/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.metadata;

import com.vmware.vise.core.model.data;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.data.common.XSFacet;
import com.vmware.vise.data.common.XSFacetType;
import com.vmware.vise.metadata.DataElementDescriptor;
import com.vmware.vise.metadata.Descriptor;
import com.vmware.vise.metadata.Units;
import java.util.Arrays;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlAttribute;

@data
public class PropertyDescriptor
extends DataElementDescriptor {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    @XmlAttribute
    public String[] aliases = EMPTY_STRING_ARRAY;
    @XmlAttribute
    public Boolean immutable;
    @XmlAttribute
    public String inapplicableOperators;
    @XmlAttribute
    public Boolean sortable = Boolean.TRUE;
    public NameValuePair[] mutationArguments;

    public PropertyDescriptor() {
    }

    public PropertyDescriptor(PropertyDescriptor original) {
        original.copyFieldsTo(this, false);
    }

    @Override
    protected void copyFieldsTo(Descriptor target, boolean cloneLocalizableFields) {
        super.copyFieldsTo(target, cloneLocalizableFields);
        if (target instanceof PropertyDescriptor) {
            PropertyDescriptor pd = (PropertyDescriptor)target;
            pd.aliases = this.aliases;
            pd.immutable = this.immutable;
            pd.mutationArguments = this.mutationArguments;
            pd.inapplicableOperators = this.inapplicableOperators;
            pd.sortable = this.sortable;
        }
    }

    @Override
    protected void appendFieldValuesTo(StringBuilder sb) {
        super.appendFieldValuesTo(sb);
        sb.append(", aliases=").append(Arrays.toString(this.aliases)).append(", immutable=").append(this.immutable).append(", inapplicableOperators=").append(this.inapplicableOperators).append(", sortable=").append(this.sortable).append(", mutationArguments=").append(Arrays.toString(this.mutationArguments));
    }

    public static void main(String[] args) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("ala", "bala");
        tags.put("foo", "bar");
        PropertyDescriptor pd = new PropertyDescriptor();
        pd.name = "name";
        pd.title = "title";
        pd.description = "desc";
        pd.tags = tags;
        pd.valueTypeName = "string";
        pd.providerName = "VM";
        pd.displayForm = Units.DATE;
        pd.unit = Units.AUTO;
        pd.defaultValue = "ggbg";
        pd.isOptional = false;
        pd.staticValueSpace = new XSFacet[2];
        pd.staticValueSpace[0] = new XSFacet();
        pd.staticValueSpace[0].type = XSFacetType.FRACTIONDIGITS;
        pd.staticValueSpace[0].value = 5;
        pd.staticValueSpace[1] = new XSFacet();
        pd.staticValueSpace[1].type = XSFacetType.MAXLENGTH;
        pd.staticValueSpace[1].value = 7;
        pd.aliases = new String[]{"al1", "ias2"};
        pd.immutable = false;
        pd.inapplicableOperators = "whizzle";
        pd.sortable = true;
        pd.mutationArguments = new NameValuePair[]{new NameValuePair("nvp", "val")};
        System.out.println(pd);
    }
}

