/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.util.impl;

import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.util.ResultAnalyzer;
import com.vmware.vise.util.ArrayUtil;
import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.List;

public final class ResultAnalyzerImpl
implements ResultAnalyzer {
    @Override
    public <T> T findPropertyValueIn(String prop, List<ResultItem> resultItems) {
        if (ArrayUtil.isNullOrEmpty(resultItems)) {
            return null;
        }
        for (ResultItem resultItem : resultItems) {
            Object[] propValues = resultItem.properties;
            if (ArrayUtil.isNullOrEmpty((Object[])propValues)) continue;
            for (Object propValue : propValues) {
                if (!((PropertyValue)propValue).propertyName.equals(prop)) continue;
                return (T)((PropertyValue)propValue).value;
            }
        }
        return null;
    }

    @Override
    public boolean checkProperties(PropertyValue[] properties, String[] propertyNames) {
        if (properties == null || propertyNames == null || properties.length < propertyNames.length) {
            return false;
        }
        HashSet<String> propertyNameSet = new HashSet<String>();
        for (PropertyValue property : properties) {
            if (property == null || property.value == null) {
                return false;
            }
            propertyNameSet.add(property.propertyName);
        }
        for (String propertyName : propertyNames) {
            if (propertyName == null || propertyNameSet.contains(propertyName)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object[] findMoRefsIn(ResultSet result) {
        ResultItem[] resultItems;
        Object[] refs = null;
        if (result != null && (resultItems = result.items) != null && resultItems.length > 0) {
            refs = (Object[])Array.newInstance(resultItems[0].resourceObject.getClass(), resultItems.length);
            for (int i = 0; i < resultItems.length; ++i) {
                refs[i] = resultItems[i].resourceObject;
            }
        }
        return refs;
    }

    @Override
    public String getLocalizedString(String key) {
        return Utils.getLocalizedString(key);
    }
}

