/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.util.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.util.PropertyChangeInfo;
import com.vmware.vise.data.query.util.QueryHelperService;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueryHelperServiceImpl
implements QueryHelperService {
    private static final Logger _logger = LoggerFactory.getLogger(QueryHelperServiceImpl.class);
    public static final Constraint[] EMPTY_CONSTRAINTS = new Constraint[0];
    public static final ResultSet[] EMPTYSET = new ResultSet[0];
    private final ObjectReferenceService _objectReferenceService;

    public QueryHelperServiceImpl(ObjectReferenceService objectReferenceService) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{objectReferenceService});
        this._objectReferenceService = objectReferenceService;
    }

    @Override
    public String getResourceObjectType(Object reference) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{reference});
        return this._objectReferenceService.getResourceObjectType(reference);
    }

    @Override
    public String getServerGuid(Object reference) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{reference});
        return this._objectReferenceService.getServerGuid(reference);
    }

    @Override
    public String getUid(Object reference) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{reference});
        return this._objectReferenceService.getUid(reference);
    }

    @Override
    public Object getReference(String uid) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{uid});
        return this._objectReferenceService.getReference(uid);
    }

    @Override
    public String getUid(Object reference, boolean encode) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{reference});
        return this._objectReferenceService.getUid(reference, encode);
    }

    @Override
    public Object getReference(String uid, boolean decode) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{uid});
        return this._objectReferenceService.getReference(uid, decode);
    }

    @Override
    public <T> T getProperty(DataService dataService, Object obj, String prop) throws Exception {
        PropertyValue[] properties;
        if (obj == null || StringUtil.isNullOrEmpty((String)prop)) {
            throw new Exception(Utils.getLocalizedString("error.invalidQueryInput"));
        }
        for (PropertyValue property : properties = this.getProperties(dataService, obj, new String[]{prop})) {
            if (property == null || property.propertyName == null || !property.propertyName.equals(prop)) continue;
            return (T)property.value;
        }
        return null;
    }

    @Override
    public PropertyValue[] getProperty(DataService dataService, Object[] objs, String prop) throws Exception {
        return this.getProperties(dataService, objs, new String[]{prop});
    }

    @Override
    public PropertyValue[] getProperties(DataService dataService, Object obj, String[] properties) throws Exception {
        return this.getProperties(dataService, new Object[]{obj}, properties);
    }

    @Override
    public PropertyValue[] getProperties(DataService dataService, Object[] objs, String[] properties) throws Exception {
        ResultItem[] items;
        if (ArrayUtil.isNullOrEmpty((Object[])objs) || ArrayUtil.isNullOrEmpty((Object[])properties)) {
            throw new Exception(Utils.getLocalizedString("error.invalidQueryInput"));
        }
        Object obj = objs[0];
        QuerySpec query = this.buildQuerySpec(objs, properties);
        query.name = this.getUid(obj) + ".properties";
        ResultSet resultSet = this.getData(dataService, query);
        ArrayList<PropertyValue> result = new ArrayList<PropertyValue>();
        if (resultSet != null && (items = resultSet.items) != null && items.length > 0 && items[0] != null) {
            for (ResultItem item : items) {
                for (PropertyValue v : item.properties) {
                    v.resourceObject = item.resourceObject;
                    result.add(v);
                }
            }
        }
        if (result.isEmpty() && resultSet.error != null) {
            throw resultSet.error;
        }
        return (PropertyValue[])ArrayUtil.toArray(result, PropertyValue.class);
    }

    @Override
    public PropertyValue[] getPropertyForRelatedObjects(DataService dataService, Object object, String relationship, String targetType, String property) throws Exception {
        return this.getPropertiesForRelatedObjects(dataService, object, relationship, targetType, new String[]{property});
    }

    @Override
    public PropertyValue[] getPropertiesForRelatedObjects(DataService dataService, Object object, String relationship, String targetType, String[] properties) throws Exception {
        if (object == null || ArrayUtil.isNullOrEmpty((Object[])properties)) {
            throw new Exception(Utils.getLocalizedString("error.invalidQueryInput"));
        }
        if (StringUtil.isNullOrEmpty((String)relationship)) {
            return this.getProperties(dataService, object, properties);
        }
        ObjectIdentityConstraint objectConstraint = this.createObjectIdentityConstraint(object);
        RelationalConstraint relationalConstraint = this.createRelationalConstraint(relationship, objectConstraint, true, targetType);
        QuerySpec query = this.buildQuerySpec(relationalConstraint, properties);
        query.name = this.getUid(object) + "." + relationship + ".properties";
        ResultSet resultSet = this.getData(dataService, query);
        ArrayList<PropertyValue> result = new ArrayList<PropertyValue>();
        if (resultSet != null && resultSet.items != null) {
            for (ResultItem item : resultSet.items) {
                if (item == null || item.properties == null) continue;
                for (PropertyValue propValue : item.properties) {
                    if (propValue == null) continue;
                    result.add(propValue);
                }
            }
        }
        if (result.isEmpty() && resultSet.error != null) {
            throw resultSet.error;
        }
        return (PropertyValue[])ArrayUtil.toArray(result, PropertyValue.class);
    }

    @Override
    public ResultSet getData(DataService dataService, QuerySpec query) throws Exception {
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{query};
        Response response = new Response();
        response = dataService.getData(requestSpec);
        Object[] retVal = response.resultSet;
        if (ArrayUtil.isNullOrEmpty((Object[])retVal) || retVal[0] == null) {
            throw new Exception(Utils.getLocalizedString("error.emptyResult"));
        }
        return retVal[0];
    }

    @Override
    public <T> T findPropertyValueIn(String prop, List<ResultItem> resultItems) {
        if (ArrayUtil.isNullOrEmpty(resultItems)) {
            return null;
        }
        for (ResultItem resultItem : resultItems) {
            Object[] propValues = resultItem.properties;
            if (ArrayUtil.isNullOrEmpty((Object[])propValues)) continue;
            for (Object propValue : propValues) {
                if (!((PropertyValue)propValue).propertyName.equals(prop)) continue;
                return (T)((PropertyValue)propValue).value;
            }
        }
        return null;
    }

    @Override
    public boolean checkProperties(PropertyValue[] properties, String[] propertyNames) {
        if (properties == null || propertyNames == null || properties.length < propertyNames.length) {
            return false;
        }
        HashSet<String> propertyNameSet = new HashSet<String>();
        for (PropertyValue property : properties) {
            if (property == null || property.value == null) {
                return false;
            }
            propertyNameSet.add(property.propertyName);
        }
        for (String propertyName : propertyNames) {
            if (propertyName == null || propertyNameSet.contains(propertyName)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object[] findMoRefsIn(ResultSet result) {
        ResultItem[] resultItems;
        Object[] refs = null;
        if (result != null && (resultItems = result.items) != null && resultItems.length > 0) {
            refs = (Object[])Array.newInstance(resultItems[0].resourceObject.getClass(), resultItems.length);
            for (int i = 0; i < resultItems.length; ++i) {
                refs[i] = resultItems[i].resourceObject;
            }
        }
        return refs;
    }

    @Override
    public String getLocalizedString(String key) {
        return Utils.getLocalizedString(key);
    }

    @Override
    public Boolean waitUntilSearchable(DataService dataService, Object object, String[] requiredProperties) {
        return this.waitUntilStatusChange(dataService, object, requiredProperties, true);
    }

    @Override
    public Boolean waitUntilSearchable(DataService dataService, Object object) {
        return this.waitUntilSearchable(dataService, object, new String[]{"name"});
    }

    @Override
    public Boolean waitUntilNotSearchable(DataService dataService, Object object, String[] requiredProperties) {
        return this.waitUntilStatusChange(dataService, object, requiredProperties, false);
    }

    @Override
    public Boolean waitUntilNotSearchable(DataService dataService, Object object) {
        return this.waitUntilNotSearchable(dataService, object, new String[]{"name"});
    }

    @Override
    public Boolean waitUntilStatusChange(DataService dataService, Object object, String[] requiredProperties, boolean waitUntilObjectFound) {
        int numberOfAttempts = 30;
        PropertyValue[] properties = null;
        boolean syncSuccesfully = false;
        for (int count = 0; count < 30; ++count) {
            try {
                properties = this.getProperties(dataService, object, requiredProperties);
                boolean hasProperties = this.checkProperties(properties, requiredProperties);
                if (waitUntilObjectFound && hasProperties) {
                    syncSuccesfully = true;
                    break;
                }
                if (!waitUntilObjectFound && !hasProperties) {
                    syncSuccesfully = true;
                    break;
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                _logger.error(e.getLocalizedMessage());
            }
        }
        return syncSuccesfully;
    }

    @Override
    public Boolean waitUntilPropertyChanged(DataService dataService, Object object, PropertyChangeInfo propInfo) throws Exception {
        String property = propInfo.getPropertyName();
        int numberOfAttempts = 30;
        boolean objectChanged = false;
        _logger.debug("Start waiting for change in property '" + property + "' on object " + this.getUid(object));
        for (int count = 0; count < 30; ++count) {
            Object propValue = this.getProperty(dataService, object, property);
            objectChanged = propInfo.isChanged(propValue);
            if (objectChanged) {
                _logger.debug("Property '" + property + "' on object " + this.getUid(object) + " has changed!");
                break;
            }
            _logger.debug("No change detected for property '" + property + "' on object " + this.getUid(object));
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                _logger.error(e.getLocalizedMessage());
            }
        }
        return objectChanged;
    }

    @Override
    public QuerySpec buildQuerySpec(Object entity, String[] properties) {
        ObjectIdentityConstraint oc = new ObjectIdentityConstraint();
        oc.target = entity;
        String targetType = this.getResourceObjectType(entity);
        HashSet<String> targetTypes = new HashSet<String>();
        targetTypes.add(targetType);
        QuerySpec query = this.buildQuerySpec(oc, properties, targetTypes);
        return query;
    }

    @Override
    public QuerySpec buildQuerySpec(Object[] entities, String[] properties) {
        if (entities.length == 1) {
            return this.buildQuerySpec(entities[0], properties);
        }
        CompositeConstraint cc = new CompositeConstraint();
        cc.conjoiner = Conjoiner.OR;
        Constraint[] nestedConstraints = new Constraint[entities.length];
        HashSet<String> targetTypes = new HashSet<String>();
        String targetType = null;
        for (int index = 0; index < entities.length; ++index) {
            ObjectIdentityConstraint oc = new ObjectIdentityConstraint();
            oc.target = entities[index];
            nestedConstraints[index] = oc;
            targetType = this.getResourceObjectType(oc.target);
            targetTypes.add(targetType);
        }
        cc.nestedConstraints = nestedConstraints;
        QuerySpec query = this.buildQuerySpec(cc, properties, targetTypes);
        return query;
    }

    @Override
    public QuerySpec buildQuerySpec(Constraint constraint, String[] properties) {
        QuerySpec query = this.buildQuerySpec(constraint, properties, null);
        return query;
    }

    @Override
    public QuerySpec buildQuerySpec(Constraint constraint, String[] properties, Set<String> targetTypes) {
        QuerySpec query = new QuerySpec();
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = constraint;
        ArrayList<PropertySpec> pSpecs = new ArrayList<PropertySpec>();
        if (targetTypes != null) {
            for (String targetType : targetTypes) {
                PropertySpec propSpec = this.createPropertySpec(properties, targetType);
                pSpecs.add(propSpec);
            }
        } else {
            PropertySpec propSpec = this.createPropertySpec(properties, null);
            pSpecs.add(propSpec);
        }
        resourceSpec.propertySpecs = pSpecs.toArray(new PropertySpec[0]);
        query.resourceSpec = resourceSpec;
        return query;
    }

    @Override
    public PropertySpec createPropertySpec(String[] properties, String targetType) {
        PropertySpec propSpec = new PropertySpec();
        propSpec.type = targetType;
        propSpec.propertyNames = properties;
        return propSpec;
    }

    @Override
    public ResourceSpec createEmptyResourceSpec() {
        PropertySpec propSpec = new PropertySpec();
        propSpec.propertyNames = new String[0];
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.propertySpecs = new PropertySpec[]{propSpec};
        return resourceSpec;
    }

    @Override
    public boolean areEquivalent(QuerySpec a, QuerySpec b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return ObjectUtil.objectsEqual((Object)a.resourceSpec, (Object)b.resourceSpec) && ObjectUtil.objectsEqual((Object)a.resultSpec, (Object)b.resultSpec) && ObjectUtil.objectsEqual(a.options, b.options);
    }

    @Override
    public Map<String, Set<String>> getQueryProperties(QuerySpec query, boolean mayHaveHeterogenousConstraints) {
        if (query == null || query.resourceSpec == null || ArrayUtil.isNullOrEmpty((Object[])query.resourceSpec.propertySpecs)) {
            return new HashMap<String, Set<String>>();
        }
        HashMap<String, Set<String>> queryProperties = new HashMap<String, Set<String>>();
        Set<String> constraintTypes = this.getConstraintTargetTypes(query.resourceSpec.constraint, mayHaveHeterogenousConstraints);
        PropertySpec[] propertySpecs = query.resourceSpec.propertySpecs;
        if (constraintTypes != null && constraintTypes.isEmpty()) {
            constraintTypes.add("*");
        }
        for (PropertySpec propertySpec : propertySpecs) {
            if (!this.checkPropertySpec(propertySpec)) continue;
            if (StringUtil.isNullOrEmpty((String)propertySpec.type)) {
                for (String constraintType : constraintTypes) {
                    this.addQueryProperties(queryProperties, constraintType, propertySpec.propertyNames);
                }
                continue;
            }
            this.addQueryProperties(queryProperties, propertySpec.type, propertySpec.propertyNames);
        }
        return queryProperties;
    }

    private void addQueryProperties(Map<String, Set<String>> queryProperties, String type2, String[] properties) {
        Set<String> typeProperties = queryProperties.get(type2);
        if (typeProperties == null) {
            typeProperties = new HashSet<String>();
            queryProperties.put(type2, typeProperties);
        }
        for (String propertyName : properties) {
            typeProperties.add(Utils.stripIfEndsWith(propertyName, ".@formatted"));
        }
    }

    private boolean checkPropertySpec(PropertySpec propertySpec) {
        return propertySpec != null && StringUtil.isNullOrEmpty((String)propertySpec.relation) && !ArrayUtil.isNullOrEmpty((Object[])propertySpec.propertyNames);
    }

    @Override
    public RelationalConstraint createRelationalConstraint(String relationship, Constraint constraintOnRelatedObject, Boolean hasInverseRelation, String targetType) {
        RelationalConstraint rc = new RelationalConstraint();
        rc.relation = relationship;
        rc.hasInverseRelation = hasInverseRelation;
        rc.constraintOnRelatedObject = constraintOnRelatedObject;
        rc.targetType = targetType;
        return rc;
    }

    @Override
    public Constraint createConstraintForRelationship(Object object, String relationship, String targetType) {
        ObjectIdentityConstraint objectConstraint = this.createObjectIdentityConstraint(object);
        RelationalConstraint relationalConstraint = this.createRelationalConstraint(relationship, objectConstraint, true, targetType);
        return relationalConstraint;
    }

    @Override
    public PropertyConstraint createPropertyConstraint(String objectType, String propertyName, Comparator comparator, Object comparableValue) {
        PropertyConstraint constraint = new PropertyConstraint();
        constraint.targetType = objectType;
        constraint.propertyName = propertyName;
        constraint.comparator = comparator;
        constraint.comparableValue = comparableValue;
        return constraint;
    }

    @Override
    public Constraint combineIntoSingleConstraint(Constraint[] constraints, Conjoiner conjoiner) {
        if (ArrayUtil.isNullOrEmpty((Object[])constraints)) {
            return null;
        }
        if (constraints.length == 1) {
            return constraints[0];
        }
        return this.createCompositeConstraint(constraints, conjoiner);
    }

    @Override
    public Constraint combineIntoSingleConstraint(Object[] entities, Conjoiner conjoiner) {
        if (ArrayUtil.isNullOrEmpty((Object[])entities)) {
            return null;
        }
        Constraint[] nestedConstraints = new Constraint[entities.length];
        for (int index = 0; index < entities.length; ++index) {
            ObjectIdentityConstraint oc = new ObjectIdentityConstraint();
            oc.target = entities[index];
            oc.targetType = this.getResourceObjectType(entities[index]);
            nestedConstraints[index] = oc;
        }
        if (entities.length == 1) {
            return nestedConstraints[0];
        }
        return this.createCompositeConstraint(nestedConstraints, conjoiner);
    }

    @Override
    public CompositeConstraint createCompositeConstraint(Constraint[] nestedConstraints, Conjoiner conjoiner) {
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.nestedConstraints = nestedConstraints;
        compositeConstraint.conjoiner = conjoiner;
        return compositeConstraint;
    }

    @Override
    public ObjectIdentityConstraint createObjectIdentityConstraint(Object entity) {
        ObjectIdentityConstraint oc = new ObjectIdentityConstraint();
        oc.target = entity;
        oc.targetType = this.getResourceObjectType(entity);
        return oc;
    }

    @Override
    public boolean validateQueryConstraint(Constraint constraint) {
        if (constraint == null) {
            _logger.warn("Invalid constraint: constraint is null");
            return false;
        }
        if (constraint instanceof ObjectIdentityConstraint) {
            boolean isValid;
            ObjectIdentityConstraint oic = (ObjectIdentityConstraint)constraint;
            boolean bl = isValid = oic.target != null;
            if (!isValid) {
                _logger.warn("Invalid constraint: constraint target is null");
            }
            return isValid;
        }
        if (constraint instanceof RelationalConstraint) {
            RelationalConstraint rc = (RelationalConstraint)constraint;
            if (StringUtil.isNullOrEmpty((String)rc.relation)) {
                _logger.warn("Invalid constraint: relational constraint's relation is null");
                return false;
            }
            return this.validateQueryConstraint(rc.constraintOnRelatedObject);
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint cc = (CompositeConstraint)constraint;
            if (cc.nestedConstraints == null) {
                _logger.warn("Invalid composite constraint: nested constraints are null");
                return false;
            }
            if (cc.nestedConstraints.length == 0) {
                _logger.warn("Invalid composite constraint: nested constraints are empty");
                return false;
            }
            if (cc.conjoiner == null) {
                _logger.warn("Invalid composite constraint: conjoiner is null");
                return false;
            }
            for (Constraint c : cc.nestedConstraints) {
                if (this.validateQueryConstraint(c)) continue;
                return false;
            }
        } else if (constraint instanceof PropertyConstraint) {
            boolean isValid;
            PropertyConstraint pc = (PropertyConstraint)constraint;
            boolean bl = isValid = pc.comparator != null;
            if (!isValid) {
                _logger.warn("Invalid constraint: property constraint comparator is null");
            }
            return isValid;
        }
        return true;
    }

    @Override
    public Set<String> getConstraintTargetTypes(Constraint constraint, boolean mayHaveHeterogenousConstraints) {
        if (constraint == null || constraint instanceof RelationalConstraint && ((RelationalConstraint)constraint).hasInverseRelation) {
            return new HashSet<String>();
        }
        String targetType = constraint.targetType;
        if (constraint instanceof ObjectIdentityConstraint) {
            targetType = this._objectReferenceService.getResourceObjectType(((ObjectIdentityConstraint)constraint).target);
        } else if (constraint instanceof CompositeConstraint) {
            Constraint[] nestedConstraints = ((CompositeConstraint)constraint).nestedConstraints;
            nestedConstraints = nestedConstraints == null ? new Constraint[]{} : nestedConstraints;
            HashSet<String> nestedTypes = new HashSet<String>();
            for (Constraint nestedConstraint : nestedConstraints) {
                Set<String> nestedConstraintTypes = this.getConstraintTargetTypes(nestedConstraint, mayHaveHeterogenousConstraints);
                if (nestedConstraintTypes.isEmpty()) continue;
                nestedTypes.addAll(nestedConstraintTypes);
            }
            if (!nestedTypes.isEmpty()) {
                if (mayHaveHeterogenousConstraints) {
                    return nestedTypes;
                }
                if (nestedTypes.size() == 1) {
                    targetType = (String)nestedTypes.iterator().next();
                }
            }
        }
        return StringUtil.isNullOrEmpty((String)targetType) ? new HashSet<String>() : new HashSet<String>(Arrays.asList(targetType));
    }

    @Override
    public String getConstraintTargetType(Constraint constraint) {
        Set<String> constraintTargetTypes = this.getConstraintTargetTypes(constraint, false);
        if (constraintTargetTypes != null && constraintTargetTypes.size() == 1) {
            return constraintTargetTypes.iterator().next();
        }
        return null;
    }
}

