/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.util.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.util.PropertyChangeInfo;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.data.query.util.ResultAnalyzer;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueryExecutorImpl
implements QueryExecutor {
    private static final Logger _logger = LoggerFactory.getLogger(QueryExecutorImpl.class);
    public static final Constraint[] EMPTY_CONSTRAINTS = new Constraint[0];
    public static final ResultSet[] EMPTYSET = new ResultSet[0];
    private final DataService _dataService;
    private final ObjectReferenceService _objectReferenceService;
    private final QuerySpecBuilder _querySpecBuilder;
    private final ResultAnalyzer _resultAnalyzer;

    public QueryExecutorImpl(DataService dataService, ObjectReferenceService objectReferenceService, QuerySpecBuilder querySpecBuilder, ResultAnalyzer resultAnalyzer) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{dataService, objectReferenceService, querySpecBuilder, resultAnalyzer});
        this._dataService = dataService;
        this._objectReferenceService = objectReferenceService;
        this._querySpecBuilder = querySpecBuilder;
        this._resultAnalyzer = resultAnalyzer;
    }

    @Override
    public <T> T getProperty(Object obj, String prop) throws Exception {
        PropertyValue[] properties;
        if (obj == null || StringUtil.isNullOrEmpty((String)prop)) {
            throw new Exception(Utils.getLocalizedString("error.invalidQueryInput"));
        }
        for (PropertyValue property : properties = this.getProperties(obj, new String[]{prop})) {
            if (property == null || property.propertyName == null || !property.propertyName.equals(prop)) continue;
            return (T)property.value;
        }
        return null;
    }

    @Override
    public PropertyValue[] getProperty(Object[] objs, String prop) throws Exception {
        return this.getProperties(objs, new String[]{prop});
    }

    @Override
    public PropertyValue[] getProperties(Object obj, String[] properties) throws Exception {
        return this.getProperties(new Object[]{obj}, properties);
    }

    @Override
    public PropertyValue[] getProperties(Object[] objs, String[] properties) throws Exception {
        ResultItem[] items;
        if (ArrayUtil.isNullOrEmpty((Object[])objs) || ArrayUtil.isNullOrEmpty((Object[])properties)) {
            throw new Exception(Utils.getLocalizedString("error.invalidQueryInput"));
        }
        Object obj = objs[0];
        QuerySpec query = this._querySpecBuilder.buildQuerySpec(objs, properties);
        query.name = this._objectReferenceService.getUid(obj) + ".properties";
        ResultSet resultSet = this.getData(query);
        ArrayList<PropertyValue> result = new ArrayList<PropertyValue>();
        if (resultSet != null && (items = resultSet.items) != null && items.length > 0 && items[0] != null) {
            for (ResultItem item : items) {
                for (PropertyValue v : item.properties) {
                    v.resourceObject = item.resourceObject;
                    result.add(v);
                }
            }
        }
        if (result.isEmpty() && resultSet.error != null) {
            throw resultSet.error;
        }
        return (PropertyValue[])ArrayUtil.toArray(result, PropertyValue.class);
    }

    @Override
    public PropertyValue[] getPropertyForRelatedObjects(Object object, String relationship, String targetType, String property) throws Exception {
        return this.getPropertiesForRelatedObjects(object, relationship, targetType, new String[]{property});
    }

    @Override
    public PropertyValue[] getPropertiesForRelatedObjects(Object object, String relationship, String targetType, String[] properties) throws Exception {
        if (object == null || ArrayUtil.isNullOrEmpty((Object[])properties)) {
            throw new Exception(Utils.getLocalizedString("error.invalidQueryInput"));
        }
        if (StringUtil.isNullOrEmpty((String)relationship)) {
            return this.getProperties(object, properties);
        }
        ObjectIdentityConstraint objectConstraint = this._querySpecBuilder.createObjectIdentityConstraint(object);
        RelationalConstraint relationalConstraint = this._querySpecBuilder.createRelationalConstraint(relationship, objectConstraint, true, targetType);
        QuerySpec query = this._querySpecBuilder.buildQuerySpec(relationalConstraint, properties);
        query.name = this._objectReferenceService.getUid(object) + "." + relationship + ".properties";
        ResultSet resultSet = this.getData(query);
        ArrayList<PropertyValue> result = new ArrayList<PropertyValue>();
        if (resultSet != null && resultSet.items != null) {
            for (ResultItem item : resultSet.items) {
                if (item == null || item.properties == null) continue;
                for (PropertyValue propValue : item.properties) {
                    if (propValue == null) continue;
                    result.add(propValue);
                }
            }
        }
        if (result.isEmpty() && resultSet.error != null) {
            throw resultSet.error;
        }
        return (PropertyValue[])ArrayUtil.toArray(result, PropertyValue.class);
    }

    @Override
    public ResultSet getData(QuerySpec query) throws Exception {
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{query};
        Response response = new Response();
        response = this._dataService.getData(requestSpec);
        Object[] retVal = response.resultSet;
        if (ArrayUtil.isNullOrEmpty((Object[])retVal) || retVal[0] == null) {
            throw new Exception(Utils.getLocalizedString("error.emptyResult"));
        }
        return retVal[0];
    }

    @Override
    public Boolean waitUntilSearchable(Object object, String[] requiredProperties) {
        return this.waitUntilStatusChange(object, requiredProperties, true);
    }

    @Override
    public Boolean waitUntilSearchable(Object object) {
        return this.waitUntilSearchable(object, new String[]{"name"});
    }

    @Override
    public Boolean waitUntilNotSearchable(Object object, String[] requiredProperties) {
        return this.waitUntilStatusChange(object, requiredProperties, false);
    }

    @Override
    public Boolean waitUntilNotSearchable(Object object) {
        return this.waitUntilNotSearchable(object, new String[]{"name"});
    }

    @Override
    public Boolean waitUntilStatusChange(Object object, String[] requiredProperties, boolean waitUntilObjectFound) {
        int numberOfAttempts = 30;
        PropertyValue[] properties = null;
        boolean syncSuccesfully = false;
        for (int count = 0; count < 30; ++count) {
            try {
                properties = this.getProperties(object, requiredProperties);
                boolean hasProperties = this._resultAnalyzer.checkProperties(properties, requiredProperties);
                if (waitUntilObjectFound && hasProperties) {
                    syncSuccesfully = true;
                    break;
                }
                if (!waitUntilObjectFound && !hasProperties) {
                    syncSuccesfully = true;
                    break;
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                _logger.error(e.getLocalizedMessage());
            }
        }
        return syncSuccesfully;
    }

    @Override
    public Boolean waitUntilPropertyChanged(Object object, PropertyChangeInfo propInfo) throws Exception {
        String property = propInfo.getPropertyName();
        int numberOfAttempts = 30;
        boolean objectChanged = false;
        _logger.debug("Start waiting for change in property '" + property + "' on object " + this._objectReferenceService.getUid(object));
        for (int count = 0; count < 30; ++count) {
            Object propValue = this.getProperty(object, property);
            objectChanged = propInfo.isChanged(propValue);
            if (objectChanged) {
                _logger.debug("Property '" + property + "' on object " + this._objectReferenceService.getUid(object) + " has changed!");
                break;
            }
            _logger.debug("No change detected for property '" + property + "' on object " + this._objectReferenceService.getUid(object));
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                _logger.error(e.getLocalizedMessage());
            }
        }
        return objectChanged;
    }
}

