/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.util;

import com.vmware.vise.util.io.StreamUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Config {
    private static final Log _logger = LogFactory.getLog(Config.class);
    public static final int THREAD_POOL_CORE_SIZE;
    public static final int THREAD_POOL_MAXIMUM_SIZE;
    public static final int THREAD_POOL_LOGGABLE_SIZE_CHANGE;
    public static final long QUERY_BATCH_TIME_THRESHOLD;
    public static final long DATA_PROVIDER_ADAPTER_TIME_THRESHOLD;
    public static final long PROPERTY_PROVIDER_ADAPTER_TIME_THRESHOLD;
    public static final long PROPERTY_PROVIDER_BEAN_METHOD_TIME_THRESHOLD;

    private static int getIntProperty(Properties props, String propName, int defaultValue) {
        int value = defaultValue;
        String sPropValue = props.getProperty(propName);
        if (sPropValue != null) {
            try {
                value = Integer.valueOf(sPropValue);
            }
            catch (NumberFormatException e) {
                _logger.error((Object)("The property " + propName + " cannot be parsed to int. Will use the default value: " + defaultValue), (Throwable)e);
            }
        }
        return value;
    }

    private static long getLongProperty(Properties props, String propName, long defaultValue) {
        long value = defaultValue;
        String sPropValue = props.getProperty(propName);
        if (sPropValue != null) {
            try {
                value = Long.valueOf(sPropValue);
            }
            catch (NumberFormatException e) {
                _logger.error((Object)("The property " + propName + " cannot be parsed to long. Will use the default value: " + defaultValue), (Throwable)e);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Properties config = new Properties();
        ClassLoader cl = Config.class.getClassLoader();
        InputStream in = cl.getResourceAsStream("data-services-framework.properties");
        if (in != null) {
            try {
                config.load(in);
            }
            catch (IOException e) {
                _logger.error((Object)"Failed to load the Data Service configuration properties", (Throwable)e);
            }
            finally {
                StreamUtil.close((Closeable)in);
            }
        } else {
            _logger.warn((Object)"Data Service config.properties file not found. Will use defaults.");
        }
        THREAD_POOL_CORE_SIZE = Config.getIntProperty(config, "adapters.threadPool.coreSize", 200);
        THREAD_POOL_MAXIMUM_SIZE = Config.getIntProperty(config, "adapters.threadPool.maximumSize", 500);
        THREAD_POOL_LOGGABLE_SIZE_CHANGE = Config.getIntProperty(config, "adapters.threadPool.loggableSizeChange", 100);
        QUERY_BATCH_TIME_THRESHOLD = Config.getLongProperty(config, "profiling.queryBatchTimeThreshold", 5000L);
        DATA_PROVIDER_ADAPTER_TIME_THRESHOLD = Config.getLongProperty(config, "profiling.dataAdapterTimeThreshold", 4000L);
        PROPERTY_PROVIDER_ADAPTER_TIME_THRESHOLD = Config.getLongProperty(config, "profiling.propertyProviderAdapterTimeThreshold", 4000L);
        PROPERTY_PROVIDER_BEAN_METHOD_TIME_THRESHOLD = Config.getLongProperty(config, "profiling.propertyProviderBeanMethodTimeThreshold", 4000L);
    }
}

