/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.transform.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.data.common.XSFacet;
import com.vmware.vise.data.common.XSFacetType;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.transform.Transformer;
import com.vmware.vise.metadata.PropertyDescriptor;
import com.vmware.vise.metadata.impl.MetadataServiceRegistryInternal;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EnumPropertyConstraintTransformer
implements Transformer<Constraint, Constraint> {
    private static final Log _logger = LogFactory.getLog(EnumPropertyConstraintTransformer.class);
    private final MetadataServiceRegistryInternal _metadataRegistry;

    public EnumPropertyConstraintTransformer(MetadataServiceRegistryInternal metadataRegistry) {
        this._metadataRegistry = metadataRegistry;
    }

    @Override
    public Transformer.Result<Constraint> transform(Constraint constraint) {
        if (!(constraint instanceof PropertyConstraint)) {
            return new Transformer.Result<Constraint>(constraint);
        }
        PropertyConstraint propConstr = (PropertyConstraint)constraint;
        if (StringUtil.isNullOrEmpty((String)propConstr.targetType) || StringUtil.isNullOrEmpty((String)propConstr.propertyName)) {
            return new Transformer.Result<Constraint>(constraint);
        }
        Constraint modifiedConstraint = this.getEquivalentConstraint(propConstr);
        boolean hasBeenModified = !modifiedConstraint.equals(constraint);
        return new Transformer.Result<Constraint>(modifiedConstraint, hasBeenModified, null);
    }

    private PropertyDescriptor getPropertyDescriptor(PropertyConstraint propertyConstraint) {
        PropertyDescriptor[] propertyDescriptors;
        String providerType = propertyConstraint.targetType;
        String propertyName = propertyConstraint.propertyName;
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = this._metadataRegistry.lookUpPropertyDescriptors(providerType)) {
            if (!propertyDescriptor.name.equals(propertyName) && !ArrayUtil.contains((Object)propertyName, (Object[])propertyDescriptor.aliases).booleanValue()) continue;
            return propertyDescriptor;
        }
        return null;
    }

    private Constraint getEquivalentConstraint(PropertyConstraint propertyConstraint) {
        if (!EnumPropertyConstraintTransformer.isContainsTypeComparator(propertyConstraint.comparator) || propertyConstraint.comparableValue == null) {
            return propertyConstraint;
        }
        PropertyDescriptor propDesc = this.getPropertyDescriptor(propertyConstraint);
        if (propDesc == null) {
            return propertyConstraint;
        }
        EnumTranslator enumTranslator = new EnumTranslator(propDesc);
        String comparableValue = propertyConstraint.comparableValue.toString();
        List<String> matchingEnumValues = enumTranslator.getMatchingValues(comparableValue);
        if (matchingEnumValues.isEmpty()) {
            return propertyConstraint;
        }
        ArrayList<PropertyConstraint> componentPropConstraints = new ArrayList<PropertyConstraint>(matchingEnumValues.size());
        for (String enumValue : matchingEnumValues) {
            PropertyConstraint componentPropConstr = EnumPropertyConstraintTransformer.newPropertyConstraint(propertyConstraint, enumValue);
            componentPropConstr.comparator = Comparator.EQUALS;
            componentPropConstraints.add(componentPropConstr);
        }
        if (componentPropConstraints.size() == 1) {
            return (Constraint)componentPropConstraints.get(0);
        }
        Constraint[] propertyConstraints = componentPropConstraints.toArray(new Constraint[componentPropConstraints.size()]);
        Constraint componentConstr = QueryUtil.combineIntoSingleConstraint(propertyConstraints, Conjoiner.OR);
        return componentConstr;
    }

    private static boolean isContainsTypeComparator(Comparator comparator) {
        return comparator == Comparator.TEXTUALLY_MATCHES || comparator == Comparator.CONTAINS;
    }

    private static PropertyConstraint newPropertyConstraint(PropertyConstraint originalPropConstr, String comparableValue) {
        PropertyConstraint propConstr = (PropertyConstraint)ObjectUtil.shallowCopy((Object)originalPropConstr, PropertyConstraint.class);
        propConstr.comparableValue = comparableValue;
        return propConstr;
    }

    private static class EnumTranslator {
        private final PropertyDescriptor _propertyDescriptor;

        public EnumTranslator(PropertyDescriptor propertyDescriptor) {
            this._propertyDescriptor = propertyDescriptor;
        }

        public List<String> getMatchingValues(String text) {
            if (StringUtil.isNullOrEmpty((String)text)) {
                return Collections.emptyList();
            }
            ArrayList<String> matchedEnumValues = new ArrayList<String>();
            XSFacet[] restrictions = this._propertyDescriptor.staticValueSpace;
            if (restrictions != null) {
                for (XSFacet restriction : restrictions) {
                    String restrictionValue;
                    if (restriction.type != XSFacetType.ENUMERATION || !(restriction.value instanceof NameValuePair)) continue;
                    NameValuePair nameValuePair = (NameValuePair)restriction.value;
                    if (nameValuePair.value == null || StringUtil.isNullOrEmpty((String)(restrictionValue = nameValuePair.name))) continue;
                    Locale locale = ResourceUtil.getLocale();
                    if (locale == null) {
                        _logger.warn((Object)("Null locale while getting matching values for: " + text));
                        continue;
                    }
                    if (!restrictionValue.toLowerCase(locale).contains(text.toLowerCase(locale))) continue;
                    matchedEnumValues.add(nameValuePair.value.toString());
                }
            }
            return matchedEnumValues;
        }
    }
}

