/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.transform.impl;

import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.impl.ComponentPropertyRetriever;
import com.vmware.vise.data.query.impl.DataServiceExtensionRegistryInternal;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.transform.Transformer;
import com.vmware.vise.util.ArrayUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class CustomPropertyOrderTransformer
implements Transformer<OrderingCriteria, OrderingCriteria> {
    private final ComponentPropertyRetriever _componentPropertyRetriever;

    public CustomPropertyOrderTransformer(DataServiceExtensionRegistryInternal dataAdapterRegistry) {
        this._componentPropertyRetriever = new ComponentPropertyRetriever(dataAdapterRegistry);
    }

    @Override
    public Transformer.Result<OrderingCriteria> transform(OrderingCriteria orderCriteria) {
        if (orderCriteria == null) {
            return new Transformer.Result<OrderingCriteria>(orderCriteria, false, null);
        }
        OrderingCriteria modifiedOrderCriteria = this.getModifiedOrderingCriteria(orderCriteria);
        boolean hasBeenModified = !modifiedOrderCriteria.equals(orderCriteria);
        return new Transformer.Result<OrderingCriteria>(modifiedOrderCriteria, hasBeenModified, null);
    }

    private OrderingCriteria getModifiedOrderingCriteria(OrderingCriteria orderCriteria) {
        if (ArrayUtil.isNullOrEmpty((Object[])orderCriteria.orderingProperties)) {
            return orderCriteria;
        }
        OrderingPropertySpec[] orderPropSpecs = new OrderingPropertySpec[orderCriteria.orderingProperties.length];
        boolean needModification = false;
        int index = 0;
        for (OrderingPropertySpec orderPropSpec : orderCriteria.orderingProperties) {
            String type2 = orderPropSpec.type;
            HashSet<String> orderPops = new HashSet<String>(orderPropSpec.propertyNames.length);
            Collections.addAll(orderPops, orderPropSpec.propertyNames);
            Set<String> componentProps = this._componentPropertyRetriever.getComponentProperties(orderPropSpec.type, orderPops);
            OrderingPropertySpec modifiedOrderPropSpec = orderPropSpec;
            if (!orderPops.containsAll(componentProps)) {
                needModification = true;
                modifiedOrderPropSpec = Utils.newOrderingPropertySpec(type2, componentProps.toArray(new String[0]), null, orderPropSpec.orderingType);
            }
            orderPropSpecs[index++] = modifiedOrderPropSpec;
        }
        if (!needModification) {
            return orderCriteria;
        }
        OrderingCriteria modifiedOrderingCriteria = new OrderingCriteria();
        modifiedOrderingCriteria.orderingProperties = orderPropSpecs;
        return modifiedOrderingCriteria;
    }
}

