/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.transform.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.impl.ComponentPropertyRetriever;
import com.vmware.vise.data.query.impl.DataServiceExtensionRegistryInternal;
import com.vmware.vise.data.query.transform.Transformer;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class CustomPropertyConstraintTransformer
implements Transformer<Constraint, Constraint> {
    private final ComponentPropertyRetriever _componentPropertyRetriever;

    public CustomPropertyConstraintTransformer(DataServiceExtensionRegistryInternal dataAdapterRegistry) {
        this._componentPropertyRetriever = new ComponentPropertyRetriever(dataAdapterRegistry);
    }

    @Override
    public Transformer.Result<Constraint> transform(Constraint constraint) {
        if (!(constraint instanceof PropertyConstraint)) {
            return new Transformer.Result<Constraint>(constraint);
        }
        PropertyConstraint propConstr = (PropertyConstraint)constraint;
        if (StringUtil.isNullOrEmpty((String)propConstr.targetType) || StringUtil.isNullOrEmpty((String)propConstr.propertyName)) {
            return new Transformer.Result<Constraint>(propConstr);
        }
        Constraint modifiedConstraint = this.getEquivalentConstraint(propConstr);
        boolean hasBeenModified = !modifiedConstraint.equals(constraint);
        return new Transformer.Result<Constraint>(modifiedConstraint, hasBeenModified, null);
    }

    private Constraint getEquivalentConstraint(PropertyConstraint propConstr) {
        if (propConstr.comparator != Comparator.TEXTUALLY_MATCHES) {
            return propConstr;
        }
        String type2 = propConstr.targetType;
        HashSet<String> properties = new HashSet<String>();
        properties.add(propConstr.propertyName);
        Set<String> componentProperties = this._componentPropertyRetriever.getComponentProperties(type2, properties);
        if (properties.containsAll(componentProperties)) {
            return propConstr;
        }
        ArrayList<Constraint> componentPropConstraints = new ArrayList<Constraint>(componentProperties.size());
        for (String equivalentProp : componentProperties) {
            PropertyConstraint componentPropConstr = CustomPropertyConstraintTransformer.newPropertyConstraint(propConstr, equivalentProp);
            componentPropConstraints.add(componentPropConstr);
        }
        if (componentPropConstraints.isEmpty()) {
            return propConstr;
        }
        if (componentPropConstraints.size() == 1) {
            return (Constraint)componentPropConstraints.get(0);
        }
        Constraint componentConstr = CustomPropertyConstraintTransformer.combineIntoSingleOrConstraint(type2, componentPropConstraints);
        return componentConstr;
    }

    private static PropertyConstraint newPropertyConstraint(PropertyConstraint originalPropConstr, String propertyName) {
        PropertyConstraint propConstr = (PropertyConstraint)ObjectUtil.shallowCopy((Object)originalPropConstr, PropertyConstraint.class);
        propConstr.propertyName = propertyName;
        return propConstr;
    }

    private static Constraint combineIntoSingleOrConstraint(String type2, Collection<Constraint> constraints) {
        if (constraints == null || constraints.isEmpty()) {
            return null;
        }
        CompositeConstraint compositeConstr = new CompositeConstraint();
        compositeConstr.targetType = type2;
        compositeConstr.conjoiner = Conjoiner.OR;
        compositeConstr.nestedConstraints = constraints.toArray(new Constraint[0]);
        return compositeConstr;
    }
}

