/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.internal.profiling;

import com.vmware.cis.data.internal.provider.profiler.QueryIdLogConfigurator;
import com.vmware.cis.data.internal.util.QueryMarker;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.DynamicProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.QueryOption;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.util.OpIdUtil;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.MDC;

public final class ViseDsLogConfigurator {
    private static final String SEPARATOR = ":";
    private static final String PROVIDER_INVOCATION_ID_KEY = "viseProvider";
    private static final String VISE_BATCH_INVOCATION_ID_PREFIX = "vb-";
    private static final AtomicLong PROVIDER_INVOCATION_ID_GENERATOR = new AtomicLong(0L);

    public static ViseDsLogContext onBatchStart() {
        final QueryIdLogConfigurator logConfigurator = QueryIdLogConfigurator.onQueryStart((String)"", (String)VISE_BATCH_INVOCATION_ID_PREFIX);
        return new ViseDsLogContext(){

            @Override
            public void close() {
                logConfigurator.close();
            }

            @Override
            public String getInvocationId() {
                return QueryMarker.getQueryId();
            }

            @Override
            public String getPreviousInvocationId() {
                return QueryMarker.getParentQueryId();
            }
        };
    }

    public static ViseDsLogContext onQueryStart(QuerySpec querySpec) {
        final String queryId = QueryMarker.getQueryId();
        String newQueryId = ViseDsLogConfigurator.isQueryFromQueryService(querySpec.options) ? queryId : queryId + SEPARATOR + querySpec.name;
        QueryMarker.setQueryId((String)newQueryId);
        return new ViseDsLogContext(){

            @Override
            public void close() {
                QueryMarker.setQueryId((String)queryId);
            }

            @Override
            public String getInvocationId() {
                return QueryMarker.getQueryId();
            }

            @Override
            public String getPreviousInvocationId() {
                return QueryMarker.getParentQueryId();
            }
        };
    }

    public static ViseDsLogContext onDataAdapterStart(DataProviderAdapter adapter) {
        assert (adapter != null);
        String queryId = QueryMarker.getQueryId();
        String adapterName = adapter.getClass().getSimpleName();
        String queryControl = QueryMarker.getQueryControl();
        String newQueryControl = adapter instanceof DynamicProviderAdapter ? queryControl : "external";
        return ViseDsLogConfigurator.onProviderInvocation(queryId, adapterName, newQueryControl);
    }

    public static ViseDsLogContext onPropertyProviderStart(QuerySpec querySpec, PropertyProviderAdapter propertyProvider) {
        assert (querySpec != null);
        assert (querySpec.name != null);
        assert (propertyProvider != null);
        String queryId = QueryMarker.getQueryId();
        String providerName = Utils.renderPropertyProvider(propertyProvider, false);
        String newQueryId = ViseDsLogConfigurator.isQueryFromQueryService(querySpec.options) ? queryId : queryId + SEPARATOR + querySpec.name;
        return ViseDsLogConfigurator.onProviderInvocation(newQueryId, providerName, "external");
    }

    private static ViseDsLogContext onProviderInvocation(String newQueryId, String providerName, String newQueryControl) {
        final String queryId = QueryMarker.getQueryId();
        final String customOpIdPrefix = OpIdUtil.getCustomOpIdPrefix();
        final String providerInvocation = ViseDsLogConfigurator.getProviderInvocation();
        String invocationPrefix = newQueryId + SEPARATOR + providerName;
        final String newProviderInvocation = ViseDsLogConfigurator.nextProviderInvocation(invocationPrefix);
        QueryMarker.setQueryId((String)newQueryId);
        OpIdUtil.setCustomOpIdPrefix((String)newProviderInvocation);
        ViseDsLogConfigurator.setProviderInvocation(newProviderInvocation);
        final QueryIdLogConfigurator logConfigurator = QueryIdLogConfigurator.onProviderStart((String)newQueryControl, (String)providerName);
        return new ViseDsLogContext(){

            @Override
            public void close() {
                OpIdUtil.setCustomOpIdPrefix((String)customOpIdPrefix);
                ViseDsLogConfigurator.setProviderInvocation(providerInvocation);
                logConfigurator.close();
                QueryMarker.setQueryId((String)queryId);
            }

            @Override
            public String getInvocationId() {
                return newProviderInvocation;
            }

            @Override
            public String getPreviousInvocationId() {
                return providerInvocation;
            }
        };
    }

    private static void setProviderInvocation(String invocation) {
        MDC.put((String)PROVIDER_INVOCATION_ID_KEY, (String)invocation);
    }

    public static String getProviderInvocation() {
        return MDC.get((String)PROVIDER_INVOCATION_ID_KEY);
    }

    private static String nextProviderInvocation(String prefix) {
        String id = Long.toString(PROVIDER_INVOCATION_ID_GENERATOR.incrementAndGet());
        return prefix + SEPARATOR + id;
    }

    private static boolean isQueryFromQueryService(Map<String, Object> queryOptions) {
        if (queryOptions == null) {
            return false;
        }
        Object mode = queryOptions.get(QueryOption.VISE_TO_RISE_TRANSLATOR_STRICT_MODE.name());
        return Boolean.TRUE.equals(mode);
    }

    public static interface ViseDsLogContext
    extends AutoCloseable {
        public String getInvocationId();

        public String getPreviousInvocationId();

        @Override
        public void close();
    }
}

