/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.common.MappingUtil;
import com.vmware.vise.data.common.PathTemplate;
import com.vmware.vise.data.common.UnsupportedPropertyException;
import com.vmware.vise.data.query.DataException;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.Config;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServicePropertyProviderAdapter
implements PropertyProviderAdapter {
    private PropertyProviderBean _providerInstance;
    private Map<String, ArrayList<String>> _propertyByType;
    private Map<String, Method> _methodByGeneratedPropertyName;
    private Map<Pair<String, String>, Method> _methodByTypePropertyPair;
    private static final Log _logger = LogFactory.getLog(ServicePropertyProviderAdapter.class);

    public ServicePropertyProviderAdapter(PropertyProviderBean provider) {
        this._providerInstance = provider;
        this._propertyByType = new HashMap<String, ArrayList<String>>();
        this._methodByGeneratedPropertyName = new HashMap<String, Method>();
        this._methodByTypePropertyPair = new HashMap<Pair<String, String>, Method>();
        this.processProvider();
    }

    public TypeInfo[] getProvidedTypeInfos() {
        if (this._propertyByType.size() == 0) {
            return null;
        }
        ArrayList<TypeInfo> types = new ArrayList<TypeInfo>();
        for (Map.Entry<String, ArrayList<String>> entry : this._propertyByType.entrySet()) {
            TypeInfo ti = new TypeInfo();
            ti.type = entry.getKey();
            ti.properties = entry.getValue().toArray(new String[0]);
            types.add(ti);
        }
        return types.toArray(new TypeInfo[0]);
    }

    @Override
    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
        Object[] objects = propertyRequest.objects;
        PropertySpec[] properties = propertyRequest.properties;
        if (objects == null || objects.length == 0 || properties == null || properties.length == 0) {
            return null;
        }
        ResultSet result = new ResultSet();
        ArrayList<DataException> faults = new ArrayList<DataException>();
        ArrayList<ResultItem> items = new ArrayList<ResultItem>();
        for (PropertySpec propSpec : properties) {
            HashMap<String, Object> parameterByPropMap = new HashMap<String, Object>();
            if (propSpec.parameters != null) {
                for (ParameterSpec paramSpec : propSpec.parameters) {
                    parameterByPropMap.put(paramSpec.propertyName, paramSpec);
                }
            }
            for (Object ref : objects) {
                ResultItem ri = new ResultItem();
                ri.resourceObject = ref;
                items.add(ri);
                ArrayList<PropertyValue> propertyValues = new ArrayList<PropertyValue>();
                for (String property : propSpec.propertyNames) {
                    HashMap<String, Object> discoveredArgsByName = null;
                    Method method = this._methodByGeneratedPropertyName.get(property);
                    if (method == null) {
                        discoveredArgsByName = new HashMap<String, Object>();
                        method = this.getPropertyAccessor(ref, property, discoveredArgsByName);
                    }
                    if (method == null) continue;
                    try {
                        PropertyValue pv = this.invokeMethod(method, property, ref, (ParameterSpec)parameterByPropMap.get(property), discoveredArgsByName);
                        propertyValues.add(pv);
                    }
                    catch (Exception ex) {
                        if (ex.getCause() instanceof UnsupportedPropertyException) continue;
                        Throwable t = ex;
                        if (ex instanceof InvocationTargetException) {
                            t = ((InvocationTargetException)ex).getCause();
                        }
                        String errorMessage = String.format("Error when fetching property {%1s} from property provider {%2s}", property, this._providerInstance.getClass().toString());
                        _logger.error((Object)errorMessage, t);
                        DataException de = DataException.newInstance(t, ref, property);
                        faults.add(de);
                    }
                }
                if (propertyValues.size() == 0) continue;
                ri.properties = propertyValues.toArray(new PropertyValue[0]);
            }
        }
        result.items = items.toArray(new ResultItem[0]);
        if (faults.size() > 0) {
            List<DataException> mergedFaults = ResultUtil.mergeDuplicates(faults);
            result.error = mergedFaults.size() > 1 ? new CompositeException(mergedFaults) : (Exception)((Object)mergedFaults.get(0));
        }
        return result;
    }

    public PropertyProviderBean getPropertyProvider() {
        return this._providerInstance;
    }

    private static String getPropertyAccessorParam(String classParam, String methodParam) {
        if (StringUtil.isNullOrEmpty((String)classParam)) {
            return methodParam;
        }
        if (StringUtil.isNullOrEmpty((String)methodParam)) {
            return classParam;
        }
        if (PathTemplate.matches(classParam, methodParam)) {
            return methodParam;
        }
        return null;
    }

    private static String[] getPropertyAccessorTypes(String[] classTypes, String[] methodTypes) {
        if (ArrayUtil.isNullOrEmpty((Object[])classTypes)) {
            return methodTypes;
        }
        if (ArrayUtil.isNullOrEmpty((Object[])methodTypes)) {
            return classTypes;
        }
        ArrayList<String> result = new ArrayList<String>(methodTypes.length);
        block0: for (String methodType : methodTypes) {
            for (String classType : classTypes) {
                if (!classType.equals(methodType)) continue;
                result.add(methodType);
                continue block0;
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private Method getPropertyAccessor(Object object, String property, Map<String, Object> discoveredArgsByName) {
        String type2 = QueryUtil.getReferenceType(object);
        for (Pair<String, String> typePropertyPair : this._methodByTypePropertyPair.keySet()) {
            if (!MappingUtil.matchesMapping((String)typePropertyPair.first, (String)typePropertyPair.second, type2, property, discoveredArgsByName)) continue;
            Method method = this._methodByTypePropertyPair.get(typePropertyPair);
            return method;
        }
        return null;
    }

    private PropertyValue invokeMethod(Method method, String propertyName, Object object, ParameterSpec paramSpec, Map<String, Object> discoveredArgsByName) throws Exception {
        if (method == null || object == null) {
            return null;
        }
        PropertyValue pv = new PropertyValue();
        pv.propertyName = propertyName;
        pv.resourceObject = object;
        Object parameter = null;
        if (paramSpec != null) {
            parameter = paramSpec.parameter;
        }
        Object[] methodArgs = MappingUtil.resolveArgs(method, new Object[]{object, parameter}, discoveredArgsByName);
        long startMillis = System.currentTimeMillis();
        Exception exc = null;
        try {
            pv.value = method.invoke((Object)this._providerInstance, methodArgs);
        }
        catch (Exception e) {
            try {
                exc = e;
                throw e;
            }
            catch (Throwable throwable) {
                long elapsedTime = System.currentTimeMillis() - startMillis;
                if (elapsedTime > Config.PROPERTY_PROVIDER_BEAN_METHOD_TIME_THRESHOLD && _logger.isWarnEnabled()) {
                    _logger.warn((Object)("A PropertyProviderBean method's execution took too long: " + elapsedTime + " milliseconds." + (exc != null ? " The method failed with an exception: " + exc.getMessage() : "") + " (Provider instance: " + this._providerInstance + ", method: " + method + ", property: ref: " + object + ", method args: " + Arrays.toString(methodArgs) + ")"));
                }
                throw throwable;
            }
        }
        long elapsedTime = System.currentTimeMillis() - startMillis;
        if (elapsedTime > Config.PROPERTY_PROVIDER_BEAN_METHOD_TIME_THRESHOLD && _logger.isWarnEnabled()) {
            _logger.warn((Object)("A PropertyProviderBean method's execution took too long: " + elapsedTime + " milliseconds." + (exc != null ? " The method failed with an exception: " + exc.getMessage() : "") + " (Provider instance: " + this._providerInstance + ", method: " + method + ", property: ref: " + object + ", method args: " + Arrays.toString(methodArgs) + ")"));
        }
        return pv;
    }

    private void processProvider() {
        Method[] methods;
        if (this._providerInstance == null) {
            return;
        }
        Class<?> clazz = this._providerInstance.getClass();
        ModelMetadata classLevelModel = clazz.getAnnotation(ModelMetadata.class);
        for (Method method : methods = clazz.getDeclaredMethods()) {
            this.processPropertyAccessor(method, classLevelModel);
            this.processGetMethod(method);
        }
    }

    private void processGetMethod(Method method) {
        Annotation[] annotations;
        String generatedPropertyName = Utils.getPropertyName(method);
        if (StringUtil.isNullOrEmpty((String)generatedPropertyName)) {
            return;
        }
        boolean hasTypeAnnotation = false;
        for (Annotation annotation : annotations = method.getAnnotations()) {
            if (!type.class.isInstance(annotation)) continue;
            hasTypeAnnotation = true;
            this.populateTypeToPropertyMapping((type)annotation, generatedPropertyName);
            break;
        }
        if (hasTypeAnnotation) {
            this.applyWorkaroundForJavaBug4071957(method);
            this._methodByGeneratedPropertyName.put(generatedPropertyName, method);
        }
    }

    private void processPropertyAccessor(Method method, ModelMetadata classLevelModel) {
        String propertyName = Utils.getPropertyName(method);
        if (StringUtil.isNullOrEmpty((String)propertyName)) {
            return;
        }
        ModelMetadata methodLevelModel = method.getAnnotation(ModelMetadata.class);
        String[] types = null;
        String propertyNamespace = null;
        if (methodLevelModel != null) {
            if (!StringUtil.isNullOrEmpty((String)methodLevelModel.property())) {
                propertyName = methodLevelModel.property();
            }
            types = methodLevelModel.type();
            propertyNamespace = methodLevelModel.propertyNamespace();
        }
        if (classLevelModel != null) {
            propertyName = ServicePropertyProviderAdapter.getPropertyAccessorParam(classLevelModel.property(), propertyName);
            propertyNamespace = ServicePropertyProviderAdapter.getPropertyAccessorParam(classLevelModel.propertyNamespace(), propertyNamespace);
            types = ServicePropertyProviderAdapter.getPropertyAccessorTypes(classLevelModel.type(), types);
        }
        if (ArrayUtil.isNullOrEmpty(types) || StringUtil.isNullOrEmpty((String)propertyName)) {
            return;
        }
        propertyName = Utils.getNamespacedProperty(propertyName, propertyNamespace);
        for (String type2 : types) {
            this.applyWorkaroundForJavaBug4071957(method);
            this._methodByTypePropertyPair.put((Pair<String, String>)new Pair((Object)type2, (Object)propertyName, true), method);
            this.populateTypeToPropertyMapping(type2, propertyName);
        }
    }

    private void applyWorkaroundForJavaBug4071957(Method method) {
        if (Modifier.isPublic(method.getModifiers())) {
            method.setAccessible(true);
        }
    }

    private void populateTypeToPropertyMapping(type typeAnnotation, String propertyName) {
        String[] typeNames;
        for (String typeName : typeNames = typeAnnotation.value().split(",")) {
            typeName = typeName.trim();
            this.populateTypeToPropertyMapping(typeName, propertyName);
        }
    }

    private void populateTypeToPropertyMapping(String type2, String property) {
        ArrayList<String> properties = this._propertyByType.get(type2);
        if (properties == null) {
            properties = new ArrayList();
            this._propertyByType.put(type2, properties);
        }
        properties.add(property);
    }

    public String toString() {
        return super.toString() + "(" + this._providerInstance.getClass().getName() + ")";
    }
}

