/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.impl.ResultSetInfo;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.metadata.impl.MetadataServiceRegistryInternal;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class ResultDirectory {
    private static final Log _logger = LogFactory.getLog(ResultDirectory.class);
    private final Map<String, Set<String>> _remainingPropertiesByType = new HashMap<String, Set<String>>();
    private final Map<String, Set<ParameterSpec>> _parameters = new HashMap<String, Set<ParameterSpec>>();
    private final Map<String, Set<Object>> _objectsPerType = new HashMap<String, Set<Object>>();
    private final MetadataServiceRegistryInternal _metadataServiceRegistry;

    ResultDirectory(MetadataServiceRegistryInternal metadataServiceRegistry, QuerySpec query, ResultSetInfo result) {
        assert (query != null && query.resourceSpec != null);
        assert (result != null);
        this._metadataServiceRegistry = metadataServiceRegistry;
        Map<String, List<ResultItem>> resultItemsPerType = ResultDirectory.groupResultItemsPerType(result);
        this.computeObjectsSet(query, resultItemsPerType);
        this.computeRemainingProperties(query, resultItemsPerType);
    }

    boolean hasRemainingProperties() {
        if (this._remainingPropertiesByType.isEmpty()) {
            return false;
        }
        for (Set<String> remainingProperties : this._remainingPropertiesByType.values()) {
            if (remainingProperties == null || remainingProperties.isEmpty()) continue;
            return true;
        }
        return false;
    }

    Set<String> getRemainingPropertiesFor(String type2) {
        assert (!StringUtil.isNullOrEmpty((String)type2));
        Set<String> remainingPropertiesForType = this._remainingPropertiesByType.get(type2);
        if (remainingPropertiesForType == null) {
            return new HashSet<String>(0);
        }
        return remainingPropertiesForType;
    }

    Set<ParameterSpec> getParametersFor(Set<String> properties) {
        HashSet<ParameterSpec> params = new HashSet<ParameterSpec>();
        for (String prop : properties) {
            Set<ParameterSpec> propParams = this._parameters.get(prop);
            if (propParams == null) continue;
            params.addAll(propParams);
        }
        return params;
    }

    Map<String, Set<Object>> getEnumeratedObjects() {
        return this._objectsPerType;
    }

    private void computeObjectsSet(QuerySpec query, Map<String, List<ResultItem>> resultItemsPerType) {
        boolean isEmptyResult = true;
        for (String type2 : resultItemsPerType.keySet()) {
            List<ResultItem> resItems = resultItemsPerType.get(type2);
            for (ResultItem ri : resItems) {
                ResultDirectory.addObjectRef(this._objectsPerType, ri.resourceObject);
                isEmptyResult = false;
            }
        }
        boolean hasQueryLimit = false;
        if (query.resultSpec != null) {
            Integer maxResultCount = query.resultSpec.maxResultCount;
            boolean bl = hasQueryLimit = maxResultCount != null && maxResultCount >= 0;
        }
        if (!hasQueryLimit || isEmptyResult) {
            Object[] targetObjects;
            for (Object ref : targetObjects = Utils.getEnumeratedObjects(query)) {
                ResultDirectory.addObjectRef(this._objectsPerType, ref);
            }
        }
    }

    private static void addObjectRef(Map<String, Set<Object>> objectsPerType, Object ref) {
        String type2 = QueryUtil.getReferenceType(ref);
        if (type2 == null) {
            _logger.warn((Object)String.format("Type cannot be resolved for %1$s", ref.toString()));
            return;
        }
        Set<Object> objectSet = objectsPerType.get(type2);
        if (objectSet == null) {
            objectSet = new HashSet<Object>();
            objectsPerType.put(type2, objectSet);
        }
        objectSet.add(ref);
    }

    private void computeRemainingProperties(QuerySpec query, Map<String, List<ResultItem>> resultItemsPerType) {
        List<ResultItemsByTypeInfo> typeResultInfos = this.getTypeResultInfos(resultItemsPerType);
        for (PropertySpec propSpec : query.resourceSpec.propertySpecs) {
            if (!StringUtil.isNullOrEmpty((String)propSpec.relation)) continue;
            if (StringUtil.isNullOrEmpty((String)propSpec.type) || propSpec.type.equals("*")) {
                Set<String> allRequestedTypes = this._objectsPerType.keySet();
                this.addRemainingPropertiesForAllTypes(typeResultInfos, allRequestedTypes, propSpec);
            } else {
                this.addRemainingProperties(typeResultInfos, propSpec.type, propSpec);
            }
            this.addParameters(propSpec);
        }
    }

    private List<ResultItemsByTypeInfo> getTypeResultInfos(Map<String, List<ResultItem>> resultItemsPerType) {
        ArrayList<ResultItemsByTypeInfo> typeResultInfos = new ArrayList<ResultItemsByTypeInfo>();
        for (String type2 : resultItemsPerType.keySet()) {
            String[] superTypes = this._metadataServiceRegistry.getSupertypes(type2);
            List<ResultItem> resultItems = resultItemsPerType.get(type2);
            ResultItemsByTypeInfo typeResultInfo = new ResultItemsByTypeInfo(resultItems, type2, superTypes);
            typeResultInfos.add(typeResultInfo);
        }
        return typeResultInfos;
    }

    private void addRemainingPropertiesForAllTypes(List<ResultItemsByTypeInfo> typeResultInfos, Set<String> allRequestedTypes, PropertySpec propSpec) {
        for (String type2 : allRequestedTypes) {
            this.addRemainingProperties(typeResultInfos, type2, propSpec);
        }
    }

    private void addRemainingPropertiesByType(String type2, Set<String> properties) {
        Set<String> props = this._remainingPropertiesByType.get(type2);
        if (props == null) {
            props = new HashSet<String>();
            this._remainingPropertiesByType.put(type2, props);
        }
        props.addAll(properties);
    }

    private void addRemainingProperties(List<ResultItemsByTypeInfo> typeResultInfos, String type2, PropertySpec propSpec) {
        List<ResultItemsByTypeInfo> filteredTypeResultInfos = this.filterByType(type2, typeResultInfos);
        if (ArrayUtil.isNullOrEmpty(filteredTypeResultInfos)) {
            this.addAllRemainingProperties(type2, propSpec);
            return;
        }
        for (ResultItemsByTypeInfo filteredTypeResultInfo : filteredTypeResultInfos) {
            List<ResultItem> resultItems = filteredTypeResultInfo.getResultItems();
            String currentType = filteredTypeResultInfo.getType();
            if (ArrayUtil.isNullOrEmpty(resultItems)) {
                this.addAllRemainingProperties(currentType, propSpec);
                continue;
            }
            Set<String> remainingProperties = ResultDirectory.getRemainingProperties(propSpec.propertyNames, resultItems);
            this.addRemainingPropertiesByType(currentType, remainingProperties);
        }
    }

    private void addAllRemainingProperties(String type2, PropertySpec propSpec) {
        Set<Object> objectsForType = this._objectsPerType.get(type2);
        if (objectsForType != null && !objectsForType.isEmpty()) {
            Set<String> remainingProperties = ResultDirectory.getProperties(propSpec.propertyNames);
            this.addRemainingPropertiesByType(type2, remainingProperties);
        }
    }

    private void addParameters(PropertySpec propSpec) {
        if (propSpec.parameters == null) {
            return;
        }
        for (ParameterSpec paramSpec : propSpec.parameters) {
            Set<ParameterSpec> params = this._parameters.get(paramSpec.propertyName);
            if (params == null) {
                params = new HashSet<ParameterSpec>();
                this._parameters.put(paramSpec.propertyName, params);
            }
            params.add(paramSpec);
        }
    }

    private List<ResultItemsByTypeInfo> filterByType(String type2, List<ResultItemsByTypeInfo> typeResultInfos) {
        ArrayList<ResultItemsByTypeInfo> filteredTypeResultInfos = new ArrayList<ResultItemsByTypeInfo>();
        for (ResultItemsByTypeInfo typeResultInfo : typeResultInfos) {
            if (!typeResultInfo.ofType(type2)) continue;
            filteredTypeResultInfos.add(typeResultInfo);
        }
        return filteredTypeResultInfos;
    }

    private static Set<String> getRemainingProperties(String[] requestedProps, List<ResultItem> resultItems) {
        HashSet<String> remainingProperties = new HashSet<String>();
        if (requestedProps == null) {
            remainingProperties.add("*");
        } else {
            for (ResultItem resultItem : resultItems) {
                for (String prop : requestedProps) {
                    PropertyValue propertyValue = ResultUtil.getPropertyValue(resultItem, prop);
                    if (propertyValue != null) continue;
                    remainingProperties.add(prop);
                }
            }
        }
        return remainingProperties;
    }

    private static Set<String> getProperties(String[] requestedProps) {
        HashSet<String> remainingProperties = new HashSet<String>();
        for (String prop : requestedProps) {
            remainingProperties.add(prop);
        }
        return remainingProperties;
    }

    private static Map<String, List<ResultItem>> groupResultItemsPerType(ResultSetInfo result) {
        HashMap<String, List<ResultItem>> itemsPerType = new HashMap<String, List<ResultItem>>();
        for (ResultItem ri : result.getResultSet().items) {
            Object ref = ri.resourceObject;
            String type2 = QueryUtil.getReferenceType(ref);
            ArrayList<ResultItem> itemSet = (ArrayList<ResultItem>)itemsPerType.get(type2);
            if (itemSet == null) {
                itemSet = new ArrayList<ResultItem>();
                itemsPerType.put(type2, itemSet);
            }
            itemSet.add(ri);
        }
        return itemsPerType;
    }

    private static class ResultItemsByTypeInfo {
        private final String _type;
        private final Set<String> _superTypes = new HashSet<String>();
        private final List<ResultItem> _resultItems;

        public ResultItemsByTypeInfo(List<ResultItem> resultItems, String type2, String[] superTypes) {
            this._resultItems = resultItems;
            this._type = type2;
            if (superTypes != null) {
                for (String superType : superTypes) {
                    this._superTypes.add(superType);
                }
            }
        }

        public boolean ofType(String type2) {
            if (type2 == null) {
                return false;
            }
            if (type2.equals(this._type)) {
                return true;
            }
            return this._superTypes.contains(type2);
        }

        public String getType() {
            return this._type;
        }

        public List<ResultItem> getResultItems() {
            return this._resultItems;
        }
    }
}

