/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DataServiceThreadPoolStats {
    private static final Logger _logger = LoggerFactory.getLogger(DataServiceThreadPoolStats.class);
    private final ThreadPoolExecutor _threadPool;
    private final String _threadPoolName;
    private final int _loggableSizeChange;
    private volatile int _sizeSnapshot;

    DataServiceThreadPoolStats(ThreadPoolExecutor threadPool, String threadPoolName, int loggableSizeChange) {
        assert (threadPool != null);
        assert (threadPoolName != null);
        this._threadPool = threadPool;
        this._threadPoolName = threadPoolName;
        this._loggableSizeChange = loggableSizeChange;
        this._sizeSnapshot = 0;
    }

    void logUsageIfChanged() {
        int sizeSnapshot = this._sizeSnapshot;
        int poolSize = this._threadPool.getPoolSize();
        if (poolSize - this._loggableSizeChange >= sizeSnapshot || sizeSnapshot - this._loggableSizeChange >= poolSize) {
            this._sizeSnapshot = poolSize;
            _logger.info("Thread pool: {}, Core: {}, Max: {}, Size: {}, Active: {}", new Object[]{this._threadPoolName, this._threadPool.getCorePoolSize(), this._threadPool.getMaximumPoolSize(), this._threadPool.getPoolSize(), this._threadPool.getActiveCount()});
        }
    }
}

