/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.query.impl.DataServiceThreadPoolDecorator;
import com.vmware.vise.data.query.util.Config;
import com.vmware.vise.util.concurrent.ThreadPoolManager;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataServiceThreadPoolFactory {
    private static final Logger _logger = LoggerFactory.getLogger(DataServiceThreadPoolFactory.class);
    private static final long KEEP_ALIVE_TIME_SECONDS = 60L;

    public static ExecutorService newCachedThreadPool(String threadPoolName, int corePoolSize, int maxPoolSize, RejectedExecutionHandler rejectedExecutionHandler) {
        Validate.notEmpty(threadPoolName);
        Validate.isTrue(corePoolSize >= 0);
        Validate.isTrue(maxPoolSize > 0);
        Validate.notNull(rejectedExecutionHandler);
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(threadPoolName);
        ThreadPoolExecutor service2 = new ThreadPoolExecutor(corePoolSize, maxPoolSize, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory, rejectedExecutionHandler);
        ThreadPoolManager.getInstance().register((ExecutorService)service2);
        int loggableSizeChange = Config.THREAD_POOL_LOGGABLE_SIZE_CHANGE;
        _logger.info("Created cached thread pool '{}' with core size {} and max size {}. Will log if pool size changes with more than {} threads", new Object[]{threadPoolName, corePoolSize, maxPoolSize, loggableSizeChange});
        return new DataServiceThreadPoolDecorator(service2, threadPoolName, loggableSizeChange);
    }

    private static final class DefaultThreadFactory
    implements ThreadFactory {
        private final AtomicInteger createdThreadCount = new AtomicInteger();
        private final String _threadPoolName;

        DefaultThreadFactory(String threadPoolName) {
            assert (!StringUtils.isEmpty(threadPoolName));
            this._threadPoolName = threadPoolName;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            String threadName = this._threadPoolName + "-" + this.createdThreadCount.incrementAndGet();
            Thread thread = new Thread(runnable, threadName);
            return thread;
        }
    }
}

