/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.query.impl.DataServiceThreadPoolStats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

final class DataServiceThreadPoolDecorator
implements ExecutorService {
    private static final Logger _logger = LoggerFactory.getLogger(DataServiceThreadPoolDecorator.class);
    private final ThreadPoolExecutor _executor;
    private final DataServiceThreadPoolStats _threadPoolStats;

    DataServiceThreadPoolDecorator(ThreadPoolExecutor executor, String threadPoolName, int loggableSizeChange) {
        assert (executor != null);
        assert (threadPoolName != null);
        this._executor = executor;
        this._threadPoolStats = new DataServiceThreadPoolStats(executor, threadPoolName, loggableSizeChange);
    }

    @Override
    public void execute(Runnable command) {
        Validate.notNull(command);
        this._executor.execute(DataServiceThreadPoolDecorator.mdcAware(command));
        this._threadPoolStats.logUsageIfChanged();
    }

    @Override
    public void shutdown() {
        this._executor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this._executor.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this._executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this._executor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this._executor.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        Validate.notNull(task);
        Future<T> future = this._executor.submit(DataServiceThreadPoolDecorator.mdcAware(task));
        this._threadPoolStats.logUsageIfChanged();
        return future;
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        Validate.notNull(task);
        Future<T> future = this._executor.submit(DataServiceThreadPoolDecorator.mdcAware(task), result);
        this._threadPoolStats.logUsageIfChanged();
        return future;
    }

    @Override
    public Future<?> submit(Runnable task) {
        Validate.notNull(task);
        Future<?> future = this._executor.submit(DataServiceThreadPoolDecorator.mdcAware(task));
        this._threadPoolStats.logUsageIfChanged();
        return future;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        Validate.notNull(tasks);
        List<Future<T>> futures = this._executor.invokeAll(DataServiceThreadPoolDecorator.mdcAware(tasks));
        this._threadPoolStats.logUsageIfChanged();
        return futures;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        Validate.notNull(tasks);
        List<Future<T>> futures = this._executor.invokeAll(DataServiceThreadPoolDecorator.mdcAware(tasks), timeout, unit);
        this._threadPoolStats.logUsageIfChanged();
        return futures;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        Validate.notNull(tasks);
        T result = this._executor.invokeAny(DataServiceThreadPoolDecorator.mdcAware(tasks));
        this._threadPoolStats.logUsageIfChanged();
        return result;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Validate.notNull(tasks);
        T result = this._executor.invokeAny(DataServiceThreadPoolDecorator.mdcAware(tasks), timeout, unit);
        this._threadPoolStats.logUsageIfChanged();
        return result;
    }

    private static <T> Collection<Callable<T>> mdcAware(Collection<? extends Callable<T>> callables) {
        ArrayList<Callable<T>> mdcAwareCallables = new ArrayList<Callable<T>>();
        for (Callable<T> callable : callables) {
            mdcAwareCallables.add(DataServiceThreadPoolDecorator.mdcAware(callable));
        }
        return mdcAwareCallables;
    }

    private static <T> Callable<T> mdcAware(final Callable<T> callable) {
        assert (callable != null);
        final long startTime = System.currentTimeMillis();
        final long originalThread = Thread.currentThread().getId();
        final Map context = MDC.getCopyOfContextMap();
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                long currentThread = Thread.currentThread().getId();
                if (currentThread != originalThread) {
                    MDC.setContextMap((Map)context);
                }
                try {
                    Object v = callable.call();
                    return v;
                }
                catch (Throwable t) {
                    long executionTime = System.currentTimeMillis() - startTime;
                    Object[] logObjects = new Object[]{callable, executionTime, t};
                    _logger.warn("Data Service execution for task: {} has failed after {} ms", logObjects);
                    throw t;
                }
                finally {
                    if (currentThread != originalThread) {
                        MDC.clear();
                    }
                }
            }
        };
    }

    private static Runnable mdcAware(final Runnable runnable) {
        assert (runnable != null);
        final long startTime = System.currentTimeMillis();
        final long originalThread = Thread.currentThread().getId();
        final Map context = MDC.getCopyOfContextMap();
        return new Runnable(){

            @Override
            public void run() {
                long currentThread = Thread.currentThread().getId();
                if (currentThread != originalThread) {
                    MDC.setContextMap((Map)context);
                }
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    long executionTime = System.currentTimeMillis() - startTime;
                    Object[] logObjects = new Object[]{runnable, executionTime, t};
                    _logger.warn("Data Service execution for task: {} has failed after {} ms", logObjects);
                    throw t;
                }
                finally {
                    if (currentThread != originalThread) {
                        MDC.clear();
                    }
                }
            }
        };
    }
}

