/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.common.PathTemplate;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.DerivedPropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResourceObjectReferenceAdapter;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.impl.DataAdapterInfo;
import com.vmware.vise.data.query.impl.DataServiceExtensionRegistryInternal;
import com.vmware.vise.data.query.impl.PropertyProviderInfo;
import com.vmware.vise.data.query.impl.SubTypeResolver;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.metadata.impl.MetadataServiceRegistryInternal;
import com.vmware.vise.util.IdentityHashSet;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataServiceExtensionRegistryImpl
implements DataServiceExtensionRegistryInternal {
    private static final Log _logger = LogFactory.getLog(DataServiceExtensionRegistryImpl.class);
    private final ReadWriteLock _dataAdapterLock = new ReentrantReadWriteLock();
    private final ReadWriteLock _propertyProviderLock = new ReentrantReadWriteLock();
    private final ReadWriteLock _derivedPropertyProviderLock = new ReentrantReadWriteLock();
    private final Map<String, List<DataAdapterInfo>> _dataAdaptersByTypeName;
    private final IdentityHashSet<DataProviderAdapter> _dynamicTypedAdapter;
    private final IdentityHashSet<DataAdapterInfo> _dynamicDataAdapterInfo;
    private final IdentityHashMap<PropertyProviderAdapter, TypeInfo[]> _providerTypeInfoMap;
    private final TypePropertyTupleMap<PropertyProviderAdapter> _typePropertyTupleProviderMap;
    private final IdentityHashMap<DerivedPropertyProviderAdapter, TypeInfo[]> _derivedProviderTypeInfoMap;
    private final TypePropertyTupleMap<DerivedPropertyProviderAdapter> _typePropertyTupleDerivedProviderMap;
    private final IdentityHashMap<DataProviderAdapter, DataAdapterInfo> _adapterToInfoMap;
    private final ReadWriteLock _refAdapterLock = new ReentrantReadWriteLock();
    private final Map<Class<?>, ResourceObjectReferenceAdapter> _refAdapterByType;
    private final Map<String, ResourceObjectReferenceAdapter> _refAdapterByUidPrefix;
    private final Map<Class<?>, Set<String>> _uidPrefixSetByType;
    private final MetadataServiceRegistryInternal _metadataServiceRegistry;
    private final SubTypeResolver _subTypeResolver;

    public DataServiceExtensionRegistryImpl(MetadataServiceRegistryInternal metadataServiceRegistry, SubTypeResolver subTypeResolver) {
        if (metadataServiceRegistry == null) {
            throw new IllegalArgumentException("metadataServiceRegistry shouldn't be null");
        }
        this._metadataServiceRegistry = metadataServiceRegistry;
        this._subTypeResolver = subTypeResolver;
        this._dataAdaptersByTypeName = new HashMap<String, List<DataAdapterInfo>>();
        this._dynamicTypedAdapter = new IdentityHashSet();
        this._dynamicDataAdapterInfo = new IdentityHashSet();
        this._providerTypeInfoMap = new IdentityHashMap();
        this._typePropertyTupleProviderMap = new TypePropertyTupleMap();
        this._derivedProviderTypeInfoMap = new IdentityHashMap();
        this._typePropertyTupleDerivedProviderMap = new TypePropertyTupleMap();
        this._adapterToInfoMap = new IdentityHashMap();
        this._refAdapterByType = new HashMap();
        this._refAdapterByUidPrefix = new HashMap<String, ResourceObjectReferenceAdapter>();
        this._uidPrefixSetByType = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDataAdapter(DataProviderAdapter adapter, String[] types) {
        if (adapter == null) {
            return;
        }
        String className = adapter.getClass().getName();
        if (_logger.isDebugEnabled()) {
            DataServiceExtensionRegistryImpl.logAdapterRegistration(className, types);
        }
        this._dataAdapterLock.writeLock().lock();
        try {
            if (types == null || types.length == 0) {
                DataServiceExtensionRegistryImpl.registerDynamicAdapter(this._dynamicTypedAdapter, this._dynamicDataAdapterInfo, adapter, className);
                return;
            }
            DataAdapterInfo daInfo = DataServiceExtensionRegistryImpl.toDataAdapterInfo(adapter, DataServiceExtensionRegistryImpl.toTypeInfos(types), this._adapterToInfoMap);
            for (String type2 : types) {
                if (type2 == null || type2.length() == 0) {
                    _logger.error((Object)("Invalid null/empty type provided by adapter: " + className));
                    continue;
                }
                List<DataAdapterInfo> adapterInfos = this._dataAdaptersByTypeName.get(type2);
                if (adapterInfos == null) {
                    adapterInfos = new ArrayList<DataAdapterInfo>();
                    this._dataAdaptersByTypeName.put(type2, adapterInfos);
                }
                this._adapterToInfoMap.put(adapter, daInfo);
                boolean isFirstRegistered = adapterInfos.add(daInfo);
                if (isFirstRegistered) continue;
                _logger.error((Object)("Adapter already registered: " + className + ", for type: " + type2));
            }
        }
        finally {
            this._dataAdapterLock.writeLock().unlock();
        }
    }

    private static void registerDynamicAdapter(IdentityHashSet<DataProviderAdapter> dynamicTypedAdapter, IdentityHashSet<DataAdapterInfo> dynamicDataAdapterInfo, DataProviderAdapter adapter, String className) {
        boolean isFirstRegistered = dynamicTypedAdapter.add((Object)adapter);
        if (isFirstRegistered) {
            DataAdapterInfo daInfo = new DataAdapterInfo();
            daInfo.adapter = adapter;
            dynamicDataAdapterInfo.add((Object)daInfo);
        } else {
            _logger.error((Object)("Dynamic adapter already registered! " + className));
        }
    }

    @Override
    public void registerDataAdapter(PropertyProviderAdapter provider, TypeInfo[] providedTypes) {
        if (provider == null) {
            return;
        }
        String className = provider.getClass().getName();
        if (providedTypes == null || providedTypes.length == 0) {
            _logger.error((Object)("Invalid null or empty types from provider " + className));
            return;
        }
        if (_logger.isDebugEnabled()) {
            DataServiceExtensionRegistryImpl.logProviderRegistration(className, providedTypes);
        }
        if (provider instanceof DerivedPropertyProviderAdapter) {
            this.registerDerivedPropertyProviderAdapter((DerivedPropertyProviderAdapter)provider, providedTypes);
        } else {
            this.registerPropertyProviderAdapter(provider, providedTypes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reRegisterDataAdapter(PropertyProviderAdapter provider, TypeInfo[] types) {
        Lock lock = this._propertyProviderLock.writeLock();
        if (provider instanceof DerivedPropertyProviderAdapter) {
            lock = this._derivedPropertyProviderLock.writeLock();
        }
        lock.lock();
        try {
            this.unregisterDataAdapter(provider);
            this.registerDataAdapter(provider, types);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPropertyProviderAdapter(PropertyProviderAdapter provider, TypeInfo[] providedTypes) {
        this._propertyProviderLock.writeLock().lock();
        try {
            if (this._providerTypeInfoMap.put(provider, providedTypes) != null) {
                _logger.error((Object)("The PropertyProviderAdapter '" + Utils.renderPropertyProvider(provider) + "' was already registered and the properties for which it was registered are replaced with [" + Arrays.toString(providedTypes) + "]"));
                return;
            }
            for (TypeInfo ti : providedTypes) {
                for (String property : ti.properties) {
                    PropertyProviderAdapter existingProvider = this._typePropertyTupleProviderMap.addTupleValue(ti.type, property, provider);
                    if (existingProvider == null) continue;
                    _logger.warn((Object)("The PropertyProviderAdapter '" + Utils.renderPropertyProvider(existingProvider) + "' was already registered for type '" + ti.type + "' and property '" + property + "' and was replaced by '" + Utils.renderPropertyProvider(provider) + "'"));
                }
            }
        }
        finally {
            this._propertyProviderLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDerivedPropertyProviderAdapter(DerivedPropertyProviderAdapter provider, TypeInfo[] providedTypes) {
        this._derivedPropertyProviderLock.writeLock().lock();
        try {
            if (this._derivedProviderTypeInfoMap.put(provider, providedTypes) != null) {
                _logger.error((Object)("The DerivedPropertyProviderAdapter '" + provider.getClass().getCanonicalName() + "' was already registered and the properties for which it was registered are replaced with [" + Arrays.toString(providedTypes) + "]"));
                return;
            }
            for (TypeInfo ti : providedTypes) {
                for (String property : ti.properties) {
                    DerivedPropertyProviderAdapter existingProvider = this._typePropertyTupleDerivedProviderMap.addTupleValue(ti.type, property, provider);
                    if (existingProvider == null) continue;
                    _logger.warn((Object)("The DerivedPropertyProviderAdapter '" + existingProvider.getClass().getCanonicalName() + "' was already registered for type '" + ti.type + "' and property '" + property + "' and was replaced by '" + provider.getClass().getCanonicalName() + "'"));
                }
                this._subTypeResolver.updateSubTypes(ti.type);
            }
        }
        finally {
            this._derivedPropertyProviderLock.writeLock().unlock();
        }
    }

    @Override
    public void unregisterDataAdapter(DataProviderAdapter adapter) {
        if (adapter == null) {
            return;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Unregistering DataProviderAdapter: " + adapter.getClass().getName()));
        }
        this._dataAdapterLock.writeLock().lock();
        try {
            if (this._dynamicTypedAdapter.contains((Object)adapter)) {
                this._dynamicTypedAdapter.remove((Object)adapter);
                DataServiceExtensionRegistryImpl.removeAdapterFromDynamicAdapterInfo(adapter, this._dynamicDataAdapterInfo);
                return;
            }
            DataServiceExtensionRegistryImpl.removeFromTypeDataAdapterMap(adapter, this._adapterToInfoMap, this._dataAdaptersByTypeName);
            this._adapterToInfoMap.remove(adapter);
        }
        finally {
            this._dataAdapterLock.writeLock().unlock();
        }
    }

    @Override
    public void unregisterDataAdapter(PropertyProviderAdapter provider) {
        if (provider == null) {
            return;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Unregistering PropertyProviderAdapter: " + provider.getClass().getName()));
        }
        if (provider instanceof DerivedPropertyProviderAdapter) {
            this.unregisterDerivedPropertyProviderAdapter((DerivedPropertyProviderAdapter)provider);
        } else {
            this.unregisterPropertyProviderAdapter(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterPropertyProviderAdapter(PropertyProviderAdapter provider) {
        this._propertyProviderLock.writeLock().lock();
        try {
            TypeInfo[] types = this._providerTypeInfoMap.get(provider);
            if (types != null) {
                for (int i = 0; i < types.length; ++i) {
                    TypeInfo ti = types[i];
                    for (String property : ti.properties) {
                        this._typePropertyTupleProviderMap.removeTuple(ti.type, property);
                    }
                }
                this._providerTypeInfoMap.remove(provider);
            }
        }
        finally {
            this._propertyProviderLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterDerivedPropertyProviderAdapter(DerivedPropertyProviderAdapter provider) {
        this._derivedPropertyProviderLock.writeLock().lock();
        try {
            TypeInfo[] types = this._derivedProviderTypeInfoMap.get(provider);
            if (types != null) {
                for (int i = 0; i < types.length; ++i) {
                    TypeInfo ti = types[i];
                    for (String property : ti.properties) {
                        this._typePropertyTupleDerivedProviderMap.removeTuple(ti.type, property);
                    }
                }
                this._derivedProviderTypeInfoMap.remove(provider);
            }
        }
        finally {
            this._derivedPropertyProviderLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerObjectRefTypeAdapter(ResourceObjectReferenceAdapter adapter, Class<?> type2, String uidPrefix) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{type2, adapter});
        if (StringUtil.isNullOrEmpty((String)uidPrefix)) {
            throw new IllegalArgumentException("uidPrefix cannot be null or emtpy");
        }
        if (Object.class.equals(type2)) {
            throw new IllegalArgumentException("Cannot register an adapter for Object.");
        }
        this._refAdapterLock.writeLock().lock();
        try {
            if (!this._refAdapterByType.containsKey(type2)) {
                this._refAdapterByType.put(type2, adapter);
                _logger.debug((Object)("Registering ResourceObjectReferenceAdapter for type: " + type2.getName() + ", adapter: " + adapter.getClass().getName()));
            } else {
                _logger.debug((Object)("RefTypeAdapter already registered for " + type2 + ", ignroing."));
            }
            if (!this._refAdapterByUidPrefix.containsKey(uidPrefix)) {
                this._refAdapterByUidPrefix.put(uidPrefix, adapter);
                _logger.debug((Object)("Registering ResourceObjectReferenceAdapter for uidPrefix: " + uidPrefix + ", adapter: " + adapter.getClass().getName()));
            } else {
                _logger.debug((Object)("RefTypeAdapter already registered for " + uidPrefix + ", ignroing."));
            }
            if (!this._uidPrefixSetByType.containsKey(type2)) {
                this._uidPrefixSetByType.put(type2, new HashSet());
            }
            Set<String> uidPrefixSet = this._uidPrefixSetByType.get(type2);
            uidPrefixSet.add(uidPrefix);
        }
        finally {
            this._refAdapterLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterObjectRefTypeAdapter(Class<?> type2) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{type2});
        this._refAdapterLock.writeLock().lock();
        try {
            this._refAdapterByType.remove(type2);
            Set<String> uidPrefixSet = this._uidPrefixSetByType.get(type2);
            for (String prefix : uidPrefixSet) {
                this._refAdapterByUidPrefix.remove(prefix);
            }
        }
        finally {
            this._refAdapterLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceObjectReferenceAdapter getObjectRefTypeAdapter(Class<?> type2) {
        if (type2 == null) {
            return null;
        }
        this._refAdapterLock.readLock().lock();
        try {
            ResourceObjectReferenceAdapter adapter = this._refAdapterByType.get(type2);
            if (adapter != null) {
                ResourceObjectReferenceAdapter resourceObjectReferenceAdapter = adapter;
                return resourceObjectReferenceAdapter;
            }
            Class<?> superClass = type2.getSuperclass();
            if (superClass == null) {
                ResourceObjectReferenceAdapter resourceObjectReferenceAdapter = null;
                return resourceObjectReferenceAdapter;
            }
            ResourceObjectReferenceAdapter resourceObjectReferenceAdapter = adapter = this.getObjectRefTypeAdapter(superClass);
            return resourceObjectReferenceAdapter;
        }
        finally {
            this._refAdapterLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceObjectReferenceAdapter getObjectRefTypeAdapter(String uid) {
        if (uid == null) {
            return null;
        }
        this._refAdapterLock.readLock().lock();
        try {
            ResourceObjectReferenceAdapter adapter;
            String uidPrefix = DataServiceExtensionRegistryImpl.findUidPrefix(uid, this._refAdapterByUidPrefix);
            ResourceObjectReferenceAdapter resourceObjectReferenceAdapter = adapter = this._refAdapterByUidPrefix.get(uidPrefix);
            return resourceObjectReferenceAdapter;
        }
        finally {
            this._refAdapterLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<DataAdapterInfo> getDataAdapters(QuerySpec query) {
        IdentityHashSet matchedAdapters = new IdentityHashSet();
        if (query == null || query.resourceSpec == null) {
            return matchedAdapters;
        }
        Constraint constraint = query.resourceSpec.constraint;
        String[] typeNames = Utils.getTypeNamesFromConstraint(constraint);
        this._dataAdapterLock.readLock().lock();
        try {
            boolean containsNonExplicitType;
            if (typeNames != null) {
                for (String typeName : typeNames) {
                    List<DataAdapterInfo> adapterInfos;
                    if (typeName == null || (adapterInfos = this._dataAdaptersByTypeName.get(typeName)) == null) continue;
                    for (DataAdapterInfo daInfo : adapterInfos) {
                        if (daInfo == null) continue;
                        matchedAdapters.add(daInfo);
                    }
                }
            }
            if (matchedAdapters.isEmpty() && _logger.isDebugEnabled()) {
                _logger.debug((Object)("No specific adapters found for query : " + query.name));
            }
            if (containsNonExplicitType = Utils.containsNonExplicitType(typeNames, this._metadataServiceRegistry)) {
                matchedAdapters.addAll(this._dynamicDataAdapterInfo);
            }
        }
        finally {
            this._dataAdapterLock.readLock().unlock();
        }
        return matchedAdapters;
    }

    @Override
    public Collection<DataAdapterInfo> getDynamicAdapters() {
        this._dataAdapterLock.readLock().lock();
        try {
            ArrayList<DataAdapterInfo> adapters;
            ArrayList<DataAdapterInfo> arrayList = adapters = new ArrayList<DataAdapterInfo>((Collection<DataAdapterInfo>)this._dynamicDataAdapterInfo);
            return arrayList;
        }
        finally {
            this._dataAdapterLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PropertyProviderInfo> getPropertyProviders(String type2, Set<String> properties) {
        IdentityHashMap<PropertyProviderAdapter, PropertyProviderInfo> matchedProviders = new IdentityHashMap<PropertyProviderAdapter, PropertyProviderInfo>();
        this._propertyProviderLock.readLock().lock();
        try {
            if (properties.isEmpty()) {
                List<PropertyProviderAdapter> propertyAdapters = this._typePropertyTupleProviderMap.lookupTupleValue(type2, "*");
                DataServiceExtensionRegistryImpl.addPropertyProviderInfo(matchedProviders, propertyAdapters, "*");
            } else {
                for (String property : properties) {
                    List<PropertyProviderAdapter> propertyAdapters = this._typePropertyTupleProviderMap.lookupTupleValue(type2, property);
                    DataServiceExtensionRegistryImpl.addPropertyProviderInfo(matchedProviders, propertyAdapters, property);
                }
            }
        }
        finally {
            this._propertyProviderLock.readLock().unlock();
        }
        return matchedProviders.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PropertyProviderInfo> getDerivedPropertyProviders(String type2, Set<String> properties) {
        IdentityHashMap<PropertyProviderAdapter, PropertyProviderInfo> matchedProviders = new IdentityHashMap<PropertyProviderAdapter, PropertyProviderInfo>();
        this._derivedPropertyProviderLock.readLock().lock();
        try {
            if (properties.isEmpty()) {
                List<DerivedPropertyProviderAdapter> propertyAdapters = this._typePropertyTupleDerivedProviderMap.lookupTupleValue(type2, "*");
                DataServiceExtensionRegistryImpl.addPropertyProviderInfo(matchedProviders, propertyAdapters, "*");
            } else {
                for (String property : properties) {
                    List<DerivedPropertyProviderAdapter> propertyAdapters = this._typePropertyTupleDerivedProviderMap.lookupTupleValue(type2, property);
                    DataServiceExtensionRegistryImpl.addPropertyProviderInfo(matchedProviders, propertyAdapters, property);
                }
            }
        }
        finally {
            this._derivedPropertyProviderLock.readLock().unlock();
        }
        return matchedProviders.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getDerivedPropertyProvidersRegisteredTypes() {
        HashSet<String> registeredTypes = new HashSet<String>();
        this._derivedPropertyProviderLock.readLock().lock();
        try {
            Collection<TypeInfo[]> typeInfoCollection = this._derivedProviderTypeInfoMap.values();
            for (TypeInfo[] typeInfos : typeInfoCollection) {
                for (TypeInfo typeInfo : typeInfos) {
                    if ("*".equals(typeInfo.type)) continue;
                    registeredTypes.add(typeInfo.type);
                }
            }
        }
        finally {
            this._derivedPropertyProviderLock.readLock().unlock();
        }
        return registeredTypes;
    }

    @Override
    public TypeInfo[] getProvidedTypeInfos(PropertyProviderAdapter provider) {
        if (provider == null) {
            return null;
        }
        if (provider instanceof DerivedPropertyProviderAdapter) {
            return this.getProvidedTypeInfosForDerivedPropertyProvider((DerivedPropertyProviderAdapter)provider);
        }
        return this.getProvidedTypeInfosForPropertyProvider(provider);
    }

    private TypeInfo[] getProvidedTypeInfosForPropertyProvider(PropertyProviderAdapter propertyProvider) {
        TypeInfo[] typeInfos = null;
        this._propertyProviderLock.readLock().lock();
        try {
            typeInfos = this._providerTypeInfoMap.get(propertyProvider);
        }
        finally {
            this._propertyProviderLock.readLock().unlock();
        }
        if (typeInfos == null) {
            typeInfos = new TypeInfo[]{};
        }
        TypeInfo[] defensiveCopy = Arrays.copyOf(typeInfos, typeInfos.length);
        return defensiveCopy;
    }

    private TypeInfo[] getProvidedTypeInfosForDerivedPropertyProvider(DerivedPropertyProviderAdapter derivedPropertyProvider) {
        TypeInfo[] typeInfos = null;
        this._derivedPropertyProviderLock.readLock().lock();
        try {
            typeInfos = this._derivedProviderTypeInfoMap.get(derivedPropertyProvider);
        }
        finally {
            this._derivedPropertyProviderLock.readLock().unlock();
        }
        if (typeInfos == null) {
            typeInfos = new TypeInfo[]{};
        }
        TypeInfo[] defensiveCopy = Arrays.copyOf(typeInfos, typeInfos.length);
        return defensiveCopy;
    }

    private static DataAdapterInfo toDataAdapterInfo(DataProviderAdapter adapter, TypeInfo[] typeInfos, IdentityHashMap<DataProviderAdapter, DataAdapterInfo> adapterToInfoMap) {
        DataAdapterInfo daInfo = adapterToInfoMap.get(adapter);
        if (daInfo == null) {
            daInfo = new DataAdapterInfo();
            daInfo.adapter = adapter;
            daInfo.typeInfo = typeInfos;
        } else {
            ArrayList<TypeInfo> newTypeInfos = new ArrayList<TypeInfo>();
            boolean isNewTypeInfo = false;
            int i = 0;
            for (int index = 0; index < daInfo.typeInfo.length; ++index) {
                for (i = 0; i < typeInfos.length; ++i) {
                    if (typeInfos[i] == daInfo.typeInfo[index]) continue;
                    newTypeInfos.add(typeInfos[i]);
                }
                if (!isNewTypeInfo) continue;
                isNewTypeInfo = false;
                newTypeInfos.add(typeInfos[i]);
            }
            int newLength = newTypeInfos.size() + daInfo.typeInfo.length;
            TypeInfo[] allTypeInfos = new TypeInfo[newLength];
            int k = 0;
            for (k = 0; k < newTypeInfos.size(); ++k) {
                allTypeInfos[k] = (TypeInfo)newTypeInfos.get(k);
            }
            int u = 0;
            for (int j = k; j < daInfo.typeInfo.length; ++j) {
                allTypeInfos[j] = daInfo.typeInfo[u];
                ++u;
            }
            daInfo.typeInfo = allTypeInfos;
        }
        return daInfo;
    }

    private static TypeInfo[] toTypeInfos(String[] types) {
        assert (types != null);
        TypeInfo[] typeInfos = new TypeInfo[types.length];
        for (int index = 0; index < types.length; ++index) {
            TypeInfo typeInfo;
            String type2 = types[index];
            typeInfos[index] = typeInfo = DataServiceExtensionRegistryImpl.toTypeInfo(type2);
        }
        return typeInfos;
    }

    private static TypeInfo toTypeInfo(String type2) {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = type2;
        typeInfo.properties = new String[]{"*"};
        return typeInfo;
    }

    private static void addPropertyProviderInfo(Map<PropertyProviderAdapter, PropertyProviderInfo> providerInfos, List<? extends PropertyProviderAdapter> propertyAdapters, String property) {
        for (PropertyProviderAdapter propertyProviderAdapter : propertyAdapters) {
            PropertyProviderInfo propProviderInfo = providerInfos.get(propertyProviderAdapter);
            if (propProviderInfo == null) {
                propProviderInfo = new PropertyProviderInfo();
                propProviderInfo.propertyProvider = propertyProviderAdapter;
                providerInfos.put(propertyProviderAdapter, propProviderInfo);
            }
            propProviderInfo.providedProperties.add(property);
        }
    }

    private static void logProviderRegistration(String name, TypeInfo[] providedTypes) {
        String message = " for types & properties: ";
        for (TypeInfo type2 : providedTypes) {
            message = message + "\n- " + type2;
        }
        _logger.debug((Object)("Registering property provider " + name + message));
    }

    private static void removeAdapterFromDynamicAdapterInfo(DataProviderAdapter adapter, IdentityHashSet<DataAdapterInfo> dynamicDataAdapterInfo) {
        for (DataAdapterInfo daInfo : dynamicDataAdapterInfo) {
            if (daInfo.adapter != adapter) continue;
            dynamicDataAdapterInfo.remove((Object)daInfo);
            return;
        }
    }

    private static void removeFromTypeDataAdapterMap(DataProviderAdapter adapter, IdentityHashMap<DataProviderAdapter, DataAdapterInfo> adapterToInfoMap, Map<String, List<DataAdapterInfo>> dataAdaptersByTypeName) {
        if (adapter == null) {
            return;
        }
        DataAdapterInfo adapterInfo = adapterToInfoMap.get(adapter);
        if (adapterInfo == null) {
            return;
        }
        TypeInfo[] typeinfos = adapterInfo.typeInfo;
        for (int index = 0; index < typeinfos.length; ++index) {
            String type2;
            List<DataAdapterInfo> adapterInfos;
            TypeInfo typeInfo = typeinfos[index];
            if (typeInfo == null || (adapterInfos = dataAdaptersByTypeName.get(type2 = typeInfo.type)) == null) continue;
            boolean removed = adapterInfos.remove(adapterInfo);
            if (_logger.isDebugEnabled()) {
                String removedStr = removed ? ") removed for type: " : ") ALREADY REMOVED for type: ";
                _logger.debug((Object)("Adapter (" + adapter.getClass().getName() + removedStr + type2));
            }
            if (adapterInfos.size() != 0) continue;
            dataAdaptersByTypeName.remove(type2);
        }
    }

    private static String createTypePropertyTuple(String typeName, String property) {
        if (typeName == null || property == null) {
            return "";
        }
        return typeName + ":" + property;
    }

    private static String findUidPrefix(String uid, Map<String, ResourceObjectReferenceAdapter> refAdapterByUidPrefix) {
        assert (uid != null);
        String longestMatchingPrefix = "";
        for (String prefix : refAdapterByUidPrefix.keySet()) {
            if (!uid.startsWith(prefix) || prefix.length() <= longestMatchingPrefix.length()) continue;
            longestMatchingPrefix = prefix;
        }
        return longestMatchingPrefix;
    }

    private static void logAdapterRegistration(String name, String[] providedTypes) {
        if (providedTypes == null || providedTypes.length == 0) {
            _logger.debug((Object)("Registering dynamic adapter : " + name));
        } else {
            String message = " for types: ";
            for (String type2 : providedTypes) {
                message = message + type2 + ", ";
            }
            _logger.debug((Object)("Registering data adapter " + name + message));
        }
    }

    private static class TypePropertyTupleMap<T> {
        private final Map<Pair<String, String>, T> _typePropertyTupleMap = new HashMap<Pair<String, String>, T>();
        private final Map<Pair<String, String>, T> _templateTupleMap = new HashMap<Pair<String, String>, T>();

        private void assertTypePropertyArgsAreValid(String type2, String property) {
            if (StringUtil.isNullOrEmpty((String)type2)) {
                throw new IllegalArgumentException("The 'type' argument shouldn't be empty");
            }
            if (StringUtil.isNullOrEmpty((String)property)) {
                throw new IllegalArgumentException("The 'property' argument shouldn't be empty");
            }
        }

        public T addTupleValue(String type2, String property, T value) {
            this.assertTypePropertyArgsAreValid(type2, property);
            Pair typePropertyTuple = new Pair((Object)type2, (Object)property, true);
            if (PathTemplate.isTemplate(property) || PathTemplate.isTemplate(type2)) {
                return this._templateTupleMap.put((Pair<String, String>)typePropertyTuple, value);
            }
            return this._typePropertyTupleMap.put((Pair<String, String>)typePropertyTuple, value);
        }

        public void removeTuple(String type2, String property) {
            this.assertTypePropertyArgsAreValid(type2, property);
            Pair typePropertyTuple = new Pair((Object)type2, (Object)property, true);
            T value = this._typePropertyTupleMap.remove(typePropertyTuple);
            if (value == null) {
                this._templateTupleMap.remove(typePropertyTuple);
            }
        }

        public List<T> lookupTupleValue(String type2, String property) {
            Pair tupleForAllTypes;
            Pair tupleForAllProperties;
            this.assertTypePropertyArgsAreValid(type2, property);
            ArrayList<T> result = new ArrayList<T>();
            Pair searchTuple = new Pair((Object)type2, (Object)property, true);
            T value = this._typePropertyTupleMap.get(searchTuple);
            if (value != null) {
                result.add(value);
                return result;
            }
            if (!"*".equals(property) && (value = this._typePropertyTupleMap.get(tupleForAllProperties = new Pair((Object)type2, (Object)"*"))) != null) {
                result.add(value);
                return result;
            }
            if (!"*".equals(type2) && (value = this._typePropertyTupleMap.get(tupleForAllTypes = new Pair((Object)"*", (Object)property))) != null) {
                result.add(value);
                return result;
            }
            for (Pair<String, String> templateTuple : this._templateTupleMap.keySet()) {
                if (!PathTemplate.matches((String)templateTuple.first, (String)searchTuple.first) || !PathTemplate.matches((String)templateTuple.second, (String)searchTuple.second)) continue;
                T templateTupleValue = this._templateTupleMap.get(templateTuple);
                result.add(templateTupleValue);
            }
            return result;
        }
    }
}

