/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DynamicProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.impl.ServicePropertyProviderAdapter;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.service.ServiceListener;
import com.vmware.vise.util.service.ServiceRegistry;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataServiceAdapterRegistrar {
    private static final Log _logger = LogFactory.getLog(DataServiceAdapterRegistrar.class);
    private boolean _initialized = false;
    private final Map<PropertyProviderBean, PropertyProviderAdapter> _serviceAdapterByBean;
    private DataServiceExtensionRegistry _extensionRegistry;
    private final ServiceRegistry _serviceRegistry;

    public DataServiceAdapterRegistrar(DataServiceExtensionRegistry extensionRegistry, ServiceRegistry serviceRegistry) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{extensionRegistry, serviceRegistry});
        this._extensionRegistry = extensionRegistry;
        this._serviceRegistry = serviceRegistry;
        this._serviceAdapterByBean = new HashMap<PropertyProviderBean, PropertyProviderAdapter>();
        this.initialize();
    }

    private synchronized void initialize() {
        if (this._initialized) {
            return;
        }
        ServiceListener propertyProviderListener = new ServiceListener(){

            public void serviceAdded(Object service2) {
                DataServiceAdapterRegistrar.this.registerService(service2, true);
            }

            public void serviceRemoved(Object service2) {
                DataServiceAdapterRegistrar.this.unregisterService(service2, true);
            }
        };
        ServiceListener dataAdapterListener = new ServiceListener(){

            public void serviceAdded(Object service2) {
                DataServiceAdapterRegistrar.this.registerService(service2, false);
            }

            public void serviceRemoved(Object service2) {
                DataServiceAdapterRegistrar.this.unregisterService(service2, false);
            }
        };
        this._serviceRegistry.registerServiceListener(PropertyProviderBean.class.getName(), propertyProviderListener);
        this._serviceRegistry.registerServiceListener(DataProviderAdapter.class.getName(), dataAdapterListener);
        this._initialized = true;
    }

    private synchronized void unregisterService(Object service2, boolean isPropertyProviderService) {
        PropertyProviderAdapter ppa;
        if (service2 instanceof DataProviderAdapter) {
            DataProviderAdapter dpa = (DataProviderAdapter)service2;
            this._extensionRegistry.unregisterDataAdapter(dpa);
        }
        if (service2 instanceof PropertyProviderAdapter) {
            ppa = (PropertyProviderAdapter)service2;
            this._extensionRegistry.unregisterDataAdapter(ppa);
        }
        if (service2 instanceof PropertyProviderBean) {
            ppa = this._serviceAdapterByBean.remove((PropertyProviderBean)service2);
            this._extensionRegistry.unregisterDataAdapter(ppa);
        }
    }

    private synchronized void registerService(Object service2, boolean isPropertyProviderService) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Registering service " + service2));
        }
        if (isPropertyProviderService) {
            PropertyProviderBean ppb = (PropertyProviderBean)service2;
            ServicePropertyProviderAdapter sppa = new ServicePropertyProviderAdapter(ppb);
            this._extensionRegistry.registerDataAdapter(sppa, sppa.getProvidedTypeInfos());
            this._serviceAdapterByBean.put(ppb, sppa);
        } else {
            DataAdapterAnnotationProcessor annotationProcessor = new DataAdapterAnnotationProcessor((DataProviderAdapter)service2);
            if (annotationProcessor.isTypeAnnotationPresent() || service2 instanceof DynamicProviderAdapter) {
                this._extensionRegistry.registerDataAdapter((DataProviderAdapter)service2, annotationProcessor.getTypes());
            }
        }
    }

    private static class DataAdapterAnnotationProcessor {
        private final DataProviderAdapter _adapter;
        private String[] _annotatedTypes;

        public DataAdapterAnnotationProcessor(DataProviderAdapter adapter) {
            assert (adapter != null);
            this._adapter = adapter;
            this.init();
        }

        public boolean isTypeAnnotationPresent() {
            return this._annotatedTypes != null && this._annotatedTypes.length > 0;
        }

        public String[] getTypes() {
            return this._annotatedTypes;
        }

        private void init() {
            Annotation[] annotations;
            ModelMetadata adapterModel = this._adapter.getClass().getAnnotation(ModelMetadata.class);
            this.processModelAnnotation(adapterModel);
            for (Annotation annotation : annotations = this._adapter.getClass().getAnnotations()) {
                if (!type.class.isInstance(annotation)) continue;
                this.processTypeAnnotation((type)annotation);
            }
        }

        private void processTypeAnnotation(type typeAnnotation) {
            assert (typeAnnotation != null);
            String value = typeAnnotation.value();
            if (this._annotatedTypes != null && this._annotatedTypes.length > 0) {
                _logger.warn((Object)("Ignoring extra type annotation " + value + " for " + this._adapter));
                return;
            }
            if (value == null || value.length() == 0) {
                if (this._adapter instanceof DynamicProviderAdapter) {
                    this._annotatedTypes = new String[0];
                } else {
                    _logger.warn((Object)("No value defined in type annotation found on " + this._adapter));
                }
                return;
            }
            this._annotatedTypes = value.split(",");
            for (int index = 0; index < this._annotatedTypes.length; ++index) {
                this._annotatedTypes[index] = this._annotatedTypes[index].trim();
            }
        }

        private void processModelAnnotation(ModelMetadata adapterModel) {
            if (adapterModel == null) {
                return;
            }
            Object[] types = adapterModel.type();
            if (!ArrayUtil.isNullOrEmpty((Object[])this._annotatedTypes)) {
                _logger.warn((Object)("Ignoring extra ModelMetadata annotation " + types + " for " + this._adapter));
                return;
            }
            if (ArrayUtil.isNullOrEmpty((Object[])types)) {
                if (this._adapter instanceof DynamicProviderAdapter) {
                    this._annotatedTypes = new String[0];
                } else {
                    _logger.warn((Object)("No types defined in ModelMapping annotation found on " + this._adapter));
                }
                return;
            }
            this._annotatedTypes = types;
        }
    }
}

