/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.commands.impl;

import com.vmware.vise.data.query.FacetInfo;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.commands.DataFetchCommandFactory;
import com.vmware.vise.data.query.commands.DataModel;
import com.vmware.vise.data.query.commands.impl.DataModelMetadata;
import com.vmware.vise.data.query.commands.impl.FieldMetadata;
import com.vmware.vise.data.query.commands.impl.PropertyValueHelper;
import com.vmware.vise.data.query.commands.impl.ReflectionUtil;
import com.vmware.vise.data.query.commands.impl.RelationshipMetadata;
import com.vmware.vise.data.query.commands.impl.RequestProcessor;
import com.vmware.vise.util.StringUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResponseProcessor<T extends DataModel> {
    private static Log _logger = LogFactory.getLog(DataFetchCommandFactory.class);
    private static final PropertyValueHelper _valueHelper = new PropertyValueHelper(true, true);
    private final RequestProcessor<T> _requestProcessor;
    private final Response _response = new Response();

    public ResponseProcessor(RequestProcessor<T> requestProcessor, ResultSet[] resultSets) {
        this._requestProcessor = requestProcessor;
        this.processResultSets(resultSets);
    }

    public List<T> getDataModelInstances() {
        return this._response._dataModels;
    }

    public Exception getError() {
        return this._response._error;
    }

    public List<FacetInfo> getFacetInfo() {
        return this._response._facetInfo;
    }

    public int getTotalResultCount() {
        return this._response._totalResultCount;
    }

    protected static Exception extractFirstError(ResultSet[] resultSets) {
        for (ResultSet resultSet : resultSets) {
            if (resultSet.error == null) continue;
            StringBuffer sb = new StringBuffer();
            sb.append("Error in result set for ");
            sb.append(resultSet.queryName);
            sb.append(" returned by DataService: ");
            sb.append(resultSet.error);
            _logger.warn((Object)sb.toString());
            return resultSet.error;
        }
        return null;
    }

    private static String getRefUid(Object serverObject) {
        try {
            return QueryUtil.getReferenceUid(serverObject);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    private T createItem(DataModelMetadata<T> dmmd, Object serverObject, ResultContainer resultContainer) {
        Class<T> dataModelClass = dmmd.getDataModelClass();
        T dataModel = ReflectionUtil.instantiateDataObject(dataModelClass);
        ((DataModel)dataModel).provider = serverObject;
        for (FieldMetadata fm : dmmd.getFieldMatadata()) {
            if (fm.getRelationships() == null) {
                Object propertyValue = this.getPropertyValue(serverObject, fm, resultContainer);
                ReflectionUtil.setField(dataModel, fm.getField(), propertyValue);
                continue;
            }
            Object relationshipValue = this.getRelatedObject(serverObject, fm, resultContainer);
            if (relationshipValue == null) {
                String fieldName = fm.getField().getName();
                _logger.warn((Object)("The related object of field: " + fieldName + " is null."));
                continue;
            }
            String refUid = ResponseProcessor.getRefUid(relationshipValue);
            if (refUid != null) {
                this.handleSingleCardinalityRelationship(dataModel, fm, resultContainer, relationshipValue);
                continue;
            }
            if (relationshipValue == null || !relationshipValue.getClass().isArray()) continue;
            this.handleMultiCardinalityRelationship(dataModel, fm, resultContainer, relationshipValue);
        }
        return dataModel;
    }

    private Object getPropertyValue(Object serverObject, FieldMetadata fieldMetadata, ResultContainer resultContainer) {
        if (fieldMetadata.getNestedModel() != null) {
            return this.createItem(fieldMetadata.getNestedModel(), serverObject, resultContainer);
        }
        String propertyName = fieldMetadata.getPropertyName();
        if (StringUtil.isNullOrEmpty((String)propertyName)) {
            return serverObject;
        }
        Class<?> dataType = fieldMetadata.getField().getType();
        return resultContainer.getPropertyValue(serverObject, propertyName, dataType);
    }

    private Object getRelatedObject(Object serverObject, FieldMetadata fieldMetadata, ResultContainer resultContainer) {
        Object relatedObject = serverObject;
        for (RelationshipMetadata rmd : fieldMetadata.getRelationships()) {
            Object prevRelatedObject = relatedObject;
            if (ResponseProcessor.getRefUid(prevRelatedObject) == null) {
                return null;
            }
            relatedObject = resultContainer.getPropertyValue(prevRelatedObject, rmd.getRelation(), null);
        }
        return relatedObject;
    }

    private ResultSet getResultSetByQueryIdx(ResultSet[] resultSets, int queryIdx) {
        List<QuerySpec> querySpecs = this._requestProcessor.getQuerySpecs();
        if (queryIdx >= querySpecs.size()) {
            return null;
        }
        String queryName = querySpecs.get((int)queryIdx).name;
        for (ResultSet resultSet : resultSets) {
            if (resultSet.queryName != queryName) continue;
            return resultSet;
        }
        return null;
    }

    private void handleMultiCardinalityRelationship(T dataModel, FieldMetadata fm, ResultContainer resultContainer, Object relationshipValue) {
        Object[] relatedObjects = (Object[])relationshipValue;
        ArrayList<Object> values = new ArrayList<Object>();
        for (Object relatedObject : relatedObjects) {
            if (!resultContainer.containsObject(relatedObject)) {
                _logger.debug((Object)("Related object not returned by DataService: " + relatedObject));
                continue;
            }
            values.add(this.getPropertyValue(relatedObject, fm, resultContainer));
        }
        this.setMultiCardinalityValues(dataModel, fm.getField(), values);
    }

    private void handleSingleCardinalityRelationship(T dataModel, FieldMetadata fm, ResultContainer resultContainer, Object relationshipValue) {
        if (resultContainer.containsObject(relationshipValue)) {
            Object propertyValue = this.getPropertyValue(relationshipValue, fm, resultContainer);
            ReflectionUtil.setField(dataModel, fm.getField(), propertyValue);
        } else {
            _logger.debug((Object)("Related object not returned by DataService: " + relationshipValue));
        }
    }

    private void processResultSets(ResultSet[] resultSets) {
        ResultSet mainResultSet = this.getResultSetByQueryIdx(resultSets, 0);
        ResultSet relationshipResultSet = this.getResultSetByQueryIdx(resultSets, 1);
        this._response._error = ResponseProcessor.extractFirstError(resultSets);
        if (mainResultSet == null || mainResultSet.items == null) {
            if (mainResultSet == null) {
                _logger.debug((Object)"Null mainResultSet retrieved");
            } else {
                _logger.debug((Object)"Null mainResultSet.items retrieved");
            }
            return;
        }
        ResultContainer resultContainer = new ResultContainer();
        if (relationshipResultSet != null) {
            resultContainer.addResultSet(relationshipResultSet);
        }
        for (ResultItem resultItem : mainResultSet.items) {
            resultContainer.addResultItem(resultItem);
            this._response._dataModels.add(this.createItem(this._requestProcessor.getDataModelMetadata(), resultItem.resourceObject, resultContainer));
            resultContainer.removeResultItem(resultItem);
        }
        this._response._facetInfo.addAll(Arrays.asList(mainResultSet.facets));
        this._response._totalResultCount = mainResultSet.totalMatchedObjectCount;
    }

    private void setMultiCardinalityValues(T item, Field field, List<Object> values) {
        Class<?> dataModelClass = field.getType();
        if (dataModelClass.isArray()) {
            dataModelClass = dataModelClass.getComponentType();
            Object array = Array.newInstance(dataModelClass, values.size());
            int inx = 0;
            for (Object obj : values) {
                try {
                    Array.set(array, inx++, obj);
                }
                catch (RuntimeException e) {
                    Class<?> cls = obj != null ? obj.getClass() : null;
                    StringBuilder builder = new StringBuilder(50);
                    builder.append("Failed to add object ");
                    builder.append(obj);
                    builder.append(" (");
                    builder.append(cls);
                    builder.append(")");
                    builder.append(" to the array of type ");
                    builder.append(dataModelClass.getName());
                    builder.append(" belonging to field ");
                    builder.append(field.getName());
                    builder.append(" from class ");
                    builder.append(field.getDeclaringClass().getName());
                    RuntimeException exception = new RuntimeException(builder.toString());
                    exception.initCause(e);
                    throw exception;
                }
            }
            ReflectionUtil.setField(item, field, array);
        }
    }

    final class ResultContainer {
        private final Map<String, Map<String, Object>> _propertiesByObject = new HashMap<String, Map<String, Object>>();

        private ResultContainer() {
        }

        private void addResultItem(ResultItem resultItem) {
            String refUid = ResponseProcessor.getRefUid(resultItem.resourceObject);
            if (this._propertiesByObject.get(refUid) == null) {
                this._propertiesByObject.put(refUid, new HashMap());
            }
            Map<String, Object> properties = this._propertiesByObject.get(refUid);
            for (PropertyValue propertyValue : resultItem.properties) {
                properties.put(propertyValue.propertyName, propertyValue.value);
            }
        }

        private void addResultSet(ResultSet resultSet) {
            for (ResultItem resultItem : resultSet.items) {
                this.addResultItem(resultItem);
            }
        }

        private boolean containsObject(Object serverObject) {
            String refUid = ResponseProcessor.getRefUid(serverObject);
            return this._propertiesByObject.get(refUid) != null;
        }

        private Object getPropertyValue(Object serverObject, String property, Class<?> targetType) {
            String refUid = ResponseProcessor.getRefUid(serverObject);
            Map<String, Object> objectProperties = this._propertiesByObject.get(refUid);
            if (objectProperties == null) {
                _logger.error((Object)("Server object properties not returned by Data Service for " + refUid));
                return null;
            }
            Object value = objectProperties.get(property);
            return _valueHelper.getPropertyValue(property, value, targetType);
        }

        private void removeResultItem(ResultItem resultItem) {
            String refUid = ResponseProcessor.getRefUid(resultItem.resourceObject);
            this._propertiesByObject.remove(refUid);
        }
    }

    final class Response {
        private final List<T> _dataModels = new ArrayList();
        private Exception _error = null;
        private final List<FacetInfo> _facetInfo = new ArrayList<FacetInfo>();
        private int _totalResultCount = 0;

        Response() {
        }
    }
}

