/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.commands.impl;

import com.vmware.vise.data.query.commands.DataModel;
import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class ReflectionUtil {
    private static Log _logger = LogFactory.getLog(ReflectionUtil.class);

    private ReflectionUtil() {
    }

    static <T extends DataModel> T instantiateDataObject(Class<T> classDef) {
        if (classDef == null) {
            throw new IllegalArgumentException("classDef cannot be passed as null");
        }
        try {
            DataModel dataModelInstance = (DataModel)classDef.newInstance();
            return (T)dataModelInstance;
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to create reflective instance of: " + classDef.getSimpleName() + "\n " + e.toString());
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Unable to create reflective instance of: " + classDef.getSimpleName() + "\n " + e.toString());
        }
    }

    static <T extends DataModel> void setField(T dataModelInstance, Field field, Object value) {
        if (dataModelInstance == null) {
            throw new IllegalArgumentException("dataModelInstance cannot be null");
        }
        if (field == null) {
            throw new IllegalArgumentException("field cannot be passed as null");
        }
        if (value == null) {
            _logger.warn((Object)("Setting null value on field:" + field.getName()));
        }
        try {
            field.set(dataModelInstance, value);
        }
        catch (IllegalAccessException e) {
            Class<?> dataObjectClassType = dataModelInstance.getClass();
            throw new IllegalStateException("Can't reflectively set field on instanceof: " + dataObjectClassType.getSimpleName() + "\n " + e.toString());
        }
    }
}

