/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.commands.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.commands.DataModel;
import com.vmware.vise.data.query.commands.impl.DataModelMetadataParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QueryGenerator<T extends DataModel> {
    public static final String DFC_AUTO_GENERATED = "dfc-auto-generated";
    public static final String RELATIONSHIPS = "relationships";

    protected List<QuerySpec> generateQuerySpecs(DataModelMetadataParser<T> parser, ResultSpec resultSpec) {
        ArrayList<QuerySpec> querySpecs = new ArrayList<QuerySpec>(2);
        String DIRECT_PROPS = "";
        QuerySpec firstQuerySpec = QueryGenerator.createNewQuerySpec(parser.getConstraintForRelationship(DIRECT_PROPS), parser.getRelationshipProperties(DIRECT_PROPS), parser.getDataModelMetadata().getTargetType(), null, parser.getParametersForRelationship(DIRECT_PROPS), resultSpec);
        querySpecs.add(firstQuerySpec);
        parser.removeRelationship(DIRECT_PROPS);
        if (parser.getRelationshipCount() > 0) {
            QuerySpec secondQuerySpec = QueryGenerator.createNewQuerySpec(parser.getCompositeConstraint(), parser.getAllProperties(), null, RELATIONSHIPS, parser.getParameters(), null);
            querySpecs.add(secondQuerySpec);
        }
        return querySpecs;
    }

    private static QuerySpec createNewQuerySpec(Constraint constraint, Object propertiesToRetrieve, String targetType, String queryId, Map<String, Object> parameters, ResultSpec resultSpec) {
        QuerySpec querySpec = new QuerySpec();
        querySpec.name = DFC_AUTO_GENERATED;
        if (queryId != null) {
            querySpec.name = querySpec.name + "-" + queryId;
        }
        querySpec.resourceSpec = QueryGenerator.createNewResourceSpec(constraint, propertiesToRetrieve, targetType, parameters);
        querySpec.resultSpec = resultSpec == null ? QueryGenerator.createDefaultResultSpec() : resultSpec;
        return querySpec;
    }

    private static ResultSpec createDefaultResultSpec() {
        ResultSpec resultSpec = new ResultSpec();
        resultSpec.maxResultCount = -1;
        return resultSpec;
    }

    private static ResourceSpec createNewResourceSpec(Constraint constraint, Object propertiesToRetrieve, String targetType, Map<String, Object> parameters) {
        Object pToRetrieve;
        ArrayList<PropertySpec> propertySet = new ArrayList<PropertySpec>();
        if (propertiesToRetrieve instanceof Map) {
            pToRetrieve = (Map)propertiesToRetrieve;
            for (String providerType : pToRetrieve.keySet()) {
                Set properties = (Set)pToRetrieve.get(providerType);
                PropertySpec ps = QueryGenerator.createPropertySpec(providerType, properties.toArray(new String[0]), parameters);
                propertySet.add(ps);
            }
        } else if (propertiesToRetrieve instanceof Set) {
            pToRetrieve = (Set)propertiesToRetrieve;
            PropertySpec ps = QueryGenerator.createPropertySpec(targetType, pToRetrieve.toArray(new String[0]), parameters);
            propertySet.add(ps);
        }
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = constraint;
        resourceSpec.propertySpecs = propertySet.toArray(new PropertySpec[0]);
        return resourceSpec;
    }

    private static PropertySpec createPropertySpec(String providerType, String[] properties, Map<String, Object> parameters) {
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.relation = "";
        propertySpec.propertyNames = properties;
        String string = propertySpec.type = providerType == "" ? null : providerType;
        if (parameters != null) {
            ArrayList<ParameterSpec> paramSpecs = new ArrayList<ParameterSpec>();
            for (String property : properties) {
                if (!parameters.containsKey(property)) continue;
                ParameterSpec parameterSpec = new ParameterSpec();
                parameterSpec.propertyName = property;
                parameterSpec.parameter = parameters.get(property);
                paramSpecs.add(parameterSpec);
            }
            propertySpec.parameters = paramSpecs.toArray(new ParameterSpec[0]);
        }
        return propertySpec;
    }
}

