/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.commands.impl;

import com.vmware.vise.data.query.commands.impl.BooleanTransformer;
import com.vmware.vise.data.query.commands.impl.ByteTransformer;
import com.vmware.vise.data.query.commands.impl.DoubleTransformer;
import com.vmware.vise.data.query.commands.impl.FloatTransformer;
import com.vmware.vise.data.query.commands.impl.IntegerTransformer;
import com.vmware.vise.data.query.commands.impl.LongTransformer;
import com.vmware.vise.data.query.commands.impl.ShortTransformer;
import com.vmware.vise.data.query.commands.impl.StringTransformer;
import com.vmware.vise.data.query.commands.impl.Transformer;
import java.util.HashMap;
import java.util.Map;

public class PropertyValueHelper {
    private static final Map<Class<?>, Transformer> _transformers = new HashMap();
    private final boolean _useDefaultWhenNull;
    private final boolean _useDefaultWhenTypeMismatch;

    public PropertyValueHelper(boolean useDefaultWhenNull, boolean useDefaultWhenTypeMismatch) {
        this._useDefaultWhenNull = useDefaultWhenNull;
        this._useDefaultWhenTypeMismatch = useDefaultWhenTypeMismatch;
    }

    public Object getPropertyValue(String propertyName, Object propertyValue, Class<?> targetType) {
        if (targetType == null) {
            return propertyValue;
        }
        Transformer transformer = _transformers.get(targetType);
        if (transformer == null) {
            return propertyValue;
        }
        return transformer.value(propertyName, propertyValue, this._useDefaultWhenNull, this._useDefaultWhenTypeMismatch);
    }

    static {
        _transformers.put(Byte.class, new ByteTransformer());
        _transformers.put(Short.class, new ShortTransformer());
        _transformers.put(Integer.class, new IntegerTransformer());
        _transformers.put(Long.class, new LongTransformer());
        _transformers.put(Float.class, new FloatTransformer());
        _transformers.put(Double.class, new DoubleTransformer());
        _transformers.put(Boolean.class, new BooleanTransformer());
        _transformers.put(Byte.TYPE, _transformers.get(Byte.class));
        _transformers.put(Short.TYPE, _transformers.get(Short.class));
        _transformers.put(Integer.TYPE, _transformers.get(Integer.class));
        _transformers.put(Long.TYPE, _transformers.get(Long.class));
        _transformers.put(Float.TYPE, _transformers.get(Float.class));
        _transformers.put(Double.TYPE, _transformers.get(Double.class));
        _transformers.put(Boolean.TYPE, _transformers.get(Boolean.class));
        _transformers.put(String.class, new StringTransformer());
    }
}

