/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.commands.impl;

import com.vmware.vise.data.query.commands.DataModel;
import com.vmware.vise.data.query.commands.NestedModel;
import com.vmware.vise.data.query.commands.Property;
import com.vmware.vise.data.query.commands.Relationship;
import com.vmware.vise.data.query.commands.impl.DataModelMetadata;
import com.vmware.vise.data.query.commands.impl.RelationshipMetadata;
import java.lang.reflect.Field;

public final class FieldMetadata {
    private static final String MULTI_HOP_RELATIONSHIP_REGEX = "[,;]";
    private final Field _field;
    private final DataModelMetadata<?> _nestedModel;
    private final String _propertyName;
    private final RelationshipMetadata[] _relationships;

    public FieldMetadata(Field field) {
        this._field = field;
        String propertyName = FieldMetadata.getPropertyName(field);
        String relationships = FieldMetadata.getRelationships(field);
        Class<?> nestedModelClass = FieldMetadata.getNestedModelClass(field);
        String string = this._propertyName = propertyName == null ? "" : propertyName.trim();
        if (relationships != null) {
            String[] relationshipsArry = relationships.split(MULTI_HOP_RELATIONSHIP_REGEX);
            int relationshipsInx = 0;
            this._relationships = new RelationshipMetadata[relationshipsArry.length];
            for (String relationship : relationshipsArry) {
                this._relationships[relationshipsInx++] = new RelationshipMetadata(relationship);
            }
        } else {
            this._relationships = null;
        }
        this._nestedModel = nestedModelClass != null ? new DataModelMetadata(nestedModelClass) : null;
    }

    public Field getField() {
        return this._field;
    }

    public DataModelMetadata<?> getNestedModel() {
        return this._nestedModel;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public RelationshipMetadata[] getRelationships() {
        return this._relationships;
    }

    private static String getPropertyName(Field field) {
        if (field.isAnnotationPresent(Property.class)) {
            Property property = field.getAnnotation(Property.class);
            return property.name();
        }
        return null;
    }

    private static Class<?> getNestedModelClass(Field field) {
        if (field.isAnnotationPresent(NestedModel.class)) {
            Class<?> fieldType = field.getType();
            if (DataModel.class.isAssignableFrom(fieldType)) {
                return fieldType;
            }
            if (fieldType.isArray() && DataModel.class.isAssignableFrom(fieldType.getComponentType())) {
                return fieldType.getComponentType();
            }
        }
        return null;
    }

    private static String getRelationships(Field field) {
        if (field.isAnnotationPresent(Relationship.class)) {
            Relationship relationship = field.getAnnotation(Relationship.class);
            return relationship.name();
        }
        return null;
    }
}

