/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.commands.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.commands.DataModel;
import com.vmware.vise.data.query.commands.impl.DataModelMetadata;
import com.vmware.vise.data.query.commands.impl.FieldMetadata;
import com.vmware.vise.data.query.commands.impl.RelationshipMetadata;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DataModelMetadataParser<T extends DataModel> {
    public static final String DIRECT_PROPS = "";
    private DataModelMetadata<T> _dataModelMetadata;
    private PropertyMap _propertyMap;

    public void parse(Class<T> dataModelClass, Constraint constraint, Map<String, Object> parameters) {
        this._dataModelMetadata = new DataModelMetadata<T>(dataModelClass);
        this._propertyMap = new PropertyMap(constraint, parameters);
        this.enumerateDataModelProperties(this._dataModelMetadata);
    }

    public Set<String> getAllProperties() {
        return this._propertyMap.getAllProperties();
    }

    public Constraint getCompositeConstraint() {
        return this._propertyMap.getCompositeConstraint();
    }

    public Constraint getConstraintForRelationship(String relationship) {
        return this._propertyMap.getConstraintForRelationship(relationship);
    }

    public int getRelationshipCount() {
        return this._propertyMap.getRelationshipCount();
    }

    public DataModelMetadata<T> getDataModelMetadata() {
        return this._dataModelMetadata;
    }

    public Map<String, Object> getParameters() {
        return this._propertyMap.getParameters();
    }

    public Map<String, Object> getParametersForRelationship(String relationship) {
        return this._propertyMap.getParametersForRelationship(relationship);
    }

    public Set<String> getRelationshipProperties(String relationship) {
        return this._propertyMap.getRelationshipProperties(relationship);
    }

    public void removeRelationship(String relationship) {
        this._propertyMap.removeRelationship(relationship);
    }

    private void enumerateDataModelProperties(DataModelMetadata<T> dmmd) {
        this.enumerateDataModelProperties(DIRECT_PROPS, dmmd);
    }

    private void enumerateDataModelProperties(String path, DataModelMetadata<T> dmmd) {
        List<FieldMetadata> fieldMetadataList = dmmd.getFieldMatadata();
        for (FieldMetadata fieldMetadata : fieldMetadataList) {
            String propertyName;
            String myPath = path;
            if (fieldMetadata.getRelationships() != null) {
                for (RelationshipMetadata rmd : fieldMetadata.getRelationships()) {
                    myPath = this._propertyMap.addRelationship(myPath, rmd);
                }
            }
            if (!StringUtil.isNullOrEmpty((String)(propertyName = fieldMetadata.getPropertyName()))) {
                this._propertyMap.addProperty(myPath, propertyName);
            }
            if (fieldMetadata.getNestedModel() == null) continue;
            this.enumerateDataModelProperties(myPath, fieldMetadata.getNestedModel());
        }
    }

    class PropertyMapItem {
        private final Constraint constraint;
        private final Set<String> properties;

        private PropertyMapItem(Constraint constraint) {
            this.constraint = constraint;
            this.properties = new HashSet<String>();
        }
    }

    final class PropertyMap {
        private int _count;
        private final Map<String, Object> _parameters;
        private final Map<String, PropertyMapItem> _propertiesByRelationship = new HashMap<String, PropertyMapItem>();

        private PropertyMap(Constraint constraint, Map<String, Object> parameters) {
            this._propertiesByRelationship.put(DataModelMetadataParser.DIRECT_PROPS, new PropertyMapItem(constraint));
            this._count = 1;
            this._parameters = parameters;
        }

        private void addParametersForRelationship(String relationship, Map<String, Object> parametersToReturn) {
            PropertyMapItem propertyMapItem = this._propertiesByRelationship.get(relationship);
            if (propertyMapItem == null) {
                return;
            }
            for (String property : propertyMapItem.properties) {
                String fullPropertyPath = this.joinRelations(relationship, property);
                if (this._parameters.get(fullPropertyPath) == null) continue;
                parametersToReturn.put(property, this._parameters.get(fullPropertyPath));
            }
        }

        private void addProperty(String path, String property) {
            this._propertiesByRelationship.get(path).properties.add(property);
        }

        private String addRelationship(String path, RelationshipMetadata relationshipMetadata) {
            String fullPath = this.joinRelations(path, relationshipMetadata.getRelation());
            PropertyMapItem relationItem = this._propertiesByRelationship.get(fullPath);
            if (relationItem == null) {
                PropertyMapItem parent = this._propertiesByRelationship.get(path);
                relationItem = new PropertyMapItem(this.createChildConstraint(parent.constraint, relationshipMetadata));
                this._propertiesByRelationship.put(fullPath, relationItem);
                ++this._count;
            }
            this.addProperty(path, relationshipMetadata.getRelation());
            return fullPath;
        }

        private Constraint createChildConstraint(Constraint parent, RelationshipMetadata rmd) {
            return QueryUtil.createRelationalConstraint(rmd.getRelation(), parent, true, rmd.getTargetType());
        }

        private Set<String> getAllProperties() {
            HashSet<String> properties = new HashSet<String>();
            for (PropertyMapItem item : this._propertiesByRelationship.values()) {
                properties.addAll(item.properties);
            }
            return properties;
        }

        private Constraint getCompositeConstraint() {
            if (this._count == 0) {
                return null;
            }
            ArrayList<Constraint> constraints = new ArrayList<Constraint>(this._count);
            for (PropertyMapItem pmi : this._propertiesByRelationship.values()) {
                constraints.add(pmi.constraint);
            }
            return constraints.size() > 1 ? QueryUtil.createCompositeConstraint(constraints.toArray(new Constraint[0]), Conjoiner.OR) : (Constraint)constraints.get(0);
        }

        private Constraint getConstraintForRelationship(String relationship) {
            return this._propertiesByRelationship.get(relationship).constraint;
        }

        private int getRelationshipCount() {
            return this._count;
        }

        private Map<String, Object> getParameters() {
            if (this._parameters == null) {
                return null;
            }
            HashMap<String, Object> parametersToReturn = new HashMap<String, Object>();
            for (String relationship : this._propertiesByRelationship.keySet()) {
                this.addParametersForRelationship(relationship, parametersToReturn);
            }
            return parametersToReturn;
        }

        private Map<String, Object> getParametersForRelationship(String relationship) {
            if (this._parameters == null) {
                return null;
            }
            HashMap<String, Object> parametersToReturn = new HashMap<String, Object>();
            this.addParametersForRelationship(relationship, parametersToReturn);
            return parametersToReturn;
        }

        private Set<String> getRelationshipProperties(String relationship) {
            return this._propertiesByRelationship.get(relationship).properties;
        }

        private String joinRelations(String parent, String relation) {
            String result = parent;
            if (result != DataModelMetadataParser.DIRECT_PROPS) {
                result = result + ".";
            }
            result = result + relation;
            return result;
        }

        private void removeRelationship(String relationship) {
            this._propertiesByRelationship.remove(relationship);
            --this._count;
        }
    }
}

