/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.commands.impl;

import com.vmware.vise.data.query.commands.DataModel;
import com.vmware.vise.data.query.commands.NestedModel;
import com.vmware.vise.data.query.commands.Property;
import com.vmware.vise.data.query.commands.Relationship;
import com.vmware.vise.data.query.commands.impl.FieldMetadata;
import com.vmware.vise.data.query.type;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public final class DataModelMetadata<T extends DataModel> {
    private final Class<T> _classDefinition;
    private final List<FieldMetadata> _fieldMetadataList = new ArrayList<FieldMetadata>();
    private final String _targetType;

    public DataModelMetadata(Class<T> classDefinition) {
        Field[] allFields;
        if (classDefinition == null) {
            throw new IllegalArgumentException("The data model class can not be null.");
        }
        this._classDefinition = classDefinition;
        type dataModelType = classDefinition.getAnnotation(type.class);
        this._targetType = dataModelType != null ? dataModelType.value() : null;
        for (Field field : allFields = classDefinition.getFields()) {
            if (!DataModelMetadata.shouldFieldBeParsed(field)) continue;
            FieldMetadata fieldMetadata = new FieldMetadata(field);
            this._fieldMetadataList.add(fieldMetadata);
        }
    }

    public Class<T> getDataModelClass() {
        return this._classDefinition;
    }

    public List<FieldMetadata> getFieldMatadata() {
        return this._fieldMetadataList;
    }

    public String getTargetType() {
        return this._targetType;
    }

    private static boolean shouldFieldBeParsed(Field field) {
        boolean propExist = field.isAnnotationPresent(Property.class);
        boolean nestedModelExist = field.isAnnotationPresent(NestedModel.class);
        boolean relationshipExist = field.isAnnotationPresent(Relationship.class);
        if (propExist && nestedModelExist) {
            throw new IllegalArgumentException("The field can not have both @Property and @NestedModel.");
        }
        return propExist || nestedModelExist || relationshipExist;
    }
}

