/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query;

import com.vmware.vise.core.model.data;
import com.vmware.vise.data.query.ResourceItem;
import com.vmware.vise.util.ObjectUtil;
import java.lang.reflect.Array;

@data(base="Object")
public class PropertyValue
extends ResourceItem {
    public Object value;
    public String propertyName;

    public String toString() {
        String valueAsStr = PropertyValue.stringValue(this.value);
        StringBuilder sb = new StringBuilder();
        sb.append(this.propertyName).append('=').append(valueAsStr);
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PropertyValue)) {
            return false;
        }
        PropertyValue other = (PropertyValue)obj;
        return ObjectUtil.objectsEqual((Object)this.value, (Object)other.value) && ObjectUtil.objectsEqual((Object)this.propertyName, (Object)other.propertyName) && super.equals(other);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + ObjectUtil.getHashCode((Object)this.value);
        hash = 31 * hash + ObjectUtil.getHashCode((Object)this.propertyName);
        return hash;
    }

    private static String stringValue(Object parameter) {
        if (PropertyValue.isArray(parameter)) {
            return PropertyValue.arrayToString(parameter);
        }
        return String.valueOf(parameter);
    }

    private static boolean isArray(Object o) {
        return o == null ? false : o.getClass().isArray();
    }

    private static String arrayToString(Object propertyValue) {
        StringBuilder sb = new StringBuilder("[");
        int length = Array.getLength(propertyValue);
        for (int i = 0; i < length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(Array.get(propertyValue, i));
        }
        sb.append("]");
        return sb.toString();
    }
}

