/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.common;

import com.vmware.vise.util.Pair;
import com.vmware.vise.util.StringUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

public class PathTemplate {
    private static final Pattern VARIABLE_NAME_PATTERN = Pattern.compile("\\{(.+?)\\}");
    private static final String STRICT_VALUE_REGEX = "([^\\.]+)";
    private static final String LENIENT_VALUE_REGEX = "(.+)";
    private static final String ASTERISK = "*";
    private final List<String> _variableNames;
    private final Pattern _regexPattern;
    private final String _pathTemplate;

    public PathTemplate(String pathTemplate) {
        this(pathTemplate, true);
    }

    public PathTemplate(String pathTemplate, boolean treatAsteriskAsMatchAll) {
        if (StringUtil.isNullOrEmpty((String)pathTemplate)) {
            throw new IllegalArgumentException("Invalid path template: " + pathTemplate);
        }
        this._pathTemplate = pathTemplate;
        ParseResult parseResult = this.parseTemplate(pathTemplate, treatAsteriskAsMatchAll);
        this._regexPattern = parseResult._regexPattern != null ? Pattern.compile(parseResult._regexPattern) : null;
        this._variableNames = parseResult._variableNames;
    }

    public String getTemplate() {
        return this._pathTemplate;
    }

    public final List<String> getVariableNames() {
        return Collections.unmodifiableList(this._variableNames);
    }

    public boolean matches(String expr) {
        if (expr == null) {
            return false;
        }
        if (this._regexPattern == null) {
            return true;
        }
        Matcher matcher = this._regexPattern.matcher(expr);
        return matcher.matches();
    }

    public Map<String, Pair<String, Integer>> matchWithPosition(String expr) {
        Assert.notNull((Object)expr, (String)"'expr' must not be null");
        if (this._regexPattern == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Pair<String, Integer>> result = new LinkedHashMap<String, Pair<String, Integer>>(this._variableNames.size());
        Matcher matcher = this._regexPattern.matcher(expr);
        if (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String name = this._variableNames.get(i - 1);
                String value = matcher.group(i);
                Pair pair = new Pair((Object)value, (Object)matcher.start(i), true);
                result.put(name, (Pair<String, Integer>)pair);
            }
        }
        return result;
    }

    public Map<String, String> match(String expr) {
        Assert.notNull((Object)expr, (String)"'expr' must not be null");
        if (this._regexPattern == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(this._variableNames.size());
        Matcher matcher = this._regexPattern.matcher(expr);
        if (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String name = this._variableNames.get(i - 1);
                String value = matcher.group(i);
                result.put(name, value);
            }
        }
        return result;
    }

    public String toString() {
        return this._pathTemplate;
    }

    private ParseResult parseTemplate(String pathTemplate, boolean treatAsteriskAsMatchAll) {
        Assert.hasText((String)pathTemplate, (String)"'pathTemplate' must not be null");
        if (treatAsteriskAsMatchAll && ASTERISK.equals(pathTemplate)) {
            return new ParseResult(null, Collections.emptyList());
        }
        Matcher m = VARIABLE_NAME_PATTERN.matcher(pathTemplate);
        StringBuilder patternBuilder = new StringBuilder();
        LinkedList<String> variableNames = new LinkedList<String>();
        int end = 0;
        while (m.find()) {
            String varName = m.group(1);
            boolean lenientMode = varName.endsWith(ASTERISK);
            patternBuilder.append(this.quote(pathTemplate, end, m.start()));
            patternBuilder.append(lenientMode ? LENIENT_VALUE_REGEX : STRICT_VALUE_REGEX);
            if (lenientMode) {
                varName = varName.substring(0, varName.length() - 1);
            }
            variableNames.add(varName);
            end = m.end();
        }
        patternBuilder.append(this.quote(pathTemplate, end, pathTemplate.length()));
        return new ParseResult(patternBuilder.toString(), variableNames);
    }

    private String quote(String fullPath, int start, int end) {
        if (start == end) {
            return "";
        }
        String segment = fullPath.substring(start, end);
        return Pattern.quote(segment);
    }

    public static boolean containsVariables(String templateString) {
        if (StringUtil.isNullOrEmpty((String)templateString)) {
            return false;
        }
        Matcher m = VARIABLE_NAME_PATTERN.matcher(templateString);
        return m.find();
    }

    public static boolean isTemplate(String templateString) {
        return PathTemplate.isTemplate(templateString, true);
    }

    public static boolean isTemplate(String templateString, boolean treatAsteriskAsMatchAll) {
        return treatAsteriskAsMatchAll && ASTERISK.equals(templateString) || PathTemplate.containsVariables(templateString);
    }

    public static boolean matches(String template, String expression) {
        PathTemplate pathTemplate = new PathTemplate(template);
        return pathTemplate.matches(expression);
    }

    private static class ParseResult {
        private final List<String> _variableNames;
        private final String _regexPattern;

        public ParseResult(String pattern, List<String> variableNames) {
            this._regexPattern = pattern;
            this._variableNames = variableNames;
        }
    }
}

