/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.h5.sdk.plugin.migration.factory.impl;

import com.vmware.h5.sdk.plugin.migration.ExtensionType;
import com.vmware.h5.sdk.plugin.migration.error.PluginManifestError;
import com.vmware.h5.sdk.plugin.migration.factory.ModelFactory;
import com.vmware.h5.sdk.plugin.migration.model.ObjectScopes;
import com.vmware.h5.sdk.plugin.migration.model.PluginBuilderConfig;
import com.vmware.h5.sdk.plugin.migration.utils.PluginMigrationUtils;
import com.vmware.h5.sdk.plugin.migration.utils.XmlUtils;
import com.vmware.vise.plugin.manifest.model.icon.SpriteSheetIconReference;
import com.vmware.vise.plugin.manifest.model.object.ObjectScope;
import com.vmware.vise.plugin.manifest.model.object.ObjectType;
import com.vmware.vise.plugin.manifest.model.object.menu.Action;
import com.vmware.vise.plugin.manifest.model.object.menu.ActionTrigger;
import com.vmware.vise.plugin.manifest.model.object.menu.Menu;
import com.vmware.vise.plugin.manifest.model.object.menu.Modal;
import com.vmware.vise.plugin.manifest.model.object.size.PixelSize;
import com.vmware.vise.plugin.manifest.model.object.size.SpanSize;
import com.vmware.vise.plugin.manifest.model.object.summary.Portlet;
import com.vmware.vise.plugin.manifest.model.object.summary.Summary;
import com.vmware.vise.plugin.manifest.model.object.view.Category;
import com.vmware.vise.plugin.manifest.model.object.view.ObjectView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class ObjectScopesModelFactory
implements ModelFactory<ObjectScopes> {
    private Map<ObjectType, List<Element>> unsupportedObjectExtensions = new HashMap<ObjectType, List<Element>>();

    @Override
    public ObjectScopes createModel(PluginBuilderConfig pluginBuilderConfig) {
        ObjectScopes objectScopes = new ObjectScopes();
        objectScopes.setObjectScopesMap(this.buildObjectScopes(pluginBuilderConfig));
        this.logUnsupportedObjectExtensions(pluginBuilderConfig, this.unsupportedObjectExtensions);
        return objectScopes;
    }

    private Map<ObjectType, ObjectScope> buildObjectScopes(PluginBuilderConfig pluginBuilderConfig) {
        HashMap<ObjectType, ObjectScope> objectScopesMap = new HashMap<ObjectType, ObjectScope>();
        Map<ObjectType, List<Element>> objectTypeExtensionsMap = pluginBuilderConfig.getObjectTypeExtensionsMap();
        for (Map.Entry<ObjectType, List<Element>> entry : objectTypeExtensionsMap.entrySet()) {
            ObjectScope objectScope = new ObjectScope();
            for (Element element : entry.getValue()) {
                this.populateObjectScopeViews(pluginBuilderConfig, objectScope, element, entry.getKey());
            }
            if (!this.isObjectScopeValid(objectScope)) continue;
            objectScopesMap.put(entry.getKey(), objectScope);
        }
        return objectScopesMap;
    }

    private void populateObjectScopeViews(PluginBuilderConfig pluginBuilderConfig, ObjectScope objectScope, Element element, ObjectType objectType) {
        String extendedPoint = XmlUtils.getChildElementNodeValue(element, "extendedPoint");
        if (ExtensionType.SUMMARY_VIEWS.matches(extendedPoint)) {
            this.setSummaryView(pluginBuilderConfig, objectScope, element);
        } else if (ExtensionType.CATEGORY_VIEWS.matches(extendedPoint) || ExtensionType.MANAGE_SETTING_VIEWS.matches(extendedPoint)) {
            this.setConfigureCategory(pluginBuilderConfig, objectScope, element);
        } else if (ExtensionType.MONITOR_VIEWS.matches(extendedPoint)) {
            this.setMonitorCategory(pluginBuilderConfig, objectScope, element);
        } else if (ExtensionType.ACTIONS_SPECS.matches(extendedPoint) || ExtensionType.SOLUTION_MENUS.matches(extendedPoint)) {
            this.setMenuActions(pluginBuilderConfig, objectScope, element, objectType);
        } else if (!ExtensionType.ACTIONS.matches(extendedPoint)) {
            this.unsupportedObjectExtensions.computeIfAbsent(objectType, o -> new ArrayList()).add(element);
        }
    }

    private void setSummaryView(PluginBuilderConfig pluginBuilderConfig, ObjectScope objectScope, Element summaryViewExtension) {
        Summary summary = new Summary();
        Portlet portlet = new Portlet();
        Element objectEl = XmlUtils.getLastChildElementNode(summaryViewExtension, "object");
        String title = PluginMigrationUtils.saveAndReturnLocaleKey(pluginBuilderConfig.getPluginDefaultBundleName(), pluginBuilderConfig.getResourceDefinition(), XmlUtils.getLastChildElementNodeValue(objectEl, "name"));
        String icon = XmlUtils.getLastChildElementNodeValue(objectEl, "icon");
        if (!PluginMigrationUtils.isStringEmpty(icon)) {
            String iconResource = PluginMigrationUtils.saveAndReturnIconKey(pluginBuilderConfig.getPluginDefaultBundleName(), pluginBuilderConfig.getResourceDefinition(), icon);
            SpriteSheetIconReference spriteSheetIconRef = new SpriteSheetIconReference();
            spriteSheetIconRef.name = iconResource;
            portlet.setIcon(spriteSheetIconRef);
        }
        portlet.changeUri(PluginMigrationUtils.getUri(pluginBuilderConfig.getManifest(), objectEl));
        portlet.changeSize(this.createSpanSize(summaryViewExtension));
        portlet.setTitleKey(title);
        summary.portlet = portlet;
        objectScope.summary = summary;
    }

    private void setConfigureCategory(PluginBuilderConfig pluginBuilderConfig, ObjectScope objectScope, Element categoryViewExtension) {
        Category category;
        Category existingCategory = this.getExistingCategory(objectScope, true);
        objectScope.configureCategory = category = this.createCategoryView(pluginBuilderConfig, existingCategory, categoryViewExtension);
    }

    private void setMonitorCategory(PluginBuilderConfig pluginBuilderConfig, ObjectScope objectScope, Element categoryViewExtension) {
        Category category;
        Category existingCategory = this.getExistingCategory(objectScope, false);
        objectScope.monitorCategory = category = this.createCategoryView(pluginBuilderConfig, existingCategory, categoryViewExtension);
    }

    private Category getExistingCategory(ObjectScope objectScope, boolean isCategoryView) {
        return isCategoryView ? objectScope.configureCategory : objectScope.monitorCategory;
    }

    private Category createCategoryView(PluginBuilderConfig pluginBuilderConfig, Category category, Element categoryViewExtension) {
        ObjectView[] objectViews = null;
        if (category != null) {
            ObjectView[] existingViews = category.getViews();
            int len = existingViews.length;
            objectViews = new ObjectView[len + 1];
            System.arraycopy(existingViews, 0, objectViews, 0, len);
        } else {
            category = new Category();
            objectViews = new ObjectView[1];
        }
        ObjectView objectView = new ObjectView();
        Element objectEl = XmlUtils.getLastChildElementNode(categoryViewExtension, "object");
        objectView.setLabelKey(PluginMigrationUtils.saveAndReturnLocaleKey(pluginBuilderConfig.getPluginDefaultBundleName(), pluginBuilderConfig.getResourceDefinition(), XmlUtils.getLastChildElementNodeValue(objectEl, "name")));
        objectView.setNavigationId(XmlUtils.getAttributeValue(categoryViewExtension, "id"));
        objectView.setUri(PluginMigrationUtils.getUri(pluginBuilderConfig.getManifest(), objectEl));
        objectViews[objectViews.length - 1] = objectView;
        category.changeViews(objectViews);
        return category;
    }

    private void setMenuActions(PluginBuilderConfig pluginBuilderConfig, ObjectScope objectScope, Element viseActionsExtension, ObjectType objectType) {
        Menu menu = objectScope.menu;
        ArrayList<Action> actionList = null;
        if (menu == null) {
            menu = new Menu();
            actionList = new ArrayList<Action>();
        } else {
            actionList = menu.actions == null ? new ArrayList() : new ArrayList<Action<? extends ActionTrigger>>(Arrays.asList(menu.actions));
        }
        Element objectEl = XmlUtils.getLastChildElementNode(viseActionsExtension, "object");
        Element actionsChildrenEl = XmlUtils.getChildElement(objectEl, "children");
        if (actionsChildrenEl != null) {
            this.setMenuActionsForHTMLSdkActions(pluginBuilderConfig, actionList, actionsChildrenEl, objectType);
        } else {
            this.setMenuActionSpecForHTMLBridgeSdkAction(pluginBuilderConfig, actionList, objectEl);
        }
        if (!actionList.isEmpty()) {
            menu.actions = actionList.toArray(new Action[actionList.size()]);
            objectScope.menu = menu;
        }
    }

    private void setMenuActionSpecForHTMLBridgeSdkAction(PluginBuilderConfig pluginBuilderConfig, List<Action> actionList, Element objectEl) {
        Element modalEl = XmlUtils.getChildElement(objectEl, "modal");
        if (modalEl != null) {
            Modal modal = new Modal();
            String actionUrl = XmlUtils.getLastChildElementNodeValue(modalEl, "url");
            String size = XmlUtils.getLastChildElementNodeValue(modalEl, "size");
            modal.changeUri(PluginMigrationUtils.getUri(pluginBuilderConfig.getManifest(), actionUrl));
            modal.changeClosable(Boolean.valueOf(XmlUtils.getLastChildElementNodeValue(modalEl, "closable")));
            modal.changeTitleKey(PluginMigrationUtils.saveAndReturnLocaleKey(pluginBuilderConfig.getPluginDefaultBundleName(), pluginBuilderConfig.getResourceDefinition(), XmlUtils.getLastChildElementNodeValue(objectEl, "label")));
            PixelSize pixelSize = this.createPixelSize(size);
            if (pixelSize != null) {
                modal.changeSize(pixelSize);
            }
            Action action = new Action(modal);
            action.changeLabelKey(PluginMigrationUtils.saveAndReturnLocaleKey(pluginBuilderConfig.getPluginDefaultBundleName(), pluginBuilderConfig.getResourceDefinition(), XmlUtils.getLastChildElementNodeValue(objectEl, "label")));
            String iconReference = XmlUtils.getLastChildElementNodeValue(objectEl, "icon");
            if (!PluginMigrationUtils.isStringEmpty(iconReference)) {
                SpriteSheetIconReference spriteSheetIconRef = new SpriteSheetIconReference();
                spriteSheetIconRef.name = PluginMigrationUtils.saveAndReturnIconKey(pluginBuilderConfig.getPluginDefaultBundleName(), pluginBuilderConfig.getResourceDefinition(), iconReference);
                action.changeIcon(spriteSheetIconRef);
            }
            actionList.add(action);
        }
    }

    private void setMenuActionsForHTMLSdkActions(PluginBuilderConfig pluginBuilderConfig, List<Action> actionList, Element actionReferencesEl, ObjectType objectType) {
        List<Element> actionArrayElements = XmlUtils.getChildElements(actionReferencesEl, "Array");
        ArrayList<Element> actionMenuSpecReferences = new ArrayList<Element>();
        for (Element actionArrayElement : actionArrayElements) {
            actionMenuSpecReferences.addAll(XmlUtils.getChildElements(actionArrayElement, "com.vmware.actionsfw.ActionMenuItemSpec"));
        }
        Map<ObjectType, List<Element>> objectTypeExtensionsMap = pluginBuilderConfig.getObjectTypeExtensionsMap();
        List<Element> actionEls = this.getActionElements(objectTypeExtensionsMap.get((Object)objectType));
        for (Element actionSpecsRef : actionMenuSpecReferences) {
            String actionId = XmlUtils.getLastChildElementNodeValue(actionSpecsRef, "uid");
            Element actionSpecEl = this.getActionSpecElementById(actionEls, actionId);
            if (actionSpecEl == null) continue;
            Element rootEl = XmlUtils.getLastChildElementNode(actionSpecEl, "delegate", "object", "root");
            String className = XmlUtils.getLastChildElementNodeValue(actionSpecEl, "delegate", "className");
            if ("com.vmware.vsphere.client.HtmlPluginModalAction".equals(className) || "com.vmware.vsphere.client.htmlbridge.HtmlActionDelegate".equals(className)) {
                Modal modal = new Modal();
                String title = XmlUtils.getLastChildElementNodeValue(rootEl, "dialogTitle");
                String size = XmlUtils.getLastChildElementNodeValue(rootEl, "dialogSize");
                if (PluginMigrationUtils.isStringEmpty(title) && PluginMigrationUtils.isStringEmpty(size)) {
                    this.addUnsupportedActionExtension(pluginBuilderConfig, objectType, actionSpecEl, className);
                    continue;
                }
                String actionUrl = XmlUtils.getLastChildElementNodeValue(rootEl, "actionUrl");
                modal.changeUri(PluginMigrationUtils.getUri(pluginBuilderConfig.getManifest(), actionUrl));
                modal.changeTitleKey(PluginMigrationUtils.saveAndReturnLocaleKey(pluginBuilderConfig.getPluginDefaultBundleName(), pluginBuilderConfig.getResourceDefinition(), XmlUtils.getLastChildElementNodeValue(rootEl, "dialogTitle")));
                PixelSize pixelSize = this.createPixelSize(size);
                if (pixelSize != null) {
                    modal.changeSize(pixelSize);
                }
                Action action = new Action(modal);
                action.changeLabelKey(PluginMigrationUtils.saveAndReturnLocaleKey(pluginBuilderConfig.getPluginDefaultBundleName(), pluginBuilderConfig.getResourceDefinition(), XmlUtils.getLastChildElementNodeValue(actionSpecEl, "label")));
                String iconReference = XmlUtils.getLastChildElementNodeValue(actionSpecEl, "icon");
                if (!PluginMigrationUtils.isStringEmpty(iconReference)) {
                    SpriteSheetIconReference spriteSheetIconRef = new SpriteSheetIconReference();
                    spriteSheetIconRef.name = PluginMigrationUtils.saveAndReturnIconKey(pluginBuilderConfig.getPluginDefaultBundleName(), pluginBuilderConfig.getResourceDefinition(), iconReference);
                    action.changeIcon(spriteSheetIconRef);
                }
                actionList.add(action);
                continue;
            }
            this.addUnsupportedActionExtension(pluginBuilderConfig, objectType, actionSpecEl, className);
        }
    }

    private void addUnsupportedActionExtension(PluginBuilderConfig pluginBuilderConfig, ObjectType objectType, Element actionSpecEl, String className) {
        PluginManifestError error = PluginManifestError.ACTION_SPECS_UNSUPPORTED_ERR;
        String message = String.format(error.getMessage(), ExtensionType.ACTIONS.toString(), objectType.getVSphereName(), className);
        PluginMigrationUtils.addToUnsupportedExtensions(pluginBuilderConfig, ExtensionType.ACTIONS.toString(), objectType, message, error.getErrorCode(), Collections.singletonList(actionSpecEl));
    }

    private List<Element> getActionElements(List<Element> elements) {
        ArrayList<Element> filteredActionElements = new ArrayList<Element>();
        for (Element element : elements) {
            String extendedPoint = XmlUtils.getChildElementNodeValue(element, "extendedPoint");
            if (!extendedPoint.equals(ExtensionType.ACTIONS.toString())) continue;
            filteredActionElements.add(element);
        }
        return filteredActionElements;
    }

    private Element getActionSpecElementById(List<Element> actionElements, String actionId) {
        for (Element actionElement : actionElements) {
            Element actionsEl = XmlUtils.getLastChildElementNode(actionElement, "object", "actions");
            if (actionsEl == null) continue;
            List<Element> actionSpecElements = XmlUtils.getChildElements(actionsEl, "com.vmware.actionsfw.ActionSpec");
            for (Element actionSpecEl : actionSpecElements) {
                if (!actionId.equals(XmlUtils.getChildElementNodeValue(actionSpecEl, "uid"))) continue;
                return actionSpecEl;
            }
        }
        return null;
    }

    private PixelSize createPixelSize(String dialogSize) {
        PixelSize pixelSize = null;
        if (!PluginMigrationUtils.isStringEmpty(dialogSize)) {
            pixelSize = new PixelSize();
            String[] pixels = dialogSize.split(",");
            if (pixels.length >= 2) {
                pixelSize.changeWidth(Integer.parseInt(pixels[0]));
                pixelSize.changeHeight(Integer.parseInt(pixels[1]));
            }
        }
        return pixelSize;
    }

    private SpanSize createSpanSize(Element summaryViewExtension) {
        String height = XmlUtils.getLastChildElementNodeValue(summaryViewExtension, "object", "size", "height");
        String width = XmlUtils.getLastChildElementNodeValue(summaryViewExtension, "object", "size", "width");
        SpanSize spanSize = null;
        if (!PluginMigrationUtils.isStringEmpty(height) && !PluginMigrationUtils.isStringEmpty(width)) {
            spanSize = new SpanSize();
            spanSize.changeHeight(Integer.parseInt(height));
            spanSize.changeWidth(Integer.parseInt(width));
        }
        return spanSize;
    }

    private void logUnsupportedObjectExtensions(PluginBuilderConfig pluginBuilderConfig, Map<ObjectType, List<Element>> unsupportedObjectExtensions) {
        unsupportedObjectExtensions.entrySet().stream().forEach(entry -> {
            ObjectType objectType = (ObjectType)((Object)((Object)entry.getKey()));
            String folderType = (String)objectType.getMetadata().get("folderType");
            StringBuilder typeBuilder = new StringBuilder(objectType.getVSphereName());
            if (folderType != null) {
                typeBuilder.append(" - ").append(folderType);
            }
            String name = typeBuilder.toString();
            String extensionInfo = String.format("unsupported-object-extensions-%s", name);
            PluginManifestError error = PluginManifestError.OBJECT_EXTENSIONS_UNSUPPORTED_ERR;
            String message = String.format(error.getMessage(), name);
            PluginMigrationUtils.addToUnsupportedExtensions(pluginBuilderConfig, extensionInfo, objectType, message, error.getErrorCode(), (List)entry.getValue());
        });
    }

    private boolean isObjectScopeValid(ObjectScope objectScope) {
        if (objectScope == null) {
            return false;
        }
        return objectScope.configureCategory != null || objectScope.monitorCategory != null || objectScope.menu != null || objectScope.summary != null;
    }
}

