/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.networking.util;

import com.vmware.vim.binding.vim.NumericRange;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.DataObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Util {
    public static final String NETWORK_SERVICE_STRINGS = "networkservice";
    private static Log _logger = LogFactory.getLog(Util.class);

    public static <T> boolean checkPropertyValueNameType(PropertyValue pv, String propertyName, Class<T> type2) {
        if (pv != null && type2 != null && propertyName != null && pv.propertyName.equals(propertyName)) {
            Object value = pv.value;
            if (value == null) {
                _logger.info((Object)("Null return value for property name " + pv.propertyName + " with expected type " + type2.getName()));
                return false;
            }
            if (type2.isInstance(value)) {
                return true;
            }
            _logger.error((Object)("Unexpected value type for property " + pv.propertyName + ", Expected " + type2.getName() + ", type was " + value.getClass().getName()));
        }
        return false;
    }

    public static <T> T getPropertyValue(ResultItem resItem, String propName) {
        PropertyValue propValue = ResultUtil.getPropertyValue((ResultItem)resItem, (String)propName);
        if (propValue != null && propValue.value != null) {
            return (T)propValue.value;
        }
        return null;
    }

    public static int getIntPropertyValue(ResultItem resItem, String propName) {
        Integer value = (Integer)Util.getPropertyValue(resItem, propName);
        if (value != null) {
            return value;
        }
        return 0;
    }

    public static Map<Object, Map<String, Object>> propertyValuesToMap(PropertyValue[] values) {
        if (values == null) {
            return null;
        }
        HashMap<Object, Map<String, Object>> rs = new HashMap<Object, Map<String, Object>>();
        Util.appendPropertyValuesToMap(rs, values);
        return rs;
    }

    public static void appendPropertyValuesToMap(Map<Object, Map<String, Object>> resultMap, PropertyValue[] values) {
        if (values == null) {
            return;
        }
        Validate.notNull(resultMap, (String)"The resultMap argument cannot be null.");
        for (PropertyValue pv : values) {
            if (!resultMap.containsKey(pv.resourceObject)) {
                resultMap.put(pv.resourceObject, new HashMap());
            }
            Map<String, Object> map = resultMap.get(pv.resourceObject);
            map.put(pv.propertyName, pv.value);
        }
    }

    public static Map<Object, Map<String, Object>> resultSetToMap(ResultSet resultSet) {
        if (resultSet == null) {
            return null;
        }
        HashMap<Object, Map<String, Object>> rs = new HashMap<Object, Map<String, Object>>();
        for (ResultItem ri : resultSet.items) {
            if (!rs.containsKey(ri.resourceObject)) {
                rs.put(ri.resourceObject, new HashMap());
            }
            for (PropertyValue pv : ri.properties) {
                Map map = (Map)rs.get(ri.resourceObject);
                map.put(pv.propertyName, pv.value);
            }
        }
        return rs;
    }

    public static ResultSet validateResultSet(String queryId, ResultSet rs) {
        Validate.notEmpty((String)queryId, (String)"The queryId argument cannot be null or empty.");
        if (rs == null) {
            _logger.error((Object)("Result set for query " + queryId + " is null"));
            throw new RuntimeException("Could not retrieve data for query " + queryId);
        }
        if (rs.error != null) {
            _logger.error((Object)("Error retrieving data for query " + queryId), (Throwable)rs.error);
            throw new RuntimeException(rs.error);
        }
        return rs;
    }

    public static ResultSet findResultSetByName(String name, Response response) {
        Validate.notNull((Object)name, (String)"The name argument cannot be null.");
        Validate.notNull((Object)response, (String)"The response argument cannot be null.");
        if (response.resultSet == null) {
            return null;
        }
        for (ResultSet resultSet : response.resultSet) {
            if (!name.equals(resultSet.queryName)) continue;
            return resultSet;
        }
        return null;
    }

    public static boolean isFieldInitialized(boolean condition, DataObject object, String fieldName) {
        if (!condition) {
            if (_logger.isWarnEnabled()) {
                _logger.warn((Object)String.format("Required field is not initialized: %s.%s", object.getClass().getSimpleName(), fieldName));
            }
            return false;
        }
        return true;
    }

    public static List<String> checkEntitiesWithMissingPrivileges(PropertyValue[] entityNames, String[] privileges, LegacyAuthorizationService authorizationService) throws Exception {
        ArrayList<String> noPrivList = new ArrayList<String>();
        if (entityNames != null) {
            for (PropertyValue pv : entityNames) {
                ManagedObjectReference ref = (ManagedObjectReference)pv.resourceObject;
                boolean privilegeGranted = authorizationService.checkPrivileges(new ManagedObjectReference[]{ref}, privileges);
                if (privilegeGranted) continue;
                noPrivList.add((String)pv.value);
            }
        }
        return noPrivList;
    }

    public static String formatPortGroupType(String portBinding, Boolean isElastic) {
        if (StringUtil.isNullOrEmpty((String)portBinding)) {
            return Util.getLocalizedString("noData");
        }
        String portBindingLabel = null;
        switch (DistributedVirtualPortgroup.PortgroupType.valueOf((String)portBinding)) {
            case earlyBinding: {
                if (isElastic != null && isElastic.booleanValue()) {
                    portBindingLabel = Util.getLocalizedString("dvPortGroup.portBinding.staticElastic");
                    break;
                }
                portBindingLabel = Util.getLocalizedString("dvPortGroup.portBinding.static");
                break;
            }
            case ephemeral: {
                portBindingLabel = Util.getLocalizedString("dvPortGroup.portBinding.ephemeral");
                break;
            }
            case lateBinding: {
                portBindingLabel = Util.getLocalizedString("dvPortGroup.portBinding.dynamic");
                break;
            }
            default: {
                portBindingLabel = Util.getLocalizedString("noData");
            }
        }
        return portBindingLabel;
    }

    public static String formatVlanTrunkRange(NumericRange[] vlanTrunkRange) {
        StringBuilder vlanId = new StringBuilder();
        if (!ArrayUtil.isNullOrEmpty((Object[])vlanTrunkRange)) {
            for (int i = 0; i < vlanTrunkRange.length; ++i) {
                NumericRange nr = vlanTrunkRange[i];
                if (nr != null) {
                    if (nr.start == nr.end) {
                        vlanId.append(nr.start);
                    } else {
                        vlanId.append(nr.start);
                        vlanId.append("-");
                        vlanId.append(nr.end);
                    }
                } else {
                    _logger.error((Object)"Null NumericRange detected!");
                }
                if (i >= vlanTrunkRange.length - 1) continue;
                vlanId.append(", ");
            }
        }
        return vlanId.toString();
    }

    public static String formatPvlanEntry(VmwareDistributedVirtualSwitch.PvlanMapEntry pvlanEntry, String formatString) {
        if (pvlanEntry == null || StringUtil.isNullOrEmpty((String)formatString)) {
            return Util.getLocalizedString("noData");
        }
        String pvlanLabel = null;
        switch (VmwareDistributedVirtualSwitch.PvlanPortType.valueOf((String)pvlanEntry.pvlanType)) {
            case promiscuous: {
                pvlanLabel = String.format(formatString, Util.getLocalizedString("dvPortGroup.pvlan.promiscuous"), pvlanEntry.primaryVlanId, pvlanEntry.secondaryVlanId);
                break;
            }
            case isolated: {
                pvlanLabel = String.format(formatString, Util.getLocalizedString("dvPortGroup.pvlan.isolated"), pvlanEntry.primaryVlanId, pvlanEntry.secondaryVlanId);
                break;
            }
            case community: {
                pvlanLabel = String.format(formatString, Util.getLocalizedString("dvPortGroup.pvlan.community"), pvlanEntry.primaryVlanId, pvlanEntry.secondaryVlanId);
                break;
            }
            default: {
                pvlanLabel = Util.getLocalizedString("noData");
            }
        }
        return pvlanLabel;
    }

    public static String formatLacpVersion(String lacpApiVersion, Boolean lacpCapability) {
        if (StringUtil.isNullOrEmpty((String)lacpApiVersion)) {
            return Util.getLocalizedString("noData");
        }
        String lacpVersionLabel = "";
        if (!lacpCapability.booleanValue()) {
            lacpVersionLabel = Util.getLocalizedString("noData");
        } else {
            switch (VmwareDistributedVirtualSwitch.LacpApiVersion.valueOf((String)lacpApiVersion)) {
                case singleLag: {
                    lacpVersionLabel = Util.getLocalizedString("lacp.version.singleLag");
                    break;
                }
                case multipleLag: {
                    lacpVersionLabel = Util.getLocalizedString("lacp.version.multipleLag");
                    break;
                }
                default: {
                    lacpVersionLabel = Util.getLocalizedString("noData");
                }
            }
        }
        return lacpVersionLabel;
    }

    public static String getLocalizedString(String key) {
        return ResourceUtil.getString((String)NETWORK_SERVICE_STRINGS, (String)key, (ClassLoader)Util.class.getClassLoader());
    }
}

