/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.network.host.iscsi.impl;

import com.vmware.vim.binding.vim.fault.IscsiFaultVnicInUse;
import com.vmware.vim.binding.vim.host.IscsiManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.network.IscsiMigrationSpec;
import com.vmware.vsphere.client.network.host.iscsi.info.IscsiMigrationStatusInfo;
import com.vmware.vsphere.client.network.host.iscsi.info.VnicIscsiStatusInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeSet;

public class IscsiPortInfoPropertyProvider
implements PropertyProviderBean {
    private DataService _dataService;

    public IscsiPortInfoPropertyProvider(DataService dataService) {
        this._dataService = dataService;
    }

    @type(value="HostSystem")
    public IscsiManager.IscsiPortInfo[] getBoundIscsiPortInfo(ManagedObjectReference hostRef, String iscsiHbaName) throws Exception {
        IscsiManager.IscsiPortInfo[] res = new IscsiManager.IscsiPortInfo[]{};
        ManagedObjectReference iscsiMangerObjref = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)hostRef, (String)"iscsiManager");
        IscsiManager iscsiManager = (IscsiManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)iscsiMangerObjref);
        if (iscsiManager == null) {
            return res;
        }
        IscsiManager.IscsiPortInfo[] iscsiPortInfoObjects = iscsiManager.queryBoundVnics(iscsiHbaName);
        if (iscsiPortInfoObjects == null) {
            return res;
        }
        res = iscsiPortInfoObjects;
        return res;
    }

    @type(value="HostSystem")
    public IscsiManager.IscsiPortInfo[] getCandidateIscsiInfo(ManagedObjectReference hostRef, String iscsiHbaName) throws Exception {
        ManagedObjectReference iscsiMangerObjref = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)hostRef, (String)"iscsiManager");
        IscsiManager iscsiManager = (IscsiManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)iscsiMangerObjref);
        if (iscsiManager == null) {
            return null;
        }
        IscsiManager.IscsiPortInfo[] iscsiPortInfoObjects = iscsiManager.queryCandidateNics(iscsiHbaName);
        if (iscsiPortInfoObjects == null) {
            return null;
        }
        return iscsiPortInfoObjects;
    }

    @type(value="HostSystem")
    public IscsiMigrationStatusInfo getIscsiMigrationInfo(ManagedObjectReference hostRef, IscsiMigrationSpec iscsiSpec) throws Exception {
        IscsiMigrationStatusInfo migrationInfo = new IscsiMigrationStatusInfo();
        migrationInfo.hostRef = hostRef;
        ManagedObjectReference iscsiManagerRef = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)hostRef, (String)"iscsiManager");
        if (iscsiManagerRef == null) {
            migrationInfo.isIscsiPortBindingSupported = false;
            return migrationInfo;
        }
        IscsiManager iscsiManager = (IscsiManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)iscsiManagerRef);
        if (iscsiManager == null) {
            migrationInfo.isIscsiPortBindingSupported = false;
        } else {
            migrationInfo.isIscsiPortBindingSupported = true;
            if (!ArrayUtil.isNullOrEmpty((Object[])iscsiSpec.pnicDevices)) {
                migrationInfo.pnicMigrationDependency = iscsiManager.queryMigrationDependencies(iscsiSpec.pnicDevices);
            }
            ArrayList<VnicIscsiStatusInfo> vnicInfoList = new ArrayList<VnicIscsiStatusInfo>();
            TreeSet vnicSet = new TreeSet();
            if (iscsiSpec.vnicDevices != null) {
                Collections.addAll(vnicSet, iscsiSpec.vnicDevices);
            }
            if (iscsiSpec.vnicDevicesToRemove != null) {
                Collections.addAll(vnicSet, iscsiSpec.vnicDevicesToRemove);
            }
            if (!vnicSet.isEmpty()) {
                IscsiManager.IscsiMigrationDependency unchagedPnicDependency = null;
                if (!ArrayUtil.isNullOrEmpty((Object[])iscsiSpec.unchangedPnicDevices)) {
                    unchagedPnicDependency = iscsiManager.queryMigrationDependencies(iscsiSpec.unchangedPnicDevices);
                }
                for (String vnic : vnicSet) {
                    VnicIscsiStatusInfo vnicStatusInfo = new VnicIscsiStatusInfo();
                    vnicStatusInfo.vnicDevice = vnic;
                    vnicStatusInfo.isIscsiPortBound = false;
                    vnicInfoList.add(vnicStatusInfo);
                    IscsiManager.IscsiStatus iscsiStatus = iscsiManager.queryVnicStatus(vnic);
                    if (iscsiStatus != null && iscsiStatus.reason != null) {
                        for (Exception ex : iscsiStatus.reason) {
                            if (!(ex instanceof IscsiFaultVnicInUse)) continue;
                            vnicStatusInfo.isIscsiPortBound = true;
                        }
                    }
                    if (!vnicStatusInfo.isIscsiPortBound) continue;
                    vnicStatusInfo.pnicDevice = this.getBoundPnic(vnic, migrationInfo.pnicMigrationDependency);
                    if (!StringUtil.isNullOrEmpty((String)vnicStatusInfo.pnicDevice)) continue;
                    vnicStatusInfo.pnicDevice = this.getBoundPnic(vnic, unchagedPnicDependency);
                }
            }
            if (vnicInfoList.size() > 0) {
                migrationInfo.vnicIscsiStatus = vnicInfoList.toArray(new VnicIscsiStatusInfo[vnicInfoList.size()]);
            }
        }
        return migrationInfo;
    }

    private String getBoundPnic(String vnicDevice, IscsiManager.IscsiMigrationDependency migrationDependency) {
        if (StringUtil.isNullOrEmpty((String)vnicDevice) || migrationDependency == null || ArrayUtil.isNullOrEmpty((Object[])migrationDependency.dependency)) {
            return null;
        }
        String result = null;
        for (IscsiManager.IscsiDependencyEntity entity : migrationDependency.dependency) {
            if (entity == null || !vnicDevice.equals(entity.vnicDevice)) continue;
            result = entity.pnicDevice;
            break;
        }
        return result;
    }
}

