/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dvs.impl;

import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.NetworkResourcePool;
import com.vmware.vim.binding.vim.dvs.PortConnection;
import com.vmware.vim.binding.vim.dvs.VmVnicNetworkResourcePool;
import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.dvs.api.featureupgrade.ValidationCheckResult;
import com.vmware.vsphere.client.dvs.api.info.DvsResControlStatistics;
import com.vmware.vsphere.client.dvs.api.spec.DvsResControlUpgradeStatistics;
import com.vmware.vsphere.client.dvs.api.spec.DvsVmResControlSpec;
import com.vmware.vsphere.client.dvs.api.spec.VmResControlConfigInfoSpec;
import com.vmware.vsphere.client.dvs.api.spec.VmResControlSpec;
import com.vmware.vsphere.client.dvs.api.spec.VmVnicInfoSpec;
import com.vmware.vsphere.client.dvs.api.spec.VmVnicSpec;
import com.vmware.vsphere.client.dvs.impl.DvsResControlUpgradePrerequisitesValidator;
import com.vmware.vsphere.client.dvs.impl.DvsUtil;
import com.vmware.vsphere.client.dvs.impl.VmUpdateResControlInfo;
import com.vmware.vsphere.client.networking.util.I18nUtil;
import com.vmware.vsphere.client.networking.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvsResControlPropertyProvider
implements PropertyProviderBean {
    private static final String PROP_NAME = "name";
    private static final String PROP_KEY = "key";
    private static final String PROP_ICON_ID = "primaryIconId";
    private static final String PROP_LABELIDS = "labelIds";
    private static final String PROP_DVS_UUID = "uuid";
    private static final String PROP_DVS_CAP_HIGH_SHARES = "capability.featuresSupported.networkResourceManagementCapability.networkResourcePoolHighShareValue";
    private static final String PROP_DVS_INFRASTRUCTURE_TRAFFIC = "config.infrastructureTrafficResourceConfig";
    private static final String PROP_DVS_NETWORK_RESOURCE_POOL = "config.vmVnicNetworkResourcePool";
    private static final String PROP_DVS_PNIC_CAPACITY_RATIO = "config.pnicCapacityRatioForReservation";
    private static final String PROP_DVS_NETWORK_RESOURCE_POOL_NAMES = "networkResourcePoolNames";
    private static final String PROP_DVS_TOTAL_NETWORK_RESOURCE_POOL_RESERVATION = "totalNetworkResourcePoolReservation";
    private static final String PROP_DVS_VIRTUAL_MACHINE_VNIC_RESERVATION = "runtime.resourceRuntimeInfo.allocatedResource";
    private static final String PROP_DVPG_RES_POOL_KEY = "config.vmVnicNetworkResourcePoolKey";
    private static final String PROP_HOST_CONNECTION_STATE = "connectionState";
    private static final String PROP_HOST_POWER_STATE = "powerState";
    private static final String PROP_HOST_PNIC = "config.network.pnic";
    private static final String PROP_HOST_PROXYSWITCH = "config.network.proxySwitch";
    private static final String PROP_VM_DVS_NIC = "virtualEthernetDistributedBacking";
    private static final String PROP_VM_CONNECTION_STATE = "runtime.connectionState";
    private static final String PROP_VM_CHANGE_VERSION = "config.changeVersion";
    private static final String PROP_VM_HOST = "host";
    private static final String PROP_DVPG_VM_COUNT = "vm._length";
    private static final String RELATION_PORTGROUP = "portgroup";
    private static final String RELATION_HOST = "summary.hostMember";
    private static final String RELATION_VM = "vm";
    private static final int DEFAULT_HIGH_SHARES = 100;
    private static final int DEFAULT_MAX_LIMIT_MBPS = 10000;
    private static final int MAX_NUMBER_DATA_SERVICE_CONSTRAINTS = 50;
    private static Log _logger = LogFactory.getLog(DvsResControlPropertyProvider.class);
    private final DataService _dataService;
    private final DvsResControlUpgradePrerequisitesValidator _resControlUpgradePrerequisitesValidator;

    public DvsResControlPropertyProvider(DataService dataService, DvsResControlUpgradePrerequisitesValidator resControlPrerequisiteValidator) {
        this._dataService = dataService;
        this._resControlUpgradePrerequisitesValidator = resControlPrerequisiteValidator;
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch")
    public DistributedVirtualSwitch.HostInfrastructureTrafficResource getInfrastructureTrafficConfig(ManagedObjectReference dvsRef, String trafficKey) throws Exception {
        if (this._dataService == null || dvsRef == null || StringUtil.isNullOrEmpty((String)trafficKey)) {
            _logger.error((Object)"Invalid argument specified.", (Throwable)MixedUtil.getInvalidEntityFault());
            return null;
        }
        Object[] dvsProperties = QueryUtil.getProperties((DataService)this._dataService, (Object)dvsRef, (String[])new String[]{PROP_DVS_INFRASTRUCTURE_TRAFFIC});
        if (ArrayUtil.isNullOrEmpty((Object[])dvsProperties)) {
            throw new Exception(I18nUtil.text("dvs.error.notFound", new String[0]));
        }
        Object infrastructureTraffic = null;
        block0: for (Object prop : dvsProperties) {
            Object[] infrastructureTrafficConfigs;
            if (((PropertyValue)prop).value == null || !PROP_DVS_INFRASTRUCTURE_TRAFFIC.equals(((PropertyValue)prop).propertyName) || ArrayUtil.isNullOrEmpty((Object[])(infrastructureTrafficConfigs = (DistributedVirtualSwitch.HostInfrastructureTrafficResource[])((PropertyValue)prop).value))) continue;
            for (Object trafficConfig : infrastructureTrafficConfigs) {
                if (!trafficKey.equals(((DistributedVirtualSwitch.HostInfrastructureTrafficResource)trafficConfig).key)) continue;
                infrastructureTraffic = trafficConfig;
                continue block0;
            }
        }
        return infrastructureTraffic;
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch")
    public VmVnicNetworkResourcePool getVmVnicResourcePoolConfig(ManagedObjectReference dvsRef, String resourcePoolKey) throws Exception {
        if (this._dataService == null || dvsRef == null) {
            _logger.error((Object)"Invalid argument specified.", (Throwable)MixedUtil.getInvalidEntityFault());
            return null;
        }
        if (StringUtil.isNullOrEmpty((String)resourcePoolKey)) {
            return null;
        }
        Object[] dvsProperties = QueryUtil.getProperties((DataService)this._dataService, (Object)dvsRef, (String[])new String[]{PROP_DVS_NETWORK_RESOURCE_POOL});
        if (ArrayUtil.isNullOrEmpty((Object[])dvsProperties)) {
            throw new Exception(I18nUtil.text("dvs.error.notFound", new String[0]));
        }
        Object resourcePool = null;
        block0: for (Object prop : dvsProperties) {
            Object[] resourcePoolConfigs;
            if (((PropertyValue)prop).value == null || !PROP_DVS_NETWORK_RESOURCE_POOL.equals(((PropertyValue)prop).propertyName) || ArrayUtil.isNullOrEmpty((Object[])(resourcePoolConfigs = (VmVnicNetworkResourcePool[])((PropertyValue)prop).value))) continue;
            for (Object config : resourcePoolConfigs) {
                if (!resourcePoolKey.equals(((VmVnicNetworkResourcePool)config).key)) continue;
                resourcePool = config;
                continue block0;
            }
        }
        return resourcePool;
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch")
    public String[] getVmVnicResourcePoolNames(ManagedObjectReference dvsRef) throws Exception {
        if (this._dataService == null || dvsRef == null) {
            _logger.error((Object)"Invalid argument specified.", (Throwable)MixedUtil.getInvalidEntityFault());
            return null;
        }
        Object[] dvsProperties = QueryUtil.getProperties((DataService)this._dataService, (Object)dvsRef, (String[])new String[]{PROP_DVS_NETWORK_RESOURCE_POOL_NAMES});
        if (ArrayUtil.isNullOrEmpty((Object[])dvsProperties)) {
            return null;
        }
        String[] names = null;
        for (Object prop : dvsProperties) {
            if (((PropertyValue)prop).value == null || !PROP_DVS_NETWORK_RESOURCE_POOL_NAMES.equals(((PropertyValue)prop).propertyName) || !(((PropertyValue)prop).value instanceof Object[])) continue;
            Object[] nameObjectArray = (Object[])((PropertyValue)prop).value;
            names = (String[])Arrays.copyOf(nameObjectArray, nameObjectArray.length, String[].class);
        }
        return names;
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch")
    public DvsResControlStatistics getResControlStatistics(ManagedObjectReference dvsRef) throws Exception {
        return this.getResControlStatistics(dvsRef, null);
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch")
    public DvsVmResControlSpec getResourceControlVms(ManagedObjectReference dvsRef, String resourcePoolKey) throws Exception {
        if (this._dataService == null || dvsRef == null || StringUtil.isNullOrEmpty((String)resourcePoolKey)) {
            _logger.error((Object)"Invalid argument specified.", (Throwable)MixedUtil.getInvalidEntityFault());
            return null;
        }
        Object[] dvsProperties = QueryUtil.getProperties((DataService)this._dataService, (Object)dvsRef, (String[])new String[]{PROP_DVS_UUID, PROP_DVS_CAP_HIGH_SHARES});
        if (ArrayUtil.isNullOrEmpty((Object[])dvsProperties)) {
            throw new Exception(I18nUtil.text("dvs.error.notFound", new String[0]));
        }
        Constraint pgConstraint = this.getPortgroupConstraint(dvsRef, resourcePoolKey);
        ResultSet dvpgResults = this.getPortgroupsData(pgConstraint);
        if (dvpgResults.error != null) {
            _logger.error((Object)dvpgResults.error);
        }
        ResultSet vmResults = this.getVmData(pgConstraint);
        if (vmResults.error != null) {
            _logger.error((Object)vmResults.error);
        }
        return this.processVmResControlData(dvsRef, (PropertyValue[])dvsProperties, dvpgResults, vmResults);
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch")
    public VmResControlConfigInfoSpec getResourceControlVmConfig(ManagedObjectReference dvsRef, Object[] vmVnicInfoSpec) throws Exception {
        if (this._dataService == null || dvsRef == null || ArrayUtil.isNullOrEmpty((Object[])vmVnicInfoSpec)) {
            _logger.error((Object)"Invalid argument specified.", (Throwable)MixedUtil.getInvalidEntityFault());
            return null;
        }
        Map<ManagedObjectReference, VmUpdateResControlInfo> vmMap = this.getVmUpdateInfoMap(vmVnicInfoSpec);
        HashSet<ManagedObjectReference> hostSet = new HashSet<ManagedObjectReference>();
        PropertyValue[] vmProperties = this.queryVmVnicBatchUpdateInfo(vmMap);
        this.processVmVnicBatchUpdateInfo(vmProperties, vmMap, hostSet);
        DvsResControlStatistics stats = this.getResControlStatistics(dvsRef, hostSet);
        this.validateVmVnicBatchUpdateInfo(vmMap, stats.dvsUuid);
        VmResControlConfigInfoSpec configInfo = new VmResControlConfigInfoSpec();
        configInfo.highShareValue = 100;
        configInfo.maxReservation = Math.min(stats.maxPnicLinkSpeed, stats.reservedVmTrafficBandwidth);
        configInfo.maxLimit = stats.maxPnicLinkSpeed;
        if (stats.vmTrafficLimit > 0 && stats.vmTrafficLimit < stats.maxPnicLinkSpeed) {
            configInfo.maxLimit = stats.vmTrafficLimit;
        }
        if (configInfo.maxLimit == 0) {
            configInfo.maxLimit = 10000;
        }
        ArrayList<VmVnicSpec> vmVnicSpecList = new ArrayList<VmVnicSpec>();
        for (VmUpdateResControlInfo updateInfo : vmMap.values()) {
            vmVnicSpecList.add(updateInfo.toVmVnicSpec());
        }
        configInfo.vmVnicSpec = vmVnicSpecList.toArray(new VmVnicSpec[vmVnicSpecList.size()]);
        return configInfo;
    }

    @type(value="VmwareDistributedVirtualSwitch")
    public ValidationCheckResult[] getResControlUpgradePrerequisites(ManagedObjectReference dvsRef) throws Exception {
        return this._resControlUpgradePrerequisitesValidator.validatePrerequisites(dvsRef);
    }

    @type(value="VmwareDistributedVirtualSwitch")
    public DvsResControlUpgradeStatistics getResControlUpgradeStatistics(ManagedObjectReference dvsRef) throws Exception {
        DvsResControlUpgradeStatistics stats = new DvsResControlUpgradeStatistics();
        NetworkResourcePool[] pools = (NetworkResourcePool[])QueryUtil.getProperty((DataService)this._dataService, (Object)dvsRef, (String)"networkResourcePool");
        stats.userDefinedNrpCount = 0;
        stats.modifiedSystemNrpCount = 0;
        if (pools == null) {
            return stats;
        }
        for (NetworkResourcePool pool : pools) {
            if (!DvsUtil.isSystemNetworkResourcePool(pool.key)) {
                ++stats.userDefinedNrpCount;
                continue;
            }
            if (!DvsUtil.isCosTagSpecified(pool)) continue;
            ++stats.modifiedSystemNrpCount;
        }
        stats.modifiedPortGroupCount = 0;
        stats.modifiedVmCount = 0;
        if (stats.userDefinedNrpCount == 0) {
            return stats;
        }
        Constraint constraint = DvsUtil.createPortGroupsWithNrpConstraint(dvsRef);
        QuerySpec query = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])new String[]{PROP_DVPG_VM_COUNT});
        Map<Object, Map<String, Object>> rs = Util.resultSetToMap(QueryUtil.getData((DataService)this._dataService, (QuerySpec)query));
        if (rs == null) {
            _logger.error((Object)"Could not retrieve data for port groups associated with user-defined NRPs.", (Throwable)MixedUtil.getInvalidEntityFault());
            return stats;
        }
        stats.modifiedPortGroupCount = rs.size();
        for (Map<String, Object> resultItem : rs.values()) {
            Integer vmCount = (Integer)resultItem.get(PROP_DVPG_VM_COUNT);
            if (vmCount == null) continue;
            stats.modifiedVmCount += vmCount.intValue();
        }
        return stats;
    }

    private DvsResControlStatistics getResControlStatistics(ManagedObjectReference dvsRef, Set<ManagedObjectReference> hostRefFilter) throws Exception {
        if (this._dataService == null || dvsRef == null) {
            _logger.error((Object)"Invalid argument specified.", (Throwable)MixedUtil.getInvalidEntityFault());
            return null;
        }
        Object[] dvsProperties = QueryUtil.getProperties((DataService)this._dataService, (Object)dvsRef, (String[])new String[]{PROP_DVS_UUID, PROP_DVS_INFRASTRUCTURE_TRAFFIC, PROP_DVS_TOTAL_NETWORK_RESOURCE_POOL_RESERVATION, PROP_DVS_PNIC_CAPACITY_RATIO, PROP_DVS_VIRTUAL_MACHINE_VNIC_RESERVATION});
        if (ArrayUtil.isNullOrEmpty((Object[])dvsProperties)) {
            throw new Exception(I18nUtil.text("dvs.error.notFound", new String[0]));
        }
        boolean hasDataServiceHostFilter = hostRefFilter != null && hostRefFilter.size() > 0 && hostRefFilter.size() <= 50;
        QuerySpec hostSpec = hasDataServiceHostFilter ? this.getDvsHostsQuerySpec(dvsRef, hostRefFilter) : this.getDvsHostsQuerySpec(dvsRef, null);
        ResultSet hostResults = QueryUtil.getData((DataService)this._dataService, (QuerySpec)hostSpec);
        if (hostResults.error != null) {
            _logger.error((Object)hostResults.error);
        }
        return this.processResControlStatisticsData(dvsRef, hostRefFilter, (PropertyValue[])dvsProperties, hostResults);
    }

    private QuerySpec getDvsHostsQuerySpec(ManagedObjectReference dvsRef, Set<ManagedObjectReference> hostRefFilter) {
        Constraint[] constraintArray;
        Constraint hostFilterConstraint;
        Constraint dvsHostConstraint = QueryUtil.createConstraintForRelationship((Object)dvsRef, (String)RELATION_HOST, (String)HostSystem.class.getSimpleName());
        PropertyConstraint hostConnectionPropConstraint = QueryUtil.createPropertyConstraint((String)HostSystem.class.getSimpleName(), (String)PROP_HOST_CONNECTION_STATE, (Comparator)Comparator.EQUALS, (Object)HostSystem.ConnectionState.connected.name());
        PropertyConstraint hostPowerStatePropConstraint = QueryUtil.createPropertyConstraint((String)HostSystem.class.getSimpleName(), (String)PROP_HOST_POWER_STATE, (Comparator)Comparator.EQUALS, (Object)HostSystem.PowerState.poweredOn.name());
        ArrayList<ObjectIdentityConstraint> hostConstraintList = new ArrayList<ObjectIdentityConstraint>();
        if (hostRefFilter != null && hostRefFilter.size() > 0) {
            for (ManagedObjectReference hostRef : hostRefFilter) {
                hostConstraintList.add(QueryUtil.createObjectIdentityConstraint((Object)hostRef));
            }
        }
        if ((hostFilterConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])hostConstraintList.toArray(new Constraint[hostConstraintList.size()]), (Conjoiner)Conjoiner.OR)) == null) {
            Constraint[] constraintArray2 = new Constraint[3];
            constraintArray2[0] = dvsHostConstraint;
            constraintArray2[1] = hostConnectionPropConstraint;
            constraintArray = constraintArray2;
            constraintArray2[2] = hostPowerStatePropConstraint;
        } else {
            Constraint[] constraintArray3 = new Constraint[4];
            constraintArray3[0] = dvsHostConstraint;
            constraintArray3[1] = hostConnectionPropConstraint;
            constraintArray3[2] = hostPowerStatePropConstraint;
            constraintArray = constraintArray3;
            constraintArray3[3] = hostFilterConstraint;
        }
        Constraint[] hostConstraints = constraintArray;
        Constraint hostConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])hostConstraints, (Conjoiner)Conjoiner.AND);
        QuerySpec hostSpec = QueryUtil.buildQuerySpec((Constraint)hostConstraint, (String[])new String[]{PROP_HOST_PNIC, PROP_HOST_PROXYSWITCH});
        return hostSpec;
    }

    private Map<ManagedObjectReference, VmUpdateResControlInfo> getVmUpdateInfoMap(Object[] vmVnicInfoSpec) {
        HashMap<ManagedObjectReference, VmUpdateResControlInfo> vmMap = new HashMap<ManagedObjectReference, VmUpdateResControlInfo>();
        for (Object vmObj : vmVnicInfoSpec) {
            if (!(vmObj instanceof VmVnicInfoSpec)) continue;
            VmVnicInfoSpec vmInfo = (VmVnicInfoSpec)vmObj;
            VmUpdateResControlInfo updateInfo = (VmUpdateResControlInfo)vmMap.get(vmInfo.vmRef);
            if (updateInfo == null) {
                updateInfo = new VmUpdateResControlInfo(vmInfo.vmRef);
                vmMap.put(vmInfo.vmRef, updateInfo);
            }
            if (vmInfo.deviceKey == null) continue;
            for (int deviceKey : vmInfo.deviceKey) {
                updateInfo.deviceKeys.add(deviceKey);
            }
        }
        return vmMap;
    }

    private PropertyValue[] queryVmVnicBatchUpdateInfo(Map<ManagedObjectReference, VmUpdateResControlInfo> vmMap) throws Exception {
        Object[] vmRefs = vmMap.keySet().toArray(new ManagedObjectReference[vmMap.size()]);
        PropertyValue[] vmProperties = QueryUtil.getProperties((DataService)this._dataService, (Object[])vmRefs, (String[])new String[]{PROP_VM_HOST, PROP_VM_CHANGE_VERSION, PROP_VM_CONNECTION_STATE, PROP_VM_DVS_NIC});
        return vmProperties;
    }

    private void validateVmVnicBatchUpdateInfo(Map<ManagedObjectReference, VmUpdateResControlInfo> vmMap, String dvsUuid) {
        for (VmUpdateResControlInfo updateInfo : vmMap.values()) {
            Iterator<VirtualEthernetCard> iterator = updateInfo.virtualEthernetCards.iterator();
            while (iterator.hasNext()) {
                VirtualEthernetCard nic = iterator.next();
                if (!(nic.backing instanceof VirtualEthernetCard.DistributedVirtualPortBackingInfo)) continue;
                VirtualEthernetCard.DistributedVirtualPortBackingInfo backing = (VirtualEthernetCard.DistributedVirtualPortBackingInfo)nic.backing;
                if (backing.port != null && dvsUuid.equals(backing.port.switchUuid)) continue;
                iterator.remove();
            }
        }
    }

    private void processVmVnicBatchUpdateInfo(PropertyValue[] vmProperties, Map<ManagedObjectReference, VmUpdateResControlInfo> vmMap, Set<ManagedObjectReference> hostSet) throws Exception {
        if (ArrayUtil.isNullOrEmpty((Object[])vmProperties)) {
            throw new Exception(I18nUtil.text("vm.batchUpdateResControl.error.notFound", new String[0]));
        }
        for (PropertyValue prop : vmProperties) {
            if (prop.value == null || !(prop.resourceObject instanceof ManagedObjectReference)) continue;
            ManagedObjectReference vmRef = (ManagedObjectReference)prop.resourceObject;
            VmUpdateResControlInfo updateInfo = vmMap.get(vmRef);
            assert (updateInfo != null);
            updateInfo.isVmAvailable = true;
            if (PROP_VM_CONNECTION_STATE.equals(prop.propertyName)) {
                VirtualMachine.ConnectionState connectionState = (VirtualMachine.ConnectionState)prop.value;
                if (connectionState != VirtualMachine.ConnectionState.connected) continue;
                updateInfo.isVmConnected = true;
                continue;
            }
            if (PROP_VM_DVS_NIC.equals(prop.propertyName)) {
                Object[] ethernetCards = (VirtualDevice[])prop.value;
                if (ArrayUtil.isNullOrEmpty((Object[])ethernetCards)) continue;
                for (Object dev : ethernetCards) {
                    if (!(dev instanceof VirtualEthernetCard) || !(((VirtualDevice)dev).backing instanceof VirtualEthernetCard.DistributedVirtualPortBackingInfo)) continue;
                    VirtualEthernetCard nic = (VirtualEthernetCard)dev;
                    if (!updateInfo.deviceKeys.contains(nic.key)) continue;
                    updateInfo.virtualEthernetCards.add(nic);
                }
                continue;
            }
            if (PROP_VM_HOST.equals(prop.propertyName)) {
                if (!(prop.value instanceof ManagedObjectReference)) continue;
                hostSet.add((ManagedObjectReference)prop.value);
                continue;
            }
            if (!PROP_VM_CHANGE_VERSION.equals(prop.propertyName)) continue;
            updateInfo.changeVersion = (String)prop.value;
        }
    }

    private ResultSet getVmData(Constraint pgConstraint) throws Exception {
        RelationalConstraint dvpgVmConstraint = QueryUtil.createRelationalConstraint((String)RELATION_VM, (Constraint)pgConstraint, (Boolean)true, (String)VirtualMachine.class.getSimpleName());
        QuerySpec query = QueryUtil.buildQuerySpec((Constraint)dvpgVmConstraint, (String[])new String[]{PROP_NAME, PROP_ICON_ID, PROP_LABELIDS, PROP_VM_DVS_NIC});
        ResultSet vmResults = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
        return vmResults;
    }

    private ResultSet getPortgroupsData(Constraint pgConstraint) throws Exception {
        QuerySpec pgSpec = QueryUtil.buildQuerySpec((Constraint)pgConstraint, (String[])new String[]{PROP_KEY});
        ResultSet dvpgResults = QueryUtil.getData((DataService)this._dataService, (QuerySpec)pgSpec);
        return dvpgResults;
    }

    private Constraint getPortgroupConstraint(ManagedObjectReference dvsRef, String resourcePoolKey) {
        Constraint dvsDvpgConstraint = QueryUtil.createConstraintForRelationship((Object)dvsRef, (String)RELATION_PORTGROUP, (String)DistributedVirtualPortgroup.class.getSimpleName());
        PropertyConstraint dvpgPropConstraint = QueryUtil.createPropertyConstraint((String)DistributedVirtualPortgroup.class.getSimpleName(), (String)PROP_DVPG_RES_POOL_KEY, (Comparator)Comparator.EQUALS, (Object)resourcePoolKey);
        Constraint pgConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{dvsDvpgConstraint, dvpgPropConstraint}, (Conjoiner)Conjoiner.AND);
        return pgConstraint;
    }

    private DvsVmResControlSpec processVmResControlData(ManagedObjectReference dvsRef, PropertyValue[] dvsProperties, ResultSet dvpgResults, ResultSet vmResults) throws Exception {
        DvsVmResControlSpec dvsSpec = new DvsVmResControlSpec();
        dvsSpec.dvsRef = dvsRef;
        String dvsUuid = null;
        for (PropertyValue prop : dvsProperties) {
            if (prop.value == null) continue;
            if (PROP_DVS_UUID.equals(prop.propertyName)) {
                dvsUuid = (String)prop.value;
                continue;
            }
            if (!PROP_DVS_CAP_HIGH_SHARES.equals(prop.propertyName)) continue;
            dvsSpec.highShareValue = (Integer)prop.value;
        }
        if (StringUtil.isNullOrEmpty(dvsUuid)) {
            throw new Exception(I18nUtil.text("dvs.error.notFound", new String[0]));
        }
        HashSet<String> dvpgKeySet = new HashSet<String>();
        if (dvpgResults.items != null) {
            for (ResultItem pgItem : dvpgResults.items) {
                String pgKey = (String)Util.getPropertyValue(pgItem, PROP_KEY);
                if (StringUtil.isNullOrEmpty((String)pgKey)) continue;
                dvpgKeySet.add(pgKey);
            }
        }
        List<VmResControlSpec> vmResourceList = this.processVmProperties(vmResults, dvsUuid, dvpgKeySet);
        dvsSpec.vmResControlSpec = vmResourceList.toArray(new VmResControlSpec[vmResourceList.size()]);
        return dvsSpec;
    }

    private List<VmResControlSpec> processVmProperties(ResultSet vmResults, String dvsUuid, Set<String> dvpgKeySet) {
        ArrayList<VmResControlSpec> vmResourceList = new ArrayList<VmResControlSpec>();
        if (vmResults.items != null) {
            for (ResultItem vmItem : vmResults.items) {
                Object[] device = (VirtualDevice[])Util.getPropertyValue(vmItem, PROP_VM_DVS_NIC);
                if (ArrayUtil.isNullOrEmpty((Object[])device)) continue;
                for (Object dev : device) {
                    PortConnection portData;
                    if (!(dev instanceof VirtualEthernetCard)) continue;
                    VirtualEthernetCard vnic = (VirtualEthernetCard)dev;
                    if (!(vnic.backing instanceof VirtualEthernetCard.DistributedVirtualPortBackingInfo) || (portData = ((VirtualEthernetCard.DistributedVirtualPortBackingInfo)vnic.backing).port) == null || !dvsUuid.equals(portData.switchUuid) || !dvpgKeySet.contains(portData.portgroupKey)) continue;
                    VmResControlSpec vmSpec = new VmResControlSpec();
                    vmSpec.vmRef = (ManagedObjectReference)vmItem.resourceObject;
                    vmSpec.name = (String)Util.getPropertyValue(vmItem, PROP_NAME);
                    vmSpec.primaryIconId = (String)Util.getPropertyValue(vmItem, PROP_ICON_ID);
                    vmSpec.labelIds = (String)Util.getPropertyValue(vmItem, PROP_LABELIDS);
                    vmSpec.networkAdapterName = vnic.deviceInfo == null ? null : vnic.deviceInfo.label;
                    vmSpec.deviceKey = vnic.key;
                    vmSpec.resourceAllocation = vnic.resourceAllocation;
                    if (vmSpec.vmRef == null || StringUtil.isNullOrEmpty((String)vmSpec.name) || StringUtil.isNullOrEmpty((String)vmSpec.primaryIconId) || StringUtil.isNullOrEmpty((String)vmSpec.networkAdapterName) || vmSpec.deviceKey <= 0) {
                        _logger.error((Object)"Invalid virtual machine NIC properties.", (Throwable)MixedUtil.getInvalidEntityFault());
                        continue;
                    }
                    vmResourceList.add(vmSpec);
                }
            }
        }
        return vmResourceList;
    }

    private DvsResControlStatistics processResControlStatisticsData(ManagedObjectReference dvsRef, Set<ManagedObjectReference> hostRefFilter, PropertyValue[] dvsProperties, ResultSet hostResults) throws Exception {
        String dvsUuid = null;
        int reservedVmTrafficBandwidthMbps = 0;
        int vmTrafficLimitMbps = -1;
        int reservedInfrastructureTrafficBandwidthMbps = 0;
        int pnicCapacityRatio = 0;
        long reservedVmVnicPoolBandwidthMbps = 0L;
        long aggregatedVmBandwidthReservation = 0L;
        for (PropertyValue prop : dvsProperties) {
            if (prop.value == null) continue;
            if (PROP_DVS_UUID.equals(prop.propertyName)) {
                dvsUuid = (String)prop.value;
                continue;
            }
            if (PROP_DVS_INFRASTRUCTURE_TRAFFIC.equals(prop.propertyName)) {
                Object[] infrastructureTraffic = (DistributedVirtualSwitch.HostInfrastructureTrafficResource[])prop.value;
                if (ArrayUtil.isNullOrEmpty((Object[])infrastructureTraffic)) continue;
                Object[] objectArray = infrastructureTraffic;
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object trafficConfig = objectArray[i];
                    int reservation = ((DistributedVirtualSwitch.HostInfrastructureTrafficResource)trafficConfig).allocationInfo != null && ((DistributedVirtualSwitch.HostInfrastructureTrafficResource)trafficConfig).allocationInfo.reservation != null ? ((DistributedVirtualSwitch.HostInfrastructureTrafficResource)trafficConfig).allocationInfo.reservation.intValue() : 0;
                    int limit = ((DistributedVirtualSwitch.HostInfrastructureTrafficResource)trafficConfig).allocationInfo != null && ((DistributedVirtualSwitch.HostInfrastructureTrafficResource)trafficConfig).allocationInfo.limit != null ? ((DistributedVirtualSwitch.HostInfrastructureTrafficResource)trafficConfig).allocationInfo.limit.intValue() : -1;
                    reservedInfrastructureTrafficBandwidthMbps += reservation;
                    if (!DistributedVirtualSwitch.HostInfrastructureTrafficClass.virtualMachine.toString().equals(((DistributedVirtualSwitch.HostInfrastructureTrafficResource)trafficConfig).key)) continue;
                    reservedVmTrafficBandwidthMbps = reservation;
                    vmTrafficLimitMbps = limit;
                }
                continue;
            }
            if (PROP_DVS_TOTAL_NETWORK_RESOURCE_POOL_RESERVATION.equals(prop.propertyName)) {
                if (!(prop.value instanceof Long)) continue;
                reservedVmVnicPoolBandwidthMbps = prop.value != null ? (Long)prop.value : 0L;
                continue;
            }
            if (PROP_DVS_PNIC_CAPACITY_RATIO.equals(prop.propertyName)) {
                if (!(prop.value instanceof Integer)) continue;
                pnicCapacityRatio = (Integer)prop.value;
                continue;
            }
            if (!PROP_DVS_VIRTUAL_MACHINE_VNIC_RESERVATION.equals(prop.propertyName) || !(prop.value instanceof VmVnicNetworkResourcePool.VnicAllocatedResource[])) continue;
            for (VmVnicNetworkResourcePool.VnicAllocatedResource vnicReservation : (VmVnicNetworkResourcePool.VnicAllocatedResource[])prop.value) {
                aggregatedVmBandwidthReservation += vnicReservation.reservation.longValue();
            }
        }
        if (StringUtil.isNullOrEmpty(dvsUuid)) {
            throw new Exception(I18nUtil.text("dvs.error.notFound", new String[0]));
        }
        DvsResControlStatistics stats = new DvsResControlStatistics();
        stats.dvsUuid = dvsUuid;
        stats.reservedVmTrafficBandwidth = reservedVmTrafficBandwidthMbps;
        stats.vmTrafficLimit = vmTrafficLimitMbps;
        stats.reservedInfrastructureTrafficBandwidth = reservedInfrastructureTrafficBandwidthMbps;
        stats.reservedVmVnicPoolBandwidth = reservedVmVnicPoolBandwidthMbps;
        stats.pnicCapacityRatio = pnicCapacityRatio;
        stats.aggregatedVmBandwidthReservation = aggregatedVmBandwidthReservation;
        this.processHostProperties(hostRefFilter, hostResults, dvsUuid, stats);
        return stats;
    }

    private void processHostProperties(Set<ManagedObjectReference> hostRefFilter, ResultSet hostResults, String dvsUuid, DvsResControlStatistics stats) {
        int totalPnicCount = 0;
        int excludedPnicCount = 0;
        int minPnicLinkSpeedMbps = Integer.MAX_VALUE;
        int maxPnicLinkSpeedMbps = 0;
        int totalPnicBandwidthMbps = 0;
        int reservedPnicCount = 0;
        if (hostResults.items != null) {
            for (ResultItem hostItem : hostResults.items) {
                ManagedObjectReference hostRef;
                if (hostRefFilter != null && hostRefFilter.size() > 0 && !hostRefFilter.contains(hostRef = (ManagedObjectReference)hostItem.resourceObject)) continue;
                PhysicalNic[] pnics = (PhysicalNic[])Util.getPropertyValue(hostItem, PROP_HOST_PNIC);
                HostProxySwitch[] proxySwitches = (HostProxySwitch[])Util.getPropertyValue(hostItem, PROP_HOST_PROXYSWITCH);
                HostProxySwitch proxySwitch = this.getProxySwitch(proxySwitches, dvsUuid);
                List<PhysicalNic> proxySwitchPnics = this.getProxySwitchPhysicalNics(proxySwitch, pnics);
                for (PhysicalNic pnic : proxySwitchPnics) {
                    ++totalPnicCount;
                    boolean isNiocEnabledPnic = true;
                    if (pnic.resourcePoolSchedulerAllowed != null && !pnic.resourcePoolSchedulerAllowed.booleanValue()) {
                        ++excludedPnicCount;
                        isNiocEnabledPnic = false;
                    }
                    if (pnic.linkSpeed == null || pnic.linkSpeed.speedMb <= 0) continue;
                    if (isNiocEnabledPnic) {
                        maxPnicLinkSpeedMbps = Math.max(pnic.linkSpeed.speedMb, maxPnicLinkSpeedMbps);
                        minPnicLinkSpeedMbps = Math.min(pnic.linkSpeed.speedMb, minPnicLinkSpeedMbps);
                        if (pnic.linkSpeed.speedMb >= stats.reservedVmTrafficBandwidth) {
                            ++reservedPnicCount;
                        }
                    }
                    totalPnicBandwidthMbps += pnic.linkSpeed.speedMb;
                }
            }
        }
        minPnicLinkSpeedMbps = Math.min(minPnicLinkSpeedMbps, maxPnicLinkSpeedMbps);
        stats.totalPnicCount = totalPnicCount;
        stats.excludedPnicCount = excludedPnicCount;
        stats.maxPnicLinkSpeed = maxPnicLinkSpeedMbps;
        stats.minPnicLinkSpeed = minPnicLinkSpeedMbps;
        stats.totalPnicBandwidth = totalPnicBandwidthMbps;
        stats.totalVmVnicPoolBandwidth = reservedPnicCount * stats.reservedVmTrafficBandwidth;
    }

    private HostProxySwitch getProxySwitch(HostProxySwitch[] proxySwitches, String dvsUuid) {
        if (ArrayUtil.isNullOrEmpty((Object[])proxySwitches) || StringUtil.isNullOrEmpty((String)dvsUuid)) {
            return null;
        }
        for (HostProxySwitch proxySwitch : proxySwitches) {
            if (!dvsUuid.equals(proxySwitch.dvsUuid)) continue;
            return proxySwitch;
        }
        return null;
    }

    private List<PhysicalNic> getProxySwitchPhysicalNics(HostProxySwitch proxySwitch, PhysicalNic[] physicalNics) {
        ArrayList<PhysicalNic> switchPnics = new ArrayList<PhysicalNic>();
        if (ArrayUtil.isNullOrEmpty((Object[])physicalNics) || proxySwitch == null || ArrayUtil.isNullOrEmpty((Object[])proxySwitch.pnic)) {
            return switchPnics;
        }
        for (String pnicKey : proxySwitch.pnic) {
            if (StringUtil.isNullOrEmpty((String)pnicKey)) continue;
            for (PhysicalNic pnic : physicalNics) {
                if (pnic == null || !pnicKey.equals(pnic.key)) continue;
                switchPnics.add(pnic);
            }
        }
        return switchPnics;
    }
}

