/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sms.impl;

import com.vmware.vim.binding.sms.Task;
import com.vmware.vim.binding.sms.TaskInfo;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vsphere.client.sms.util.SmsUtil;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SmsTaskWaiter {
    private static final String TASK_STATE_RUNNING = "running";
    private static final long SLEEP_INTERVAL_IN_MILLIS = 1000L;
    private static final long MIN_TIMEOUT_IN_MILLIS = 1000L;
    private static final long INFINITE_TIMEOUT = -1L;
    private Task _task;

    public SmsTaskWaiter(Task task) {
        this._task = task;
    }

    public TaskInfo waitTaskToComplete() throws ExecutionException, InterruptedException, TimeoutException {
        return this.waitTaskToComplete(-1L);
    }

    public TaskInfo waitTaskToComplete(long timeout) throws ExecutionException, InterruptedException, TimeoutException {
        TaskInfo taskInfo;
        BlockingFuture future = new BlockingFuture();
        long startTime = System.currentTimeMillis();
        while (true) {
            this._task.queryInfo((Future)future);
            if (timeout != -1L) {
                long queryInfoTimeout = timeout - (System.currentTimeMillis() - startTime);
                queryInfoTimeout = Math.max(1000L, queryInfoTimeout);
                taskInfo = (TaskInfo)future.get(queryInfoTimeout, TimeUnit.MILLISECONDS);
            } else {
                taskInfo = (TaskInfo)future.get();
            }
            if (!TASK_STATE_RUNNING.equals(taskInfo.state)) break;
            long elapsedTimeMillis = System.currentTimeMillis() - startTime;
            if (timeout != -1L && timeout < elapsedTimeMillis) {
                throw new TimeoutException(SmsUtil.getLocalizedString("error.waitTimeoutException"));
            }
            Thread.sleep(1000L);
        }
        return taskInfo;
    }
}

